/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.BitSet;
import org.eclipse.edt.ide.core.internal.errors.ErrorGrammar;

public class EGLContextBoundaryUtility {
    private static final EGLContextBoundaryUtility INSTANCE = new EGLContextBoundaryUtility();
    private ErrorGrammar grammar = ErrorGrammar.getInstance();
    private BitSet boundaryStatesSet;

    public static EGLContextBoundaryUtility getInstance() {
        return INSTANCE;
    }

    public boolean isBoundaryState(int state) {
        short[] nonterminalCandidates = this.grammar.getNonTerminalCandidates(state);
        int i = 0;
        while (i < nonterminalCandidates.length) {
            if (this.getBoundarySet().get(nonterminalCandidates[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private BitSet getBoundarySet() {
        if (this.boundaryStatesSet == null) {
            this.initBoundaryStatesSet();
        }
        return this.boundaryStatesSet;
    }

    private void initBoundaryStatesSet() {
        this.boundaryStatesSet = new BitSet(500);
        this.boundaryStatesSet.set(33);
        this.boundaryStatesSet.set(70);
        this.boundaryStatesSet.set(47);
        this.boundaryStatesSet.set(71);
        this.boundaryStatesSet.set(93);
        this.boundaryStatesSet.set(92);
        this.boundaryStatesSet.set(55);
        this.boundaryStatesSet.set(66);
        this.boundaryStatesSet.set(36);
        this.boundaryStatesSet.set(35);
        this.boundaryStatesSet.set(79);
        this.boundaryStatesSet.set(78);
        this.boundaryStatesSet.set(41);
        this.boundaryStatesSet.set(8);
        this.boundaryStatesSet.set(81);
        this.boundaryStatesSet.set(17);
        this.boundaryStatesSet.set(91);
        this.boundaryStatesSet.set(87);
        this.boundaryStatesSet.set(80);
        this.boundaryStatesSet.set(42);
        this.boundaryStatesSet.set(22);
        this.boundaryStatesSet.set(44);
        this.boundaryStatesSet.set(54);
        this.boundaryStatesSet.set(5);
        this.boundaryStatesSet.set(103);
        this.boundaryStatesSet.set(20);
        this.boundaryStatesSet.set(28);
        this.boundaryStatesSet.set(21);
        this.boundaryStatesSet.set(40);
        this.boundaryStatesSet.set(95);
        this.boundaryStatesSet.set(73);
        this.boundaryStatesSet.set(38);
        this.boundaryStatesSet.set(27);
        this.boundaryStatesSet.set(49);
        this.boundaryStatesSet.set(23);
        this.boundaryStatesSet.set(69);
        this.boundaryStatesSet.set(67);
        this.boundaryStatesSet.set(29);
        this.boundaryStatesSet.set(77);
        this.boundaryStatesSet.set(86);
        this.boundaryStatesSet.set(85);
        this.boundaryStatesSet.set(56);
        this.boundaryStatesSet.set(96);
    }
}

