/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.awt.Point;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractFromLibraryUseStatementProposalHandler;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLFunctionFromLibraryUseStatementProposalHandler
extends EGLAbstractFromLibraryUseStatementProposalHandler {
    public EGLFunctionFromLibraryUseStatementProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, boolean mustHaveReturnCode, Node boundNode) {
        super(viewer, documentOffset, prefix, editor, mustHaveReturnCode, boundNode);
    }

    @Override
    protected List getProposals(LibraryBinding[] libraryContexts, int i) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        List functions = libraryContexts[i].getDeclaredFunctions(true);
        Iterator iter = functions.iterator();
        while (iter.hasNext()) {
            IFunctionBinding function = (IFunctionBinding)((IDataBinding)iter.next()).getType();
            if (!function.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || function.isPrivate() || this.containerPartFunctions.contains(function.getName().toLowerCase())) continue;
            if (this.mustHaveReturnCode && function.getReturnType() != null) {
                proposals.add(this.createProposal(function));
            }
            if (this.mustHaveReturnCode || function.getReturnType() != null) continue;
            proposals.add(this.createProposal(function));
        }
        return proposals;
    }

    protected String getReplacementString(IFunctionBinding functionBinding) {
        StringBuffer buffer = new StringBuffer(functionBinding.getCaseSensitiveName());
        buffer.append("(");
        List parms = functionBinding.getParameters();
        Iterator iter = parms.iterator();
        while (iter.hasNext()) {
            IDataBinding parm = (IDataBinding)iter.next();
            buffer.append(parm.getCaseSensitiveName());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected String getAdditionalInfo(IFunctionBinding functionBinding) {
        return MessageFormat.format(UINlsStrings.CAProposal_UseDeclarationIn, "function", functionBinding.getDeclarer().getCaseSensitiveName());
    }

    protected EGLCompletionProposal createProposal(IFunctionBinding functionBinding) {
        String replacementString = this.getReplacementString(functionBinding);
        String displayString = this.getDisplayString(functionBinding);
        Point selection = this.getFirstParmSelection(replacementString);
        return new EGLCompletionProposal(this.viewer, displayString, replacementString, this.getAdditionalInfo(functionBinding), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), selection.x, 50, selection.y, "org.eclipse.edt.ide.ui.funct_obj.gif");
    }
}

