/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLDataTypeUtility;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;

public class EGLPrimitiveProposalHandler
extends EGLAbstractProposalHandler {
    private ITypeBinding partBinding;

    public EGLPrimitiveProposalHandler(ITextViewer viewer, int documentOffset, String prefix, Node boundNode) {
        super(viewer, documentOffset, prefix);
        if (boundNode != null) {
            while (!(boundNode instanceof File)) {
                if (boundNode instanceof Part) {
                    this.partBinding = (ITypeBinding)((Part)boundNode).getName().resolveBinding();
                }
                boundNode = boundNode.getParent();
            }
        }
    }

    public List getProposals() {
        return this.getProposals(false);
    }

    public List getProposals(boolean loose) {
        ArrayList proposals = new ArrayList();
        boolean vagCompatibility = EGLBasePlugin.getPlugin().getPreferenceStore().getBoolean("VAGCompatibilityOption");
        proposals.addAll(this.createPrimitiveProposals(false, vagCompatibility, this.getPrimitiveTypes()));
        if (loose) {
            proposals.addAll(this.createPrimitiveProposals(true, vagCompatibility, EGLDataTypeUtility.PRIMITIVE_TYPE_LOOSE_STRINGS));
        }
        return proposals;
    }

    private String[] getPrimitiveTypes() {
        if (this.partBinding != null) {
            switch (this.partBinding.getKind()) {
                case 6: {
                    return EGLDataTypeUtility.PRIMITIVE_TYPE_NONFLEXIBLE_STRINGS;
                }
                case 7: {
                    return EGLDataTypeUtility.PRIMITIVE_TYPE_STRINGS;
                }
                case 5: {
                    return EGLDataTypeUtility.PRIMITIVE_TYPE_NONFLEXIBLE_STRINGS;
                }
                case 8: 
                case 9: {
                    return EGLDataTypeUtility.PRIMITIVE_TYPE_FORM_STRINGS;
                }
            }
        }
        return EGLDataTypeUtility.PRIMITIVE_TYPE_STRINGS;
    }

    private List createPrimitiveProposals(boolean loose, boolean vagCompatibility, String[] primitiveStrings) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        int i = 0;
        while (i < primitiveStrings.length) {
            if (primitiveStrings[i].toUpperCase().startsWith(this.getPrefix().toUpperCase()) && this.checkVagCompatibility(primitiveStrings[i], vagCompatibility)) {
                int curserDelta;
                String primitiveString = primitiveStrings[i];
                if (!loose && this.needsParens(primitiveString)) {
                    curserDelta = 1;
                    primitiveString = String.valueOf(primitiveString) + "()";
                } else {
                    curserDelta = 0;
                }
                proposals.add(new EGLCompletionProposal(this.viewer, null, primitiveString, this.getAdditionalInfo(loose), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), primitiveString.length() - curserDelta, 60, ""));
            }
            ++i;
        }
        return proposals;
    }

    private String getAdditionalInfo(boolean loose) {
        if (loose) {
            return UINlsStrings.CAProposal_LoosePrimitiveType;
        }
        return UINlsStrings.CAProposal_PrimitiveType;
    }

    private boolean checkVagCompatibility(String primitiveName, boolean vagCompatibility) {
        if (vagCompatibility) {
            return true;
        }
        return !primitiveName.equalsIgnoreCase("NUMC") && !primitiveName.equalsIgnoreCase("PACF");
    }

    private boolean needsParens(String primitiveString) {
        if (primitiveString.equalsIgnoreCase("int")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("bigInt")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("boolean")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("bytes")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("smallInt")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("float")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("smallFloat")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("date")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("time")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("money")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("string")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("number")) {
            return false;
        }
        if (primitiveString.equalsIgnoreCase("timeStamp")) {
            return false;
        }
        return !primitiveString.equalsIgnoreCase("interval");
    }
}

