/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.DataTableBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLTableUseStatementProposalHandler
extends EGLAbstractProposalHandler {
    private boolean parens;
    private Node functionContainerPart;

    public EGLTableUseStatementProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, Node boundNode) {
        super(viewer, documentOffset, prefix, editor);
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof NestedFunction) {
                this.functionContainerPart = boundNode.getParent();
            }
            boundNode = boundNode.getParent();
        }
    }

    public List getProposals() {
        return this.getProposals(false);
    }

    public List getProposals(boolean parens) {
        this.parens = parens;
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionContainerPart != null) {
            Set tableUseStatements = this.getTableUseStatementParts(this.functionContainerPart);
            for (DataTableBinding tableTypeBinding : tableUseStatements) {
                if (!tableTypeBinding.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
                proposals.add(this.createProposal(tableTypeBinding));
            }
        }
        return proposals;
    }

    private EGLCompletionProposal createProposal(DataTableBinding typeBinding) {
        String proposalString = this.getProposalString(typeBinding.getCaseSensitiveName());
        String packageName = this.getPackageName((IPartBinding)typeBinding);
        return new EGLCompletionProposal(this.viewer, String.valueOf(typeBinding.getCaseSensitiveName()) + " - " + packageName + " (" + this.getPartTypeString((ITypeBinding)typeBinding) + ")", proposalString, this.getAdditionalInfo((ITypeBinding)typeBinding), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length(), this.getPartTypeImgKeyStr(this.getPartTypeString((ITypeBinding)typeBinding)));
    }

    private String getProposalString(String string) {
        if (this.parens) {
            return "(" + string + ");";
        }
        return string;
    }
}

