/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.EGLPropertiesHandler;
import org.eclipse.edt.compiler.internal.EGLPropertyRule;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLDeclarationProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.jface.text.ITextViewer;

public class EGLPropertyListValueReferenceCompletion
extends EGLAbstractReferenceCompletion {
    public static final int LOCATION_PROPERTY_LIST_NONE = 0;
    public static final int LOCATION_PROPERTY_LIST_OUTLINE = 1;
    private String prefix;
    private ITextViewer viewer;
    private int documentOffset;
    private List structureItems;

    @Override
    protected void precompileContexts() {
        this.addContext("package a; program a { name = [");
    }

    @Override
    protected List returnCompletionProposals(final ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        this.prefix = prefix.toUpperCase();
        this.viewer = viewer;
        this.documentOffset = documentOffset;
        final ArrayList proposals = new ArrayList();
        this.getBoundASTNodeForOffsetInStatement(viewer, documentOffset, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node node) {
                EGLPropertyListValueReferenceCompletion.this.structureItems = EGLPropertyListValueReferenceCompletion.this.getStructureItems(node);
                EGLPropertyRule propertyRule = EGLPropertyListValueReferenceCompletion.this.getPropertyListPropertyRule(parseStack);
                if (propertyRule != null) {
                    if (propertyRule.getName().equalsIgnoreCase("keyItems")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueKeyItemsProposals(viewer, documentOffset, prefix, false));
                    } else if (propertyRule.getName().equalsIgnoreCase("outline")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueOutlineProposals(viewer, documentOffset, prefix, false, parseStack, propertyRule));
                    } else if (propertyRule.getName().equalsIgnoreCase("pageSize")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueNumericLiteralProposal());
                    } else if (propertyRule.getName().equalsIgnoreCase("position")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueNumericLiteralProposal());
                    } else if (propertyRule.getName().equalsIgnoreCase("validValues")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueNumericLiteralProposal());
                    } else if (propertyRule.getName().equalsIgnoreCase("screenSize")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueNumericLiteralProposal());
                    } else if (propertyRule.getName().equalsIgnoreCase("screenSizes")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.handleScreenSizes(parseStack));
                    } else if (propertyRule.getName().equalsIgnoreCase("formSize")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueNumericLiteralProposal());
                    } else if (propertyRule.getName().equalsIgnoreCase("tableNames")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueTableNamesLiteralProposals());
                    } else if (propertyRule.getName().equalsIgnoreCase("tableNameVariables")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueTableNameVariablesLiteralProposals());
                    } else if (propertyRule.getName().equalsIgnoreCase("validationBypassKeys")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueValidationBypassKeysProposals(viewer, documentOffset, prefix, false));
                    } else if (propertyRule.getName().equalsIgnoreCase("validationBypassFunctions")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueValidationBypassFunctionsProposals(viewer, documentOffset, prefix, false));
                    } else if (propertyRule.getName().equalsIgnoreCase("segments")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueSegmentsProposal());
                    } else if (propertyRule.getName().equalsIgnoreCase("linkParms")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueLinkParameterProposal());
                    } else if (propertyRule.getName().equalsIgnoreCase("pcbParms")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValuePCBParmsProposal(node));
                    } else if (propertyRule.getName().equalsIgnoreCase("hierarchy")) {
                        proposals.addAll(EGLPropertyListValueReferenceCompletion.this.getListValueHierarchyProposal());
                    }
                }
            }
        });
        return proposals;
    }

    private List getListValueLinkParameterProposal() {
        String proposalString = "@linkParameter {}";
        return this.createProposal(this.viewer, "linkParameter", proposalString, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.documentOffset, proposalString.length() - 1, 0);
    }

    private List getListValueHierarchyProposal() {
        String proposalString = "@relationship {}";
        return this.createProposal(this.viewer, "relationship", proposalString, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.documentOffset, proposalString.length() - 1, 0);
    }

    private List getListValuePCBParmsProposal(Node boundNode) {
        ArrayList proposals = new ArrayList();
        if (boundNode != null) {
            proposals.addAll(new EGLDeclarationProposalHandler(this.viewer, this.documentOffset, this.prefix, boundNode).getProgramParameterRecordProposals(EGLDeclarationProposalHandler.BASIC_RECORD, false, false));
        }
        return proposals;
    }

    protected List handleScreenSizes(ParseStack parseStack) {
        return this.getListValueNumericLiteralProposal();
    }

    private EGLPropertyRule getPropertyListPropertyRule(ParseStack parseStack) {
        String propertyName = this.getPropertyName(parseStack);
        if (propertyName.length() > 0) {
            return this.getRule(propertyName);
        }
        return null;
    }

    private String getPropertyName(ParseStack parseStack) {
        ParseStack tempStack = parseStack.copy();
        tempStack.deleteContext(1);
        int stackSize = tempStack.getStack().size();
        while (stackSize > 0) {
            ParseNode parseNode = tempStack.deleteContext(1)[0];
            if (parseNode.getText().startsWith("=")) {
                parseNode = tempStack.deleteContext(1)[0];
                return parseNode.getText().trim();
            }
            --stackSize;
        }
        return "";
    }

    private EGLPropertyRule getRule(String propertyName) {
        if (propertyName.equalsIgnoreCase("keyItems")) {
            return this.getRule(EGLPropertiesHandler.getSQLRecordPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("outline")) {
            return this.getRule(EGLPropertiesHandler.getDataItemPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("pageSize")) {
            return this.getRule(EGLPropertiesHandler.getPrintFloatingAreaPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("position")) {
            return this.getRule(EGLPropertiesHandler.getTextFormPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("validValues")) {
            return this.getRule(EGLPropertiesHandler.getDataItemPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("screenSize")) {
            return this.getRule(EGLPropertiesHandler.getScreenFloatingAreaPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("screenSizes")) {
            return this.getRule(EGLPropertiesHandler.getTextFormPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("formSize")) {
            return this.getRule(EGLPropertiesHandler.getTextFormPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("tableNames")) {
            return this.getRule(EGLPropertiesHandler.getSQLRecordPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("tableNameVariables")) {
            return this.getRule(EGLPropertiesHandler.getSQLRecordPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("validationBypassFunctions")) {
            return this.getRule(EGLPropertiesHandler.getPageHandlerPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("validationBypassKeys")) {
            return this.getRule(EGLPropertiesHandler.getTextFormPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("segments")) {
            return this.getRule(EGLPropertiesHandler.getConsoleFieldPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("linkParms")) {
            return this.getRule(EGLPropertiesHandler.getLinkParmsPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("pcbParms")) {
            return this.getRule(EGLPropertiesHandler.getPcbParmsPropertyRules(), propertyName);
        }
        if (propertyName.equalsIgnoreCase("hierarchy")) {
            return this.getRule(EGLPropertiesHandler.getHierarchyPropertyRules(), propertyName);
        }
        return null;
    }

    private EGLPropertyRule getRule(List rules, String propertyName) {
        for (EGLPropertyRule propertyRule : rules) {
            if (!propertyRule.getName().equalsIgnoreCase(propertyName)) continue;
            return propertyRule;
        }
        return null;
    }

    private List getListValueNumericLiteralProposal() {
        return this.createProposal(this.viewer, "numericLiteral", this.prefix, UINlsStrings.CAProposal_PropertyValue, this.documentOffset, 0, "numericLiteral".length());
    }

    protected List getListValueScreenSizesLiteralProposal() {
        String proposalString = "[lines,columns]";
        return this.createProposal(this.viewer, proposalString, this.prefix, UINlsStrings.CAProposal_PropertyValue, this.documentOffset, 1, 5);
    }

    protected List getListValueSegmentsProposal() {
        return this.createProposal(this.viewer, "[line,column,length]", this.prefix, UINlsStrings.CAProposal_PropertyValue, this.documentOffset, 1, 4);
    }

    private List getListValueTableNamesLiteralProposals() {
        return this.createProposal(this.viewer, "[\"tableName\", \"tableLabel\"]", this.prefix, UINlsStrings.CAProposal_PropertyValue, this.documentOffset, 2, 9);
    }

    private List getListValueTableNameVariablesLiteralProposals() {
        return this.createProposal(this.viewer, "[\"variableName\", \"tableLabel\"]", this.prefix, UINlsStrings.CAProposal_PropertyValue, this.documentOffset, 2, 12);
    }

    @Override
    public List getStructureItems() {
        return this.structureItems;
    }
}

