/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLDeclarationProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.jface.text.ITextViewer;

public class EGLSQLWithStatementReferenceCompletion
extends EGLAbstractReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; function a() get a with ");
        this.addContext("package a; function a() get a from a with ");
        this.addContext("package a; function a() execute with ");
        this.addContext("package a; function a() delete from a with ");
        this.addContext("package a; function a() delete a from a with ");
        this.addContext("package a; function a() open a with ");
        this.addContext("package a; function a() open a from a with ");
        this.addContext("package a; function a() replace a to a with ");
        this.addContext("package a; function a() prepare a from a with ");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        final ArrayList<EGLCompletionProposal> result = new ArrayList<EGLCompletionProposal>();
        int prefixLength = prefix.length();
        if ("#sql".toUpperCase().startsWith(prefix.toUpperCase())) {
            String message = "#sql{}";
            result.add(new EGLCompletionProposal(viewer, message, message, UINlsStrings.CAProposal_EGLKeyword, documentOffset - prefixLength, prefixLength, message.length() - 1, 71, ""));
        }
        this.getBoundASTNodeForOffsetInStatement(viewer, documentOffset, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                EGLDeclarationProposalHandler eglDP = new EGLDeclarationProposalHandler(viewer, documentOffset, prefix, boundNode);
                result.addAll(eglDP.getSQLStatementProposals());
                result.addAll(eglDP.getSQLStringProposals());
            }
        });
        return result;
    }
}

