/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.dialogs.InterfaceSelectionDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.editor.util.EGLModelUtility;
import org.eclipse.edt.ide.ui.internal.services.wizards.ServiceConfiguration;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class CalledBasicProgramSelectionDialog
extends InterfaceSelectionDialog {
    private ServiceConfiguration fConfig;
    private Hashtable<String, IPart> partHash;
    private Hashtable pgmHash;

    public CalledBasicProgramSelectionDialog(Shell parent, IRunnableContext context, ListDialogField list, ServiceConfiguration config, IEGLProject p) {
        super(parent, context, list, 1, "BasicProgram", config, p);
        this.fConfig = config;
        this.partHash = new Hashtable();
        this.pgmHash = new Hashtable();
    }

    @Override
    protected void addSelectedPart() {
        Object ref = this.getLowerSelectedElement();
        if (ref instanceof PartInfo) {
            PartInfo partinfo = (PartInfo)ref;
            String qualifiedName = partinfo.getFullyQualifiedName();
            this.fList.addElement(qualifiedName);
            IPart part = this.partHash.get(qualifiedName);
            if (part != null) {
                Program pgmProgram;
                if (part.getParent() instanceof IEGLFile) {
                    pgmProgram = (Program)this.pgmHash.get(qualifiedName);
                    this.fConfig.addCalledBasicPgm(qualifiedName, part, pgmProgram);
                } else if (part.getParent() instanceof IClassFile) {
                    pgmProgram = (BinaryPart)this.pgmHash.get(qualifiedName);
                    this.fConfig.addCalledBasicPgm(qualifiedName, part, (BinaryPart)pgmProgram);
                }
            }
            String message = NewWizardMessages.bind((String)NewWizardMessages.EGLInterfaceSelectionDialogInterfaceaddedInfo, (Object)qualifiedName);
            this.updateStatus(new StatusInfo(1, message));
        }
    }

    private BinaryPart getPGMProgramPartFromBinaryFile(IPart programPart) {
        if (programPart.getParent() instanceof IClassFile && programPart instanceof BinaryPart && ((BinaryPart)programPart).isProgram()) {
            return (BinaryPart)programPart;
        }
        return null;
    }

    private Program getPGMProgramPart(IPart programpart) {
        if (programpart.getParent() instanceof IEGLFile) {
            IEGLFile eglFile = (IEGLFile)programpart.getParent();
            try {
                File fileAST = EGLModelUtility.getEGLFileAST(eglFile, EGLUI.getBufferFactory());
                final Program[] pgm = new Program[1];
                fileAST.accept((IASTVisitor)new DefaultASTVisitor(){

                    public boolean visit(File file) {
                        return true;
                    }

                    public boolean visit(Program program) {
                        pgm[0] = program;
                        return false;
                    }
                });
                return pgm[0];
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    protected int addParts(ArrayList partsList, IEGLSearchScope scope, int elementKinds, String subType) {
        ArrayList<PartInfo> typeList = new ArrayList<PartInfo>();
        int superReturn = super.addParts(partsList, scope, elementKinds, subType);
        if (superReturn == 0) {
            for (PartInfo partinfo : partsList) {
                String fullyqualifeidname;
                Program pgmProgramPart;
                IPart part = this.getPartFromPartInfo(partinfo);
                if (part.getParent() instanceof IEGLFile) {
                    pgmProgramPart = this.getPGMProgramPart(part);
                    if (pgmProgramPart == null || !pgmProgramPart.isCallable()) continue;
                    typeList.add(partinfo);
                    fullyqualifeidname = partinfo.getFullyQualifiedName();
                    this.partHash.put(fullyqualifeidname, part);
                    this.pgmHash.put(fullyqualifeidname, pgmProgramPart);
                    continue;
                }
                pgmProgramPart = this.getPGMProgramPartFromBinaryFile(part);
                try {
                    if (pgmProgramPart == null || !((SourcePartElementInfo)pgmProgramPart.getElementInfo()).isCalledProgram()) continue;
                    typeList.add(partinfo);
                    fullyqualifeidname = partinfo.getFullyQualifiedName();
                    this.partHash.put(fullyqualifeidname, part);
                    this.pgmHash.put(fullyqualifeidname, pgmProgramPart);
                }
                catch (EGLModelException e) {
                    e.printStackTrace();
                }
            }
            partsList.clear();
            partsList.addAll(typeList);
        }
        return superReturn;
    }
}

