/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.dialogs;

import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.PartSelectionDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenPartSelectionDialog
extends PartSelectionDialog {
    public static final int IN_HIERARCHY = 1025;
    private Point fLocation;
    private Point fSize;

    public OpenPartSelectionDialog(Shell parent, IRunnableContext context, int elementKinds, IEGLSearchScope scope) {
        super(parent, context, elementKinds, null, scope);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, IUIHelpConstants.EGL_OPEN_TYPE_DIALOG);
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.readSettings();
        return control;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    private void readSettings() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.fLocation = new Point(x, y);
            int width = s.getInt("width");
            int height = s.getInt("height");
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
            this.fSize = null;
        }
    }

    private void writeSettings() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
    }

    private IDialogSettings getDialogSettings() {
        String sectionName;
        IDialogSettings settings = EDTUIPlugin.getDefault().getDialogSettings();
        IDialogSettings subSettings = settings.getSection(sectionName = ((Object)((Object)this)).getClass().getName());
        if (subSettings == null) {
            subSettings = settings.addNewSection(sectionName);
        }
        return subSettings;
    }
}

