/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.ide.ui.internal.editor.AccumulatingDynamicProblemRequestor;

public class AccumulatingTopLevelProblemRequestor
extends DefaultProblemRequestor {
    private IProblemRequestor requestor;
    private boolean containerContextDependent;
    private boolean reportContextErrors;

    public AccumulatingTopLevelProblemRequestor(boolean reportContextErrors, boolean containerContextDependent) {
        this.requestor = new AccumulatingDynamicProblemRequestor();
        this.reportContextErrors = reportContextErrors;
        this.containerContextDependent = containerContextDependent;
    }

    public AccumulatingTopLevelProblemRequestor(IProblemRequestor requestor) {
        this.requestor = requestor;
    }

    public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
        if (this.shouldReportProblem(problemKind)) {
            this.requestor.acceptProblem(startOffset, endOffset, severity, problemKind, inserts);
        }
    }

    public String[] shiftInserts(int problemKind, String[] inserts) {
        String[] newInserts = new String[inserts.length + 3];
        System.arraycopy(inserts, 0, newInserts, 1, inserts.length);
        return newInserts;
    }

    public boolean shouldReportProblem(int problemKind) {
        if (this.reportContextErrors) {
            return this.reportContextProblems(problemKind);
        }
        return this.resportNoContextProblems(problemKind);
    }

    private boolean resportNoContextProblems(int problemKind) {
        if (this.isContainerContextDependent() && problemKind == 3260) {
            return false;
        }
        return !messagesWithLineNumberInserts.contains(new Integer(problemKind));
    }

    public boolean reportContextProblems(int problemKind) {
        if (this.isContainerContextDependent() && problemKind == 3260) {
            return true;
        }
        return messagesWithLineNumberInserts.contains(new Integer(problemKind));
    }

    protected boolean isContainerContextDependent() {
        return this.containerContextDependent;
    }

    public void setReportContextErrors(boolean reportContextErrors) {
        this.reportContextErrors = reportContextErrors;
    }

    public void setContainerContextDependent(boolean containerContextDependent) {
        this.containerContextDependent = containerContextDependent;
    }

    public IProblemRequestor getRequestor() {
        return this.requestor;
    }
}

