/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.editor.IFoldingStructureProvider;
import org.eclipse.edt.ide.ui.internal.editor.folding.FoldingStructureProviderDescriptor;

public class FoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "eglFoldingStructureProviders";
    private Map fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        FoldingStructureProviderRegistry foldingStructureProviderRegistry = this;
        synchronized (foldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new FoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FoldingStructureProviderDescriptor getFoldingProviderDescriptor(String id) {
        FoldingStructureProviderRegistry foldingStructureProviderRegistry = this;
        synchronized (foldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (FoldingStructureProviderDescriptor)this.fDescriptors.get(id);
        }
    }

    public IFoldingStructureProvider getCurrentFoldingProvider() {
        String id = EDTUIPlugin.getDefault().getPreferenceStore().getString("editor_folding_provider");
        FoldingStructureProviderDescriptor desc = this.getFoldingProviderDescriptor(id);
        if (desc != null) {
            try {
                return desc.createProvider();
            }
            catch (CoreException e) {
                EDTUIPlugin.log(e);
            }
        }
        return null;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        HashMap<String, FoldingStructureProviderDescriptor> map = new HashMap<String, FoldingStructureProviderDescriptor>();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EDTUIPlugin.getPluginId(), EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            FoldingStructureProviderDescriptor desc = new FoldingStructureProviderDescriptor(elements[i]);
            map.put(desc.getId(), desc);
            ++i;
        }
        FoldingStructureProviderRegistry foldingStructureProviderRegistry = this;
        synchronized (foldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(map);
        }
    }
}

