/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.StandardEGLElementContentProvider;
import org.eclipse.edt.ide.ui.internal.eglarpackager.AbstractEglarDestinationWizardPage;
import org.eclipse.edt.ide.ui.internal.eglarpackager.CheckboxTreeAndListGroup;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageData;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageWizard;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackagerMessages;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementLabelProvider;
import org.eclipse.edt.ide.ui.internal.util.SWTUtil;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class EglarPackageWizardPage
extends AbstractEglarDestinationWizardPage {
    protected EglarPackageData fEglarPackage;
    private IStructuredSelection fInitialSelection;
    private CheckboxTreeAndListGroup fInputGroup;
    private Button fExportEGLSrcFilesCheckbox;
    protected Button fExportEGLWithErrorsCheckbox;
    protected Button fExportEGLWithWarningCheckbox;
    private static final String PAGE_NAME = "EglarPackageWizardPage";
    private static final String STORE_EXPORT_IR_FILES = "EglarPackageWizardPage.EXPORT_IR_FILES";
    private static final String STORE_COMPRESS = "EglarPackageWizardPage.COMPRESS";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 480;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;
    private static final String SELECT_ALL_TITLE = EglarPackagerMessages.EglarPackageWizardPage_selectAll;
    private static final String DESELECT_ALL_TITLE = EglarPackagerMessages.EglarPackageWizardPage_deselectAll;

    public EglarPackageWizardPage(EglarPackageData eglarPackage, IStructuredSelection selection) {
        this(PAGE_NAME, eglarPackage, selection);
    }

    public EglarPackageWizardPage(String pageName, EglarPackageData eglarPackage, IStructuredSelection selection) {
        super(pageName, selection, eglarPackage);
        this.setTitle(EglarPackagerMessages.EglarPackageWizardPage_title);
        this.setDescription(EglarPackagerMessages.EglarPackageWizardPage_description);
        this.fEglarPackage = eglarPackage;
        this.fInitialSelection = selection;
    }

    public Button getExportEGLSrcFilesCheckbox() {
        return this.fExportEGLSrcFilesCheckbox;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createPlainLabel(composite, EglarPackagerMessages.EglarPackageWizardPage_whatToExport_label);
        this.createInputGroup(composite);
        this.createSelectionButtonsGroup(composite);
        this.createExportTypeGroup(composite);
        new Label(composite, 0);
        this.createPlainLabel(composite, EglarPackagerMessages.EglarPackageWizardPage_whereToExport_label);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.fInitialSelection != null) {
            BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    EglarPackageWizardPage.this.setupBasedOnInitialSelections();
                }
            });
        }
        this.setControl((Control)composite);
        this.update();
        this.giveFocusToDestination();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.EGLAR_EXPORT_WIZARD);
    }

    protected final void createSelectionButtonsGroup(Composite parent) {
        Font font = parent.getFont();
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        Button selectButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EglarPackageWizardPage.this.fInputGroup.setAllSelections(true);
                EglarPackageWizardPage.this.updateWidgetEnablements();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        selectButton.setFont(font);
        this.setButtonLayoutData(selectButton);
        Button deselectButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EglarPackageWizardPage.this.fInputGroup.setAllSelections(false);
                EglarPackageWizardPage.this.updateWidgetEnablements();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        deselectButton.setFont(font);
        this.setButtonLayoutData(deselectButton);
    }

    protected void createOptionsGroup(Composite parent) {
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.fInputGroup.getAllCheckedListItems();
    }

    @Override
    public final void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_EXPORT_IR_FILES, this.fEglarPackage.areEGLIRFilesExported());
            settings.put(STORE_COMPRESS, this.fEglarPackage.isCompressed());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        if (!((EglarPackageWizard)this.getWizard()).isInitializingFromEglarPackage()) {
            this.initializeEglarPackage();
        }
        this.fExportEGLSrcFilesCheckbox.setSelection(this.fEglarPackage.areEGLSrcFilesExported());
        this.fExportEGLWithErrorsCheckbox.setSelection(this.fEglarPackage.areErrorsExported());
        this.fExportEGLWithWarningCheckbox.setSelection(this.fEglarPackage.exportWarnings());
        this.restoreLocation();
    }

    @Override
    protected void initializeEglarPackage() {
        super.initializeEglarPackage();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fEglarPackage.setElements(this.getSelectedElements());
            this.fEglarPackage.setExportEGLIRFiles(settings.getBoolean(STORE_EXPORT_IR_FILES));
            this.fEglarPackage.setCompress(settings.getBoolean(STORE_COMPRESS));
        }
    }

    @Override
    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        this.fEglarPackage.setExportEGLSrcFiles(this.fExportEGLSrcFilesCheckbox.getSelection());
        this.fEglarPackage.setExportErrors(this.fExportEGLWithErrorsCheckbox.getSelection());
        this.fEglarPackage.setExportWarnings(this.fExportEGLWithWarningCheckbox.getSelection());
        this.fEglarPackage.setElements(this.getSelectedElements());
        super.updateModel();
    }

    protected IResource findResource(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), 15);
        if (result.isOK() && workspace.getRoot().exists(path)) {
            return workspace.getRoot().findMember(path);
        }
        return null;
    }

    protected void createInputGroup(Composite parent) {
        int labelFlags = 272;
        StandardEGLElementContentProvider treeContentProvider = new StandardEGLElementContentProvider(){

            @Override
            public boolean hasChildren(Object element) {
                if (element instanceof IEGLProject) {
                    return super.hasChildren(element);
                }
                return false;
            }

            @Override
            public Object[] getChildren(Object element) {
                if (element instanceof IEGLModel) {
                    Object[] projects = (IEGLProject[])super.getChildren(element);
                    ArrayList<IEGLProject> projectsList = new ArrayList<IEGLProject>();
                    Object[] objectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEGLProject project = objectArray[n2];
                        if (!project.isBinary()) {
                            projectsList.add(project);
                        }
                        ++n2;
                    }
                    projects = new IEGLProject[projectsList.size()];
                    projectsList.toArray(projects);
                    return projects;
                }
                return NO_CHILDREN;
            }
        };
        DecoratingLabelProvider provider = new DecoratingLabelProvider((ILabelProvider)new EGLElementLabelProvider(labelFlags), (ILabelDecorator)new ProblemsLabelDecorator(null));
        this.fInputGroup = new CheckboxTreeAndListGroup(parent, EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()), treeContentProvider, (ILabelProvider)provider, (ILabelProvider)provider, 0, 480, 150);
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EglarPackageWizardPage.this.update();
            }
        };
        this.fInputGroup.addCheckStateListener(listener);
        SWTUtil.setAccessibilityText((Control)this.fInputGroup.getTree(), EglarPackagerMessages.EglarPackageWizardPage_tree_accessibility_message);
    }

    protected void createExportTypeGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        this.fExportEGLWithErrorsCheckbox = new Button(optionsGroup, 16416);
        this.fExportEGLWithErrorsCheckbox.setText(EglarPackagerMessages.EglarPackageWizardPage_exportEGLWithErrors_text);
        this.fExportEGLWithErrorsCheckbox.addListener(13, (Listener)this);
        this.fExportEGLWithWarningCheckbox = new Button(optionsGroup, 16416);
        this.fExportEGLWithWarningCheckbox.setText(EglarPackagerMessages.EglarPackageWizardPage_exportEGLWithWarnings_text);
        this.fExportEGLWithWarningCheckbox.addListener(13, (Listener)this);
        this.fExportEGLSrcFilesCheckbox = new Button(optionsGroup, 16416);
        this.fExportEGLSrcFilesCheckbox.setText(EglarPackagerMessages.EglarPackageWizardPage_exportEGLSourceFiles_text);
        this.fExportEGLSrcFilesCheckbox.addListener(13, (Listener)this);
        this.fExportEGLSrcFilesCheckbox.setVisible(false);
        this.fExportEGLSrcFilesCheckbox.setEnabled(false);
        this.fExportEGLSrcFilesCheckbox.setSelection(false);
    }

    public boolean isPageComplete() {
        boolean complete = this.validateSourceGroup();
        complete = this.validateDestinationGroup() && complete;
        boolean bl = complete = this.validateOptionsGroup() && complete;
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    @Override
    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
        this.updateRefactoringMessage();
    }

    protected void updateRefactoringMessage() {
        String currentMessage = this.getMessage();
        if (this.fEglarPackage.isRefactoringAware() && this.fEglarPackage.getRefactoringDescriptors().length == 0) {
            if (currentMessage == null) {
                this.setMessage(EglarPackagerMessages.EglarPackageWizardPage_no_refactorings_selected, 1);
            }
        } else if (EglarPackagerMessages.EglarPackageWizardPage_no_refactorings_selected.equals(currentMessage)) {
            this.setMessage(null);
        }
    }

    protected boolean validateOptionsGroup() {
        Object[] selProjects = this.getSelectedElements();
        boolean ret = true;
        Object[] objectArray = selProjects;
        int n = selProjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            IEGLProject eglProject = (IEGLProject)obj;
            IProject project = eglProject.getProject();
            try {
                IMarker[] eglMarkers = project.findMarkers("org.eclipse.core.resources.marker", true, 2);
                if (eglMarkers.length > 0) {
                    IMarker[] iMarkerArray = eglMarkers;
                    int n3 = eglMarkers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMarker marker = iMarkerArray[n4];
                        switch (marker.getAttribute("severity", 0)) {
                            case 2: {
                                ret = ret && this.fEglarPackage.areErrorsExported();
                                break;
                            }
                            case 1: {
                                ret = ret && this.fEglarPackage.exportWarnings();
                            }
                        }
                        ++n4;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return ret;
    }

    protected boolean validateSourceGroup() {
        if (this.getSelectedResources().size() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            return false;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
            return false;
        }
        return true;
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    protected void setupBasedOnInitialSelections() {
        for (Object selectedElement : this.fInitialSelection) {
            this.fInputGroup.initialCheckTreeItem(selectedElement);
        }
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    Object[] getSelectedElementsWithoutContainedChildren() {
        Set closure = this.removeContainedChildren(this.fInputGroup.getWhiteCheckedTreeItems());
        closure.addAll(this.getExportedNonContainers());
        return closure.toArray();
    }

    private Set removeContainedChildren(Set elements) {
        HashSet newList = new HashSet(elements.size());
        Set javaElementResources = this.getCorrespondingContainers(elements);
        Iterator iter = elements.iterator();
        boolean removedOne = false;
        while (iter.hasNext()) {
            IContainer parent;
            Object element = iter.next();
            if (element instanceof IResource) {
                parent = ((IResource)element).getParent();
            } else if (element instanceof IEGLElement) {
                parent = ((IEGLElement)element).getParent();
                if (parent instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)parent;
                    try {
                        if (pkgRoot.getCorrespondingResource() instanceof IProject) {
                            parent = pkgRoot.getEGLProject();
                        }
                    }
                    catch (EGLModelException eGLModelException) {}
                }
            } else {
                newList.add(element);
                continue;
            }
            if (element instanceof IEGLModel || !(parent instanceof IEGLModel) && (elements.contains(parent) || javaElementResources.contains(parent))) {
                removedOne = true;
                continue;
            }
            newList.add(element);
        }
        if (removedOne) {
            return this.removeContainedChildren(newList);
        }
        return newList;
    }

    private Set getExportedNonContainers() {
        Set whiteCheckedTreeItems = this.fInputGroup.getWhiteCheckedTreeItems();
        HashSet exportedNonContainers = new HashSet(whiteCheckedTreeItems.size());
        Set javaElementResources = this.getCorrespondingContainers(whiteCheckedTreeItems);
        Iterator iter = this.fInputGroup.getAllCheckedListItems();
        while (iter.hasNext()) {
            Object element = iter.next();
            IContainer parent = null;
            if (element instanceof IResource) {
                parent = ((IResource)element).getParent();
            } else if (element instanceof IEGLElement) {
                parent = ((IEGLElement)element).getParent();
            }
            if (whiteCheckedTreeItems.contains(parent) || javaElementResources.contains(parent)) continue;
            exportedNonContainers.add(element);
        }
        return exportedNonContainers;
    }

    private Set getCorrespondingContainers(Set elements) {
        HashSet<IResource> EGLElementResources = new HashSet<IResource>(elements.size());
        for (Object element : elements) {
            IResource resource;
            IEGLElement je;
            int type;
            if (!(element instanceof IEGLElement) || (type = (je = (IEGLElement)element).getElementType()) != 2 && type != 4 && type != 3 || type == 4 && ((IPackageFragment)element).isDefaultPackage()) continue;
            try {
                resource = je.getCorrespondingResource();
            }
            catch (EGLModelException eGLModelException) {
                resource = null;
            }
            if (resource == null) continue;
            EGLElementResources.add(resource);
        }
        return EGLElementResources;
    }

    protected Object[] getSelectedElements() {
        return this.getSelectedResources().toArray();
    }

    @Override
    protected String getBrowseDialogTitle() {
        return EglarPackagerMessages.EglarPackageWizardPage_SelectDialogTitle;
    }
}

