/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class FakeOutlineContentProvider
implements ITreeContentProvider {
    private TreeViewer viewer;
    private ArrayList elements = new ArrayList();
    private int NUMELEMENTS = 30;
    private int MAXLEVELS = 1;

    public FakeOutlineContentProvider() {
        int i = 0;
        while (i < this.NUMELEMENTS) {
            this.elements.add(new Element(this.MAXLEVELS));
            ++i;
        }
    }

    public Object[] getChildren(Object parentElement) {
        Element element = (Element)parentElement;
        return element.getChildren();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        TreeViewer treeViewer;
        this.viewer = treeViewer = (TreeViewer)viewer;
    }

    public void refresh() {
        int pos = (int)Math.round(Math.random() * 10.0);
        Element newElement = new Element(this.MAXLEVELS);
        this.elements.add(pos, newElement);
        newElement = new Element(this.MAXLEVELS);
        this.elements.add(pos + 3, newElement);
        this.viewer.add(this.viewer.getInput(), (Object)newElement);
    }

    private static class Element {
        private Element child;
        private int serial;

        public Element(int level) {
            if (level > 0) {
                this.child = new Element(level - 1);
            }
            this.serial = (int)(Math.random() * 10000.0);
        }

        public Object[] getChildren() {
            Object[] objectArray;
            if (this.child == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.child;
            }
            return objectArray;
        }

        public String toString() {
            return Integer.toString(this.serial);
        }
    }
}

