/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix.proposals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.AssignmentStatement;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CallbackTarget;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.quickfix.IInvocationContext;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.AbstractMethodCorrectionProposal;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceConfiguration;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Image;

public class AddFunctionProposal
extends AbstractMethodCorrectionProposal {
    public static final String RETARGNAME = "retResult";
    public static final String EXPARGNAME = "exp";
    public static final String EXPPARAMNAME = "AnyException";
    private File fFile;
    private Part fPart;
    private List<String> fNeedImport = new LinkedList<String>();
    private String fFunctionText;

    public AddFunctionProposal(String label, IInvocationContext context, int relevance, Image image, String aFunctionText, List<String> needImports) {
        super(label, context.getEGLFile(), relevance, image, context.getDocument());
        this.fFile = context.getFileAST();
        this.fPart = context.getPart();
        this.fNeedImport = needImports;
        this.fFunctionText = aFunctionText;
    }

    @Override
    protected ASTRewrite getRewrite() {
        try {
            ASTRewrite rewrite = ASTRewrite.create((File)this.fFile);
            for (String aImportStr : this.fNeedImport) {
                rewrite.addImport(this.fFile, aImportStr, false);
            }
            rewrite.addFunction(this.fPart, this.fFunctionText);
            return rewrite;
        }
        catch (Exception e) {
            EDTUIPlugin.log((IStatus)new Status(4, "org.eclipse.edt.ide.ui", "Insert Function: Error inserting function", (Throwable)e));
            return null;
        }
    }

    private static void appendArgument(String argName, String typeName, boolean isFirst, StringBuffer strbuf) {
        if (!isFirst) {
            strbuf.append(", ");
        }
        strbuf.append(argName);
        strbuf.append(' ');
        strbuf.append(typeName);
        strbuf.append(' ');
        strbuf.append("in");
    }

    private void appendArguments(String argName, ITypeBinding paramTypeBinding, boolean isFirst, StringBuffer strbuf, List currImports, String currFilePkg, Set insertedImports, String newLineDelimiter, List<String> needImport) {
        String qualifier;
        StringBuffer strBufTypeName = new StringBuffer();
        ExtractInterfaceConfiguration.getSimpleTypeString(paramTypeBinding, strBufTypeName);
        AddFunctionProposal.appendArgument(argName, strBufTypeName.toString(), isFirst, strbuf);
        if (paramTypeBinding.getBaseType().isPartBinding() && !(qualifier = ExtractInterfaceConfiguration.getReferenceTypeParamQualifier(paramTypeBinding, currFilePkg)).equalsIgnoreCase(currFilePkg)) {
            String strImport = String.valueOf(qualifier) + (qualifier.length() > 0 ? "." : "");
            if (!AddFunctionProposal.isAlreadyImported(currImports, qualifier, strImport = String.valueOf(strImport) + paramTypeBinding.getBaseType().getCaseSensitiveName()) && !insertedImports.contains(strImport) && strImport.contains(".")) {
                needImport.add(strImport);
            }
        }
    }

    private static boolean isAlreadyImported(List currentImports, String qualifier, String strImport) {
        for (ImportDeclaration importDecl : currentImports) {
            String simport = importDecl.getName().getCanonicalName();
            if ((!importDecl.isOnDemand() || !simport.equalsIgnoreCase(qualifier)) && !simport.equalsIgnoreCase(strImport)) continue;
            return true;
        }
        return false;
    }

    public static boolean getFunctionText(IInvocationContext context, final StringBuffer functionName, final StringBuffer functionTextBuffer, final List<String> needImports) {
        final int errorOffset = context.getSelectionOffset();
        final ArrayList currImports = new ArrayList();
        final String[] currPkg = new String[1];
        final String newLineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)context.getDocument());
        AddFunctionProposal.getImportsAndPkg(currImports, context.getFileAST(), currPkg);
        Part boundPart = EGLFileConfiguration.getBoundPart(context.getEGLFile(), context.getPart().getName().getCanonicalName());
        boundPart.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(CallStatement callStatement) {
                int callEndOffset = callStatement.getOffset() + callStatement.getLength();
                if (callStatement.getOffset() <= errorOffset && errorOffset <= callEndOffset) {
                    Expression serviceFunctionExpr = callStatement.getInvocationTarget();
                    CallbackTarget callbackTgt = null;
                    CallbackTarget errCallbackTgt = null;
                    if (callStatement.getCallSynchronizationValues() != null) {
                        callbackTgt = callStatement.getCallSynchronizationValues().getReturnTo();
                        errCallbackTgt = callStatement.getCallSynchronizationValues().getOnException();
                    }
                    Expression callbackExpr = null;
                    Expression errCallbackExpr = null;
                    if (callbackTgt != null) {
                        callbackExpr = callbackTgt.getExpression();
                    }
                    if (errCallbackTgt != null) {
                        errCallbackExpr = errCallbackTgt.getExpression();
                    }
                    if (callbackExpr != null && !callbackExpr.resolveDataBinding().isValidBinding() && errorOffset >= callbackExpr.getOffset() && errorOffset <= callbackExpr.getOffset() + callbackExpr.getLength()) {
                        AddFunctionProposal.createCallbackFunction(serviceFunctionExpr, callbackExpr, currImports, currPkg[0], functionTextBuffer, needImports, newLineDelimiter, functionName);
                    } else if (errCallbackExpr != null && !errCallbackExpr.resolveDataBinding().isValidBinding() && errorOffset >= errCallbackExpr.getOffset() && errorOffset <= errCallbackExpr.getOffset() + errCallbackExpr.getLength()) {
                        AddFunctionProposal.createErrCallbackFunction(serviceFunctionExpr, errCallbackExpr, newLineDelimiter, functionTextBuffer, functionName);
                    }
                }
                return false;
            }

            public boolean visit(Assignment assignment) {
                if (assignment.getOffset() <= errorOffset && errorOffset <= assignment.getOffset() + assignment.getLength()) {
                    AddFunctionProposal.createDelegateFunction(assignment, functionTextBuffer, needImports, currImports, functionName, errorOffset, currPkg[0], newLineDelimiter);
                }
                return false;
            }

            public boolean visit(AssignmentStatement assStmt) {
                if (assStmt.getOffset() <= errorOffset && errorOffset <= assStmt.getOffset() + assStmt.getLength()) {
                    AddFunctionProposal.createDelegateFunction(assStmt.getAssignment(), functionTextBuffer, needImports, currImports, functionName, errorOffset, currPkg[0], newLineDelimiter);
                }
                return false;
            }

            public boolean visit(FunctionInvocationStatement functionInvoke) {
                if (functionInvoke.getOffset() <= errorOffset && errorOffset <= functionInvoke.getOffset() + functionInvoke.getLength()) {
                    FunctionInvocation functionInvocation = functionInvoke.getFunctionInvocation();
                    FunctionBinding functionBiding = (FunctionBinding)functionInvocation.getTarget().resolveTypeBinding();
                    List paraDefList = functionBiding.getParameters();
                    Iterator realIter = functionInvocation.getArguments().iterator();
                    FunctionParameterBinding errorParaBinding = null;
                    ITypeBinding typeBinding = null;
                    String name = null;
                    Iterator iterator = paraDefList.iterator();
                    while (iterator.hasNext()) {
                        Expression aSimpleName = (Expression)realIter.next();
                        if (aSimpleName.getOffset() <= errorOffset && errorOffset <= aSimpleName.getOffset() + aSimpleName.getLength()) {
                            name = aSimpleName.getCanonicalString();
                            errorParaBinding = (FunctionParameterBinding)iterator.next();
                            typeBinding = errorParaBinding.getType();
                            break;
                        }
                        iterator.next();
                    }
                    if (typeBinding != null && typeBinding instanceof DelegateBinding) {
                        AddFunctionProposal.getDelegateFunctionString((DelegateBinding)typeBinding, name, functionName, functionTextBuffer, newLineDelimiter, needImports, currImports, currPkg[0]);
                    }
                    return false;
                }
                return false;
            }
        });
        return functionTextBuffer.toString().trim().length() > 1;
    }

    protected static void createDelegateFunction(Assignment assignment, StringBuffer functionTextBuffer, List<String> needImports, List<String> currImports, StringBuffer bfFunctionName, int errorOffset, String currPkg, String newLine) {
        ArrayTypeBinding arrayTypeBinding;
        ITypeBinding elementTypeBinding;
        ITypeBinding leftSideBinding = assignment.getLeftHandSide().resolveTypeBinding();
        DelegateBinding delegateBinding = null;
        String functionName = "";
        Expression rightEP = assignment.getRightHandSide();
        if (rightEP instanceof ArrayLiteral) {
            List expressions = ((ArrayLiteral)rightEP).getExpressions();
            for (Expression expression : expressions) {
                if (!(expression instanceof SimpleName) || ((SimpleName)expression).getOffset() > errorOffset || errorOffset > ((SimpleName)expression).getLength() + ((SimpleName)expression).getOffset()) continue;
                functionName = ((SimpleName)expression).getCanonicalName().trim();
            }
        } else if (rightEP instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)rightEP;
            functionName = simpleName.getCanonicalName().trim();
        }
        if (leftSideBinding instanceof DelegateBinding) {
            delegateBinding = (DelegateBinding)leftSideBinding;
        } else if (leftSideBinding instanceof ArrayTypeBinding && (elementTypeBinding = (arrayTypeBinding = (ArrayTypeBinding)leftSideBinding).getElementType()) instanceof DelegateBinding) {
            delegateBinding = (DelegateBinding)elementTypeBinding;
        }
        AddFunctionProposal.getDelegateFunctionString(delegateBinding, functionName, bfFunctionName, functionTextBuffer, newLine, needImports, currImports, currPkg);
    }

    private static void createCallbackFunction(Expression serviceExpr, Expression callbackExpr, final List<String> currImports, final String currFilePkg, StringBuffer functionTextBuffer, final List<String> needImports, final String newLineDelimiter, StringBuffer functionNameBuffer) {
        if (callbackExpr.isName()) {
            Name callbackExprName = (Name)callbackExpr;
            AddFunctionProposal.getCallbackFunctionString(serviceExpr, callbackExprName, new ICallbackArgumentPrinter(){

                @Override
                public void printArgs(Expression serviceExpr, StringBuffer strbuf) {
                    AddFunctionProposal.createCallbackFunctionArguments(serviceExpr, strbuf, currImports, currFilePkg, needImports, newLineDelimiter);
                }
            }, functionTextBuffer, newLineDelimiter, functionNameBuffer);
        }
    }

    private static void createErrCallbackFunction(Expression serviceExpr, Expression errCallbackExpr, String newLineDelimiter, StringBuffer functionTextBuffer, StringBuffer functionNameBuffer) {
        if (errCallbackExpr.isName()) {
            Name callbackExprName = (Name)errCallbackExpr;
            AddFunctionProposal.getCallbackFunctionString(serviceExpr, callbackExprName, new ICallbackArgumentPrinter(){

                @Override
                public void printArgs(Expression serviceExpr, StringBuffer strbuf) {
                    AddFunctionProposal.appendArgument(AddFunctionProposal.EXPARGNAME, AddFunctionProposal.EXPPARAMNAME, true, strbuf);
                }
            }, functionTextBuffer, newLineDelimiter, functionNameBuffer);
        }
    }

    private static void createCallbackFunctionArguments(Expression serviceExpr, StringBuffer strbuf, List currImports, String currFilePkg, List<String> needImports, String newLineDelimiter) {
        ITypeBinding serviceExprBinding = serviceExpr.resolveTypeBinding();
        if (serviceExprBinding != null && serviceExprBinding.getKind() == 20) {
            HashSet<String> argNames = new HashSet<String>();
            HashSet insertedImports = new HashSet();
            FunctionBinding svrFuncBinding = (FunctionBinding)serviceExprBinding;
            List params = svrFuncBinding.getParameters();
            boolean isFirst = true;
            for (Object obj : params) {
                FunctionParameterBinding paramBinding;
                if (!(obj instanceof FunctionParameterBinding) || !(paramBinding = (FunctionParameterBinding)obj).isOutput() && !paramBinding.isInputOutput()) continue;
                String argName = paramBinding.getCaseSensitiveName();
                argNames.add(argName);
                AddFunctionProposal.appendArguments(argName, paramBinding.getType(), isFirst, strbuf, currImports, currFilePkg, insertedImports, needImports, newLineDelimiter);
                isFirst = false;
            }
            ITypeBinding retType = svrFuncBinding.getReturnType();
            if (Binding.isValidBinding((IBinding)retType)) {
                int n = 1;
                String retArgNm = RETARGNAME;
                while (argNames.contains(retArgNm)) {
                    retArgNm = RETARGNAME + Integer.toString(n);
                    ++n;
                }
                AddFunctionProposal.appendArguments(retArgNm, retType, isFirst, strbuf, currImports, currFilePkg, insertedImports, needImports, newLineDelimiter);
                isFirst = false;
            }
        }
    }

    private static void appendArguments(String argName, ITypeBinding paramTypeBinding, boolean isFirst, StringBuffer strbuf, List currImports, String currFilePkg, Set insertedImports, List<String> needImport, String newLineDelimiter) {
        String qualifier;
        StringBuffer strBufTypeName = new StringBuffer();
        ExtractInterfaceConfiguration.getSimpleTypeString(paramTypeBinding, strBufTypeName);
        AddFunctionProposal.appendArgument(argName, strBufTypeName.toString(), isFirst, strbuf);
        if (paramTypeBinding.getBaseType().isPartBinding() && !(qualifier = ExtractInterfaceConfiguration.getReferenceTypeParamQualifier(paramTypeBinding, currFilePkg)).equalsIgnoreCase(currFilePkg)) {
            String strImport = String.valueOf(qualifier) + (qualifier.length() > 0 ? "." : "");
            if (!AddFunctionProposal.isAlreadyImported(currImports, qualifier, strImport = String.valueOf(strImport) + paramTypeBinding.getBaseType().getCaseSensitiveName()) && !insertedImports.contains(strImport) && strImport.length() > 0) {
                needImport.add(strImport);
            }
        }
    }

    private static Node getContainerFunction(Node callstmt) {
        Node parent = callstmt.getParent();
        while (parent != null && !(parent instanceof NestedFunction)) {
            parent = AddFunctionProposal.getContainerFunction(parent);
        }
        return parent;
    }

    private static void getImportsAndPkg(final List imports, File file, final String[] fCurrPkg) {
        file.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(File file) {
                return true;
            }

            public boolean visit(PackageDeclaration packageDeclaration) {
                fCurrPkg[0] = packageDeclaration.getName().getCanonicalString();
                return true;
            }

            public boolean visit(ImportDeclaration importDeclaration) {
                imports.add(importDeclaration);
                return true;
            }
        });
    }

    private static void getCallbackFunctionString(Expression serviceExpr, Name callbckFuncName, ICallbackArgumentPrinter callbackArgPrinter, StringBuffer callBackFuncStr, String newLineDelimiter, StringBuffer functionNameBuffer) {
        callBackFuncStr.append("function");
        callBackFuncStr.append(" ");
        String callbackFuncName = callbckFuncName.getCaseSensitiveIdentifier();
        callBackFuncStr.append(callbackFuncName);
        callBackFuncStr.append('(');
        callbackArgPrinter.printArgs(serviceExpr, callBackFuncStr);
        callBackFuncStr.append(')');
        functionNameBuffer.append(callBackFuncStr.toString());
        callBackFuncStr.append(newLineDelimiter);
        callBackFuncStr.append("\t//Auto-generated method stub");
        callBackFuncStr.append(newLineDelimiter);
        callBackFuncStr.append("end");
        callBackFuncStr.append(newLineDelimiter);
    }

    private static void getDelegateFunctionString(DelegateBinding delegateBinding, String functionName, StringBuffer bfFunctionName, StringBuffer delegateFunctionStr, String newLineDelimeter, List<String> needImports, List<String> currImiports, String currFilePkg) {
        delegateFunctionStr.append("function");
        delegateFunctionStr.append(" ");
        delegateFunctionStr.append(functionName);
        delegateFunctionStr.append("(");
        List parameters = delegateBinding.getParemeters();
        int parameterIndex = 0;
        while (parameterIndex < parameters.size()) {
            Object object = parameters.get(parameterIndex);
            if (object instanceof FunctionParameterBinding) {
                FunctionParameterBinding functionParameterBinding = (FunctionParameterBinding)object;
                String name = functionParameterBinding.getCaseSensitiveName();
                ITypeBinding paraTypeBinding = functionParameterBinding.getType();
                String type = paraTypeBinding.getCaseSensitiveName();
                String qualifier = ExtractInterfaceConfiguration.getReferenceTypeParamQualifier(paraTypeBinding, currFilePkg);
                if (!qualifier.equalsIgnoreCase(currFilePkg)) {
                    String strImport = String.valueOf(qualifier) + (qualifier.length() > 0 ? "." : "");
                    if (!AddFunctionProposal.isAlreadyImported(currImiports, qualifier, strImport = String.valueOf(strImport) + paraTypeBinding.getBaseType().getCaseSensitiveName()) && !needImports.contains(strImport) && strImport.contains(".")) {
                        needImports.add(strImport);
                    }
                }
                String decorate = null;
                if (functionParameterBinding.isInput()) {
                    decorate = "in";
                } else if (functionParameterBinding.isOutput()) {
                    decorate = "out";
                } else if (functionParameterBinding.isInputOutput()) {
                    decorate = "inOut";
                }
                delegateFunctionStr.append(name).append(" ").append(type);
                if (decorate != null) {
                    delegateFunctionStr.append(" ").append(decorate);
                }
                if (parameterIndex + 1 < parameters.size()) {
                    delegateFunctionStr.append(", ");
                }
            }
            ++parameterIndex;
        }
        delegateFunctionStr.append(") ");
        ITypeBinding returnsTypeBinding = delegateBinding.getReturnType();
        if (returnsTypeBinding != null) {
            String qualifier = ExtractInterfaceConfiguration.getReferenceTypeParamQualifier(returnsTypeBinding, currFilePkg);
            if (!qualifier.equalsIgnoreCase(currFilePkg)) {
                String strImport = String.valueOf(qualifier) + (qualifier.length() > 0 ? "." : "");
                if (!AddFunctionProposal.isAlreadyImported(currImiports, qualifier, strImport = String.valueOf(strImport) + returnsTypeBinding.getBaseType().getCaseSensitiveName()) && !needImports.contains(strImport) && strImport.contains(".")) {
                    needImports.add(strImport);
                }
            }
            String type = returnsTypeBinding.getCaseSensitiveName();
            String nullable = null;
            nullable = returnsTypeBinding.isNullable() ? "?" : "";
            delegateFunctionStr.append("returns(").append(type).append(nullable).append(")");
        }
        bfFunctionName.append(delegateFunctionStr.toString());
        delegateFunctionStr.append(newLineDelimeter);
        delegateFunctionStr.append("\t//Auto-generated method stub");
        delegateFunctionStr.append(newLineDelimeter).append("end");
    }

    private static interface ICallbackArgumentPrinter {
        public void printArgs(Expression var1, StringBuffer var2);
    }
}

