/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion.sqldb;

import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.edt.compiler.internal.sql.StringToken;
import org.eclipse.edt.gen.generator.eglsource.EglSourceContext;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLRetrieveUtility;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLStructureItem;
import org.eclipse.edt.ide.ui.internal.dataaccess.conversion.sqldb.DataToolsSqlTemplate;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;

public class DataToolsSqlColumnTemplate
extends DataToolsSqlTemplate {
    private static String[] unsupportedColumnType = new String[]{"blob", "clob", "graphic", "vargraphic", "binary", "char for bit data", "varchar for bit data"};

    public void genColumn(Column column, EglSourceContext ctx) {
        if (!this.validateColumn(column, ctx)) {
            return;
        }
        ctx.appendVariableValue("recordFileContent", this.getFieldDefinition(column, ctx, true), "");
    }

    protected boolean validateColumn(Column column, EglSourceContext ctx) {
        IMessageHandler messageHandler = (IMessageHandler)ctx.get((Object)"dbMessageHandler");
        if (column.getContainedType() == null) {
            messageHandler.addMessage("Cannot get valid message from column metadata.");
            return false;
        }
        if (this.isUnsupportedColumnTpe(column.getContainedType().getName())) {
            StringBuilder builder = new StringBuilder();
            builder.append("Column Type: ");
            builder.append(column.getContainedType().getName());
            builder.append(" for ");
            builder.append(column.getTable().getSchema().getName());
            builder.append(".");
            builder.append(column.getTable().getName());
            builder.append(".");
            builder.append(column.getName());
            builder.append(" is not supported yet and will be skipped for its generation");
            messageHandler.addMessage(builder.toString());
            return false;
        }
        return true;
    }

    protected String getFieldDefinition(Column column, EglSourceContext ctx, boolean isEntityRecord) {
        EGLSQLStructureItem item = new EGLSQLStructureItem();
        String colNameAlias = null;
        DatabaseDefinition def = (DatabaseDefinition)ctx.get((Object)"dataDefinition");
        EGLSQLRetrieveUtility.getInstance().populateStructureItem(def, column, item);
        colNameAlias = this.getAliasName(item.getName().trim());
        StringBuilder builder = new StringBuilder();
        builder.append("\t");
        builder.append(this.getFieldName(column, item));
        builder.append(" ");
        builder.append(this.getFieldType(column, item));
        if (isEntityRecord) {
            builder.append(this.getFieldAnnotation(column, colNameAlias, item));
        }
        builder.append(";");
        return builder.toString();
    }

    protected String getFieldName(Column column, EGLSQLStructureItem item) {
        String colNameAlias = this.getAliasName(item.getName().trim());
        if (colNameAlias != null) {
            return StringToken.trim((String)colNameAlias).toLowerCase();
        }
        return StringToken.trim((String)item.getName()).toLowerCase();
    }

    protected String getFieldType(Column column, EGLSQLStructureItem item) {
        StringBuilder builder = new StringBuilder();
        builder.append(item.getPrimitiveType());
        if (item.getPrimitiveType().equals("char") || item.getPrimitiveType().equals("mbChar") || item.getPrimitiveType().equals("unicode") || item.getPrimitiveType().equals("limited string")) {
            builder.append("(");
            builder.append(item.getLength());
            builder.append(")");
        } else if (item.getPrimitiveType().equals("decimal")) {
            builder.append("(");
            builder.append(item.getLength());
            if (item.getDecimals() != null) {
                builder.append(",");
                builder.append(item.getDecimals());
            }
            builder.append(")");
        } else if (item.getPrimitiveType().equals("string") && item.getLength() != null) {
            try {
                int length = Integer.parseInt(item.getLength());
                if (length > 0) {
                    builder.append("(");
                    builder.append(item.getLength());
                    builder.append(")");
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (item.isNullable()) {
            builder.append("?");
        }
        return builder.toString();
    }

    protected String getFieldAnnotation(Column column, String colNameAlias, EGLSQLStructureItem item) {
        boolean isPartOfPK = column.isPartOfPrimaryKey();
        StringBuilder builder = new StringBuilder();
        if (isPartOfPK) {
            builder.append("{");
        }
        if (column.isPartOfPrimaryKey()) {
            builder.append(" @id ");
        }
        if (colNameAlias != null) {
            if (column.isPartOfPrimaryKey()) {
                builder.append(", ");
                builder.append("@column{ name =");
            } else {
                builder.append("{@column{ name =");
            }
            builder.append("\"");
            builder.append(StringToken.trim((String)item.getColumnName()));
            builder.append("\"");
            if (column.isPartOfPrimaryKey()) {
                builder.append("}");
            } else {
                builder.append("}");
                builder.append("}");
            }
        }
        if (isPartOfPK) {
            builder.append("}");
        }
        return builder.toString();
    }

    private boolean isUnsupportedColumnTpe(String columnTypeName) {
        boolean isUnSupported = false;
        String[] stringArray = unsupportedColumnType;
        int n = unsupportedColumnType.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals(columnTypeName.toLowerCase())) {
                isUnSupported = true;
                break;
            }
            ++n2;
        }
        return isUnSupported;
    }
}

