/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion.xmlschema;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;

public class WSDLUtil {
    private static int k16 = 16384;

    public static boolean isStandardArray(XSTypeDefinition xsdType) {
        XSTerm term;
        XSComplexTypeDefinition complexType;
        XSParticle particle;
        boolean rc = false;
        if (xsdType.getTypeCategory() == 15 && (particle = (complexType = (XSComplexTypeDefinition)xsdType).getParticle()) != null && (term = particle.getTerm()) != null && term instanceof XSModelGroup) {
            XSElementDeclaration element;
            XSParticle innerParticle;
            XSObjectList list = ((XSModelGroup)particle.getTerm()).getParticles();
            XSObjectList attributes = complexType.getAttributeUses();
            if (list.getLength() == 1 && attributes.getLength() == 0 && ((innerParticle = (XSParticle)list.item(0)).getMaxOccursUnbounded() || innerParticle.getMaxOccurs() > 1) && innerParticle.getTerm() instanceof XSElementDeclaration && (element = (XSElementDeclaration)innerParticle.getTerm()) != null) {
                rc = true;
            }
        }
        return rc;
    }

    public static boolean isString(XSSimpleTypeDefinition simpleType) {
        return 2 == simpleType.getBuiltInKind() && (WSDLUtil.isString(WSDLUtil.getLength(simpleType), WSDLUtil.getMaxLength(simpleType)) || WSDLUtil.getItemLength(simpleType) >= k16);
    }

    private static boolean isString(int length, int maxLength) {
        return length == -1 && maxLength == -1;
    }

    public static boolean isTimeStamp(XSSimpleTypeDefinition simpleType) {
        return 8 == simpleType.getBuiltInKind();
    }

    public static boolean isUnicode(XSSimpleTypeDefinition simpleType) {
        return 2 == simpleType.getBuiltInKind() && WSDLUtil.isUnicode(WSDLUtil.hasCollapse(simpleType), WSDLUtil.getLength(simpleType), WSDLUtil.getMaxLength(simpleType), WSDLUtil.getMinLength(simpleType));
    }

    private static boolean isUnicode(boolean hasCollapse, int length, int maxLength, int minLength) {
        return !hasCollapse && (length != -1 || maxLength != -1 && minLength != -1 && maxLength == minLength);
    }

    public static boolean isLimitedString(XSSimpleTypeDefinition simpleType) {
        return 2 == simpleType.getBuiltInKind() && WSDLUtil.isLimitedString(WSDLUtil.hasCollapse(simpleType), WSDLUtil.getLength(simpleType), WSDLUtil.getMaxLength(simpleType), WSDLUtil.getMinLength(simpleType));
    }

    private static boolean isLimitedString(boolean hasCollapse, int length, int maxLength, int minLength) {
        return !hasCollapse && (length != -1 || maxLength != -1);
    }

    public static boolean hasCollapse(XSSimpleTypeDefinition simpleType) {
        boolean result = false;
        if (simpleType.isDefinedFacet((short)16)) {
            result = "collapse".equalsIgnoreCase(simpleType.getLexicalFacetValue((short)16));
        }
        return result;
    }

    public static int getLength(XSSimpleTypeDefinition simpleType) {
        int length = -1;
        if (simpleType.isDefinedFacet((short)1)) {
            try {
                length = Integer.parseInt(simpleType.getLexicalFacetValue((short)1));
            }
            catch (Exception exception) {}
        }
        return length;
    }

    public static int getItemLength(XSSimpleTypeDefinition simpleType) {
        int length = 0;
        int maxLength = 0;
        if (WSDLUtil.getLength(simpleType) != -1) {
            length = WSDLUtil.getLength(simpleType);
        }
        if (WSDLUtil.getMaxLength(simpleType) != -1) {
            maxLength = WSDLUtil.getMaxLength(simpleType);
        }
        return length > maxLength ? length : maxLength;
    }

    public static int getMaxLength(XSSimpleTypeDefinition simpleType) {
        int maxLength = -1;
        if (simpleType.isDefinedFacet((short)4)) {
            try {
                maxLength = Integer.parseInt(simpleType.getLexicalFacetValue((short)4));
            }
            catch (Exception exception) {}
        }
        return maxLength;
    }

    public static int getMinLength(XSSimpleTypeDefinition simpleType) {
        int minLength = -1;
        if (simpleType.isDefinedFacet((short)2)) {
            try {
                minLength = Integer.parseInt(simpleType.getLexicalFacetValue((short)2));
            }
            catch (Exception exception) {}
        }
        return minLength;
    }

    public static int getTotalDigits(XSSimpleTypeDefinition simpleType) {
        int totalDigits = -1;
        if (simpleType.isDefinedFacet((short)512)) {
            try {
                totalDigits = Integer.parseInt(simpleType.getLexicalFacetValue((short)512));
            }
            catch (Exception exception) {}
        }
        return totalDigits;
    }

    public static String eglPattern(XSSimpleTypeDefinition simpleType) {
        if (!simpleType.isDefinedFacet((short)8)) {
            return "";
        }
        StringList patterns = simpleType.getLexicalPattern();
        if (patterns == null || patterns.getLength() == 0 || patterns.item(0) == null || patterns.item(0).length() == 0) {
            return "";
        }
        String wsdlPattern = patterns.item(0);
        StringBuffer buf = new StringBuffer();
        if (wsdlPattern != null && wsdlPattern.length() > 0) {
            buf.append(wsdlPattern);
        }
        int pos = 0;
        while (pos < buf.length()) {
            if (Character.isWhitespace(buf.charAt(pos))) {
                buf.deleteCharAt(pos);
                continue;
            }
            ++pos;
        }
        StringBuffer eglPattern = new StringBuffer();
        wsdlPattern = buf.toString().toUpperCase();
        if (wsdlPattern != null && wsdlPattern.length() > 0 && wsdlPattern.charAt(0) == 'P') {
            boolean secondInterval = wsdlPattern.indexOf(89) == -1 && (wsdlPattern.indexOf(84) != -1 || wsdlPattern.indexOf(68) != -1 || wsdlPattern.indexOf(72) != -1 || wsdlPattern.indexOf(83) != -1);
            boolean singleM = wsdlPattern.indexOf(77) == wsdlPattern.lastIndexOf(77);
            Hashtable<String, Integer> types = new Hashtable<String, Integer>();
            String[] parser = buf.toString().split("\\\\p");
            int i = 0;
            while (i < parser.length) {
                Integer digit = null;
                String type = null;
                parser[i] = parser[i];
                if (parser[i].length() > 0) {
                    String[] digitParser;
                    if (parser[i].indexOf("{Nd}") != -1) {
                        digitParser = parser[i].split("}");
                        if (digitParser.length > 1) {
                            type = digitParser[2];
                            int idx = digitParser[1].indexOf(44);
                            digitParser[1] = idx != -1 ? digitParser[1].substring(idx + 1) : digitParser[1].substring(1);
                            try {
                                digit = new Integer(Integer.parseInt(digitParser[1]));
                            }
                            catch (NumberFormatException numberFormatException) {
                                digit = new Integer(0);
                            }
                        }
                    } else if (parser[i].indexOf("\\d") != -1 && (digitParser = parser[i].split("\\\\d")).length > 1) {
                        type = digitParser[digitParser.length - 1].substring(digitParser[digitParser.length - 1].length() - 1);
                        digit = new Integer(digitParser.length - 1);
                    }
                    if (digit != null) {
                        if (types.get(type) != null || secondInterval && type.charAt(0) == 'M' && singleM) {
                            type = type.toLowerCase();
                        }
                        types.put(type, digit);
                    }
                }
                ++i;
            }
            if (secondInterval) {
                eglPattern.append(WSDLUtil.convertType((Integer)types.get("D"), 'd'));
                eglPattern.append(WSDLUtil.convertType((Integer)types.get("H"), 'H'));
                eglPattern.append(WSDLUtil.convertType((Integer)types.get("m"), 'm'));
                if (types.get(".") != null) {
                    eglPattern.append(WSDLUtil.convertType((Integer)types.get("."), 's'));
                    eglPattern.append(WSDLUtil.convertType((Integer)types.get("S"), 'f'));
                } else {
                    eglPattern.append(WSDLUtil.convertType((Integer)types.get("S"), 's'));
                }
            } else {
                eglPattern.append(WSDLUtil.convertType((Integer)types.get("Y"), 'y'));
                eglPattern.append(WSDLUtil.convertType((Integer)types.get("M"), 'M'));
            }
        }
        return eglPattern.toString();
    }

    public static String convertType(Integer digits, char eglType) {
        StringBuffer retVal = new StringBuffer();
        if (digits != null) {
            int i = 0;
            while (i < digits) {
                retVal.append(eglType);
                ++i;
            }
        }
        return retVal.toString();
    }

    public static String getEGLPrimitiveBase(XSSimpleTypeDefinition simpleType) {
        String type = "string";
        switch (simpleType.getBuiltInKind()) {
            case 34: 
            case 40: {
                type = "int";
                break;
            }
            case 30: {
                type = "num(31)";
            }
            case 4: {
                type = "decimal(31,4)";
                break;
            }
            case 3: {
                type = "boolean";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 44: {
                type = "string";
                break;
            }
            case 33: 
            case 39: {
                type = "bigint";
                break;
            }
            case 35: {
                type = "smallint";
                break;
            }
            case 10: {
                type = "date";
                break;
            }
            case 6: {
                type = "float";
                break;
            }
            case 5: {
                type = "smallfloat";
                break;
            }
            case 16: 
            case 36: 
            case 41: {
                type = "hex(2)";
                break;
            }
            case 8: {
                type = "timestamp";
                break;
            }
            case 9: {
                type = "time";
                break;
            }
            case 17: {
                type = "blob";
                break;
            }
            case 7: {
                type = "interval";
                break;
            }
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: {
                type = "decimal(31)";
                break;
            }
            default: {
                type = "string";
            }
        }
        return type;
    }

    public static int[] getDecimalDefinition(XSSimpleTypeDefinition simpleType) {
        String maxExclusive;
        if (simpleType.isDefinedFacet((short)512)) {
            int length = 31;
            int decimalDig = 0;
            try {
                length = Integer.parseInt(simpleType.getLexicalFacetValue((short)512));
            }
            catch (Exception exception) {}
            if (simpleType.isDefinedFacet((short)1024)) {
                try {
                    decimalDig = Integer.parseInt(simpleType.getLexicalFacetValue((short)1024));
                }
                catch (Exception exception) {}
            }
            return new int[]{length, decimalDig};
        }
        String minInclusive = simpleType.isDefinedFacet((short)256) ? simpleType.getLexicalFacetValue((short)256) : null;
        String maxInclusive = simpleType.isDefinedFacet((short)32) ? simpleType.getLexicalFacetValue((short)32) : null;
        String minExclusive = simpleType.isDefinedFacet((short)128) ? simpleType.getLexicalFacetValue((short)128) : null;
        String string = maxExclusive = simpleType.isDefinedFacet((short)64) ? simpleType.getLexicalFacetValue((short)64) : null;
        if (minInclusive == null && maxInclusive == null && minExclusive == null && maxExclusive == null) {
            return null;
        }
        int[] decimal = new int[2];
        if (minInclusive != null) {
            WSDLUtil.getDecimal(minInclusive.trim(), decimal);
        }
        if (maxInclusive != null) {
            WSDLUtil.getDecimal(maxInclusive.trim(), decimal);
        }
        if (minExclusive != null) {
            WSDLUtil.getDecimal(minExclusive.trim(), decimal);
        }
        if (maxExclusive != null) {
            WSDLUtil.getDecimal(maxExclusive.trim(), decimal);
        }
        return decimal;
    }

    private static void getDecimal(String clusive, int[] currentDecimal) {
        int length = 0;
        int decimal = 0;
        if (clusive != null && clusive.length() > 0) {
            block7: {
                try {
                    BigDecimal bd = new BigDecimal(clusive);
                    length = bd.abs().toPlainString().length() + (bd.scale() > 0 ? -1 : 0);
                    if (bd.scale() > 0) {
                        decimal = bd.scale();
                    }
                }
                catch (Exception exception) {
                    int idx = -1;
                    if ((clusive.charAt(0) == '-' || clusive.charAt(0) == '+') && clusive.length() > 1) {
                        clusive = clusive.substring(1);
                    }
                    length = clusive.length();
                    idx = clusive.indexOf(46);
                    if (idx <= -1) break block7;
                    decimal = length - (idx + 1);
                    length -= decimal;
                }
            }
            if (length > currentDecimal[0]) {
                currentDecimal[0] = length;
            }
            if (decimal > currentDecimal[1]) {
                currentDecimal[1] = decimal;
            }
        }
    }

    public static XSObject[] findLocalAnonymousElements(XSModel xsModel, String name) {
        ArrayList<XSObject> objects = new ArrayList<XSObject>();
        XSNamedMap map = xsModel.getComponents((short)3);
        int i = 0;
        while (i < map.getLength()) {
            XSTypeDefinition type = (XSTypeDefinition)map.item(i);
            if (type.getTypeCategory() == 15 && !type.getNamespace().equals("http://www.w3.org/2001/XMLSchema") && !WSDLUtil.isStandardArray(type)) {
                WSDLUtil.findLocalAnonymousElements((XSComplexTypeDefinition)type, name, objects);
            }
            ++i;
        }
        map = xsModel.getComponents((short)2);
        i = 0;
        while (i < map.getLength()) {
            XSObject xsObject = map.item(i);
            if (xsObject instanceof XSElementDeclaration) {
                XSElementDeclaration xsElement = (XSElementDeclaration)xsObject;
                WSDLUtil.findLocalAnonymousElements(xsElement, name, objects);
            }
            ++i;
        }
        return objects.toArray(new XSObject[objects.size()]);
    }

    public static void findLocalAnonymousElements(XSComplexTypeDefinition type, String name, ArrayList<XSObject> objects) {
        XSModelGroup extGroup;
        if (type.getParticle() == null) {
            return;
        }
        XSModelGroup xsModelGroup = (XSModelGroup)type.getParticle().getTerm();
        if (xsModelGroup != (extGroup = WSDLUtil.getExtensionGroup(type))) {
            WSDLUtil.findLocalAnonymousElements(xsModelGroup, extGroup, name, objects);
        }
    }

    public static void findLocalAnonymousElements(XSModelGroup xsModelGroup, XSModelGroup extGroup, String name, ArrayList<XSObject> objects) {
        XSObjectList xsObjectList = xsModelGroup.getParticles();
        int i = 0;
        while (i < xsObjectList.getLength()) {
            XSParticle xsParticle = (XSParticle)xsObjectList.item(i);
            if (xsParticle.getTerm() instanceof XSModelGroup) {
                if (xsParticle.getTerm() != extGroup) {
                    WSDLUtil.findLocalAnonymousElements((XSModelGroup)xsParticle.getTerm(), null, name, objects);
                }
            } else if (xsParticle.getTerm() instanceof XSElementDeclaration) {
                XSElementDeclaration xsElement = (XSElementDeclaration)xsParticle.getTerm();
                WSDLUtil.findLocalAnonymousElements(xsElement, name, objects);
            }
            ++i;
        }
    }

    public static void findLocalAnonymousElements(XSElementDeclaration element, String name, ArrayList<XSObject> objects) {
        if (element.getTypeDefinition().getTypeCategory() == 15) {
            XSComplexTypeDefinition type = (XSComplexTypeDefinition)element.getTypeDefinition();
            if (type.getAnonymous() && element.getScope() == 2 && name.equals(element.getName()) && !objects.contains(element)) {
                objects.add((XSObject)element);
            }
            WSDLUtil.findLocalAnonymousElements(type, name, objects);
        }
    }

    public static XSModelGroup getExtensionGroup(XSComplexTypeDefinition xsComplexType) {
        XSModelGroup group = null;
        XSTypeDefinition derivedType = xsComplexType.getBaseType();
        if (WSDLUtil.isExtensionType(xsComplexType) && derivedType instanceof XSComplexTypeDefinition && xsComplexType.getParticle() != null) {
            group = (XSModelGroup)((XSComplexTypeDefinition)derivedType).getParticle().getTerm();
        }
        return group;
    }

    public static boolean isExtensionType(XSComplexTypeDefinition xsComplexType) {
        XSTypeDefinition derivedType = xsComplexType.getBaseType();
        return xsComplexType.getDerivationMethod() == 1 && xsComplexType.derivedFromType(derivedType, (short)1);
    }

    public static boolean isSpecialArrayType(XSTypeDefinition type) {
        return type instanceof XSSimpleTypeDefinition && (((XSSimpleTypeDefinition)type).getBuiltInKind() == 17 || ((XSSimpleTypeDefinition)type).getBuiltInKind() == 16);
    }
}

