/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragment;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.edt.ide.ui.internal.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class EGLSearchResultLabelProvider
extends LabelProvider {
    public static final int SHOW_LABEL = 1;
    public static final int SHOW_LABEL_PATH = 2;
    public static final int SHOW_PATH_LABEL = 3;
    public static final int SHOW_PATH = 4;
    private static final String fgSeparatorFormat = "{0} - {1}";
    private WorkbenchLabelProvider fLabelProvider;
    private AbstractTextSearchViewPage fPage;
    private int fOrder;
    private String[] fArgs = new String[2];

    public EGLSearchResultLabelProvider(AbstractTextSearchViewPage page, int orderFlag) {
        this.fLabelProvider = new WorkbenchLabelProvider();
        this.fOrder = orderFlag;
        this.fPage = page;
    }

    public void setOrder(int orderFlag) {
        this.fOrder = orderFlag;
    }

    public int getOrder() {
        return this.fOrder;
    }

    public String getText(Object element) {
        if (element instanceof IFunction) {
            String fullName = ((IFunction)element).getElementName();
            int index = fullName.indexOf("#");
            if (index != -1) {
                return fullName.substring(index + 1);
            }
            return fullName;
        }
        if (element instanceof IPart || element instanceof ClassFile) {
            int matchCount = 0;
            AbstractTextSearchResult result = this.fPage.getInput();
            if (result != null) {
                matchCount = result.getMatchCount(element);
            }
            if (matchCount <= 1) {
                return ((IEGLElement)element).getElementName();
            }
            String format = EGLSearchMessages.EGLSearchResultLabelProviderCountFormat;
            return MessageFormat.format(format, ((IEGLElement)element).getElementName(), new Integer(matchCount));
        }
        if (element instanceof IEGLElement) {
            if (element instanceof EglarPackageFragment) {
                String packageName = ((IEGLElement)element).getElementName();
                if (packageName == null || packageName.trim().length() == 0) {
                    packageName = EGLSearchMessages.EGLSearchResultLabelProviderDefaultPackage;
                }
                return packageName;
            }
            if (element instanceof EglarPackageFragmentRoot) {
                String eglarName = ((IEGLElement)element).getElementName();
                return eglarName;
            }
        } else if (!(element instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)element;
        String text = null;
        if (!resource.exists()) {
            text = EGLSearchMessages.EGLSearchResultLabelProviderRemoved_resourceLabel;
        } else {
            IPath path = resource.getFullPath().removeLastSegments(1);
            if (path.getDevice() == null) {
                path = path.makeRelative();
            }
            if (this.fOrder == 1 || this.fOrder == 2) {
                text = this.fLabelProvider.getText((Object)resource);
                if (path != null && this.fOrder == 2) {
                    this.fArgs[0] = text;
                    this.fArgs[1] = path.toString();
                    text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                }
            } else {
                text = path != null ? path.toString() : "";
                if (this.fOrder == 3) {
                    this.fArgs[0] = text;
                    this.fArgs[1] = this.fLabelProvider.getText((Object)resource);
                    text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                }
            }
        }
        int matchCount = 0;
        AbstractTextSearchResult result = this.fPage.getInput();
        if (result != null) {
            matchCount = result.getMatchCount(element);
        }
        if (matchCount <= 1) {
            return text;
        }
        String format = EGLSearchMessages.EGLSearchResultLabelProviderCountFormat;
        return MessageFormat.format(format, text, new Integer(matchCount));
    }

    public Image getImage(Object element) {
        if (element instanceof IFunction) {
            ImageDescriptorRegistry reg = EDTUIPlugin.getImageDescriptorRegistry();
            ImageDescriptor desp = PluginImages.DESC_OBJS_FUNCTION;
            return reg.get(desp);
        }
        if (element instanceof IPart || element instanceof ClassFile) {
            ImageDescriptorRegistry reg = EDTUIPlugin.getImageDescriptorRegistry();
            ImageDescriptor desp = PluginImages.DESC_OBJS_CFILE;
            return reg.get(desp);
        }
        if (element instanceof EglarPackageFragmentRoot) {
            ImageDescriptorRegistry reg = EDTUIPlugin.getImageDescriptorRegistry();
            ImageDescriptor desp = PluginImages.DESC_OBJS_PACKFRAG_ROOT_EGLAR;
            return reg.get(desp);
        }
        if (element instanceof IEGLElement) {
            ImageDescriptorRegistry reg = EDTUIPlugin.getImageDescriptorRegistry();
            ImageDescriptor desp = PluginImages.DESC_OBJS_PACKAGE;
            return reg.get(desp);
        }
        if (!(element instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)element;
        Image image = this.fLabelProvider.getImage((Object)resource);
        return image;
    }

    public void dispose() {
        super.dispose();
        this.fLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.fLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.fLabelProvider.removeListener(listener);
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.fLabelProvider.addListener(listener);
    }
}

