/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ConnectionDisplayProperty;
import org.eclipse.edt.compiler.core.EGLKeywordHandler;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.generator.eglsource.EglSourceContext;
import org.eclipse.edt.gen.generator.eglsource.EglSourceGenerator;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.dataaccess.conversion.sqldb.DTO2EglSource;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.ide.ui.internal.util.UISQLUtility;
import org.eclipse.edt.ide.ui.internal.wizards.DTOConfigPage;
import org.eclipse.edt.ide.ui.internal.wizards.DTOConfiguration;
import org.eclipse.edt.ide.ui.internal.wizards.EGLCodePreviewPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizard;
import org.eclipse.edt.ide.ui.wizards.BindingSQLDatabaseConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPartConfiguration;
import org.eclipse.edt.ide.ui.wizards.MultiEGLFileOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractDataAccessWizard
extends TemplateWizard
implements IWorkbenchWizard,
IPageChangingListener,
IPageChangedListener,
IMessageHandler {
    protected DTOConfiguration config;
    protected DTOConfigPage sqlDbPage;
    protected EGLCodePreviewPage summaryPage;
    protected IStructuredSelection selection;
    protected List<String> messages = new ArrayList<String>();
    protected Hashtable<String, String> sourceFileContents;
    protected String javaPackageName;
    protected String javaJsPackageName;
    protected String generatingProgressMonitorText;
    protected String dto2EGLContributor;
    protected boolean needConfigGenerator = false;
    protected int steps;

    public AbstractDataAccessWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(EDTUIPlugin.getDefault().getDialogSettings());
        this.config = new DTOConfiguration();
        this.initPages();
    }

    protected abstract void initPages();

    public void addPages() {
        this.addPage((IWizardPage)this.sqlDbPage);
        this.addPage((IWizardPage)this.summaryPage);
    }

    public void init(IWorkbench arg0, IStructuredSelection selection) {
        this.selection = selection;
    }

    @Override
    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, this.createFinishOperation());
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            EGLLogger.log((Object)this, ex.toString());
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EGLLogger.log((Object)this, ex.toString());
            return false;
        }
        return true;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer != null) {
            ((WizardDialog)wizardContainer).addPageChangingListener((IPageChangingListener)this);
            ((WizardDialog)wizardContainer).addPageChangedListener((IPageChangedListener)this);
        }
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getTargetPage() == this.summaryPage) {
            IRunnableWithProgress op = this.createPreviewOperation();
            try {
                this.getContainer().run(true, true, op);
            }
            catch (InterruptedException ex) {
                event.doit = false;
                ex.printStackTrace();
                EGLLogger.log((Object)this, ex.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                EGLLogger.log((Object)this, ex.toString());
            }
        }
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage() == this.summaryPage) {
            this.summaryPage.formatSourceDocument();
        } else if (event.getSelectedPage() == this.sqlDbPage) {
            this.sourceFileContents = null;
        }
    }

    protected IRunnableWithProgress createPreviewOperation() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ConnectionInfo connection;
                if (AbstractDataAccessWizard.this.messages != null) {
                    AbstractDataAccessWizard.this.messages.clear();
                }
                if ((connection = AbstractDataAccessWizard.this.getConnectionInfo()) == null) {
                    throw new InterruptedException("Can not get the data base connection!");
                }
                AbstractDataAccessWizard.this.sourceFileContents = AbstractDataAccessWizard.this.generateEGLCode(monitor, connection);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).AbstractDataAccessWizard.this.summaryPage.setsourceFileContentTable((this).AbstractDataAccessWizard.this.sourceFileContents);
                        (this).AbstractDataAccessWizard.this.summaryPage.setDeafultSelectFile(AbstractDataAccessWizard.this.getMainEGLFile());
                        List<String> messages = AbstractDataAccessWizard.this.getMessages();
                        if (messages != null && messages.size() > 0) {
                            (this).AbstractDataAccessWizard.this.summaryPage.setMessages(messages);
                        }
                    }
                });
            }
        };
    }

    protected ConnectionInfo getConnectionInfo() {
        IManagedConnection managedConnection = this.config.getDatabaseConnection().getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
        if (managedConnection != null) {
            return (ConnectionInfo)managedConnection.getConnection().getRawConnection();
        }
        return null;
    }

    protected IRunnableWithProgress createFinishOperation() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (AbstractDataAccessWizard.this.sourceFileContents == null) {
                    ConnectionInfo connection = AbstractDataAccessWizard.this.getConnectionInfo();
                    AbstractDataAccessWizard.this.sourceFileContents = AbstractDataAccessWizard.this.generateEGLCode(monitor, connection);
                }
                EGLPartConfiguration epc = AbstractDataAccessWizard.this.getConfiguration();
                MultiEGLFileOperation mefo = new MultiEGLFileOperation(epc, AbstractDataAccessWizard.this.sourceFileContents);
                try {
                    mefo.execute(monitor);
                    epc.setFile(mefo.getFile(AbstractDataAccessWizard.this.getMainEGLFile()));
                }
                catch (CoreException e) {
                    throw new InterruptedException(e.toString());
                }
                if (AbstractDataAccessWizard.this.needConfigGenerator) {
                    AbstractDataAccessWizard.this.setupPackageGenerator();
                }
                if (AbstractDataAccessWizard.this.config.isSaveConnectionToDeploymentDescriptor()) {
                    AbstractDataAccessWizard.this.setupSqlBinding(AbstractDataAccessWizard.this.getConnectionInfo(), true);
                }
            }
        };
    }

    public abstract String getMainEGLFile();

    public void setupPackageGenerator() {
        EGLPartConfiguration epc = this.getConfiguration();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(epc.getProjectName());
        IEGLProject eproject = EGLCore.create((IProject)project);
        Path sourcePath = new Path(epc.getContainerName());
        try {
            IPackageFragmentRoot root = eproject.findPackageFragmentRoot(sourcePath.makeAbsolute());
            IPackageFragment frag = root.getPackageFragment(this.javaPackageName);
            ProjectSettingsUtility.setGeneratorIds((IResource)frag.getResource(), (String[])new String[]{"org.eclipse.edt.ide.gen.JavaGenProvider"});
            frag = root.getPackageFragment(this.javaJsPackageName);
            ProjectSettingsUtility.setGeneratorIds((IResource)frag.getResource(), (String[])new String[]{"org.eclipse.edt.ide.gen.JavaGenProvider", "org.eclipse.edt.ide.gen.JavaScriptGenProvider", "org.eclipse.edt.ide.gen.JavaScriptDevGenProvider"});
        }
        catch (EGLModelException ex) {
            ex.printStackTrace();
            EGLLogger.log((Object)this, ex.toString());
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
            EGLLogger.log((Object)this, ex.toString());
        }
    }

    public EGLPartConfiguration getConfiguration() {
        EGLPartConfiguration configuration = (EGLPartConfiguration)((EGLPartWizard)this.getParentWizard()).getConfiguration();
        return configuration;
    }

    protected Hashtable<String, String> generateEGLCode(IProgressMonitor monitor, ConnectionInfo connection) throws InterruptedException {
        DTO2EglSource d = new DTO2EglSource(this.dto2EGLContributor);
        monitor.beginTask(this.generatingProgressMonitorText, this.config.getSelectedTables().size() + this.steps);
        EglSourceGenerator generator = new EglSourceGenerator((AbstractGeneratorCommand)d);
        EglSourceContext context = generator.makeContext((AbstractGeneratorCommand)d);
        this.setupEGLSourceContext(context, connection, monitor);
        try {
            d.generate(this.config, generator, null);
        }
        catch (Exception ex) {
            this.addMessage(ex.getMessage());
            EGLLogger.log((Object)this, ex.toString());
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        return generator.getResult();
    }

    protected String setupSqlBinding(ConnectionInfo connection, boolean isSaved) {
        String bindingName = null;
        BindingSQLDatabaseConfiguration sqlConfig = new BindingSQLDatabaseConfiguration();
        IFile eglddFile = CoreUtility.getOrCreateEGLDDFileHandle(this.getConfiguration());
        if (eglddFile != null) {
            EGLDeploymentRoot deploymentRoot = null;
            try {
                deploymentRoot = EGLDDRootHelper.getEGLDDFileSharedWorkingModel(eglddFile, false);
                IConnectionProfile profile = connection.getConnectionProfile();
                ConnectionDisplayProperty[] properties = EGLSQLUtility.getConnectionDisplayProperties((IConnectionProfile)profile);
                UISQLUtility.setBindingSQLDatabaseConfiguration(sqlConfig, properties);
                sqlConfig.setUseUri(true);
                Deployment deployment = deploymentRoot.getDeployment();
                DeploymentFactory factory = DeploymentFactory.eINSTANCE;
                Bindings bindings = deployment.getBindings();
                if (bindings == null) {
                    bindings = factory.createBindings();
                    deployment.setBindings(bindings);
                }
                EList existedBindings = bindings.getBinding();
                boolean existed = false;
                for (Binding binding : existedBindings) {
                    if (org.eclipse.edt.javart.resources.egldd.Binding.BINDING_DB_SQL.equals(binding.getType()) && binding.isUseURI() && binding.getUri() != null && binding.getUri().equals("workspace://" + profile.getName())) {
                        existed = true;
                        bindingName = binding.getName();
                    }
                    if (existed) break;
                }
                if (!existed) {
                    if (isSaved) {
                        sqlConfig.setUri("workspace://" + profile.getName());
                        Binding b = (Binding)sqlConfig.executeAddBinding(bindings);
                        bindingName = b.getName();
                    } else {
                        bindingName = sqlConfig.getValidBindingName();
                    }
                }
                if (!EGLDDRootHelper.isWorkingModelSharedByUserClients(eglddFile)) {
                    EGLDDRootHelper.saveEGLDDFile(eglddFile, deploymentRoot);
                }
            }
            finally {
                if (deploymentRoot != null) {
                    EGLDDRootHelper.releaseSharedWorkingModel(eglddFile, false);
                }
            }
        }
        return bindingName;
    }

    @Override
    public void addMessage(String message) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.add(message);
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }

    public void setupEGLSourceContext(EglSourceContext context, ConnectionInfo connection, IProgressMonitor monitor) {
        context.put((Object)"dataDefinition", (Object)connection.getDatabaseDefinition());
        context.put((Object)"tableNameQualified", (Object)this.config.isQualifiedTableNames());
        context.put((Object)"dbMessageHandler", (Object)this);
        context.put((Object)"monitor", (Object)monitor);
        String bindingName = "sqlBindingName";
        if (this.config.isSaveConnectionToDeploymentDescriptor()) {
            bindingName = this.setupSqlBinding(connection, false);
        }
        context.getVariables().put("sqlBindingName", bindingName);
        String basePackage = this.getConfiguration().getFPackage();
        context.getVariables().put("basePackageName", basePackage);
        context.getVariables().put("subPackageName", "common");
        context.getVariables().put("databaseName", this.config.getDatabaseName());
        if (this.needConfigGenerator) {
            String dbName;
            String dbPkg = dbName = this.config.getDatabaseName().toLowerCase();
            if (EGLKeywordHandler.getKeywordHashSet().contains(dbName.toLowerCase(Locale.ENGLISH))) {
                dbPkg = "_" + dbName;
            } else {
                String camelStr = CoreUtility.getCamelCaseString(dbName);
                if (camelStr != null) {
                    dbPkg = camelStr;
                }
            }
            this.javaPackageName = basePackage == null || basePackage.equals("") ? dbPkg : String.valueOf(basePackage) + "." + dbPkg;
            this.javaJsPackageName = String.valueOf(this.javaPackageName) + ".common";
            context.getVariables().put("javaPackageName", this.javaPackageName);
            context.getVariables().put("javaJsPackageName", this.javaJsPackageName);
        }
    }
}

