/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.DataTableWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.DataTableConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class DataTableWizardPage
extends EGLPartWizardPage {
    private int dataTableType = 0;
    private static final String PAGE_NAME = "NewDataTableWizardPage";
    private static final String SETTINGS_DATA_TABLE_TYPE = "data_table_type";
    private int nColumns = 5;
    private StringDialogField fDataTableDialogField;
    private StatusInfo fDataTableStatus;
    private Group fDataTableTypeGroup;
    private Button fNoneDataTableButton;
    private Button fMessageDataTableButton;
    private Button fMatchValidDataTableButton;
    private Button fMatchInvalidDataTableButton;
    private Button fRangeCheckDataTableButton;
    private DataTableFieldAdapter adapter = new DataTableFieldAdapter();

    protected DataTableWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLTableWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLTableWizardPageDescription);
        this.fDataTableStatus = new StatusInfo();
    }

    @Override
    public void init() {
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section != null) {
            try {
                this.dataTableType = section.getInt(SETTINGS_DATA_TABLE_TYPE);
                this.getConfiguration().setDataTableType(this.dataTableType);
            }
            catch (NumberFormatException numberFormatException) {
                this.dataTableType = 0;
                section.put(SETTINGS_DATA_TABLE_TYPE, this.dataTableType);
            }
        }
    }

    private DataTableConfiguration getConfiguration() {
        return (DataTableConfiguration)((DataTableWizard)this.getWizard()).getConfiguration();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.init();
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_DATA_TABLE_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.createDataTablePartControls(composite);
        this.modifyFileListeners();
        this.createDataTableTypeControls(composite);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private void createDataTablePartControls(Composite parent) {
        this.fDataTableDialogField = new StringDialogField();
        this.fDataTableDialogField.setDialogFieldListener(this.adapter);
        this.fDataTableDialogField.setLabelText(NewWizardMessages.NewEGLTableWizardPagePartlabel);
        this.fDataTableDialogField.setText(this.getConfiguration().getDataTableName());
        this.fDataTableDialogField.setEnabled(false);
        this.fDataTableDialogField.doFillIntoGrid(parent, this.nColumns - 1);
        DialogField.createEmptySpace(parent);
        LayoutUtil.setWidthHint((Control)this.fDataTableDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fDataTableDialogField.getTextControl(null));
    }

    private void modifyFileListeners() {
        this.fEGLFileDialogField.getTextControl(null).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataTableWizardPage.this.fDataTableDialogField.setText(DataTableWizardPage.this.fEGLFileDialogField.getText());
            }
        });
    }

    private void createDataTableTypeControls(Composite parent) {
        Composite dataTableTypeComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        dataTableTypeComposite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        dataTableTypeComposite.setLayoutData((Object)gd);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 3;
        groupLayout.verticalSpacing = 2;
        gd = new GridData(768);
        this.fDataTableTypeGroup = new Group(dataTableTypeComposite, 0);
        this.fDataTableTypeGroup.setText(NewWizardMessages.NewEGLTableWizardPageDataTableSubTypeLabel);
        this.fDataTableTypeGroup.setLayout((Layout)groupLayout);
        this.fDataTableTypeGroup.setLayoutData((Object)gd);
        this.fNoneDataTableButton = new Button((Composite)this.fDataTableTypeGroup, 16);
        this.fNoneDataTableButton.setText(NewWizardMessages.NewEGLTableWizardPageTableTypeNone);
        this.fNoneDataTableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTableWizardPage.this.getConfiguration().setDataTableType(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fMessageDataTableButton = new Button((Composite)this.fDataTableTypeGroup, 16);
        this.fMessageDataTableButton.setText(NewWizardMessages.NewEGLTableWizardPageTableTypeMessage);
        this.fMessageDataTableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTableWizardPage.this.getConfiguration().setDataTableType(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fMatchValidDataTableButton = new Button((Composite)this.fDataTableTypeGroup, 16);
        this.fMatchValidDataTableButton.setText(NewWizardMessages.NewEGLTableWizardPageTableTypeMatchvalid);
        this.fMatchValidDataTableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTableWizardPage.this.getConfiguration().setDataTableType(2);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fMatchInvalidDataTableButton = new Button((Composite)this.fDataTableTypeGroup, 16);
        this.fMatchInvalidDataTableButton.setText(NewWizardMessages.NewEGLTableWizardPageTableTypeMatchinvalid);
        this.fMatchInvalidDataTableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTableWizardPage.this.getConfiguration().setDataTableType(3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fRangeCheckDataTableButton = new Button((Composite)this.fDataTableTypeGroup, 16);
        this.fRangeCheckDataTableButton.setText(NewWizardMessages.NewEGLTableWizardPageTableTypeRangecheck);
        this.fRangeCheckDataTableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataTableWizardPage.this.getConfiguration().setDataTableType(4);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        switch (this.dataTableType) {
            case 1: {
                this.fMessageDataTableButton.setSelection(true);
                break;
            }
            case 2: {
                this.fMatchValidDataTableButton.setSelection(true);
                break;
            }
            case 3: {
                this.fMatchInvalidDataTableButton.setSelection(true);
                break;
            }
            case 4: {
                this.fRangeCheckDataTableButton.setSelection(true);
                break;
            }
            default: {
                this.fNoneDataTableButton.setSelection(true);
            }
        }
    }

    private void handleDataTableDialogFieldChanged() {
        this.getConfiguration().setDataTableName(this.fDataTableDialogField.getText());
        this.validatePage();
    }

    @Override
    protected boolean validatePage() {
        if (super.validatePage()) {
            this.fDataTableStatus.setOK();
            String partName = this.getConfiguration().getDataTableName();
            if (partName.length() == 0) {
                this.fDataTableStatus.setError(NewWizardMessages.NewTypeWizardPageErrorEnterPartName);
            } else if (partName.indexOf(46) != -1) {
                this.fDataTableStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
            } else {
                this.validateEGLName(partName, 8, this.fDataTableStatus);
            }
            this.updateStatus(new IStatus[]{this.fDataTableStatus});
            return this.fDataTableStatus.getSeverity() != 4;
        }
        return false;
    }

    @Override
    public void finishPage() {
        super.finishPage();
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(PAGE_NAME);
        }
        section.put(SETTINGS_DATA_TABLE_TYPE, this.getConfiguration().getDataTableType());
    }

    private class DataTableFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private DataTableFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            DataTableWizardPage.this.handleDataTableDialogFieldChanged();
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }
}

