/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.BindingBaseConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class DedicatedBindingWizardPage
extends EGLDDBindingWizardPage {
    public static final String WIZPAGENAME_DedicatedBindingWizardPage = "WIZPAGENAME_DedicatedBindingWizardPage";

    public DedicatedBindingWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.TitleAddDedicatedBinding);
        this.setDescription(NewWizardMessages.DescAddDedicatedBinding);
        this.nColumns = 3;
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.MODULE_DEDICATEDBINDING);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createComponentNameControl(composite, NewWizardMessages.LabelDedicatedBindingName, this.getEGLDDBindingConfiguration().getConfiguration("edt.binding.dedicated"));
        Label note = new Label(composite, 64);
        note.setText(NewWizardMessages.LabelDedicatedBindingNote);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        gd.verticalIndent = 20;
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        note.setLayoutData((Object)gd);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
        this.determinePageCompletion();
    }

    @Override
    protected void createComponentNameControl(Composite parent, String labelName, final BindingBaseConfiguration esConfig) {
        this.fNameField = new StringDialogField();
        this.fNameField.setLabelText(labelName);
        this.createStringDialogField(parent, this.fNameField, new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                if (field == DedicatedBindingWizardPage.this.fNameField) {
                    DedicatedBindingWizardPage.this.HandleBindingNameChanged(esConfig);
                }
            }
        });
    }

    @Override
    protected void HandleBindingNameChanged(BindingBaseConfiguration esConfig) {
        super.HandleBindingNameChanged(esConfig);
        this.determinePageCompletion();
    }

    @Override
    protected boolean determinePageCompletion() {
        this.setErrorMessage(null);
        boolean result = true;
        String name = this.fNameField.getText();
        if (name == null || name.trim().length() == 0) {
            this.setErrorMessage(NewWizardMessages.RestBindingBlankError);
            result = false;
        }
        this.setPageComplete(result);
        return result;
    }
}

