/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPackageWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.BindingBaseConfiguration;
import org.eclipse.edt.ide.ui.wizards.BindingEGLConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class EGLBindingWizardPage
extends EGLDDBindingWizardPage {
    public static final String WIZPAGENAME_EGLBindingWizardPage = "WIZPAGENAME_EGLBindingWizardPage";
    private StringDialogField fServiceNameField;
    private StringDialogField fAliasField;
    private EGLBindingFieldAdapter adapter = new EGLBindingFieldAdapter();
    private StatusInfo fServiceNameStatus;

    public EGLBindingWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.EGLBindingWizPageTitle);
        this.setDescription(NewWizardMessages.EGLBindingWizPageDescription);
        this.nColumns = 4;
        this.fServiceNameStatus = new StatusInfo();
    }

    public void HandleEGLBindingNameBrowsePressed() {
        IPart servicePart = this.browsedEGLPartFQValue(this.getBindingEGLConfiguration().getProject(), 3072, true);
        if (servicePart != null) {
            SourcePart sourcePart = (SourcePart)servicePart;
            this.fNameField.setText(servicePart.getElementName());
            try {
                SourcePartElementInfo elemInfo = (SourcePartElementInfo)sourcePart.getElementInfo();
                if (elemInfo.isService()) {
                    this.fServiceNameField.setText(servicePart.getFullyQualifiedName());
                    this.fAliasField.setText(this.getBindingEGLConfiguration().getAliasFrServicePart(servicePart));
                }
            }
            catch (EGLModelException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void HandleBindingNameChanged(BindingBaseConfiguration esConfig) {
        super.HandleBindingNameChanged(esConfig);
        this.validatePage();
    }

    @Override
    protected boolean validatePage() {
        String serviceName;
        this.fNameStatus.setOK();
        this.fServiceNameStatus.setOK();
        this.validateBindingName(this.fNameStatus);
        if (this.fServiceNameField != null && ((serviceName = this.fServiceNameField.getText()) == null || serviceName.trim().length() == 0)) {
            this.fServiceNameStatus.setError(NewWizardMessages.EGLBindingValidationMsgFQServiceName);
        }
        this.updateStatus(new IStatus[]{this.fNameStatus, this.fServiceNameStatus});
        return !this.fNameStatus.isError() && !this.fServiceNameStatus.isError();
    }

    protected BindingEGLConfiguration getBindingEGLConfiguration() {
        return (BindingEGLConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(WIZPAGENAME_EGLBindingWizardPage);
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGLDDWIZ_ADDBINDING_EGL);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createBindingControls(composite);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    protected void createBindingControls(Composite composite) {
        EGLDeploymentRoot deploymentRoot = this.getEGLDDBindingConfiguration().getDeploymentRoot();
        this.createBindingControls(composite, this.getEGLDDBindingConfiguration().getBindingEGLConfiguration(), deploymentRoot, false);
    }

    protected void createBindingControls(Composite composite, BindingEGLConfiguration bindingEGLConfig, EGLDeploymentRoot deploymentRoot, boolean isReadOnly) {
        this.createComponentNameControl(composite, NewWizardMessages.EGLBindingNameLabel, bindingEGLConfig);
        this.createServiceNameControl(composite, isReadOnly);
        this.createAliasControl(composite, isReadOnly);
    }

    @Override
    protected void createComponentNameControl(Composite parent, String labelName, BindingBaseConfiguration esConfig) {
        this.fNameField = this.createStringBrowseButtonDialogField(parent, this.adapter, labelName, esConfig.getBindingName(), this.nColumns - 1);
    }

    private void createServiceNameControl(Composite composite, boolean isReadOnly) {
        this.fServiceNameField = new StringDialogField();
        this.fServiceNameField.setLabelText(NewWizardMessages.ServiceNameLabel);
        this.fServiceNameField.setText(this.getBindingEGLConfiguration().getEGLServiceOrInterface());
        this.createStringDialogField(composite, this.fServiceNameField, this.adapter);
        this.fServiceNameField.getTextControl(composite).setEditable(!isReadOnly);
    }

    private void createAliasControl(Composite composite, boolean isReadOnly) {
        this.fAliasField = new StringDialogField();
        this.fAliasField.setLabelText(NewWizardMessages.ServiceAliasLabel);
        this.fAliasField.setText(this.getBindingEGLConfiguration().getAlias());
        this.createStringDialogField(composite, this.fAliasField, this.adapter);
        this.fAliasField.getTextControl(composite).setEditable(!isReadOnly);
    }

    public void HandleAliasFieldChanged() {
        this.getBindingEGLConfiguration().setAlias(this.fAliasField.getText());
    }

    public void HandleServiceNameFieldChanged() {
        this.getBindingEGLConfiguration().setEGLServiceOrInterface(this.fServiceNameField.getText());
        this.validatePage();
    }

    private class EGLBindingFieldAdapter
    implements EGLPackageWizardPage.IStringBrowseButtonFieldAdapter {
        private EGLBindingFieldAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field == EGLBindingWizardPage.this.fNameField) {
                EGLBindingWizardPage.this.HandleBindingNameChanged(EGLBindingWizardPage.this.getBindingEGLConfiguration());
            } else if (field == EGLBindingWizardPage.this.fAliasField) {
                EGLBindingWizardPage.this.HandleAliasFieldChanged();
            } else if (field == EGLBindingWizardPage.this.fServiceNameField) {
                EGLBindingWizardPage.this.HandleServiceNameFieldChanged();
            }
        }

        @Override
        public void changeControlPressed(DialogField field) {
            if (field == EGLBindingWizardPage.this.fNameField) {
                EGLBindingWizardPage.this.HandleEGLBindingNameBrowsePressed();
            }
        }
    }
}

