/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.ui.editor.EGLCodeFormatterUtil;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.editor.DocumentProvider;
import org.eclipse.edt.ide.ui.internal.editor.EGLSourceViewerConfiguration;
import org.eclipse.edt.ide.ui.internal.editor.TextTools;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class EGLCodePreviewPage
extends WizardPage {
    private SourceViewer fPreviewViewer;
    private Label warningLabel;
    private Table messageList;
    private Combo fileSelector;
    private Hashtable<String, String> sourceFileContentTable;
    private String deafultSelectFile;
    private Hashtable<String, IDocument> formattedSourceFileContentTable = new Hashtable();
    private Composite messageComposite;
    private Composite codeViewerSelectorContainer;
    private Composite multiFileSelectorContainer;

    public EGLCodePreviewPage(String pageName) {
        super(pageName);
    }

    public EGLCodePreviewPage(String pageName, String title, String description) {
        this(pageName);
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, IUIHelpConstants.EGL_NEW_RECORD_SUMMARY_PAGE);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.codeViewerSelectorContainer = new Composite(container, 0);
        this.codeViewerSelectorContainer.setLayoutData((Object)new GridData(768));
        GridLayout codeViewerSelectorContainerLayout = new GridLayout(2, false);
        codeViewerSelectorContainerLayout.marginWidth = 0;
        this.codeViewerSelectorContainer.setLayout((Layout)codeViewerSelectorContainerLayout);
        TextTools tools = new TextTools((IPreferenceStore)new PreferenceStore());
        this.fPreviewViewer = new SourceViewer(container, null, 2816);
        this.fPreviewViewer.configure((SourceViewerConfiguration)new EGLSourceViewerConfiguration(tools, null));
        Font font = JFaceResources.getFont((String)"org.eclipse.edt.ide.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        this.fPreviewViewer.setEditable(false);
        this.fPreviewViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.messageComposite = new HideableComposite(container, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.messageComposite.setLayout((Layout)layout);
        this.messageComposite.setLayoutData((Object)new GridData(768));
        this.warningLabel = new Label(this.messageComposite, 256);
        this.warningLabel.setText(NewWizardMessages.NewEGLFilesPreviewPage_warningLabel);
        this.warningLabel.setLayoutData((Object)new GridData(768));
        this.messageList = new Table(this.messageComposite, 68352);
        this.messageList.setLinesVisible(false);
        GridData data = new GridData(768);
        data.heightHint = 80;
        this.messageList.setLayoutData((Object)data);
        this.setControl((Control)container);
    }

    private void clearCodeViewerSelectorContainer() {
        Control[] controls = this.codeViewerSelectorContainer.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
    }

    private void addSingleFileInformationLabel(String filename) {
        this.clearCodeViewerSelectorContainer();
        Label singleFileInformationLabel = new Label(this.codeViewerSelectorContainer, 256);
        singleFileInformationLabel.setText(String.valueOf(NewWizardMessages.NewEGLFilesPreviewFileName) + filename);
    }

    private void addMultiFileSelectorContainer() {
        this.clearCodeViewerSelectorContainer();
        this.multiFileSelectorContainer = new Composite(this.codeViewerSelectorContainer, 0);
        this.multiFileSelectorContainer.setLayoutData((Object)new GridData(768));
        GridLayout fileSelectorContainerLayout = new GridLayout(2, false);
        fileSelectorContainerLayout.marginWidth = 0;
        this.multiFileSelectorContainer.setLayout((Layout)fileSelectorContainerLayout);
        Label fileSelectorLabel = new Label(this.multiFileSelectorContainer, 256);
        fileSelectorLabel.setText(NewWizardMessages.NewEGLFilesPreviewFileSelection);
        this.fileSelector = new Combo(this.multiFileSelectorContainer, 2056);
        GridData fsgd = new GridData(768);
        this.fileSelector.setLayoutData((Object)fsgd);
        this.fileSelector.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EGLCodePreviewPage.this.setContentByFileName(EGLCodePreviewPage.this.fileSelector.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EGLCodePreviewPage.this.setContentByFileName(EGLCodePreviewPage.this.fileSelector.getText());
            }
        });
    }

    public void setsourceFileContentTable(Hashtable<String, String> sourceFileContentTable) {
        this.sourceFileContentTable = sourceFileContentTable;
        Set<String> fileNames = sourceFileContentTable.keySet();
        ArrayList<String> list = new ArrayList<String>(fileNames);
        Collections.sort(list);
        if (fileNames.size() < 1) {
            this.addSingleFileInformationLabel(NewWizardMessages.NewEGLFilesPreviewNoFile);
        } else if (fileNames.size() == 1) {
            String fileName = (String)fileNames.toArray()[0];
            this.addSingleFileInformationLabel(fileName);
        } else {
            this.addMultiFileSelectorContainer();
            this.fileSelector.removeAll();
            for (String fileName : list) {
                this.fileSelector.add(fileName);
            }
        }
        this.codeViewerSelectorContainer.layout(true);
    }

    public void formatSourceDocument() {
        this.setFormattedSourceFileTable();
        Set<String> fileNames = this.sourceFileContentTable.keySet();
        if (fileNames.size() == 1) {
            String fileName = (String)fileNames.toArray()[0];
            this.setContentByFileName(fileName);
        } else {
            if (this.deafultSelectFile != null) {
                this.fileSelector.setText(this.deafultSelectFile);
            } else {
                this.fileSelector.select(0);
            }
            this.setContentByFileName(this.fileSelector.getText());
        }
    }

    private void setFormattedSourceFileTable() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    EGLCodePreviewPage.this.formattedSourceFileContentTable.clear();
                    Set fileNames = EGLCodePreviewPage.this.sourceFileContentTable.keySet();
                    monitor.beginTask(NewWizardMessages.NewEGLFilesPreviewStartFormattingCode, fileNames.size());
                    for (String fileName : fileNames) {
                        monitor.setTaskName(NewWizardMessages.bind((String)NewWizardMessages.NewEGLFilesPreviewFormattingCode, (Object[])new String[]{fileName}));
                        String code = (String)EGLCodePreviewPage.this.sourceFileContentTable.get(fileName);
                        EGLCodePreviewPage.this.formattedSourceFileContentTable.put(fileName, EGLCodePreviewPage.this.buildDocument(code));
                        monitor.worked(1);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            EGLLogger.log((Object)this, ex.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EGLLogger.log((Object)this, ex.toString());
        }
    }

    private IDocument buildDocument(String Str) {
        Document document = new Document("");
        IDocumentPartitioner partitioner = ((DocumentProvider)EGLUI.getDocumentProvider()).createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        document.set(Str != null ? Str : "");
        try {
            TextEdit edit = EGLCodeFormatterUtil.format((IDocument)document, null);
            edit.apply((IDocument)document);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EGLLogger.log((Object)this, ex.toString());
        }
        return document;
    }

    private void setContentByFileName(String fileName) {
        this.fPreviewViewer.setDocument(this.formattedSourceFileContentTable.get(fileName));
    }

    public void setMessages(List<String> messages) {
        this.messageList.removeAll();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        if (messages != null && messages.size() > 0) {
            for (String message : messages) {
                TableItem item = new TableItem(this.messageList, 0);
                item.setImage(sharedImages.getImage("IMG_OBJS_WARN_TSK"));
                item.setText(message);
            }
        }
        this.messageComposite.setVisible(this.messageList.getItemCount() > 0);
        if (this.messageList.getItemCount() == 0) {
            this.messageComposite.setVisible(false);
        } else {
            this.warningLabel.setText(NewWizardMessages.bind((String)NewWizardMessages.NewEGLFilesPreviewPage_warningLabel2, (Object[])new String[]{Integer.toString(this.messageList.getItemCount())}));
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.messageComposite != null) {
            this.messageComposite.setVisible(this.messageList.getItemCount() > 0);
        }
    }

    public void setDeafultSelectFile(String deafultSelectFile) {
        this.deafultSelectFile = deafultSelectFile;
    }

    private static class HideableComposite
    extends Composite {
        public HideableComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (this.isVisible()) {
                return super.computeSize(wHint, hHint, changed);
            }
            return new Point(0, 0);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.pack(true);
            this.getParent().layout(true);
        }
    }
}

