/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.wizards.EGLElementConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class EGLContainerConfiguration
extends EGLElementConfiguration {
    private String projectName;
    private String initialProjectName;
    private String sourceFolderName;
    private boolean bNeed2UpdateEGLPath = false;
    private boolean bUpdateEGLPath = true;

    public EGLContainerConfiguration() {
        this.setDefaultAttributes();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IEGLProject eproject;
        if (selection == null || selection.isEmpty()) {
            this.setDefaultAttributes();
            return;
        }
        Object selectedElement = selection.getFirstElement();
        String projPath = null;
        String sourcePath = null;
        if (selectedElement instanceof IResource) {
            IProject proj = ((IResource)selectedElement).getProject();
            if (proj != null) {
                projPath = proj.getFullPath().makeRelative().toString();
            }
        } else if (selectedElement instanceof IEGLElement) {
            IEGLProject eproject2 = ((IEGLElement)selectedElement).getEGLProject();
            if (eproject2 != null) {
                projPath = eproject2.getProject().getFullPath().makeRelative().toOSString();
            }
        } else if (selectedElement instanceof IJavaProject && (eproject = EGLCore.create((IProject)((IJavaProject)selectedElement).getProject())) != null) {
            projPath = eproject.getProject().getFullPath().makeRelative().toOSString();
        }
        if (selectedElement instanceof IPackageFragmentRoot) {
            sourcePath = ((IPackageFragmentRoot)selectedElement).getElementName();
        }
        if (projPath != null) {
            this.initialProjectName = this.projectName = projPath;
            this.sourceFolderName = sourcePath != null ? sourcePath : "";
        } else {
            this.setDefaultAttributes();
        }
    }

    public String getSourceFolderName() {
        return this.sourceFolderName;
    }

    public void setSourceFolderName(String root) {
        this.sourceFolderName = root;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String project) {
        this.projectName = project;
    }

    public String getContainerName() {
        String str = this.getProjectName();
        if (str.trim().length() == 0) {
            return str;
        }
        return str.concat(String.valueOf(System.getProperty("file.separator")) + this.getSourceFolderName());
    }

    public void setContainerName(String container) {
        String projectToken = "";
        String sourceToken = "";
        int separatorIndex = container.indexOf(System.getProperty("file.separator"));
        if (separatorIndex != -1) {
            projectToken = container.substring(0, separatorIndex);
            sourceToken = container.substring(separatorIndex + 1);
        } else {
            projectToken = container;
            sourceToken = "";
        }
        this.setProjectName(projectToken);
        this.setSourceFolderName(sourceToken);
    }

    private void setDefaultAttributes() {
        String projPath = "";
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject proj = projects[i];
                if (proj.isOpen() && proj.hasNature("org.eclipse.edt.ide.core.eglnature")) {
                    projPath = proj.getFullPath().makeRelative().toString();
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        this.initialProjectName = this.projectName = projPath;
        this.sourceFolderName = "";
    }

    public boolean isUpdateEGLPath() {
        return this.bUpdateEGLPath;
    }

    public void setUpdateEGLPath(boolean updateEGLPath) {
        this.bUpdateEGLPath = updateEGLPath;
    }

    public String getInitialProjectName() {
        return this.initialProjectName;
    }

    public boolean isNeed2UpdateEGLPath() {
        return this.bNeed2UpdateEGLPath;
    }

    public void setNeed2UpdateEGLPath(boolean need2UpdateEGLPath) {
        this.bNeed2UpdateEGLPath = need2UpdateEGLPath;
    }

    public void setInitialProjectName(String initialProjectName) {
        this.initialProjectName = initialProjectName;
    }
}

