/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.edt.compiler.internal.eglar.EglarFile;
import org.eclipse.edt.compiler.internal.eglar.EglarFileCache;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.core.utils.EGLProjectFileUtility;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.ui.internal.CSSUIPlugin;
import org.eclipse.wst.sse.core.utils.StringUtils;

public final class EGLProjectUtility {
    public static final String JAVA_DEFAULT_BIN_FOLDER = "bin";
    public static final String JAVA_DEFAULT_SOURCE_FOLDER = "src";

    public static void addEGLNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature("org.eclipse.edt.ide.core.eglnature")) {
            EGLProjectUtility.addNatureToProject(project, "org.eclipse.edt.ide.core.eglnature", monitor);
        } else {
            monitor.worked(1);
        }
    }

    public static void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            EGLProjectUtility.addNatureToProject(project, "org.eclipse.jdt.core.javanature", monitor);
        } else {
            monitor.worked(1);
        }
    }

    public static void addRUINature(IProject project, IProgressMonitor monitor) throws CoreException {
        boolean hasRUINatureID = project.hasNature("com.ibm.etools.egl.model.RUINature");
        if (!hasRUINatureID) {
            EGLProjectUtility.addNatureToProject(project, "com.ibm.etools.egl.model.RUINature", monitor);
        } else {
            monitor.worked(1);
        }
    }

    private static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static boolean classpathEntryExists(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        int jarIndex = -1;
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            IClasspathEntry curEntry = oldEntries[i];
            if (curEntry.getPath() != null && curEntry.getPath().toString().equalsIgnoreCase(entry.getPath().toString())) {
                jarIndex = i;
                break;
            }
            ++i;
        }
        return jarIndex >= 0;
    }

    public static IEGLPathEntry[] createEGLConfiguration(ProjectConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IPath eglOutputLocation;
        IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = fWorkspaceRoot.getProject(configuration.getProjectName());
        IEGLProject fCurrEProject = EGLCore.create((IProject)project);
        List<PPListElement> eglPathEntries = configuration.getRequiredProjects();
        if (eglPathEntries.size() == 0 && !configuration.getProjectName().equals("")) {
            eglPathEntries = EGLProjectUtility.initializeEGLPathEntries(project);
        }
        if (!fWorkspaceRoot.exists(eglOutputLocation = EGLProjectUtility.getDefaultEGLOutputPath(fCurrEProject))) {
            IFolder folder = fWorkspaceRoot.getFolder(eglOutputLocation);
            CoreUtility.createFolder(folder, true, true, null);
            folder.setDerived(true);
        }
        monitor.worked(2);
        int nEntries = eglPathEntries.size();
        IEGLPathEntry[] classpath = new IEGLPathEntry[nEntries];
        int i = 0;
        while (i < nEntries) {
            IPath folderOutput;
            PPListElement entry = eglPathEntries.get(i);
            IResource res = entry.getResource();
            if (res instanceof IFolder && !res.exists()) {
                CoreUtility.createFolder((IFolder)res, true, true, null);
            }
            if (entry.getEntryKind() == 3 && (folderOutput = (IPath)entry.getAttribute("output")) != null && folderOutput.segmentCount() > 1) {
                IFolder folder = fWorkspaceRoot.getFolder(folderOutput);
                CoreUtility.createFolder(folder, true, true, null);
            }
            classpath[i] = entry.getEGLPathEntry();
            EGLProjectUtility.configureJavaDoc(entry);
            ++i;
        }
        monitor.worked(1);
        fCurrEProject.setRawEGLPath(classpath, eglOutputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
        return classpath;
    }

    static IFolder createFolderIfNecessary(IProject project, String folderName, String encoding) throws InvocationTargetException {
        IFolder folder = project.getFolder(folderName);
        if (!folder.exists()) {
            int start = 0;
            int nextSlash = 0;
            nextSlash = folderName.indexOf(47, 0);
            try {
                while (nextSlash != -1) {
                    String subFolderName = folderName.substring(0, nextSlash);
                    IFolder subFolder = project.getFolder(subFolderName);
                    if (!subFolder.exists()) {
                        subFolder.create(false, true, null);
                        subFolder.setDefaultCharset(encoding, null);
                    }
                    start = nextSlash + 1;
                    nextSlash = folderName.indexOf(47, start);
                }
                folder.create(false, true, null);
                folder.setDefaultCharset(encoding, null);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex, ex.getMessage());
            }
        }
        return folder;
    }

    private static IClasspathEntry[] createNewClasspathEntries(IJavaProject javaProject, String folderName, String binFolderName, String encoding, IClasspathEntry[] oldEntries) throws InvocationTargetException {
        IFolder baseFolder = EGLProjectUtility.createFolderIfNecessary(javaProject.getProject(), folderName, encoding);
        IFolder binFolder = EGLProjectUtility.createFolderIfNecessary(javaProject.getProject(), binFolderName, encoding);
        try {
            IPackageFragmentRoot sourceRoot = javaProject.getPackageFragmentRoot((IResource)baseFolder);
            IPackageFragmentRoot binRoot = javaProject.getPackageFragmentRoot((IResource)binFolder);
            IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)sourceRoot.getPath(), (IPath[])new IPath[0], (IPath)binRoot.getPath());
            if (!EGLProjectUtility.classpathEntryExists(javaProject, newEntry)) {
                IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
                newEntries[0] = newEntry;
                System.arraycopy(oldEntries, 0, newEntries, 1, oldEntries.length);
                return newEntries;
            }
        }
        catch (JavaModelException ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
        return oldEntries;
    }

    private static void configureJavaDoc(PPListElement entry) {
        if (entry.getEntryKind() == 1) {
            URL javadocLocation = (URL)entry.getAttribute("javadoc");
            IPath path = entry.getPath();
            if (entry.getEntryKind() == 4) {
                path = EGLCore.getResolvedVariablePath((IPath)path);
            }
            if (path != null) {
                JavaUI.setLibraryJavadocLocation((IPath)path, (URL)javadocLocation);
            }
        } else if (entry.getEntryKind() == 5) {
            Object[] children = entry.getChildren(false);
            int i = 0;
            while (i < children.length) {
                PPListElement curr = (PPListElement)children[i];
                EGLProjectUtility.configureJavaDoc(curr);
                ++i;
            }
        }
    }

    private static List<PPListElement> initializeEGLPathEntries(IProject project) {
        List<PPListElement> newEGLPath = null;
        IEGLPathEntry[] eglPathEntries = null;
        IEGLProject eglProject = EGLCore.create((IProject)project);
        try {
            boolean projectExists;
            boolean bl = projectExists = project.exists() && project.getFile(".eglPath").exists();
            if (projectExists && eglPathEntries == null) {
                eglPathEntries = eglProject.getRawEGLPath();
            }
            if (eglPathEntries != null) {
                newEGLPath = EGLProjectUtility.getExistingEntries(eglPathEntries, eglProject);
            }
        }
        catch (CoreException e) {
            EDTUIPlugin.log(e);
        }
        if (newEGLPath == null) {
            newEGLPath = EGLProjectUtility.getDefaultClassPath(eglProject);
        }
        ArrayList<PPListElement> exportedEntries = new ArrayList<PPListElement>();
        int i = 0;
        while (i < newEGLPath.size()) {
            PPListElement currEGL = newEGLPath.get(i);
            if (currEGL.isExported() || currEGL.getEntryKind() == 3) {
                exportedEntries.add(currEGL);
            }
            ++i;
        }
        return newEGLPath;
    }

    public static ArrayList<PPListElement> getExistingEntries(IEGLPathEntry[] eglPathEntries, IEGLProject project) {
        ArrayList<PPListElement> newEGLPath = new ArrayList<PPListElement>();
        int i = 0;
        while (i < eglPathEntries.length) {
            IEGLPathEntry curr = eglPathEntries[i];
            newEGLPath.add(PPListElement.createFromExisting((IEGLPathEntry)curr, (IEGLProject)project));
            ++i;
        }
        return newEGLPath;
    }

    public static void createJavaConfiguration(IProject project, IProgressMonitor monitor) throws CoreException {
        EGLProjectUtility.addJavaNature(project, monitor);
        EGLProjectUtility.createJavaBuildPath(project, monitor);
    }

    public static void createJavaBuildPath(IProject project, IProgressMonitor monitor) throws CoreException {
        IPath javaOutputLocation = EGLProjectUtility.getDefaultJavaOutputPath(project);
        List<IClasspathEntry> newJavaClasspathEntry = EGLProjectUtility.getDefaultJavaClassPathEntryList(project);
        IClasspathEntry[] jclasspath = newJavaClasspathEntry.toArray(new IClasspathEntry[newJavaClasspathEntry.size()]);
        JavaCore.create((IProject)project).setRawClasspath(jclasspath, javaOutputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
    }

    public static List<PPListElement> getDefaultClassPath(IEGLProject eproj) {
        ArrayList<PPListElement> list = new ArrayList<PPListElement>();
        String sourceFolderName = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglSourceFolder");
        Object srcFolder = sourceFolderName.length() > 0 ? eproj.getProject().getFolder(sourceFolderName) : eproj.getProject();
        list.add(new PPListElement(eproj, 3, srcFolder.getFullPath(), (IResource)srcFolder));
        list.add(new PPListElement(eproj, 5, (IPath)new Path("org.eclipse.edt.compiler.EDT_RUNTIME"), null));
        return list;
    }

    public static IPath getDefaultEGLOutputPath(IEGLProject eproj) {
        String outputLocationName = EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglOutputFolder");
        return eproj.getProject().getFullPath().append(outputLocationName);
    }

    public static List<IClasspathEntry> getDefaultJavaClassPathEntryList(IProject project) throws CoreException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IPreferenceStore prefs = PreferenceConstants.getPreferenceStore();
        String sourceFolderName = prefs.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects") ? prefs.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName") : JAVA_DEFAULT_SOURCE_FOLDER;
        IFolder srcFolder = project.getFolder(sourceFolderName);
        if (srcFolder instanceof IFolder && !srcFolder.exists()) {
            CoreUtility.createFolder(srcFolder, true, true, null);
        }
        IClasspathEntry javaClasspathEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath(), (IPath[])new Path[0], (IPath[])new Path[0], null);
        list.add(javaClasspathEntry);
        list.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER")));
        return list;
    }

    public static IPath getDefaultJavaOutputPath(IProject project) {
        IPreferenceStore prefs = PreferenceConstants.getPreferenceStore();
        String outputLocationName = prefs.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects") ? prefs.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName") : JAVA_DEFAULT_BIN_FOLDER;
        return project.getFullPath().append(outputLocationName);
    }

    public static boolean classpathEntriesExist(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getPath().segmentCount() > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean sourceClasspathEntryExists(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3 && entries[i].getPath().segmentCount() > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static EglarFile createEglarFileFromPathEntry(IEGLProject project, IEGLPathEntry entry) throws IOException {
        IPath entryPath = entry.getPath();
        String eglarFile = EGLProjectUtility.getEglarAbsolutePath(entryPath, project.getProject());
        if (new File(eglarFile).exists()) {
            return EglarFileCache.instance.getEglarFile(eglarFile);
        }
        return null;
    }

    public static String getEglarAbsolutePath(IPath path, IProject project) {
        String eglarFilePath = path.toOSString();
        if (ResourcesPlugin.getWorkspace().getRoot().exists(path)) {
            int index = eglarFilePath.indexOf(File.separator);
            if (index == 0) {
                eglarFilePath = eglarFilePath.substring(1);
                index = eglarFilePath.indexOf(File.separator);
            }
            if (index > -1) {
                String eglarProjName = eglarFilePath.substring(0, index);
                if (eglarProjName.equals(project.getName())) {
                    eglarFilePath = String.valueOf(project.getProject().getLocation().toFile().getParentFile().getAbsolutePath()) + File.separator + eglarFilePath;
                } else {
                    IProject eglarProject = project.getProject().getWorkspace().getRoot().getProject(eglarProjName);
                    eglarFilePath = String.valueOf(eglarProject.getProject().getLocation().toFile().getParentFile().getAbsolutePath()) + File.separator + eglarFilePath;
                }
            }
        }
        return eglarFilePath;
    }

    public static IFile[] createFilesFromEglar(IResource destination, EglarFile eglarFile, String[] entries, boolean useEntryFolder) {
        IFile[] files = new IFile[entries.length];
        int i = 0;
        while (i < entries.length) {
            String entryName = entries[i];
            if (useEntryFolder) {
                files[i] = EGLProjectUtility.createFileFromEglar(destination, eglarFile, entryName, entryName);
            } else {
                String fileName = entryName;
                int index = fileName.lastIndexOf("/");
                if (index > -1) {
                    fileName = fileName.substring(index + 1);
                }
                files[i] = EGLProjectUtility.createFileFromEglar(destination, eglarFile, entryName, fileName);
            }
            ++i;
        }
        return files;
    }

    public static IFile[] createFilesFromEglar(IResource destination, EglarFile eglarFile, String[] entries) {
        return EGLProjectUtility.createFilesFromEglar(destination, eglarFile, entries, true);
    }

    public static IFile createFileFromEglar(IResource destination, EglarFile eglarFile, String entryName, String createFileName) {
        block10: {
            block9: {
                if (destination instanceof IContainer) break block9;
                return null;
            }
            if (destination.exists()) break block10;
            if (destination instanceof IFolder) {
                EGLProjectFileUtility.createFolder((IContainer)destination.getProject(), (IPath)destination.getProjectRelativePath());
                break block10;
            }
            return null;
        }
        try {
            ZipEntry zipEntry = eglarFile.getEntry(entryName);
            IFile targetResource = ((IContainer)destination).getFile((IPath)new Path(createFileName));
            InputStream is = eglarFile.getInputStream(zipEntry);
            if (targetResource.exists()) {
                targetResource.setContents(is, 2, null);
            } else {
                int index = createFileName.lastIndexOf("/");
                if (index > 0) {
                    String folder = createFileName.substring(0, index);
                    EGLProjectFileUtility.createFolder((IContainer)((IContainer)destination), (IPath)new Path(folder));
                }
                targetResource.create(is, false, null);
            }
            return targetResource;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void addClasspathEntriesIfNecessary(IProject project, IClasspathEntry[] classpathEntries) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            int index = -1;
            ArrayList<IClasspathEntry> newClasspaths = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            IClasspathEntry[] iClasspathEntryArray = classpathEntries;
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry pathEntry = iClasspathEntryArray[n2];
                int i = 0;
                while (i < oldEntries.length) {
                    IClasspathEntry curEntry = oldEntries[i];
                    if (curEntry.getPath() != null && curEntry.getPath().toOSString().equalsIgnoreCase(pathEntry.getPath().toOSString())) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index < 0) {
                    newClasspaths.add(pathEntry);
                }
                ++n2;
            }
            EGLProjectUtility.addClasspathLibraryEntries(javaProject, newClasspaths.toArray(new IClasspathEntry[newClasspaths.size()]));
        }
    }

    public static void addClasspathLibraryEntries(IJavaProject javaProject, IClasspathEntry[] classpathEntries) throws CoreException {
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + classpathEntries.length];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        int i = 0;
        while (i < classpathEntries.length) {
            newEntries[oldEntries.length + i] = classpathEntries[i];
            ++i;
        }
        javaProject.setRawClasspath(newEntries, null);
    }

    public static IFile[] removeFilesFromEglar(IResource target, EglarFile eglarFile, String[] entries, boolean useEntryFolder) {
        IFile[] files = new IFile[entries.length];
        int i = 0;
        while (i < entries.length) {
            String entryName = entries[i];
            if (useEntryFolder) {
                files[i] = EGLProjectUtility.removeFileFromEglar(target, eglarFile, entryName, entryName);
            } else {
                String fileName = entryName;
                int index = fileName.lastIndexOf("/");
                if (index > -1) {
                    fileName = fileName.substring(index + 1);
                }
                files[i] = EGLProjectUtility.removeFileFromEglar(target, eglarFile, entryName, fileName);
            }
            ++i;
        }
        return files;
    }

    public static IFile[] removeFilesFromEglar(IResource target, EglarFile eglarFile, String[] entries) {
        return EGLProjectUtility.removeFilesFromEglar(target, eglarFile, entries, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IFile removeFileFromEglar(IResource target, EglarFile eglarFile, String entryName, String createFileName) {
        try {
            if (!target.exists()) return null;
            if (!(target instanceof IContainer)) {
                return null;
            }
            ZipEntry zipEntry = eglarFile.getEntry(entryName);
            IFile toDelResource = ((IContainer)target).getFile((IPath)new Path(createFileName));
            eglarFile.getInputStream(zipEntry);
            if (!toDelResource.exists()) return null;
            toDelResource.delete(false, null);
            ArrayList<String> parents = new ArrayList<String>();
            String fileName = createFileName;
            int index = fileName.lastIndexOf("/");
            while (index > 0) {
                fileName = fileName.substring(0, index);
                parents.add(fileName);
                index = fileName.lastIndexOf("/");
            }
            for (String parent : parents) {
                IFolder parentFolder = ((IContainer)target).getFolder((IPath)new Path(parent));
                if (!parentFolder.exists()) return null;
                if (parentFolder.members().length != 0) continue;
                parentFolder.delete(false, null);
            }
            return toDelResource;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void removeClasspathLibraryEntriesIfNecessary(IProject project, IPath[] jarPaths) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            int jarIndex = -1;
            ArrayList<IPath> delJarPaths = new ArrayList<IPath>();
            IPath[] iPathArray = jarPaths;
            int n = jarPaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath jarPath = iPathArray[n2];
                IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
                int i = 0;
                while (i < oldEntries.length) {
                    IClasspathEntry curEntry = oldEntries[i];
                    if (curEntry.getPath() != null && curEntry.getPath().equals((Object)jarPath)) {
                        jarIndex = i;
                        break;
                    }
                    ++i;
                }
                if (jarIndex > 0) {
                    delJarPaths.add(jarPath);
                }
                ++n2;
            }
            EGLProjectUtility.removeClasspathLibraryEntries(javaProject, delJarPaths.toArray(new IPath[delJarPaths.size()]));
        }
    }

    public static void removeClasspathLibraryEntries(IJavaProject javaProject, IPath[] jarPaths) throws CoreException {
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        if (oldEntries.length < jarPaths.length) {
            return;
        }
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length - jarPaths.length];
        int k = 0;
        int i = 0;
        while (i < oldEntries.length) {
            boolean isEntryKept = true;
            int j = 0;
            while (j < jarPaths.length) {
                if (jarPaths[j].toString().equalsIgnoreCase(oldEntries[i].getPath().toString())) {
                    isEntryKept = false;
                    break;
                }
                ++j;
            }
            if (isEntryKept) {
                newEntries[k++] = oldEntries[i];
            }
            ++i;
        }
        javaProject.setRawClasspath(newEntries, null);
    }

    public static IPath getDefaultRUIWebContentPath(IEGLProject eproj) {
        String outputLocationName = "WebContent";
        return eproj.getProject().getFullPath().append(outputLocationName);
    }

    public static IPath getDefaultRUICSSFolderPath(IEGLProject eproj) {
        String outputLocationName = "WebContent/css";
        return eproj.getProject().getFullPath().append(outputLocationName);
    }

    public static IPath getDefaultRUIIconsFolderPath(IEGLProject eproj) {
        String outputLocationName = "WebContent/icons";
        return eproj.getProject().getFullPath().append(outputLocationName);
    }

    public static IPath getPropertiesFolderPath(IEGLProject eproj) {
        String outputLocationName = "WebContent/properties";
        return eproj.getProject().getFullPath().append(outputLocationName);
    }

    public static void createRUIWebContentAndSubFolders(IProject project) throws CoreException {
        IPath propertiesFolder;
        IPath iconsFolder;
        IPath cssFolder;
        IEGLProject eproj;
        IPath eglRUIWebContentLocation;
        IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!fWorkspaceRoot.exists(eglRUIWebContentLocation = EGLProjectUtility.getDefaultRUIWebContentPath(eproj = EGLCore.create((IProject)project)))) {
            IFolder folder = fWorkspaceRoot.getFolder(eglRUIWebContentLocation);
            CoreUtility.createFolder(folder, true, true, null);
        }
        if (!fWorkspaceRoot.exists(cssFolder = EGLProjectUtility.getDefaultRUICSSFolderPath(eproj))) {
            IFolder folder = fWorkspaceRoot.getFolder(cssFolder);
            CoreUtility.createFolder(folder, true, true, null);
            EGLProjectUtility.createDefaultCSSFile(folder);
        }
        if (!fWorkspaceRoot.exists(iconsFolder = EGLProjectUtility.getDefaultRUIIconsFolderPath(eproj))) {
            IFolder folder = fWorkspaceRoot.getFolder(iconsFolder);
            CoreUtility.createFolder(folder, true, true, null);
        }
        if (!fWorkspaceRoot.exists(propertiesFolder = EGLProjectUtility.getPropertiesFolderPath(eproj))) {
            IFolder folder = fWorkspaceRoot.getFolder(propertiesFolder);
            CoreUtility.createFolder(folder, true, true, null);
        }
    }

    private static String getTemplateString() {
        Template template = null;
        TemplateStore fTemplateStore = CSSUIPlugin.getDefault().getTemplateStore();
        String templateName = CSSUIPlugin.getDefault().getPreferenceStore().getString("newFileTemplateName");
        Template[] templates = fTemplateStore.getTemplates("css_new");
        int i = 0;
        while (i < templates.length && template == null) {
            Template template2 = templates[i];
            if (template2.getName().equals(templateName)) {
                template = template2;
            }
            ++i;
        }
        String templateString = "";
        if (template != null) {
            TemplateContextType contextType = CSSUIPlugin.getDefault().getTemplateContextRegistry().getContextType("css_new");
            Document document = new Document();
            DocumentTemplateContext context = new DocumentTemplateContext(contextType, (IDocument)document, 0, 0);
            try {
                TemplateBuffer buffer = context.evaluate(template);
                templateString = buffer.getString();
            }
            catch (Exception exception) {}
        }
        return templateString;
    }

    private static String applyLineDelimiter(IFile file, String text) {
        String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", System.getProperty("line.separator"), new IScopeContext[]{new ProjectScope(file.getProject()), new InstanceScope()});
        String convertedText = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
        convertedText = StringUtils.replace((String)convertedText, (String)"\r", (String)"\n");
        convertedText = StringUtils.replace((String)convertedText, (String)"\n", (String)lineDelimiter);
        return convertedText;
    }

    public static void createDefaultCSSFile(IFolder folder) {
        String templateString;
        IProject project = folder.getProject();
        IFile file = folder.getFile((IPath)new Path(String.valueOf(project.getName()) + ".css"));
        if (file != null && !file.exists() && (templateString = EGLProjectUtility.getTemplateString()) != null) {
            templateString = EGLProjectUtility.applyLineDelimiter(file, templateString);
            Preferences preference = CSSCorePlugin.getDefault().getPluginPreferences();
            String charSet = preference.getString("outputCodeset");
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = charSet == null || charSet.trim().equals("") ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, charSet);
                outputStreamWriter.write(templateString);
                outputStreamWriter.flush();
                outputStreamWriter.close();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                file.create((InputStream)inputStream, true, null);
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void modifyClasspathLibraryEntry(IProject project, IClasspathEntry[] modifiedEntries) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IClasspathEntry[] entries;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] newEntries = entries = javaProject.getRawClasspath();
            int j = 0;
            while (j < modifiedEntries.length) {
                int i = 0;
                while (i < entries.length) {
                    if (modifiedEntries[j].getPath().toOSString().equalsIgnoreCase(entries[i].getPath().toOSString())) {
                        newEntries[i] = modifiedEntries[j];
                        break;
                    }
                    ++i;
                }
                ++j;
            }
            javaProject.setRawClasspath(newEntries, null);
        }
    }
}

