/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.ui.project.templates.IProjectTemplate;

public class ProjectConfiguration {
    public static final int JAVA_PLATFORM = 1;
    public static final int JAVASCRIPT_PLATFORM = 2;
    public static final int JAVA_JAVASCRIPT_PLATFORMS = 3;
    public static final int COBOL_PLATFORM = 4;
    public static final int JAVA_COBOL_PLATFORMS = 5;
    public static final int JAVASCRIPT_COBOL_PLATFORMS = 6;
    public static final int JAVA_JAVASCRIPT_COBOL_PLATFORMS = 7;
    public static final String EDT_COMPILER_ID = "org.eclipse.edt.ide.compiler.edtCompiler";
    public static final String JAVA_GENERATOR_ID = "org.eclipse.edt.ide.gen.JavaGenProvider";
    public static final String JAVACORE_GENERATOR_ID = "org.eclipse.edt.ide.gen.JavaCoreGenProvider";
    public static final String JAVASCRIPT_DEV_GENERATOR_ID = "org.eclipse.edt.ide.gen.JavaScriptDevGenProvider";
    public static final String JAVASCRIPT_GENERATOR_ID = "org.eclipse.edt.ide.gen.JavaScriptGenProvider";
    private String projectName;
    private boolean useDefaults;
    private String initialProjectLocation;
    private String customProjectLocation;
    private String basePackageName;
    private int targetRuntimeValue;
    private String sourceFolderName;
    private List<PPListElement> requiredProjects;
    private List<String> selectedWidgetLibraries;
    private String selectedCompiler;
    private String[] selectedGenerators;
    private boolean configureEGLPathOnly;
    private IProjectTemplate selectedProjectTemplate;

    public void setDefaultAttributes() {
        this.useDefaults = true;
        this.projectName = "";
        this.initialProjectLocation = Platform.getLocation().toOSString();
        this.customProjectLocation = "";
        this.basePackageName = "";
        this.targetRuntimeValue = 1;
        this.requiredProjects = new ArrayList<PPListElement>();
        this.selectedWidgetLibraries = new ArrayList<String>();
        this.selectedCompiler = EDT_COMPILER_ID;
        this.selectedGenerators = new String[]{JAVA_GENERATOR_ID, JAVASCRIPT_GENERATOR_ID, JAVASCRIPT_DEV_GENERATOR_ID};
    }

    public void setEmptyCompilerProperty() {
        this.selectedGenerators = new String[0];
        this.selectedCompiler = null;
    }

    public String getSelectedCompiler() {
        return this.selectedCompiler;
    }

    public void setSelectedCompiler(String selectedCompiler) {
        this.selectedCompiler = selectedCompiler;
    }

    public String[] getSelectedGenerators() {
        return this.selectedGenerators;
    }

    public void setSelectedGenerators(String[] selectedGenerators) {
        boolean hasDevJS = false;
        boolean hasJS = false;
        String[] stringArray = selectedGenerators;
        int n = selectedGenerators.length;
        int n2 = 0;
        while (n2 < n) {
            String gen = stringArray[n2];
            if (gen.equals(JAVASCRIPT_GENERATOR_ID)) {
                hasJS = true;
            } else if (gen.equals(JAVASCRIPT_DEV_GENERATOR_ID)) {
                hasDevJS = true;
            }
            ++n2;
        }
        if (hasJS && !hasDevJS) {
            this.selectedGenerators = new String[selectedGenerators.length + 1];
            int i = 0;
            while (i < selectedGenerators.length) {
                this.selectedGenerators[i] = selectedGenerators[i];
                ++i;
            }
            this.selectedGenerators[selectedGenerators.length] = JAVASCRIPT_DEV_GENERATOR_ID;
        } else {
            this.selectedGenerators = selectedGenerators;
        }
    }

    public String getCustomProjectLocation() {
        return this.customProjectLocation;
    }

    public String getInitialProjectLocation() {
        return this.initialProjectLocation;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<PPListElement> getRequiredProjects() {
        return this.requiredProjects;
    }

    public String getSourceFolderName() {
        return this.sourceFolderName;
    }

    public void setCustomProjectLocation(String string) {
        this.customProjectLocation = string;
    }

    public void setInitialProjectLocation(String string) {
        this.initialProjectLocation = string;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public void setRequiredProjects(List<PPListElement> projects) {
        this.requiredProjects = projects;
    }

    public void setSourceFolderName(String string) {
        this.sourceFolderName = string;
    }

    public boolean isUseDefaults() {
        return this.useDefaults;
    }

    public void setUseDefaults(boolean b) {
        this.useDefaults = b;
    }

    public void addTargetRuntime(int platformMask) {
        this.targetRuntimeValue |= platformMask;
    }

    public int getTargetRuntimeValue() {
        return this.targetRuntimeValue;
    }

    public void setTargetRuntimeValue(int newValue) {
        this.targetRuntimeValue = newValue;
    }

    public void addCobolPlatform() {
        this.targetRuntimeValue |= 4;
    }

    public void addJavaPlatform() {
        this.targetRuntimeValue |= 1;
    }

    public void addJavaScriptPlatform() {
        this.targetRuntimeValue |= 2;
    }

    public boolean isCobolPlatform() {
        return (this.targetRuntimeValue & 4) != 0;
    }

    public boolean isJavaPlatform() {
        return (this.targetRuntimeValue & 1) != 0;
    }

    public boolean isJavaScriptPlatform() {
        return (this.targetRuntimeValue & 2) != 0;
    }

    public List<String> getSelectedWidgetLibraries() {
        return this.selectedWidgetLibraries;
    }

    public void setSelectedWidgetLibraries(List<String> list) {
        this.selectedWidgetLibraries = list;
    }

    public boolean configureEGLPathOnly() {
        return this.configureEGLPathOnly;
    }

    public void setConfigureEGLPathOnly(boolean flag) {
        this.configureEGLPathOnly = flag;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public void setBasePackageName(String basePackageName) {
        this.basePackageName = basePackageName;
    }

    public IProjectTemplate getSelectedProjectTemplate() {
        return this.selectedProjectTemplate;
    }

    public void setSelectedProjectTemplate(IProjectTemplate selectedProjectTemplate) {
        this.selectedProjectTemplate = selectedProjectTemplate;
    }
}

