/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet;

import eglx.lang.AnyException;
import eglx.services.ServiceKind;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.services.ServiceBase;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.services.servlet.Invoker;
import org.eclipse.edt.javart.util.JavaAliaser;

public abstract class LocalServiceInvoker
extends Invoker {
    private long elapseTime;
    private String serviceClassName;
    private ServiceKind serviceKind;
    private ServiceBase service;
    private Class<ServiceBase> serviceClass;
    private static Map<String, String> cachedAliases = new HashMap<String, String>();

    public LocalServiceInvoker(String serviceClassName, ServiceKind serviceKind) {
        this.serviceClassName = serviceClassName;
        this.serviceKind = serviceKind;
    }

    protected void traceElapsedTime(boolean start) {
        if (start) {
            this.elapseTime = System.currentTimeMillis();
        } else {
            this.elapseTime = System.currentTimeMillis() - this.elapseTime;
            if (this.trace()) {
                this.tracer().put("Service response time:" + String.valueOf(this.elapseTime));
            }
        }
    }

    protected Method getMethod(String functionName) throws AnyException {
        Method[] methodArray = this.getServiceClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equalsIgnoreCase(functionName)) {
                return method;
            }
            ++n2;
        }
        throw ServiceUtilities.buildServiceInvocationException("EGL0025E", new String[]{functionName, this.getClass().getName()}, null, ServiceKind.EGL);
    }

    protected Class<ServiceBase> getServiceClass() throws AnyException {
        if (this.serviceClass == null) {
            try {
                String aliasedServiceClassName = cachedAliases.get(this.serviceClassName);
                if (aliasedServiceClassName == null) {
                    int idx = this.serviceClassName.lastIndexOf(46);
                    if (idx != -1) {
                        StringBuilder buf = new StringBuilder(JavaAliaser.packageNameAlias((String)this.serviceClassName.substring(0, idx)));
                        aliasedServiceClassName = buf.append('.').append(JavaAliaser.getAlias((String)this.serviceClassName.substring(idx + 1))).toString();
                    } else {
                        aliasedServiceClassName = JavaAliaser.getAlias((String)this.serviceClassName);
                    }
                    cachedAliases.put(this.serviceClassName, aliasedServiceClassName);
                }
                this.serviceClass = Class.forName(aliasedServiceClassName, true, Runtime.getRunUnit().getClass().getClassLoader());
            }
            catch (Exception e) {
                throw ServiceUtilities.buildServiceInvocationException("EGL0026E", new Object[]{this.serviceClassName}, e, this.serviceKind);
            }
        }
        return this.serviceClass;
    }

    protected ServiceBase getService() throws AnyException {
        if (this.service == null) {
            try {
                this.service = this.getServiceClass().newInstance();
            }
            catch (AnyException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw ServiceUtilities.buildServiceInvocationException("EGL0026E", new Object[]{this.serviceClassName}, e, this.serviceKind);
            }
        }
        return this.service;
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public ServiceKind getServiceKind() {
        return this.serviceKind;
    }
}

