/*
 * Decompiled with CFR 0.152.
 */
package eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.ENumber;
import eglx.lang.NullValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;

public class MathLib
extends ExecutableBase {
    private static final long serialVersionUID = 10L;
    private static final double LOG_OF_10 = 2.302585092994046;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final int DOUBLE_MANTISSA_LENGTH = 52;
    private static final long DOUBLE_NO_EXPONENT_MASK = -9218868437227405313L;
    private static final int DOUBLE_MAX_EXPONENT = 2046;
    private static final int DOUBLE_EXPONENT_BIAS = 1022;
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_ZERO_EXPONENT = 4602678819172646912L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final int INT_PRECISION = 9;
    private static final int SHORT_PRECISION = 4;
    private static final int LONG_PRECISION = 18;
    private static final int FLOAT_PRECISION = 6;
    private static final int DOUBLE_PRECISION = 15;

    public static short abs(short numericField) {
        if (numericField < 0) {
            return -numericField;
        }
        return numericField;
    }

    public static int abs(int numericField) {
        if (numericField < 0) {
            return -numericField;
        }
        return numericField;
    }

    public static long abs(long numericField) {
        if (numericField < 0L) {
            return -numericField;
        }
        return numericField;
    }

    public static double abs(double numericField) {
        return StrictMath.abs(numericField);
    }

    public static float abs(float numericField) {
        return StrictMath.abs(numericField);
    }

    public static BigDecimal abs(BigDecimal numericField) {
        return numericField.abs();
    }

    public static double acos(double numericField) {
        if (numericField < -1.0 || numericField > 1.0) {
            return Double.NaN;
        }
        return StrictMath.acos(numericField);
    }

    public static double asin(double numericField) {
        if (numericField < -1.0 || numericField > 1.0) {
            return Double.NaN;
        }
        return StrictMath.asin(numericField);
    }

    public static double atan(double numericField) {
        return StrictMath.atan(numericField);
    }

    public static double atan2(double numericField1, double numericField2) {
        return StrictMath.atan2(numericField1, numericField2);
    }

    public static double ceiling(double numericField) {
        return StrictMath.ceil(numericField);
    }

    public static BigDecimal ceiling(BigDecimal numericField) {
        return numericField.setScale(0, 2);
    }

    public static double cos(double numericField) {
        return StrictMath.cos(numericField);
    }

    public static double cosh(double numericField) {
        return StrictMath.cosh(numericField);
    }

    public static int decimals(BigDecimal numericField) {
        if (numericField.signum() == 0 || numericField.scale() == 0) {
            return 0;
        }
        String numStr = numericField.toPlainString();
        int pointIndex = numStr.lastIndexOf(46);
        if (pointIndex == -1) {
            return 0;
        }
        int lastDigitIndex = numStr.length() - 1;
        while (lastDigitIndex > pointIndex && numStr.charAt(lastDigitIndex) == '0') {
            --lastDigitIndex;
        }
        return lastDigitIndex - pointIndex;
    }

    public static int decimals(double numericField) {
        if (numericField == 0.0) {
            return 0;
        }
        return MathLib.decimals(BigDecimal.valueOf(numericField));
    }

    public static int decimals(float numericField) {
        if (numericField == 0.0f) {
            return 0;
        }
        return MathLib.decimals(new BigDecimal(Float.toString(numericField)));
    }

    public static int decimals(int numericField) {
        return 0;
    }

    public static int decimals(long numericField) {
        return 0;
    }

    public static int decimals(short numericField) {
        return 0;
    }

    public static int decimals(EDecimal numericField) {
        if (numericField == null || numericField.ezeUnbox() == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        return numericField.getDecimals();
    }

    public static int decimals(ENumber numericField) {
        Number value = numericField.ezeUnbox();
        if (value instanceof Integer || value instanceof Short || value instanceof Long) {
            return 0;
        }
        if (value instanceof BigDecimal) {
            return MathLib.decimals((BigDecimal)value);
        }
        if (value instanceof Double) {
            return MathLib.decimals(BigDecimal.valueOf(value.doubleValue()));
        }
        return MathLib.decimals(new BigDecimal(Float.toString(value.floatValue())));
    }

    public static double exp(double numericField) {
        return StrictMath.exp(numericField);
    }

    public static double floor(double numericField) {
        return StrictMath.floor(numericField);
    }

    public static BigDecimal floor(BigDecimal numericField) {
        return numericField.setScale(0, 3);
    }

    public static double frexp(double numericField, AnyBoxedObject<Integer> exponent) {
        double value = numericField;
        long bits = Double.doubleToLongBits(numericField);
        int exp = (int)((bits & 0x7FF0000000000000L) >> 52);
        if (exp > 0 && exp <= 2046) {
            exponent.ezeCopy(exp -= 1022);
            long mantissa = bits & 0x800FFFFFFFFFFFFFL;
            value = Double.longBitsToDouble(mantissa |= 0x3FE0000000000000L);
        } else {
            exponent.ezeCopy(0);
        }
        return value;
    }

    public static double ldexp(double numericField, int pow) {
        double value = numericField;
        long bits = Double.doubleToLongBits(value);
        long exp = (bits & 0x7FF0000000000000L) >> 52;
        bits &= 0x800FFFFFFFFFFFFFL;
        if ((exp += (long)pow) < 0L || exp > 2046L) {
            return Double.NaN;
        }
        return Double.longBitsToDouble(bits |= exp << 52);
    }

    public static double log(double numericField) {
        if (numericField <= 0.0) {
            return Double.NaN;
        }
        return StrictMath.log(numericField);
    }

    public static double log10(double numericField) {
        if (numericField <= 0.0) {
            return Double.NaN;
        }
        return StrictMath.log(numericField) / 2.302585092994046;
    }

    public static short max(short numericField1, short numericField2) {
        if (numericField1 < numericField2) {
            return numericField2;
        }
        return numericField1;
    }

    public static int max(int numericField1, int numericField2) {
        if (numericField1 < numericField2) {
            return numericField2;
        }
        return numericField1;
    }

    public static long max(long numericField1, long numericField2) {
        if (numericField1 < numericField2) {
            return numericField2;
        }
        return numericField1;
    }

    public static double max(double numericField1, double numericField2) {
        return StrictMath.max(numericField1, numericField2);
    }

    public static float max(float numericField1, float numericField2) {
        return StrictMath.max(numericField1, numericField2);
    }

    public static BigDecimal max(BigDecimal numericField1, BigDecimal numericField2) {
        return numericField1.max(numericField2);
    }

    public static short min(short numericField1, short numericField2) {
        if (numericField1 < numericField2) {
            return numericField1;
        }
        return numericField2;
    }

    public static int min(int numericField1, int numericField2) {
        if (numericField1 < numericField2) {
            return numericField1;
        }
        return numericField2;
    }

    public static long min(long numericField1, long numericField2) {
        if (numericField1 < numericField2) {
            return numericField1;
        }
        return numericField2;
    }

    public static double min(double numericField1, double numericField2) {
        return StrictMath.min(numericField1, numericField2);
    }

    public static float min(float numericField1, float numericField2) {
        return StrictMath.min(numericField1, numericField2);
    }

    public static BigDecimal min(BigDecimal numericField1, BigDecimal numericField2) {
        return numericField1.min(numericField2);
    }

    public static double modf(double numericField1, AnyBoxedObject<Long> numericField2) {
        BigDecimal bd = new BigDecimal(numericField1);
        BigInteger intPart = bd.toBigInteger();
        BigDecimal fractPart = new BigDecimal(intPart).subtract(bd).negate();
        numericField2.ezeCopy(intPart.longValue());
        return fractPart.doubleValue();
    }

    public static double pow(double op1, double op2) {
        if (op1 == 0.0 && op2 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (op1 < 0.0 && op2 > StrictMath.floor(op2)) {
            return Double.NaN;
        }
        return StrictMath.pow(op1, op2);
    }

    public static int precision(short numericField) {
        return 4;
    }

    public static int precision(int numericField) {
        return 9;
    }

    public static int precision(long numericField) {
        return 18;
    }

    public static int precision(float numericField) {
        return 6;
    }

    public static int precision(double numericField) {
        return 15;
    }

    public static int precision(BigDecimal numericField) {
        return numericField.precision();
    }

    public static int precision(EDecimal numericField) {
        if (numericField == null || numericField.ezeUnbox() == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        return numericField.getPrecision();
    }

    public static int precision(ENumber numericField) {
        Number value = numericField.ezeUnbox();
        if (value instanceof Integer) {
            return 9;
        }
        if (value instanceof Long) {
            return 18;
        }
        if (value instanceof Short) {
            return 4;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).precision();
        }
        if (value instanceof Double) {
            return 15;
        }
        if (value instanceof Float) {
            return 6;
        }
        return BigDecimal.valueOf(value.doubleValue()).precision();
    }

    public static double random() {
        return Math.random();
    }

    public static float round(float value, int exp) {
        return MathLib.round(BigDecimal.valueOf(value), exp).floatValue();
    }

    public static double round(double value, int exp) {
        return MathLib.round(BigDecimal.valueOf(value), exp).doubleValue();
    }

    public static BigDecimal round(BigDecimal value, int exp) {
        BigDecimal rounder;
        if (exp > 0) {
            rounder = BigDecimal.valueOf(5L);
            rounder = rounder.movePointRight(exp - 1);
        } else {
            rounder = BigDecimal.valueOf(5L, -exp + 1);
        }
        value = value.signum() >= 0 ? value.add(rounder) : value.subtract(rounder);
        if (exp > 0) {
            value = value.movePointLeft(exp);
            value = new BigDecimal(value.toBigInteger());
            value = value.movePointRight(exp);
        } else {
            value = value.movePointRight(-exp);
            value = new BigDecimal(value.toBigInteger());
            value = value.movePointLeft(-exp);
        }
        return value;
    }

    public static double sin(double numericField) {
        return StrictMath.sin(numericField);
    }

    public static double sinh(double numericField) {
        return StrictMath.sinh(numericField);
    }

    public static double sqrt(double numericField) {
        if (numericField < 0.0) {
            return Double.NaN;
        }
        return StrictMath.sqrt(numericField);
    }

    public static double tan(double numericField) {
        return StrictMath.tan(numericField);
    }

    public static double tanh(double numericField) {
        return StrictMath.tanh(numericField);
    }
}

