/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources;

import java.nio.ByteOrder;

public class Platform {
    public static final boolean IS_ASCII = new String(new byte[]{48}).equals("0");
    public static final byte BYTE_ORDER;
    public static final String SYSTEM_TYPE;
    public static final String AIX = "AIX     ";
    public static final String DEBUG = "DEBUG   ";
    public static final String HP = "HP      ";
    public static final String HPUX = "HPUX    ";
    public static final String ISERIESJ = "ISERIESJ";
    public static final String LINUX = "LINUX   ";
    public static final String SOLARIS = "SOLARIS ";
    public static final String USS = "USS     ";
    public static final String WIN = "WIN     ";
    public static final String UNKNOWN = "        ";
    public static final String ZLINUX = "ZLINUX  ";

    static {
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.indexOf("windows") != -1) {
            SYSTEM_TYPE = WIN;
            BYTE_ORDER = (byte)2;
        } else if (osName.indexOf("solaris") != -1 || osName.indexOf("sunos") != -1) {
            SYSTEM_TYPE = SOLARIS;
            BYTE_ORDER = (byte)3;
        } else if (osName.indexOf("os/390") != -1) {
            SYSTEM_TYPE = USS;
            BYTE_ORDER = 1;
        } else if (osName.indexOf("os/400") != -1) {
            SYSTEM_TYPE = ISERIESJ;
            BYTE_ORDER = 1;
        } else if (osName.indexOf("linux") != -1) {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                SYSTEM_TYPE = LINUX;
                BYTE_ORDER = (byte)2;
            } else {
                SYSTEM_TYPE = ZLINUX;
                BYTE_ORDER = 1;
            }
        } else if (osName.indexOf("hp-ux") != -1) {
            SYSTEM_TYPE = HPUX;
            BYTE_ORDER = (byte)3;
        } else if (osName.indexOf("z/os") != -1) {
            SYSTEM_TYPE = USS;
            BYTE_ORDER = 1;
        } else if (osName.indexOf("aix") != -1) {
            SYSTEM_TYPE = AIX;
            BYTE_ORDER = (byte)3;
        } else {
            SYSTEM_TYPE = UNKNOWN;
            BYTE_ORDER = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (byte)2 : (byte)1;
        }
    }
}

