/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.ENumber;
import eglx.lang.InvalidArgumentException;
import eglx.lang.InvalidIndexException;
import eglx.lang.TypeCastException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.util.NumericUtil;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EFloat;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;

public class EBytes
extends AnyBoxedObject<byte[]> {
    private static final long serialVersionUID = 10L;
    private int maxLength;

    public int getLength() {
        return this.maxLength;
    }

    private EBytes(byte[] value) {
        super(value);
        this.maxLength = -1;
    }

    private EBytes(byte[] value, int length) {
        super(value);
        this.maxLength = length;
    }

    public static EBytes ezeBox(byte[] value) {
        return new EBytes(value);
    }

    public static EBytes ezeBox(byte[] value, int length) {
        return new EBytes(value, length);
    }

    public static byte[] ezeCast(Object value, Integer ... args) throws AnyException {
        return (byte[])EAny.ezeCast(value, "asBytes", EBytes.class, new Class[]{Integer[].class}, args);
    }

    public static boolean ezeIsa(Object value, Integer ... length) {
        boolean isa;
        boolean bl = isa = value instanceof EBytes && ((EBytes)value).ezeUnbox() != null;
        if (isa) {
            if (length.length != 0) {
                isa = ((EBytes)value).getLength() == length[0].intValue();
            }
        } else {
            isa = value instanceof byte[];
        }
        return isa;
    }

    public static byte[] asBytes(Short value, Integer ... length) {
        if (length.length > 0 && length[0] != 2) {
            EBytes.throwTypeCastException("smallint", value, length);
        }
        if (value == null) {
            return null;
        }
        short bValue = value;
        byte[] bytes = new byte[]{(byte)(bValue >> 8), (byte)bValue};
        return bytes;
    }

    public static byte[] asBytes(ESmallint value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EBytes.asBytes((Short)value.ezeUnbox(), length);
    }

    public static byte[] asBytes(Integer value, Integer ... length) {
        if (length.length > 0 && length[0] != 4) {
            EBytes.throwTypeCastException("int", value, length);
        }
        if (value == null) {
            return null;
        }
        int bValue = value;
        byte[] bytes = new byte[]{(byte)(bValue >> 24), (byte)(bValue >> 16), (byte)(bValue >> 8), (byte)bValue};
        return bytes;
    }

    public static byte[] asBytes(EInt value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EBytes.asBytes((Integer)value.ezeUnbox(), length);
    }

    public static byte[] asBytes(Long value, Integer ... length) {
        if (length.length > 0 && length[0] != 8) {
            EBytes.throwTypeCastException("bigint", value, length);
        }
        if (value == null) {
            return null;
        }
        long bValue = value;
        byte[] bytes = new byte[]{(byte)(bValue >> 56), (byte)(bValue >> 48), (byte)(bValue >> 40), (byte)(bValue >> 32), (byte)(bValue >> 24), (byte)(bValue >> 16), (byte)(bValue >> 8), (byte)bValue};
        return bytes;
    }

    public static byte[] asBytes(EBigint value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EBytes.asBytes((Long)value.ezeUnbox(), length);
    }

    public static byte[] asBytes(Float value, Integer ... length) {
        if (length.length > 0 && length[0] != 4) {
            EBytes.throwTypeCastException("smallfloat", value, length);
        }
        if (value == null) {
            return null;
        }
        int bValue = Float.floatToIntBits(value.floatValue());
        byte[] bytes = new byte[]{(byte)(bValue >> 24), (byte)(bValue >> 16), (byte)(bValue >> 8), (byte)bValue};
        return bytes;
    }

    public static byte[] asBytes(ESmallfloat value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EBytes.asBytes((Float)value.ezeUnbox(), length);
    }

    public static byte[] asBytes(Double value, Integer ... length) {
        if (length.length > 0 && length[0] != 8) {
            EBytes.throwTypeCastException("float", value, length);
        }
        if (value == null) {
            return null;
        }
        long bValue = Double.doubleToRawLongBits(value);
        byte[] bytes = new byte[]{(byte)(bValue >> 56), (byte)(bValue >> 48), (byte)(bValue >> 40), (byte)(bValue >> 32), (byte)(bValue >> 24), (byte)(bValue >> 16), (byte)(bValue >> 8), (byte)bValue};
        return bytes;
    }

    public static byte[] asBytes(EFloat value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EBytes.asBytes((Double)value.ezeUnbox(), length);
    }

    public static byte[] asBytes(BigDecimal value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EBytes.asBytes(value.unscaledValue(), length);
    }

    public static byte[] asBytes(EDecimal value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EBytes.asBytes((BigDecimal)value.ezeUnbox(), length);
    }

    public static byte[] asBytes(BigInteger value, Integer ... length) {
        if (value == null) {
            return null;
        }
        int digits = EBytes.digits(value);
        byte[] bytes = new byte[digits / 2 + 1];
        if (digits < 18) {
            NumericUtil.toDecimal(value.longValue(), bytes, 0, digits, bytes.length, (byte)12);
        } else {
            NumericUtil.toDecimal(value, bytes, 0, digits, bytes.length, (byte)12);
        }
        return bytes;
    }

    private static int digits(BigInteger bi) {
        int bitLength = bi.bitLength();
        if (bitLength < 4) {
            return 1;
        }
        if (bitLength < 63) {
            double log10 = Math.log10(Math.abs(bi.longValue()));
            int digits = (int)Math.ceil(log10);
            if (log10 == (double)((int)log10)) {
                ++digits;
            }
            return digits;
        }
        return new BigDecimal(bi).precision();
    }

    public static byte[] asBytes(Number value, Integer ... length) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return EBytes.asBytes((Integer)value, length);
        }
        if (value instanceof Short) {
            return EBytes.asBytes((Short)value, length);
        }
        if (value instanceof Long) {
            return EBytes.asBytes((Long)value, length);
        }
        if (value instanceof BigInteger) {
            return EBytes.asBytes((BigInteger)value, length);
        }
        if (value instanceof BigDecimal) {
            return EBytes.asBytes((BigDecimal)value, length);
        }
        if (value instanceof Double) {
            return EBytes.asBytes((Double)value, length);
        }
        if (value instanceof Float) {
            return EBytes.asBytes((Float)value, length);
        }
        EBytes.throwTypeCastException("number", value, length);
        return null;
    }

    public static byte[] asBytes(ENumber value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EBytes.asBytes(value.ezeUnbox(), length);
    }

    public static byte[] asBytes(byte[] value, Integer ... length) {
        byte[] bytes;
        if (value == null) {
            return null;
        }
        if (length.length != 0 && value.length > length[0] && (bytes = new byte[length[0].intValue()]).length > 0) {
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = value[i];
                ++i;
            }
        }
        return value;
    }

    public static byte[] asBytes(EBytes value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EBytes.asBytes((byte[])value.ezeUnbox(), length);
    }

    private static void throwTypeCastException(String actualTypeName, Object value, Integer ... length) throws TypeCastException {
        TypeCastException tcx = new TypeCastException();
        tcx.castToName = length.length > 0 ? "bytes(" + length[0] + ')' : "bytes";
        tcx.actualTypeName = actualTypeName;
        throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
    }

    public static byte[] plus(byte[] op1, byte[] op2) throws AnyException {
        return EBytes.concat(op1, op2);
    }

    public static byte[] concat(byte[] op1, byte[] op2) throws AnyException {
        int op1Length = op1 == null ? 0 : op1.length;
        int op2Length = op2 == null ? 0 : op2.length;
        byte[] bytes = new byte[op1Length + op2Length];
        int i = 0;
        while (i < op1Length) {
            bytes[i] = op1[i];
            ++i;
        }
        int j = 0;
        while (j < op2Length) {
            bytes[i] = op2[j];
            ++i;
            ++j;
        }
        return bytes;
    }

    public static byte[] concatNull(byte[] op1, byte[] op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        byte[] bytes = new byte[op1.length + op2.length];
        int i = 0;
        while (i < op1.length) {
            bytes[i] = op1[i];
            ++i;
        }
        int j = 0;
        while (j < op2.length) {
            bytes[i] = op2[j];
            ++i;
            ++j;
        }
        return bytes;
    }

    public static boolean equals(byte[] op1, byte[] op2) throws AnyException {
        if (op1 == op2) {
            return true;
        }
        if (op1 == null || op2 == null || op1.length != op2.length) {
            return false;
        }
        int i = 0;
        while (i < op1.length) {
            if (op1[i] != op2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean notEquals(byte[] op1, byte[] op2) throws AnyException {
        return !EBytes.equals(op1, op2);
    }

    public static int compareTo(byte[] op1, byte[] op2) throws AnyException {
        if (op1.length != op2.length) {
            InvalidArgumentException iax = new InvalidArgumentException();
            throw iax.fillInMessage("EGL0052E", "bytes(" + op1.length + ')', "bytes(" + op2.length + ')');
        }
        int i = 0;
        while (i < op1.length) {
            if (op1[i] != op2[i]) {
                if (op1[i] < op2[i]) {
                    return -1;
                }
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static byte[] substring(byte[] value, int start, int end) throws AnyException {
        int max = value.length;
        if (start < 1 || start > max) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = start;
            throw ex.fillInMessage("EGL0012E", start, end);
        }
        if (end < start || end < 1 || end > max) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = end;
            throw ex.fillInMessage("EGL0012E", start, end);
        }
        byte[] bytes = new byte[end - start + 1];
        if (bytes.length > 0) {
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = value[i + start - 1];
                ++i;
            }
        }
        return bytes;
    }

    public static int length(byte[] source) {
        return source.length;
    }
}

