/*******************************************************************************
 * Copyright © 2008, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_VAR
//
// Guidelines for defining Rich UI messages:  
// (1) DO NOT change the variable, "egl.eze$$rscBundles["RuiMessages"]"
// (2) The general format of a message is:
//          'MessageId'  :   'Message Text: {n}'
// (3) 'MessageId' (eg: CRRUI2007E) is composed of 4 parts:
//        - the first 5 characters is product identification, must be 'CRRUI'  
//        - the sixth character is a digit which identifies the component:
//                '0' -  Others       ( used to be 'E' )
//                '1' -  Widget       ( used to be 'I' )
//                '2' -  Runtime      ( used to be 'R' )
//                '3' -  Service      ( used to be 'S' )
//        - the 7th to 9th characters identifies message number, eg: '001'
//        - the 10th character identifies the message type:
//                'E' - error message
//                'I' - informational message
//                'W' - warning message
// (5)The message text may contain 1 or more message inserts, 
//         eg: {n},  where n is a 0 based number
// (6)Insert the message in alphabetical and numeric sort order  
//    against the MessageId to avoid conflicts which can be 
//    difficult to track at runtime            
//
egl.eze$$rscBundles["RuiMessages"] =
{
		'CRRUI0001E' : 'InitalUI[{0}]InitialUI \u540d\u304c\u7a7a\u3067\u3059\u3002\u540d\u524d\u3092\u521d\u671f\u5316\u3059\u308b\u305f\u3081\u306b\u95a2\u6570\u547c\u3073\u51fa\u3057\u3092\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002',		
		'CRRUI0006E' : 'RadioGroup \u30b0\u30eb\u30fc\u30d7 {0} \u306b\u6b63\u3057\u304f\u306a\u3044\u5f15\u6570\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002',
					
		'CRRUI1001E' : '\u5909\u6570 {0} \u3067\u306f\u3001{1} \u3092 {2} \u306b\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093',
		'CRRUI1010E' : '\u30c9\u30e9\u30c3\u30b0\u30fb\u30a2\u30f3\u30c9\u30fb\u30c9\u30ed\u30c3\u30d7\u95a2\u6570\u306f\u95a2\u6570\u53c2\u7167\u3067\u3001\u914d\u5217\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002{0}\u3002',
		'CRRUI1020E' : 'Runtime.asDictionary: \u30cf\u30f3\u30c9\u30e9\u30fc\u3068\u30ec\u30b3\u30fc\u30c9\u3092\u8f9e\u66f8\u306b\u5909\u63db\u3067\u304d\u308b\u306e\u307f\u3067\u3059\u3002{0} \u306b\u306f\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002',
		'CRRUI1030E' : '{0}.{1} \u306e\u5b9a\u7fa9\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002',
		'CRRUI1050E' : '\u5909\u6570 {0} \u306b\u306f\u300cnull\u300d\u3068\u3044\u3046\u8a9e\u3092\u542b\u3081\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002',
		'CRRUI1051E' : '\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8\u3092\u5909\u6570 {0} \u306b\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002',
		'CRRUI1055E' : '\u5b50 {1} \u3092\u5909\u6570 {2} \u306b\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002',		
		'CRRUI1057E' : '\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8 {0} \u306f\u305d\u308c\u81ea\u4f53\u306b\u306f\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002',	
		'CRRUI1058E' : '\u7956\u5148 {1} \u3092\u5909\u6570 {0} \u306b\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002{2} \u304c\u73fe\u5728\u306e\u7956\u5148\u3067\u3059\u3002',
		'CRRUI1060E' : '\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8\u300c{0}\u300d\u306e\u89aa\u3092 {1}:{2} \u306b\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002\u89aa\u306f\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002',
		'CRRUI1070E' : '\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570\u306e\u51e6\u7406\u4e2d\u306b\u4f8b\u5916 {0} \u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002try...OnException \u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI1071E' : '\u30b5\u30fc\u30d3\u30b9\u547c\u3073\u51fa\u3057\u306b\u5bfe\u3057\u4f8b\u5916\u30cf\u30f3\u30c9\u30e9\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u30b5\u30fc\u30d3\u30b9\u547c\u3073\u51fa\u3057\u306b\u5bfe\u3057\u4f8b\u5916\u30cf\u30f3\u30c9\u30e9\u30fc\u3092\u8ffd\u52a0\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI1072E' : '\u30a8\u30e9\u30fc\u30fb\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570\u3001try...OnException \u3092\u4f7f\u7528\u3057\u305f\u30b3\u30fc\u30c9\u3067\u4f8b\u5916 {0} \u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',		
		'CRRUI1080E' : '\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8\u306b\u6587\u66f8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30fb\u30e2\u30c7\u30eb (DOM) \u8981\u7d20\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u307e\u305f\u3001\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8\u304c\u6587\u66f8\u5185\u306b\u3042\u308a\u307e\u305b\u3093\u3002<br>\u3053\u306e\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8\u306e\u73fe\u5728\u306e\u5c5e\u6027:<P>{0}',
		'CRRUI1083E' : '\u30d6\u30e9\u30a6\u30b6\u30fc\u30fb\u30a4\u30d9\u30f3\u30c8 {0} \u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI1150E' : '\u5909\u6570 {0} \u304b\u3089\u300cNULL\u300d\u3092\u524a\u9664\u3057\u3088\u3046\u3068\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002',		
		'CRRUI1151E' : '\u6587\u66f8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30fb\u30e2\u30c7\u30eb (DOM) \u30a8\u30ec\u30e1\u30f3\u30c8\u306e\u306a\u3044\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8\u3092\u3001\u5909\u6570 {0} \u304b\u3089\u524a\u9664\u3057\u3088\u3046\u3068\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002',		
		'CRRUI1155E' : '{1} \u578b\u306e\u5b50\u3092 {0} \u304b\u3089\u524a\u9664\u3067\u304d\u307e\u305b\u3093: \u5909\u6570 {2}\u3002',
		'CRRUI1157E' : '\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8\u3092\u305d\u308c\u81ea\u4f53\u304b\u3089\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8\u30fb\u30bf\u30a4\u30d7\u306f {0} \u3067\u3059\u3002',
			
		'CRRUI2002E' : '{1}<br>{0} \u5185\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {2}',
		'CRRUI2004E' : '\u30d2\u30b9\u30c8\u30ea\u30fc {0} \u306b\u3001\u6b63\u3057\u304f\u306a\u3044\u5f15\u6570\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2005E' : 'NULL \u53c2\u7167\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002',
		'CRRUI2006E' : '{0}', // The text of this message comes from some other error message.
		'CRRUI2007E' : '\u4e0d\u6b63\u306a\u5f15\u6570: {0}\u3002',
		'CRRUI2009E' : 'RUI \u30cf\u30f3\u30c9\u30e9\u30fc\u304b\u3089\u30a4\u30d9\u30f3\u30c8\u3092\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002',
		'CRRUI2010E' : '\u975e\u63a8\u5968\u306e\u95a2\u6570: {0}\u3002',
		
		'CRRUI2015E' : 'RUIPropertiesLibrary {1} \u306e\u30d5\u30a1\u30a4\u30eb {0} \u304c\u6b20\u843d\u3057\u3066\u3044\u307e\u3059',
		'CRRUI2016E' : 'EGL \u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u9577\u6642\u9593\u4f7f\u7528\u3057\u3059\u304e\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2017E' : '\u30bf\u30a4\u30d7 {1} \u306e\u5024 \u300c{0}\u300d\u3092\u30bf\u30a4\u30d7 {2} \u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002',
		'CRRUI2018E' : '{0} \u3092\u30bf\u30a4\u30d7 {1} \u306b\u5272\u308a\u5f53\u3066\u308b\u3068\u304d\u306b\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2019E' : '\u8981\u7d20 {0} \u3092\u914d\u5217\u306b\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002\u914d\u5217\u306e\u6700\u5927\u30b5\u30a4\u30ba\u306f {1} \u3067\u3059',
		'CRRUI2020E' : '\u914d\u5217\u306e\u95a2\u6570\u3001setMaxSize() \u306b\u5bfe\u3059\u308b\u7121\u52b9\u306a\u5f15\u6570 {0}',
		'CRRUI2021E' : '\u30a4\u30f3\u30c7\u30c3\u30af\u30b9 {0} \u3067\u958b\u59cb\u3059\u308b\u6587\u5b57\u5217\u304b\u3089\u6b21\u306e\u30c8\u30fc\u30af\u30f3\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093',
		'CRRUI2022E' : '\u30a4\u30f3\u30c7\u30c3\u30af\u30b9 {0} \u306f\u3053\u306e\u914d\u5217\u306e\u9650\u754c\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002\u914d\u5217\u306e\u30b5\u30a4\u30ba\u306f {1} \u3067\u3059\u3002',
		'CRRUI2023E' : 'NULL \u53c2\u7167\u304c\u4f7f\u7528\u3055\u308c\u307e\u3057\u305f: {0}',
		'CRRUI2024E' : '\u30bf\u30a4\u30d7 {1} \u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u306f\u30ad\u30fc\u300c{0}\u300d\u3078\u306e\u52d5\u7684\u30a2\u30af\u30bb\u30b9\u306f\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2025E' : '\u52d5\u7684\u30a2\u30af\u30bb\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u300c{0}\u300d\u306b\u8a72\u5f53\u3059\u308b\u30ad\u30fc\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002',
		'CRRUI2030E' : 'XMLLib.convertFromXML \u306b\u5bfe\u3057\u3066\u7121\u52b9\u306a\u5f15\u6570\u3067\u3059\u3002\u6587\u5b57\u5217\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002{0}\u300d\u3092\u53d7\u3051\u53d6\u308a\u307e\u3057\u305f\u3002',
		'CRRUI2031E' : 'XML {0} \u3092\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2032E' : '\u30bf\u30a4\u30e0\u30fb\u30b9\u30bf\u30f3\u30d7\u30fb\u30d1\u30bf\u30fc\u30f3 {0} \u304c\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2033E' : '\u914d\u5217\u95a2\u6570\u3001resize() \u306b\u5bfe\u3057\u3066\u6307\u5b9a\u3057\u305f\u5024 {0} \u306f\u3001\u914d\u5217 {1} \u306e\u6700\u5927\u30b5\u30a4\u30ba\u3088\u308a\u5927\u304d\u3044\u3067\u3059\u3002',
		'CRRUI2034E' : '\u914d\u5217\u30a8\u30ec\u30e1\u30f3\u30c8\u306e\u30bf\u30a4\u30d7 {0} \u306f\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2035E' : '\u30b5\u30a4\u30ba\u5909\u66f4\u3059\u308b\u30c7\u30a3\u30e1\u30f3\u30b7\u30e7\u30f3\u306e\u6570\u304c\u3001\u305d\u306e\u914d\u5217\u306e\u30c7\u30a3\u30e1\u30f3\u30b7\u30e7\u30f3\u306e\u6570\u3088\u308a\u5927\u304d\u3044\u3067\u3059\u3002',
		'CRRUI2036E' : '{0} \u306b\u5bfe\u3059\u308b\u547c\u3073\u51fa\u3057\u3067\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc: \u5f15\u6570\u306f {1} \u3068 {2} \u306e\u9593\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002',
		'CRRUI2037E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: \u6570\u5024\u3092 0 \u3067\u9664\u7b97\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002',
		'CRRUI2038E' : '{0} \u306b\u5bfe\u3059\u308b\u547c\u3073\u51fa\u3057\u3067\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc: \u5f15\u6570\u306f\u30bc\u30ed\u3088\u308a\u5927\u304d\u3044\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002',
		'CRRUI2039E' : '{0} \u306b\u5bfe\u3059\u308b\u547c\u3073\u51fa\u3057\u3067\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc: \u5f15\u6570\u306f\u30bc\u30ed\u4ee5\u4e0a\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002',
		'CRRUI2040E' : '{0} \u306b\u5bfe\u3059\u308b\u547c\u3073\u51fa\u3057\u3067\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc: \u30bc\u30ed\u306e\u57fa\u5e95\u306e\u5834\u5408\u3001\u6307\u6570\u306f\u30bc\u30ed\u3088\u308a\u5927\u304d\u3044\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002',
		'CRRUI2041E' : '{0} \u306b\u5bfe\u3059\u308b\u547c\u3073\u51fa\u3057\u3067\u30c9\u30e1\u30a4\u30f3\u30fb\u30a8\u30e9\u30fc: \u8ca0\u306e\u57fa\u5e95\u306e\u5834\u5408\u3001\u6307\u6570\u306f\u6574\u6570\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002',
		'CRRUI2042E' : '\u30b5\u30d6\u30b9\u30c8\u30ea\u30f3\u30b0\u7d22\u5f15 {0}:{1} \u304c\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2050E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: abs() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30020 \u500b\u307e\u305f\u306f 1 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2051E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: add() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2052E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: compareTo() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2053E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: divide() - \u8ca0\u306e\u30b9\u30b1\u30fc\u30eb {0} \u306f\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2054E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: divide() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u304b\u3089 3 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2055E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: divideInteger() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2056E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: max() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2057E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: min() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2058E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: multiply() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2059E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: negate() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30020 \u500b\u307e\u305f\u306f 1 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2060E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: plus() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30020 \u500b\u307e\u305f\u306f 1 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2061E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: pow() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2062E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: pow() - \u8ca0\u306e\u4e57\u6570 {0} \u3067\u3059\u3002',
		'CRRUI2063E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: pow() - \u6841\u6570 {0} \u306f\u591a\u3059\u304e\u307e\u3059\u3002',
		'CRRUI2064E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: remainder() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2065E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: subtract() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2066E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: format() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30022 \u500b\u307e\u305f\u306f 6 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2067E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: format() - \u6307\u6570\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc {0} \u3067\u3059\u3002',
		'CRRUI2068E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: intValueExact() - \u5c0f\u6570\u90e8\u304c\u30bc\u30ed\u4ee5\u5916\u306e\u5024 {0} \u3067\u3059\u3002',
		'CRRUI2069E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: intValueExact() - \u5909\u63db\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc {0} \u3067\u3059\u3002',
		'CRRUI2070E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: setScale() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2071E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: setScale() - \u8ca0\u306e\u30b9\u30b1\u30fc\u30eb {0} \u3067\u3059\u3002',
		'CRRUI2072E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: intCheck() - \u5909\u63db\u30a8\u30e9\u30fc {0} \u3067\u3059\u3002',
		'CRRUI2073E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: dodivide() - \u6574\u6570\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc\u3002',
		'CRRUI2074E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: \u6587\u5b57\u5217 \u300c{1}\u300d\u3092\u6570\u5024\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002',
		'CRRUI2075E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: \u30e1\u30bd\u30c3\u30c9 {1} \u306b\u5bfe\u3059\u308b\u5f15\u6570\u306e\u6570 {0} \u304c\u7121\u52b9\u3067\u3059\u3002\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u5f15\u6570\u306f {2} \u3067\u3059\u3002',
		'CRRUI2076E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: \u6841\u6570\u304c\u591a\u3059\u304e\u307e\u3059 - {0}\u3002',
		'CRRUI2077E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: round() - {0} \u500b\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u30021 \u500b\u307e\u305f\u306f 2 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2078E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: round() - \u4e38\u3081\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002',
		'CRRUI2079E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: round() - \u4e38\u3081\u5024 {0} \u304c\u4e0d\u6b63\u3067\u3059\u3002',
		'CRRUI2080E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: round() - \u6307\u6570\u3001{0} \u3067\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2081E' : '\u6f14\u7b97\u30a8\u30e9\u30fc: finish() - \u6307\u6570\u3001{0} \u3067\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2082E' : '\u5185\u90e8\u30a8\u30e9\u30fc: {0} \u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u30fc\u3092\u547c\u3073\u51fa\u3057\u4e2d\u306b\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2083E' : '\u5185\u90e8\u30a8\u30e9\u30fc: \u30af\u30e9\u30b9 {0} \u3092\u5b9a\u7fa9\u4e2d\u306b\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2084E' : '\u5185\u90e8\u30a8\u30e9\u30fc: \u30a6\u30a3\u30b8\u30a7\u30c3\u30c8 {0}.{1} \u3092 egl.ui.rui.RUIPropertiesLibrary \u306e\u30b5\u30d6\u30af\u30e9\u30b9\u3068\u3057\u3066\u5b9a\u7fa9\u4e2d\u306b\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2085E' : '\u5185\u90e8\u30a8\u30e9\u30fc: \u30a6\u30a3\u30b8\u30a7\u30c3\u30c8 {0}.{1} \u3092 {2}.{3} \u306e\u30b5\u30d6\u30af\u30e9\u30b9\u3068\u3057\u3066\u5b9a\u7fa9\u4e2d\u306b\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2086E' : '\u5185\u90e8\u30a8\u30e9\u30fc: RUI \u30cf\u30f3\u30c9\u30e9\u30fc {0} \u3092\u5b9a\u7fa9\u4e2d\u306b\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2087E' : '\u5185\u90e8\u30a8\u30e9\u30fc: RUI \u30a6\u30a3\u30b8\u30a7\u30c3\u30c8 {0} \u3092\u5b9a\u7fa9\u4e2d\u306b\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2088E' : '\u3053\u306e\u30d6\u30e9\u30a6\u30b6\u30fc\u306f EGL Rich UI \u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002',
		'CRRUI2089E' : 'JSON \u30d5\u30a9\u30fc\u30de\u30c3\u30c8 \u300c{0}\u300d \u304b\u3089\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u7406\u7531\u306f {1} \u3067\u3059\u3002',
		'CRRUI2090E' : '\u30b5\u30fc\u30d3\u30b9 {0} \u3092\u547c\u3073\u51fa\u305b\u307e\u305b\u3093\u3067\u3057\u305f\u3002',
		'CRRUI2091E' : '\u30a4\u30d9\u30f3\u30c8\u3092 Eclipse IDE {0} \u306b\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3002',
		'CRRUI2092E' : '\u5185\u90e8\u30a8\u30e9\u30fc: IDE \u30a4\u30d9\u30f3\u30c8 {0} \u306e\u51e6\u7406\u4e2d\u306b\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2093E' : '\u5185\u90e8\u30a8\u30e9\u30fc: \u95a2\u6570 {0} \u3092\u88c5\u5099\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002',
		'CRRUI2094E' : '\u3053\u308c\u3089\u304c\u3001\u3053\u306e\u30a8\u30e9\u30fc\u306e\u539f\u56e0\u3067\u3042\u308b EGL \u95a2\u6570\u547c\u3073\u51fa\u3057\u3067\u3059\u3002',
		'CRRUI2095E' : '\u3053\u306e\u30a8\u30e9\u30fc\u306e\u539f\u56e0\u3067\u3042\u308b EGL \u95a2\u6570\u547c\u3073\u51fa\u3057\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002',
		'CRRUI2097E' : '\u5c5e\u6027 {0} \u306b\u5bfe\u3059\u308b CSS \u30b9\u30bf\u30a4\u30eb\u5024\u300c{1}\u300d\u306f\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2097E' : 'CSS \u30b9\u30bf\u30a4\u30eb {0} \u3092\u6b63\u3057\u304f\u69cb\u6587\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u69cb\u6587\u3092\u78ba\u8a8d\u3059\u308b\u304b\u3001\u5916\u90e8\u30b9\u30bf\u30a4\u30eb\u30fb\u30b7\u30fc\u30c8\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI2098E' : '\u30c9\u30e9\u30c3\u30b0\u30fb\u30a2\u30f3\u30c9\u30fb\u30c9\u30ed\u30c3\u30d7\u30fb\u30b5\u30dd\u30fc\u30c8\u4e2d\u306b\u30a8\u30e9\u30fc {0} \u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI2099E' : 'Rich UI \u3067\u306f\u3001\u30bf\u30a4\u30d7 {0} \u3067 EGL \u306e\u300cset\u300d\u64cd\u4f5c\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002',
		'CRRUI2100E' : 'RuiLib.convertFromXML \u306b\u5bfe\u3059\u308b\u5f15\u6570\u304c\u7121\u52b9\u3067\u3059\u3002\u6587\u5b57\u5217\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u30bf\u30a4\u30d7 {0} \u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u53d7\u3051\u53d6\u308a\u307e\u3057\u305f\u3002',
		'CRRUI2101E' : '\u300c{0}\u300d\u5185\u3067 indexOf\u300c{1}\u300d\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002\u7406\u7531\u306f {2} \u3067\u3059\u3002',
		'CRRUI2102E' : '\u914d\u5217\u3092\u30bd\u30fc\u30c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002',
		'CRRUI2103E' : '\u30bf\u30a4\u30d7\u300c{1}\u300d\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u5185\u306e\u300c{0}\u300d\u3078\u306e\u30a2\u30af\u30bb\u30b9\u304c\u4e0d\u6b63\u3067\u3059\u3002\u7406\u7531\u306f {2} \u3067\u3059\u3002',
		'CRRUI2104E' : 'JSON \u6587\u5b57\u5217\u300c{0}\u300d\u306e\u69cb\u6587\u89e3\u6790\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002',
		'CRRUI2105E' : '{0} \u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u305f\u3068\u304d\u306b JSON \u306e\u69cb\u6587\u89e3\u6790\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002JSON \u6587\u5b57\u5217\u5185\u306e\u4e88\u671f\u3055\u308c\u305f\u4f4d\u7f6e\u306b\u30d5\u30a3\u30fc\u30eb\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002',
		'CRRUI2106E' : 'JSON \u306e\u69cb\u6587\u89e3\u6790\u4e2d\u306b {0} \u3092 null \u306b\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u3066\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u7406\u7531\u306f\u3001NULL \u53ef\u80fd\u306a\u30d5\u30a3\u30fc\u30eb\u30c9\u3068\u3057\u3066\u5ba3\u8a00\u3055\u308c\u3066\u3044\u306a\u304b\u3063\u305f\u305f\u3081\u3067\u3059\u3002',
		'CRRUI2107E' : '\u30b5\u30fc\u30d3\u30b9\u30fb\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc JSON \u5909\u63db\u95a2\u6570\u306f\u3001\u30ec\u30b3\u30fc\u30c9\u307e\u305f\u306f\u30c7\u30a3\u30af\u30b7\u30e7\u30ca\u30ea\u30fc\u306b\u5bfe\u3057\u3066\u52d5\u4f5c\u3057\u307e\u3059\u3002{0} \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u308b\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002',
		'CRRUI2108E' : 'XML \u30e9\u30a4\u30d6\u30e9\u30ea\u30fc XML \u5909\u63db\u95a2\u6570\u306f\u3001\u30ec\u30b3\u30fc\u30c9\u306b\u5bfe\u3057\u3066\u52d5\u4f5c\u3057\u307e\u3059\u3002{0} \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u308b\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002',
		
		'CRRUI2111E' : 'MathContext() \u30a8\u30e9\u30fc: \u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u5f15\u6570\u306e\u6570 {0} \u304c\u7121\u52b9\u3067\u3059\u30021 \u500b\u304b\u3089 4 \u500b\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI2112E' : 'MathContext() \u30a8\u30e9\u30fc: \u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u6841\u6570 {0} \u304c\u5c0f\u3055\u3059\u304e\u307e\u3059\u3002',
		'CRRUI2113E' : 'MathContext() \u30a8\u30e9\u30fc: \u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u6841\u6570 {0} \u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002',
		'CRRUI2114E' : 'MathContext() \u30a8\u30e9\u30fc: \u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u66f8\u5f0f\u5024 {0} \u304c\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2115E' : 'MathContext() \u30a8\u30e9\u30fc: \u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u4e38\u3081\u30e2\u30fc\u30c9 {0} \u304c\u7121\u52b9\u3067\u3059\u3002',
		
	    'CRRUI2700E' : '\u5fc5\u9808\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u5165\u529b\u304c\u53d7\u4fe1\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI2702E' : '\u5165\u529b\u306e\u30c7\u30fc\u30bf\u578b\u30a8\u30e9\u30fc - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI2703E' : '\u8a31\u5bb9\u6709\u52b9\u6570\u5b57\u306e\u6570\u3092\u8d85\u3048\u3066\u3044\u307e\u3059 - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI2704E' : '{0} \u304b\u3089 {1} \u306e\u5b9a\u7fa9\u3055\u308c\u305f\u7bc4\u56f2\u3092\u8d85\u3048\u305f\u5165\u529b\u3067\u3059 - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI2705E' : '\u5165\u529b\u6700\u5c0f\u9577\u30a8\u30e9\u30fc - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI2707E' : '\u5165\u529b\u306e\u30e2\u30b8\u30e5\u30e9\u30b9\u30fb\u30c1\u30a7\u30c3\u30af\u30fb\u30a8\u30e9\u30fc - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI2708E' : '\u5b9a\u7fa9\u3055\u308c\u305f\u65e5\u4ed8\u307e\u305f\u306f\u6642\u523b\u5f62\u5f0f {0} \u306b\u5bfe\u3059\u308b\u5165\u529b\u304c\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2710E' : '\u5165\u529b\u306f\u30d6\u30fc\u30eb\u5024\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u306f\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2712E' : '16 \u9032\u30c7\u30fc\u30bf\u304c\u7121\u52b9\u3067\u3059\u3002',
		'CRRUI2713E' : '\u5165\u529b\u3055\u308c\u305f\u5024\u306f\u3001\u8a2d\u5b9a\u3055\u308c\u305f\u30d1\u30bf\u30fc\u30f3\u3068\u4e00\u81f4\u3057\u306a\u3044\u305f\u3081\u7121\u52b9\u3067\u3059\u3002',		
		'CRRUI2716E' : '\u6709\u52b9\u306a\u5024\u306e\u5b9a\u7fa9\u30ea\u30b9\u30c8\u306b\u542b\u307e\u308c\u306a\u3044\u5165\u529b\u3067\u3059 - \u518d\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002',
		'CRRUI2717E' : '\u6307\u5b9a\u3055\u308c\u305f\u65e5\u4ed8/\u6642\u523b\u5f62\u5f0f {0} \u306f\u7121\u52b9\u3067\u3059\u3002',	
		'CRRUI2719E' : '\u5165\u529b\u5024\u306e\u69cb\u6587\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',

		'CRRUI3650E' : '\u30c7\u30d7\u30ed\u30a4\u30e1\u30f3\u30c8\u8a18\u8ff0\u5b50\u30d5\u30a1\u30a4\u30eb\u300c{0}\u300d\u3092\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002',
		'CRRUI3651E' : '\u30b5\u30fc\u30d3\u30b9\u30fb\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0\u30fb\u30ad\u30fc\u300c{0}\u300d\u304c\u30c7\u30d7\u30ed\u30a4\u30e1\u30f3\u30c8\u8a18\u8ff0\u5b50\u300c{1}\u300d\u5185\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002',
		'CRRUI3652E' : '\u300c{0}\u300d\u306f\u4e0d\u6b63\u306a\u30b5\u30fc\u30d3\u30b9\u30fb\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0\u306e\u578b\u3067\u3059\u3002\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0\u306e\u578b\u300c{1}\u300d\u304c\u4e88\u671f\u3055\u308c\u3066\u3044\u307e\u3059\u3002',
		'CRRUI3653E' : '\u300c{0}\u300d\u3067 REST \u30b5\u30fc\u30d3\u30b9\u3092\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u3066\u3044\u308b\u3068\u304d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI3654E' : '\u8981\u6c42\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u300c{0}\u300d\u306e\u4f5c\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI3655E' : '\u5fdc\u7b54\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u300c{0}\u300d\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI3656E' : '\u300cformdata\u300d\u306f\u5fdc\u7b54\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3068\u3057\u3066\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002',
		'CRRUI3657E' : '\u30b5\u30fc\u30d3\u30b9\u547c\u3073\u51fa\u3057\u3092\u5b9f\u884c\u3059\u308b\u305f\u3081\u306e\u30d7\u30ed\u30ad\u30b7\u30fc\u3092\u300c{0}\u300d\u3067\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002',
		'CRRUI3658E' : '\u300c{1}\u300d\u3067\u30b5\u30fc\u30d3\u30b9\u3092\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u3066\u3044\u308b\u3068\u304d\u306b\u300c{0}\u300d\u306e\u30d7\u30ed\u30ad\u30b7\u30fc\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002',
		'CRRUI3659E' : 'JSON \u306e\u5fdc\u7b54\u69cb\u6587\u89e3\u6790\u7d50\u679c\u304c NULL \u306b\u306a\u308a\u307e\u3057\u305f\u3002\u30aa\u30ea\u30b8\u30ca\u30eb\u306e\u5fdc\u7b54\u306f\u300c{0}\u300d\u3067\u3059\u3002',
		'CRRUI3660E' : '\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u300c{0}\u300d\u306b\u5bfe\u3059\u308b\u5fdc\u7b54\u3092\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u7406\u7531\u306f\u300c{1}\u300d\u3067\u3059\u3002',
		'CRRUI3661E' : '\u30b5\u30fc\u30d3\u30b9\u95a2\u6570\u300c{1}\u300d\u3092\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u307e\u3057\u305f\u304c\u3001\u300c{0}\u300d\u306b\u5bfe\u3057\u30b5\u30fc\u30d3\u30b9\u30fb\u30d0\u30a4\u30f3\u30c7\u30a3\u30f3\u30b0\u60c5\u5831\u304c\u6b20\u843d\u3057\u3066\u3044\u307e\u3059\u3002'
};

