/*******************************************************************************
 * Copyright © 2008, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_VAR
//
// Guidelines for defining Rich UI messages:  
// (1) DO NOT change the variable, "egl.eze$$rscBundles["RuiMessages"]"
// (2) The general format of a message is:
//          'MessageId'  :   'Message Text: {n}'
// (3) 'MessageId' (eg: CRRUI2007E) is composed of 4 parts:
//        - the first 5 characters is product identification, must be 'CRRUI'  
//        - the sixth character is a digit which identifies the component:
//                '0' -  Others       ( used to be 'E' )
//                '1' -  Widget       ( used to be 'I' )
//                '2' -  Runtime      ( used to be 'R' )
//                '3' -  Service      ( used to be 'S' )
//        - the 7th to 9th characters identifies message number, eg: '001'
//        - the 10th character identifies the message type:
//                'E' - error message
//                'I' - informational message
//                'W' - warning message
// (5)The message text may contain 1 or more message inserts, 
//         eg: {n},  where n is a 0 based number
// (6)Insert the message in alphabetical and numeric sort order  
//    against the MessageId to avoid conflicts which can be 
//    difficult to track at runtime            
//
egl.eze$$rscBundles["RuiMessages"] =
{
		'CRRUI0001E' : 'InitalUI[{0}]InitialUI \u540d\u79f0\u4e3a\u7a7a\u3002\u4e0d\u80fd\u4f7f\u7528\u51fd\u6570\u8c03\u7528\u6765\u521d\u59cb\u5316\u540d\u79f0\u3002',		
		'CRRUI0006E' : '{0} RadioGroup \u7ec4\u4e2d\u5305\u542b\u975e\u6cd5\u53c2\u6570\u3002',
					
		'CRRUI1001E' : '\u5bf9\u4e8e {0} \u53d8\u91cf\uff0c\u4e0d\u80fd\u5c06 {1} \u8bbe\u7f6e\u4e3a {2}',
		'CRRUI1010E' : '\u62d6\u653e\u51fd\u6570\u662f\u51fd\u6570\u5f15\u7528\uff0c\u800c\u4e0d\u662f\u6570\u7ec4\uff1a{0}',
		'CRRUI1020E' : 'Runtime.asDictionary\uff1a\u53ea\u80fd\u5c06\u5904\u7406\u7a0b\u5e8f\u6216\u8bb0\u5f55\u8f6c\u6362\u4e3a\u5b57\u5178\u800c\u4e0d\u662f {0}',
		'CRRUI1030E' : '\u627e\u4e0d\u5230 {0}.{1} \u7684\u5b9a\u4e49',
		'CRRUI1050E' : '{0} \u53d8\u91cf\u5fc5\u987b\u5305\u542b\u5355\u8bcd\u201cnull\u201d\u3002',
		'CRRUI1051E' : '\u65e0\u6cd5\u5c06\u7a97\u53e3\u5c0f\u90e8\u4ef6\u6dfb\u52a0\u81f3 {0} \u53d8\u91cf\u3002',
		'CRRUI1055E' : '\u65e0\u6cd5\u5c06 {1} \u5b50\u4ee3\u6dfb\u52a0\u81f3 {2} \u53d8\u91cf\u3002',		
		'CRRUI1057E' : '\u65e0\u6cd5\u5c06 {0} \u7a97\u53e3\u5c0f\u90e8\u4ef6\u6dfb\u52a0\u81f3\u5b83\u81ea\u8eab\u3002',	
		'CRRUI1058E' : '\u65e0\u6cd5\u5c06 {1} \u7956\u4ee3\u6dfb\u52a0\u81f3 {0} \u53d8\u91cf\u3002{2} \u662f\u5f53\u524d\u7684\u7956\u4ee3\u3002',
		'CRRUI1060E' : '\u5c1d\u8bd5\u5c06\u7a97\u53e3\u5c0f\u90e8\u4ef6\u201c{0}\u201d\u7684\u7236\u4ee3\u8bbe\u7f6e\u4e3a {1}:{2}\uff1b\u7236\u4ee3\u5fc5\u987b\u662f\u4e00\u4e2a\u7a97\u53e3\u5c0f\u90e8\u4ef6',
		'CRRUI1070E' : '\u5904\u7406\u56de\u8c03\u51fd\u6570\u65f6\u53d1\u751f {0} \u5f02\u5e38\u3002\u8bf7\u4f7f\u7528 try...OnException\u3002',
		'CRRUI1071E' : '\u627e\u4e0d\u5230\u670d\u52a1\u8c03\u7528\u7684\u5f02\u5e38\u5904\u7406\u7a0b\u5e8f\u3002\u8bf7\u5bf9\u670d\u52a1\u8c03\u7528\u6dfb\u52a0\u5f02\u5e38\u5904\u7406\u7a0b\u5e8f\u3002',
		'CRRUI1072E' : '\u5728\u9519\u8bef\u56de\u8c03\u51fd\u6570\u4e2d\u53d1\u751f\u4e86 {0} \u5f02\u5e38\uff0c\u8bf7\u4f7f\u7528 try...OnException \u8fdb\u884c\u7f16\u7801',		
		'CRRUI1080E' : '\u7a97\u53e3\u5c0f\u90e8\u4ef6\u6ca1\u6709\u6587\u6863\u5bf9\u8c61\u6a21\u578b (DOM) \u5143\u7d20\uff0c\u5e76\u4e14\u4e0d\u5728\u6587\u6863\u4e2d\u3002<br>\u6b64\u7a97\u53e3\u5c0f\u90e8\u4ef6\u7684\u5f53\u524d\u5c5e\u6027\u5982\u4e0b\uff1a<P>{0}',
		'CRRUI1083E' : '\u5904\u7406\u6d4f\u89c8\u5668\u4e8b\u4ef6 {0} \u65f6\u51fa\u9519\u3002',
		'CRRUI1150E' : '\u5c1d\u8bd5\u4ece {0} \u53d8\u91cf\u4e2d\u9664\u53bb\u201cnull\u201d\u5931\u8d25\u3002',		
		'CRRUI1151E' : '\u5c1d\u8bd5\u4ece {0} \u53d8\u91cf\u4e2d\u9664\u53bb\u6ca1\u6709\u6587\u6863\u5bf9\u8c61\u6a21\u578b\uff08DOM\uff09\u5143\u7d20\u7684\u7a97\u53e3\u5c0f\u90e8\u4ef6\u5931\u8d25\u3002',		
		'CRRUI1155E' : '\u65e0\u6cd5\u4ece {0}: {2} \u53d8\u91cf\u4e2d\u9664\u53bb\u7c7b\u578b\u4e3a {1} \u7684\u5b50\u4ee3\u3002',
		'CRRUI1157E' : '\u65e0\u6cd5\u5c06\u7a97\u53e3\u5c0f\u90e8\u4ef6\u4ece\u5b83\u81ea\u8eab\u4e2d\u9664\u53bb\u3002\u7a97\u53e3\u5c0f\u90e8\u4ef6\u7c7b\u578b\u4e3a {0}\u3002',
			
		'CRRUI2002E' : '{1}<br>{0} \u4e2d\u53d1\u751f\u4e86\u9519\u8bef\uff1a{2}',
		'CRRUI2004E' : '\u5386\u53f2\u8bb0\u5f55 {0} \u4e2d\u5305\u542b\u975e\u6cd5\u53c2\u6570\u3002',
		'CRRUI2005E' : '\u4e0d\u80fd\u4f7f\u7528\u7a7a\u5f15\u7528\u3002',
		'CRRUI2006E' : '{0}', // The text of this message comes from some other error message.
		'CRRUI2007E' : '\u975e\u6cd5\u53c2\u6570\uff1a{0}\u3002',
		'CRRUI2009E' : '\u65e0\u6cd5\u4ece RUI \u5904\u7406\u7a0b\u5e8f\u5c06\u4e8b\u4ef6\u5b9e\u4f8b\u5316\u3002',
		'CRRUI2010E' : '\u4e0d\u63a8\u8350\u4f7f\u7528\u7684\u51fd\u6570\uff1a{0}\u3002',
		
		'CRRUI2015E' : '\u7f3a\u5c11 RUIPropertiesLibrary {1} \u7684\u6587\u4ef6 {0}',
		'CRRUI2016E' : 'EGL \u7a0b\u5e8f\u4f7f\u7528\u4e86\u592a\u957f\u65f6\u95f4',
		'CRRUI2017E' : '\u65e0\u6cd5\u5c06\u7c7b\u578b\u4e3a {1} \u7684\u503c\u201c{0}\u201d\u8f6c\u6362\u4e3a\u7c7b\u578b {2}',
		'CRRUI2018E' : '\u5c06 {0} \u6307\u5b9a\u7ed9\u7c7b\u578b {1} \u65f6\u53d1\u751f\u6ea2\u51fa',
		'CRRUI2019E' : '\u65e0\u6cd5\u5c06\u5143\u7d20 {0} \u8ffd\u52a0\u81f3\u6570\u7ec4\u3002\u6570\u7ec4\u7684\u6700\u5927\u5927\u5c0f\u4e3a {1}',
		'CRRUI2020E' : '\u6570\u7ec4\u51fd\u6570 setMaxSize() \u7684\u81ea\u53d8\u91cf {0} \u65e0\u6548',
		'CRRUI2021E' : '\u65e0\u6cd5\u4ece\u4e0b\u6807 {0} \u5904\u5f00\u59cb\u7684\u5b57\u7b26\u4e32\u4e2d\u68c0\u7d22\u4e0b\u4e00\u4e2a\u6807\u8bb0',
		'CRRUI2022E' : '\u4e0b\u6807 {0} \u8d85\u51fa\u6b64\u6570\u7ec4\u7684\u8303\u56f4\u3002\u6570\u7ec4\u5927\u5c0f\u4e3a {1}',
		'CRRUI2023E' : '\u4f7f\u7528\u4e86\u7a7a\u5f15\u7528 {0}',
		'CRRUI2024E' : '\u5728\u7c7b\u578b\u4e3a {1} \u7684\u5bf9\u8c61\u4e0a\uff0c\u5bf9\u952e\u201c{0}\u201d\u8fdb\u884c\u52a8\u6001\u8bbf\u95ee\u65e0\u6548',
		'CRRUI2025E' : '\u52a8\u6001\u8bbf\u95ee\u5931\u8d25\uff1a\u6ca1\u6709\u8fd9\u6837\u7684\u952e\u201c{0}\u201d',
		'CRRUI2030E' : 'XMLLib.convertFromXML \u7684\u81ea\u53d8\u91cf\u65e0\u6548\u3002\u671f\u671b\u5b57\u7b26\u4e32\uff0c\u4f46\u63a5\u6536\u5230\u201c{0}\u201d',
		'CRRUI2031E' : '\u89e3\u6790 XML \u65f6\u51fa\u9519\uff1a{0}',
		'CRRUI2032E' : '\u65f6\u95f4\u6233\u8bb0\u6a21\u5f0f {0} \u65e0\u6548',
		'CRRUI2033E' : '\u4e3a\u6570\u7ec4\u51fd\u6570 resize() \u6307\u5b9a\u7684\u503c {0} \u5927\u4e8e\u6b64\u6570\u7ec4\u7684\u6700\u5927\u5927\u5c0f {1}',
		'CRRUI2034E' : '\u6570\u7ec4\u5143\u7d20\u7684\u7c7b\u578b {0} \u65e0\u6548',
		'CRRUI2035E' : '\u5bf9\u5176\u8c03\u6574\u5927\u5c0f\u7684\u7ef4\u6570\u5927\u4e8e\u6570\u7ec4\u7684\u7ef4\u6570',
		'CRRUI2036E' : '\u8c03\u7528 {0} \u65f6\u53d1\u751f\u57df\u9519\u8bef\uff1a\u81ea\u53d8\u91cf\u5927\u5c0f\u5fc5\u987b\u5728 {1} \u548c {2} \u4e4b\u95f4',
		'CRRUI2037E' : '\u6570\u5b66\u9519\u8bef\uff1a\u9664\u6570\u4e0d\u80fd\u4e3a 0',
		'CRRUI2038E' : '\u8c03\u7528 {0} \u65f6\u53d1\u751f\u57df\u9519\u8bef\uff1a\u81ea\u53d8\u91cf\u5fc5\u987b\u5927\u4e8e 0',
		'CRRUI2039E' : '\u8c03\u7528 {0} \u65f6\u53d1\u751f\u57df\u9519\u8bef\uff1a\u81ea\u53d8\u91cf\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e 0',
		'CRRUI2040E' : '\u8c03\u7528 {0} \u65f6\u53d1\u751f\u57df\u9519\u8bef\uff1a\u57fa\u6570 0 \u7684\u6307\u6570\u5fc5\u987b\u5927\u4e8e 0',
		'CRRUI2041E' : '\u8c03\u7528 {0} \u65f6\u53d1\u751f\u57df\u9519\u8bef\uff1a\u8d1f\u57fa\u6570\u7684\u6307\u6570\u5fc5\u987b\u4e3a\u6574\u6570',
		'CRRUI2042E' : '\u5b50\u4e32\u4e0b\u6807 {0}:{1} \u65e0\u6548\u3002',
		'CRRUI2050E' : '\u6570\u5b66\u9519\u8bef\uff1aabs() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 0 \u6216 1',
		'CRRUI2051E' : '\u6570\u5b66\u9519\u8bef\uff1aadd() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2052E' : '\u6570\u5b66\u9519\u8bef\uff1acompareTo() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2053E' : '\u6570\u5b66\u9519\u8bef\uff1adivide() \uff0d \u5c0f\u6570\u4f4d\u6570 {0} \u4e3a\u8d1f\u6570\uff0c\u8fd9\u662f\u65e0\u6548\u7684',
		'CRRUI2054E' : '\u6570\u5b66\u9519\u8bef\uff1adivide() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u5728 1 \u548c 3 \u4e4b\u95f4',
		'CRRUI2055E' : '\u6570\u5b66\u9519\u8bef\uff1adivideInteger() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2056E' : '\u6570\u5b66\u9519\u8bef\uff1amax() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2057E' : '\u6570\u5b66\u9519\u8bef\uff1amin() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2058E' : '\u6570\u5b66\u9519\u8bef\uff1amultiply() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2059E' : '\u6570\u5b66\u9519\u8bef\uff1anegate() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 0 \u6216 1',
		'CRRUI2060E' : '\u6570\u5b66\u9519\u8bef\uff1aplus() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 0 \u6216 1',
		'CRRUI2061E' : '\u6570\u5b66\u9519\u8bef\uff1apow() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2062E' : '\u6570\u5b66\u9519\u8bef\uff1apow() \uff0d \u5e42 {0} \u4e3a\u8d1f\u6570',
		'CRRUI2063E' : '\u6570\u5b66\u9519\u8bef\uff1apow() \uff0d \u4f4d\u6570 {0} \u592a\u591a',
		'CRRUI2064E' : '\u6570\u5b66\u9519\u8bef\uff1aremainder() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2065E' : '\u6570\u5b66\u9519\u8bef\uff1asubtract() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2066E' : '\u6570\u5b66\u9519\u8bef\uff1aformat() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 2 \u6216 6',
		'CRRUI2067E' : '\u6570\u5b66\u9519\u8bef\uff1aformat() \uff0d \u6307\u6570\u6ea2\u51fa\uff0c{0}',
		'CRRUI2068E' : '\u6570\u5b66\u9519\u8bef\uff1aintValueExact() \uff0d \u5c0f\u6570\u90e8\u5206\u4e0d\u4e3a 0\uff0c{0}',
		'CRRUI2069E' : '\u6570\u5b66\u9519\u8bef\uff1aintValueExact() \uff0d \u8f6c\u6362\u6ea2\u51fa\uff0c{0}',
		'CRRUI2070E' : '\u6570\u5b66\u9519\u8bef\uff1asetScale() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2071E' : '\u6570\u5b66\u9519\u8bef\uff1asetScale() \uff0d \u5c0f\u6570\u4f4d\u6570 {0} \u4e3a\u8d1f\u6570',
		'CRRUI2072E' : '\u6570\u5b66\u9519\u8bef\uff1aintCheck() \uff0d \u53d1\u751f\u8f6c\u6362\u9519\u8bef\uff0c{0}',
		'CRRUI2073E' : '\u6570\u5b66\u9519\u8bef\uff1adodivide() \uff0d \u6574\u6570\u6ea2\u51fa',
		'CRRUI2074E' : '\u6570\u5b66\u9519\u8bef\uff1a\u672a\u80fd\u5c06\u5b57\u7b26\u4e32\u201c{1}\u201d\u8f6c\u6362\u4e3a\u6570\u5b57',
		'CRRUI2075E' : '\u6570\u5b66\u9519\u8bef\uff1a\u65b9\u6cd5 {1} \u7684\u53c2\u6570\u7f16\u53f7 {0} \u65e0\u6548\u3002\u6240\u63d0\u4f9b\u7684\u53c2\u6570\u4e3a {2}',
		'CRRUI2076E' : '\u6570\u5b66\u9519\u8bef\uff1a\u4f4d\u6570\u592a\u591a \uff0d {0}',
		'CRRUI2077E' : '\u6570\u5b66\u9519\u8bef\uff1around() \uff0d \u7ed9\u5b9a\u4e86 {0} \u4e2a\u81ea\u53d8\u91cf\u3002\u671f\u671b\u503c\u4e3a 1 \u6216 2',
		'CRRUI2078E' : '\u6570\u5b66\u9519\u8bef\uff1around() \uff0d \u9700\u8981\u8fdb\u884c\u820d\u5165',
		'CRRUI2079E' : '\u6570\u5b66\u9519\u8bef\uff1around() \uff0d \u820d\u5165\u503c {0} \u9519\u8bef',
		'CRRUI2080E' : '\u6570\u5b66\u9519\u8bef\uff1around() \uff0d \u6307\u6570 {0} \u6ea2\u51fa',
		'CRRUI2081E' : '\u6570\u5b66\u9519\u8bef\uff1afinish() \uff0d \u6307\u6570 {0} \u6ea2\u51fa',
		'CRRUI2082E' : '\u5185\u90e8\u9519\u8bef\uff1a\u8c03\u7528 {0} \u7684\u6784\u9020\u51fd\u6570\u65f6\u53d1\u751f\u5185\u90e8\u9519\u8bef',
		'CRRUI2083E' : '\u5185\u90e8\u9519\u8bef\uff1a\u5b9a\u4e49 {0} \u7c7b\u65f6\u53d1\u751f\u95ee\u9898',
		'CRRUI2084E' : '\u5185\u90e8\u9519\u8bef\uff1a\u5c06\u7a97\u53e3\u5c0f\u90e8\u4ef6 {0}.{1} \u5b9a\u4e49\u4e3a egl.ui.rui.RUIPropertiesLibrary \u7684\u5b50\u7c7b\u65f6\u53d1\u751f\u5185\u90e8\u9519\u8bef\u3002',
		'CRRUI2085E' : '\u5185\u90e8\u9519\u8bef\uff1a\u5c06\u7a97\u53e3\u5c0f\u90e8\u4ef6 {0}.{1} \u5b9a\u4e49\u4e3a {2}.{3} \u7684\u5b50\u7c7b\u65f6\u53d1\u751f\u5185\u90e8\u9519\u8bef',
		'CRRUI2086E' : '\u5185\u90e8\u9519\u8bef\uff1a\u5b9a\u4e49 RUI \u5904\u7406\u7a0b\u5e8f {0} \u65f6\u53d1\u751f\u95ee\u9898',
		'CRRUI2087E' : '\u5185\u90e8\u9519\u8bef\uff1a\u5b9a\u4e49 RUI \u7a97\u53e3\u5c0f\u90e8\u4ef6 {0} \u65f6\u53d1\u751f\u95ee\u9898',
		'CRRUI2088E' : 'EGL \u5bcc UI \u4e0d\u652f\u6301\u6b64\u6d4f\u89c8\u5668',
		'CRRUI2089E' : '\u7531\u4e8e {1} \u800c\u672a\u80fd\u4ece JSON \u683c\u5f0f\u201c{0}\u201d\u8fdb\u884c\u8f6c\u6362',
		'CRRUI2090E' : '\u672a\u80fd\u8c03\u7528\u670d\u52a1 {0}',
		'CRRUI2091E' : '\u65e0\u6cd5\u5c06\u4e8b\u4ef6\u53d1\u9001\u81f3 Eclipse IDE\uff1a{0}',
		'CRRUI2092E' : '\u5185\u90e8\u9519\u8bef\uff1a\u5904\u7406 IDE \u4e8b\u4ef6 {0} \u65f6\u53d1\u751f\u95ee\u9898',
		'CRRUI2093E' : '\u5185\u90e8\u9519\u8bef\uff1a\u672a\u80fd\u68c0\u6d4b\u51fd\u6570 {0}',
		'CRRUI2094E' : '\u4ee5\u4e0b\u662f\u5bfc\u81f4\u6b64\u9519\u8bef\u7684 EGL \u51fd\u6570\u8c03\u7528\uff1a',
		'CRRUI2095E' : '\u672a\u80fd\u627e\u5230\u5bfc\u81f4\u6b64\u9519\u8bef\u7684 EGL \u51fd\u6570\u8c03\u7528',
		'CRRUI2097E' : '\u5c5e\u6027 {0} \u7684 CSS \u6837\u5f0f\u503c\u201c{1}\u201d\u65e0\u6548',
		'CRRUI2097E' : '\u672a\u80fd\u6b63\u786e\u89e3\u6790 CSS \u6837\u5f0f {0}\u3002\u8bf7\u68c0\u67e5\u8bed\u6cd5\u662f\u5426\u6b63\u786e\uff0c\u6216\u8005\u4f7f\u7528\u5916\u90e8\u6837\u5f0f\u8868\u3002',
		'CRRUI2098E' : '\u5728\u62d6\u653e\u652f\u6301\u671f\u671b\u53d1\u751f\u9519\u8bef\uff1a{0}',
		'CRRUI2099E' : '\u5728\u5bcc UI \u4e2d\uff0c\u4e0d\u652f\u6301\u5bf9\u7c7b\u578b {0} \u6267\u884c EGL\u201cset\u201d\u64cd\u4f5c',
		'CRRUI2100E' : 'RuiLib.convertFromXML \u7684\u81ea\u53d8\u91cf\u65e0\u6548\u3002\u671f\u671b\u5b57\u7b26\u4e32\uff0c\u4f46\u63a5\u6536\u5230\u7c7b\u578b\u4e3a {0} \u7684\u5bf9\u8c61',
		'CRRUI2101E' : '\u7531\u4e8e {2} \u800c\u5728\u201c{0}\u201d\u4e2d\u65e0\u6cd5\u627e\u5230 indexOf\u201c{1}\u201d',
		'CRRUI2102E' : '\u672a\u80fd\u5bf9\u6570\u7ec4\u8fdb\u884c\u6392\u5e8f',
		'CRRUI2103E' : '\u7531\u4e8e {2} \u800c\u975e\u6cd5\u8bbf\u95ee\u4e86\u7c7b\u578b\u4e3a\u201c{1}\u201d\u7684\u5bf9\u8c61\u7684\u201c{0}\u201d',
		'CRRUI2104E' : '\u672a\u80fd\u89e3\u6790 JSON \u5b57\u7b26\u4e32\u201c{0}\u201d',
		'CRRUI2105E' : '\u5c1d\u8bd5\u8bbe\u7f6e {0} \u65f6\u53d1\u751f\u4e86 JSON \u89e3\u6790\u9519\u8bef\u3002\u5b57\u6bb5\u5728 JSON \u5b57\u7b26\u4e32\u4e2d\u7684\u671f\u671b\u4f4d\u7f6e\u4e0d\u5b58\u5728\u3002',
		'CRRUI2106E' : '\u89e3\u6790 JSON \u65f6\u5c1d\u8bd5\u5c06 {0} \u8bbe\u7f6e\u4e3a\u7a7a\u5931\u8d25\uff0c\u56e0\u4e3a\u6ca1\u6709\u5c06\u5b83\u58f0\u660e\u4e3a\u53ef\u7a7a\u5b57\u6bb5\u3002',
		'CRRUI2107E' : '\u670d\u52a1\u5e93 JSON \u8f6c\u6362\u51fd\u6570\u5728\u201c\u8bb0\u5f55\u201d\u6216\u201c\u5b57\u5178\u201d\u4e0a\u64cd\u4f5c\u3002{0} \u4e0d\u662f\u53d7\u652f\u6301\u7684\u7c7b\u578b\u3002',
		'CRRUI2108E' : 'XML \u5e93 XML \u8f6c\u6362\u51fd\u6570\u5728\u201c\u8bb0\u5f55\u201d\u4e0a\u64cd\u4f5c\u3002{0} \u4e0d\u662f\u53d7\u652f\u6301\u7684\u7c7b\u578b\u3002',
		
		'CRRUI2111E' : 'MathContext() \u9519\u8bef\uff1a\u6307\u5b9a\u7684\u53c2\u6570\u6570\u76ee {0} \u65e0\u6548\uff0c\u53c2\u6570\u6570\u76ee\u5e94\u8be5\u4e3a 1 \u5230 4\u3002',
		'CRRUI2112E' : 'MathContext() \u9519\u8bef\uff1a\u6307\u5b9a\u7684\u6570\u5b57\u6570\u76ee {0} \u592a\u5c0f\u3002',
		'CRRUI2113E' : 'MathContext() \u9519\u8bef\uff1a\u6307\u5b9a\u7684\u6570\u5b57\u6570\u76ee {0} \u592a\u5927\u3002',
		'CRRUI2114E' : 'MathContext() \u9519\u8bef\uff1a\u6307\u5b9a\u7684\u683c\u5f0f\u503c {0} \u65e0\u6548\u3002',
		'CRRUI2115E' : 'MathContext() \u9519\u8bef\uff1a\u6307\u5b9a\u7684\u820d\u5165\u65b9\u5f0f\u503c {0} \u65e0\u6548\u3002',
		
	    'CRRUI2700E' : '\u5fc5\u9700\u5b57\u6bb5\u672a\u63a5\u6536\u5230\u8f93\u5165\u5185\u5bb9 \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002',
		'CRRUI2702E' : '\u8f93\u5165\u5185\u5bb9\u7684\u6570\u636e\u7c7b\u578b\u9519\u8bef \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002',
		'CRRUI2703E' : '\u5141\u8bb8\u7684\u6709\u6548\u6570\u5b57\u4f4d\u6570\u8d85\u51fa\u8303\u56f4 \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002',
		'CRRUI2704E' : '\u8f93\u5165\u5185\u5bb9\u4e0d\u5728\u5df2\u5b9a\u4e49\u7684\u8303\u56f4 {0} \u5230 {1} \u5185 \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002',
		'CRRUI2705E' : '\u8f93\u5165\u6700\u5c0f\u957f\u5ea6\u51fa\u9519 \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002',
		'CRRUI2707E' : '\u5bf9\u8f93\u5165\u7684\u6a21\u6570\u68c0\u67e5\u53d1\u73b0\u9519\u8bef \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002',
		'CRRUI2708E' : '\u8f93\u5165\u5185\u5bb9\u5bf9\u4e8e\u5df2\u5b9a\u4e49\u7684\u65e5\u671f\u6216\u65f6\u95f4\u683c\u5f0f {0} \u65e0\u6548\u3002',
		'CRRUI2710E' : '\u5bf9\u4e8e\u5e03\u5c14\u503c\u5b57\u6bb5\uff0c\u8f93\u5165\u65e0\u6548\u3002',
		'CRRUI2712E' : '\u5341\u516d\u8fdb\u5236\u6570\u636e\u65e0\u6548\u3002',
		'CRRUI2713E' : '\u8f93\u5165\u7684\u503c\u65e0\u6548\uff0c\u56e0\u4e3a\u5b83\u4e0e\u6240\u8bbe\u7f6e\u7684\u6a21\u5f0f\u4e0d\u5339\u914d\u3002',		
		'CRRUI2716E' : '\u8f93\u5165\u5185\u5bb9\u4e0d\u5728\u5df2\u5b9a\u4e49\u7684\u6709\u6548\u503c\u5217\u8868\u4e2d \uff0d \u8bf7\u518d\u6b21\u8f93\u5165\u3002',
		'CRRUI2717E' : '\u6307\u5b9a\u7684\u65e5\u671f\u548c\u65f6\u95f4\u683c\u5f0f {0} \u65e0\u6548\u3002',	
		'CRRUI2719E' : '\u5bf9\u8f93\u5165\u503c\u8fdb\u884c\u8bed\u6cd5\u5206\u6790\u65f6\u51fa\u9519\u3002',

		'CRRUI3650E' : '\u627e\u4e0d\u5230\u90e8\u7f72\u63cf\u8ff0\u7b26\u6587\u4ef6\u201c{0}\u201d',
		'CRRUI3651E' : '\u90e8\u7f72\u63cf\u8ff0\u7b26\u201c{1}\u201d\u4e2d\u4e0d\u5b58\u5728\u670d\u52a1\u7ed1\u5b9a\u952e\u201c{0}\u201d',
		'CRRUI3652E' : '\u670d\u52a1\u7ed1\u5b9a\u7c7b\u578b\u201c{0}\u201d\u9519\u8bef\uff0c\u671f\u671b\u7684\u7ed1\u5b9a\u7c7b\u578b\u4e3a\u201c{1}\u201d',
		'CRRUI3653E' : '\u5c1d\u8bd5\u5bf9\u201c{0}\u201d\u8c03\u7528 rest \u670d\u52a1\u65f6\u53d1\u751f\u9519\u8bef',
		'CRRUI3654E' : '\u6784\u5efa\u8bf7\u6c42\u5bf9\u8c61\u201c{0}\u201d\u65f6\u53d1\u751f\u9519\u8bef',
		'CRRUI3655E' : '\u5904\u7406\u54cd\u5e94\u5bf9\u8c61\u201c{0}\u201d\u65f6\u53d1\u751f\u9519\u8bef',
		'CRRUI3656E' : '\u4e0d\u652f\u6301\u201cformdata\u201d\u4f5c\u4e3a\u54cd\u5e94\u683c\u5f0f',
		'CRRUI3657E' : '\u5728\u201c{0}\u201d\u5904\u627e\u4e0d\u5230\u4ee3\u7406\uff0c\u65e0\u6cd5\u8fdb\u884c\u670d\u52a1\u8c03\u7528',
		'CRRUI3658E' : '\u5c1d\u8bd5\u5bf9\u201c{1}\u201d\u8c03\u7528\u670d\u52a1\u65f6\uff0c\u5728\u201c{0}\u201d\u5904\u7684\u4ee3\u7406\u4e0a\u53d1\u751f\u4e86\u9519\u8bef',
		'CRRUI3659E' : '\u89e3\u6790 Json \u54cd\u5e94\u6240\u83b7\u5f97\u7684\u7ed3\u679c\u4e3a null\uff0c\u539f\u59cb\u54cd\u5e94\u4e3a\u201c{0}\u201d',
		'CRRUI3660E' : '\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u672a\u80fd\u5904\u7406\u201c{0}\u201d\u7684\u54cd\u5e94\uff0c\u539f\u56e0\u4e3a\u201c{1}\u201d',
		'CRRUI3661E' : '\u5c1d\u8bd5\u8c03\u7528\u670d\u52a1\u51fd\u6570\u201c{1}\u201d\u65f6\uff0c\u7f3a\u5c11\u201c{0}\u201d\u7684\u670d\u52a1\u7ed1\u5b9a\u4fe1\u606f\u3002'
};

