/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.AbstractPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.model.event.TreeAddEvent;
import org.eclipse.jpt.common.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.common.utility.model.event.TreeClearEvent;
import org.eclipse.jpt.common.utility.model.event.TreeRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.common.utility.model.value.TreeValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreePropertyValueModelAdapter<T>
extends AbstractPropertyValueModelAdapter<T> {
    protected final TreeValueModel<?> treeHolder;
    protected final TreeChangeListener treeChangeListener;

    protected TreePropertyValueModelAdapter(TreeValueModel<?> treeHolder) {
        this.treeHolder = treeHolder;
        this.treeChangeListener = this.buildTreeChangeListener();
    }

    protected TreeChangeListener buildTreeChangeListener() {
        return new TreeChangeListener(){

            public void nodeAdded(TreeAddEvent event) {
                TreePropertyValueModelAdapter.this.nodeAdded(event);
            }

            public void nodeRemoved(TreeRemoveEvent event) {
                TreePropertyValueModelAdapter.this.nodeRemoved(event);
            }

            public void treeCleared(TreeClearEvent event) {
                TreePropertyValueModelAdapter.this.treeCleared(event);
            }

            public void treeChanged(TreeChangeEvent event) {
                TreePropertyValueModelAdapter.this.treeChanged(event);
            }

            public String toString() {
                return "tree change listener";
            }
        };
    }

    @Override
    protected void engageModel_() {
        this.treeHolder.addTreeChangeListener("nodes", this.treeChangeListener);
    }

    @Override
    protected void disengageModel_() {
        this.treeHolder.removeTreeChangeListener("nodes", this.treeChangeListener);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.treeHolder);
    }

    protected void nodeAdded(TreeAddEvent event) {
        this.propertyChanged();
    }

    protected void nodeRemoved(TreeRemoveEvent event) {
        this.propertyChanged();
    }

    protected void treeCleared(TreeClearEvent event) {
        this.propertyChanged();
    }

    protected void treeChanged(TreeChangeEvent event) {
        this.propertyChanged();
    }
}

