/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query;

import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelManagerFactory;
import org.eclipse.jst.jsf.common.metadata.internal.ModelKeyDescriptor;
import org.eclipse.jst.jsf.common.metadata.internal.TaglibDomainMetaDataModelContextImpl;
import org.eclipse.jst.jsf.common.metadata.query.IEntityQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.ITraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.internal.HierarchicalSearchControl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleEntityQueryVisitorImpl;
import org.eclipse.jst.jsf.common.metadata.query.internal.SimpleTraitQueryVisitorImpl;

public final class TaglibDomainMetaDataQueryHelper {
    public static final String TAGLIB_DOMAIN = "TagLibraryDomain";

    private TaglibDomainMetaDataQueryHelper() {
    }

    public static ITaglibDomainMetaDataModelContext createMetaDataModelContext(IProject project, String uri) {
        return new TaglibDomainMetaDataModelContextImpl(TAGLIB_DOMAIN, project, uri);
    }

    public static Model getModel(ITaglibDomainMetaDataModelContext modelContext) {
        return TaglibDomainMetaDataQueryHelper.getMDModel(modelContext);
    }

    public static Entity getEntity(ITaglibDomainMetaDataModelContext modelContext, String entityKey) {
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        IResultSet rs = TaglibDomainMetaDataQueryHelper.getEntities(modelContext, entityKey, (IEntityQueryVisitor)visitor);
        Entity e = null;
        try {
            if (!rs.getResults().isEmpty()) {
                e = (Entity)rs.getResults().get(0);
            }
            rs.close();
        }
        catch (MetaDataException ex) {
            JSFCommonPlugin.log(4, "Error in Helper.getEntity() - 1", ex);
        }
        return e;
    }

    public static IResultSet getEntities(ITaglibDomainMetaDataModelContext modelContext, String entityKey, IEntityQueryVisitor visitor) {
        Model model = TaglibDomainMetaDataQueryHelper.getModel(modelContext);
        return TaglibDomainMetaDataQueryHelper.getEntities(model, entityKey, visitor);
    }

    public static Trait getTrait(Entity entity, String traitKey) {
        SimpleTraitQueryVisitorImpl visitor = new SimpleTraitQueryVisitorImpl();
        Trait t = null;
        IResultSet rs = TaglibDomainMetaDataQueryHelper.getTraits(entity, traitKey, visitor);
        try {
            if (!rs.getResults().isEmpty()) {
                t = (Trait)rs.getResults().get(0);
            }
            rs.close();
        }
        catch (MetaDataException ex) {
            JSFCommonPlugin.log(4, "Error in Helper.getTrait()", ex);
        }
        return t;
    }

    public static IResultSet getTraits(Entity entity, String traitKey, ITraitQueryVisitor traitQueryVisitor) {
        IResultSet<Trait> rs = traitQueryVisitor.findTraits(entity, traitKey);
        return rs;
    }

    public static Entity getEntity(Entity initialEntityContext, String entityKey) {
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        Entity e = null;
        IResultSet rs = TaglibDomainMetaDataQueryHelper.getEntities(initialEntityContext, entityKey, (IEntityQueryVisitor)visitor);
        try {
            if (!rs.getResults().isEmpty()) {
                e = (Entity)rs.getResults().get(0);
            }
            rs.close();
        }
        catch (MetaDataException ex) {
            JSFCommonPlugin.log(4, "Error in Helper.getEntity() - 0", ex);
        }
        return e;
    }

    public static IResultSet getEntities(Entity initialEntityContext, String entityQuery, IEntityQueryVisitor entityKeyQueryVisitor) {
        return entityKeyQueryVisitor.findEntities(initialEntityContext, entityQuery);
    }

    private static Model getMDModel(ITaglibDomainMetaDataModelContext modelContext) {
        IMetaDataModelContext context = TaglibDomainMetaDataQueryHelper.getContextAdapter(modelContext);
        IMetaDataModelManager mgr = MetaDataModelManagerFactory.getMetaDataModelManagerInstance(modelContext.getProject());
        if (mgr != null) {
            return mgr.getModel(context);
        }
        return null;
    }

    private static IMetaDataModelContext getContextAdapter(final ITaglibDomainMetaDataModelContext modelContext) {
        return new IMetaDataModelContext(){

            public Object getAdapter(Class adapter) {
                if (adapter == IProject.class) {
                    return this.getProject();
                }
                if (adapter == ModelKeyDescriptor.class) {
                    return new ModelKeyDescriptor(modelContext.getProject(), modelContext.getDomainID(), modelContext.getURI());
                }
                return null;
            }

            public String getDomainId() {
                return modelContext.getDomainID();
            }

            public IProject getProject() {
                return modelContext.getProject();
            }

            public String getModelIdentifier() {
                return ((ModelKeyDescriptor)this.getAdapter(ModelKeyDescriptor.class)).getUri();
            }
        };
    }

    public static Trait getTrait(ITaglibDomainMetaDataModelContext modelContext, String entityKey, String traitKey) {
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity(modelContext, entityKey);
        Trait t = null;
        if (entity != null) {
            t = TaglibDomainMetaDataQueryHelper.getTrait(entity, traitKey);
        }
        return t;
    }

    public static QName getQNameForTagEntity(Entity tagEntity) {
        Assert.isTrue((tagEntity != null ? 1 : 0) != 0);
        return new QName(tagEntity.getModel().getCurrentModelContext().getUri(), tagEntity.getId());
    }
}

