/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDGroupFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDMapFragment;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDWildcard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XSDGroupFragment
extends XSDMapFragment
implements IXSDGroupFragment {
    private XSDModelGroup xsdModelGroup_;
    private Vector groupIDsOrder_;
    private Hashtable groupIDs_;

    public XSDGroupFragment(String id, String name, XSDToFragmentConfiguration config, XSDToFragmentController controller, XSDModelGroup xsdModelGroup) {
        super(id, name, config, controller);
        this.xsdModelGroup_ = xsdModelGroup;
        this.groupIDsOrder_ = new Vector();
        this.groupIDs_ = new Hashtable();
    }

    public boolean processParameterValues(MultipartFormDataParser parser) throws MultipartFormDataException {
        boolean valuesValid = true;
        String[] params = parser.getParameterValues(this.getID());
        Vector<IXSDFragment> frags = new Vector<IXSDFragment>();
        Vector<String> groupIDsOrderCopy = new Vector<String>();
        Hashtable<String, String[]> groupIDsCopy = new Hashtable<String, String[]>();
        int i = 0;
        while (params != null && i < params.length) {
            if (params[i] != null) {
                groupIDsOrderCopy.add(params[i]);
                groupIDsCopy.put(params[i], this.getGroupMemberIDs(params[i]));
                IXSDFragment[] groupMemberFragments = this.getGroupMemberFragments(params[i]);
                int j = 0;
                while (j < groupMemberFragments.length) {
                    if (groupMemberFragments[j] != null) {
                        frags.add(groupMemberFragments[j]);
                        if (!groupMemberFragments[j].processParameterValues(parser)) {
                            valuesValid = false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.groupIDsOrder_ = groupIDsOrderCopy;
        this.groupIDs_ = groupIDsCopy;
        this.removeAllFragments();
        this.addFragments(frags);
        return valuesValid;
    }

    public boolean setParameterValuesFromInstanceDocuments(Element[] instanceDocuments) {
        this.removeGroupIDs();
        boolean paramsValid = true;
        String prevGroupID = null;
        String currGroupID = null;
        int groupMemberIndex = 0;
        int i = 0;
        while (i < instanceDocuments.length) {
            IXSDFragment[] groupMemberFrags;
            if (currGroupID == null) {
                String newGroupID = this.createInstance();
                prevGroupID = currGroupID;
                currGroupID = newGroupID;
            }
            Element[] instancePartition = null;
            int j = groupMemberIndex;
            boolean paramsAssigned = false;
            int wildcardFragIndex = -1;
            do {
                XSDComponent xsdComponent;
                if ((xsdComponent = (groupMemberFrags = this.getGroupMemberFragments(currGroupID))[j].getXSDToFragmentConfiguration().getXSDComponent()) instanceof XSDWildcard) {
                    if (wildcardFragIndex < 0) {
                        wildcardFragIndex = j;
                    }
                } else if (groupMemberFrags[j].getName().equals(this.trimPrefix(instanceDocuments[i].getTagName()))) {
                    instancePartition = this.getInstanceDocumentPartition(instanceDocuments, i, groupMemberFrags[j].getXSDToFragmentConfiguration().getMaxOccurs());
                    if (!groupMemberFrags[j].setParameterValuesFromInstanceDocuments(instancePartition)) {
                        paramsValid = false;
                    }
                    paramsAssigned = true;
                } else if (groupMemberFrags[j] instanceof XSDGroupFragment) {
                    groupMemberFrags[j].setParameterValuesFromInstanceDocuments(instanceDocuments);
                }
                if (j == groupMemberFrags.length - 1) {
                    j = 0;
                    String newGroupID = !paramsAssigned ? this.createInstance() : null;
                    prevGroupID = currGroupID;
                    currGroupID = newGroupID;
                    continue;
                }
                ++j;
            } while (!paramsAssigned && j != groupMemberIndex);
            groupMemberIndex = j;
            if (!paramsAssigned) {
                instancePartition = this.getInstanceDocumentPartition(instanceDocuments, i, -1);
                if (wildcardFragIndex >= 0) {
                    if (wildcardFragIndex >= groupMemberIndex) {
                        this.removeGroupID(currGroupID);
                        currGroupID = prevGroupID;
                    }
                    groupMemberIndex = wildcardFragIndex;
                    groupMemberFrags = this.getGroupMemberFragments(currGroupID);
                    if (!groupMemberFrags[wildcardFragIndex].setParameterValuesFromInstanceDocuments(instancePartition)) {
                        paramsValid = false;
                    }
                    paramsAssigned = true;
                } else if (!(currGroupID == null || prevGroupID != null && currGroupID.equals(prevGroupID))) {
                    paramsValid = false;
                    this.removeGroupID(currGroupID);
                    currGroupID = prevGroupID;
                }
            }
            i += instancePartition.length;
        }
        return paramsValid;
    }

    private Element[] getInstanceDocumentPartition(Element[] instanceDocuments, int start, int maxSize) {
        String tagName = instanceDocuments[start].getTagName();
        int size = 1;
        int i = start + 1;
        while (i < instanceDocuments.length) {
            if (maxSize != -1 && size >= maxSize || !instanceDocuments[i].getTagName().equals(tagName)) break;
            ++size;
            ++i;
        }
        Element[] subset = new Element[size];
        int j = 0;
        while (j < subset.length) {
            subset[j] = instanceDocuments[start + j];
            ++j;
        }
        return subset;
    }

    public Element[] genInstanceDocumentsFromParameterValues(boolean genXSIType, Hashtable namespaceTable, Document doc) {
        IXSDFragment[] groupMemberFragments = this.getAllFragments();
        Vector<Element> instanceDocumentsCopy = new Vector<Element>();
        int i = 0;
        while (i < groupMemberFragments.length) {
            Element[] fragmentInstances = groupMemberFragments[i].genInstanceDocumentsFromParameterValues(genXSIType, namespaceTable, doc);
            int j = 0;
            while (j < fragmentInstances.length) {
                instanceDocumentsCopy.add(fragmentInstances[j]);
                ++j;
            }
            ++i;
        }
        Element[] instanceDocuments = new Element[instanceDocumentsCopy.size()];
        int k = 0;
        while (k < instanceDocuments.length) {
            instanceDocuments[k] = (Element)instanceDocumentsCopy.get(k);
            ++k;
        }
        return instanceDocuments;
    }

    public void setXSDModelGroup(XSDModelGroup xsdModelGroup) {
        this.xsdModelGroup_ = xsdModelGroup;
    }

    public XSDModelGroup getXSDModelGroup() {
        return this.xsdModelGroup_;
    }

    public String[] getGroupIDs() {
        String[] groupIDs = new String[this.groupIDsOrder_.size()];
        int i = 0;
        while (i < groupIDs.length) {
            groupIDs[i] = (String)this.groupIDsOrder_.get(i);
            ++i;
        }
        return groupIDs;
    }

    protected void removeGroupIDs() {
        this.removeAllFragments();
        this.groupIDsOrder_.clear();
        this.groupIDs_.clear();
    }

    protected void removeGroupID(String groupID) {
        String[] memberFragIDs = this.getGroupMemberIDs(groupID);
        this.removeFragments(memberFragIDs);
        this.groupIDsOrder_.remove(groupID);
        this.groupIDs_.remove(groupID);
    }

    protected void setGroupMemberIDs(String groupID, String[] groupMemberIDs) {
        if (groupID != null) {
            if (!this.groupIDsOrder_.contains(groupID)) {
                this.groupIDsOrder_.add(groupID);
            }
            if (groupMemberIDs != null) {
                this.groupIDs_.put(groupID, groupMemberIDs);
            } else {
                this.groupIDs_.put(groupID, new String[0]);
            }
        }
    }

    protected void setGroupMemberFragments(String groupID, IXSDFragment[] groupMemberFragments) {
        this.addFragments(groupMemberFragments);
        String[] ids = new String[groupMemberFragments.length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = groupMemberFragments[i].getID();
            ++i;
        }
        this.setGroupMemberIDs(groupID, ids);
    }

    public String[] getGroupMemberIDs(String groupID) {
        String[] groupMemberIDs;
        if (groupID != null && (groupMemberIDs = (String[])this.groupIDs_.get(groupID)) != null) {
            return groupMemberIDs;
        }
        return new String[0];
    }

    public IXSDFragment[] getGroupMemberFragments(String groupID) {
        String[] groupMemberIDs = this.getGroupMemberIDs(groupID);
        IXSDFragment[] groupMemberFragments = new IXSDFragment[groupMemberIDs.length];
        int i = 0;
        while (i < groupMemberFragments.length) {
            groupMemberFragments[i] = this.getFragment(groupMemberIDs[i]);
            ++i;
        }
        return groupMemberFragments;
    }

    protected String createGroupInstance() {
        String groupID = this.genID();
        EList particles = this.getXSDModelGroup().getParticles();
        String[] groupMemberIDs = new String[particles.size()];
        int i = 0;
        while (i < particles.size()) {
            XSDParticle xsdParticle = (XSDParticle)particles.get(i);
            XSDParticleContent xsdParticleContent = xsdParticle.getContent();
            XSDToFragmentConfiguration thisConfig = this.getXSDToFragmentConfiguration();
            XSDToFragmentConfiguration xsdConfig = new XSDToFragmentConfiguration();
            if (xsdParticleContent instanceof XSDComponent) {
                xsdConfig.setXSDComponent((XSDComponent)xsdParticleContent);
            } else {
                xsdConfig.setXSDComponent(null);
            }
            xsdConfig.setStyle(thisConfig.getStyle());
            xsdConfig.setPartEncoding(thisConfig.getPartEncoding());
            xsdConfig.setWSDLPartName(thisConfig.getWSDLPartName());
            groupMemberIDs[i] = this.genID();
            this.addFragment(groupMemberIDs[i], this.getXSDToFragmentController().getFragment(xsdConfig, groupMemberIDs[i], groupMemberIDs[i]));
            ++i;
        }
        this.setGroupMemberIDs(groupID, groupMemberIDs);
        return groupID;
    }
}

