/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import javax.xml.namespace.QName;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.gef.commands.Command;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.visitor.W11FindInnerElementVisitor;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class W11TopLevelElementCommand
extends Command {
    private static final String XML = "xml";
    protected Definition definition;

    public W11TopLevelElementCommand(String label, Definition definition) {
        super(label);
        this.definition = definition;
    }

    protected void beginRecording(Object element) {
        if (element instanceof IDOMNode) {
            ((IDOMNode)element).getModel().beginRecording((Object)this, this.getUndoDescription());
        }
    }

    protected void endRecording(Object element) {
        if (element instanceof IDOMNode) {
            ((IDOMNode)element).getModel().endRecording((Object)this);
        }
    }

    protected String getUndoDescription() {
        return this.getLabel();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void formatChild(Element child) {
        if (!(child instanceof IDOMNode)) return;
        IDOMModel model = ((IDOMNode)child).getModel();
        try {
            model.aboutToChangeModel();
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode((Node)child);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            model.changedModel();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        model.changedModel();
    }

    public void execute() {
        W11TopLevelElementCommand.ensureDefinition(this.definition);
    }

    protected XSDElementDeclaration getNewXSDElement(XSDElementDeclaration xsdElement) {
        W11FindInnerElementVisitor visitor = new W11FindInnerElementVisitor();
        return visitor.getInnerXSDElement(xsdElement);
    }

    public static void ensureDefinition(Definition definition) {
        Document document = definition.getDocument();
        Element definitionsElement = document.getDocumentElement();
        if (definitionsElement == null) {
            String targetNamespace = W11TopLevelElementCommand.getDefaultNamespace(definition);
            definition.setQName(new QName(null, W11TopLevelElementCommand.getFileName(definition)));
            definition.setTargetNamespace(targetNamespace);
            definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            definition.updateElement();
            definition.addNamespace("tns", targetNamespace);
            definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            definitionsElement = definition.getElement();
        }
        W11TopLevelElementCommand.ensureXMLDirective(document);
    }

    private static void ensureXMLDirective(Document document) {
        if (W11TopLevelElementCommand.hasXMLDirective(document)) {
            return;
        }
        Node firstChild = document.getFirstChild();
        ProcessingInstruction xmlDeclaration = W11TopLevelElementCommand.getXMLDeclaration(document);
        document.insertBefore(xmlDeclaration, firstChild);
    }

    private static boolean hasXMLDirective(Document document) {
        Node firstChild = document.getFirstChild();
        if (firstChild == null) {
            return false;
        }
        if (firstChild.getNodeType() != 7) {
            return false;
        }
        ProcessingInstruction processingInstruction = (ProcessingInstruction)firstChild;
        return processingInstruction.getTarget().equals(XML);
    }

    private static ProcessingInstruction getXMLDeclaration(Document document) {
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String charSet = preference.getString("outputCodeset");
        if (charSet == null || charSet.trim().equals("")) {
            charSet = "UTF-8";
        }
        ProcessingInstruction xmlDeclaration = document.createProcessingInstruction(XML, "version=\"1.0\" encoding=\"" + charSet + "\"");
        return xmlDeclaration;
    }

    private static String getDefaultNamespace(Definition definition) {
        String namespace = WSDLEditorPlugin.getInstance().getPreferenceStore().getString("defaultNamespace");
        if (!namespace.endsWith("/")) {
            namespace = namespace.concat("/");
        }
        namespace = String.valueOf(namespace) + W11TopLevelElementCommand.getFileName(definition) + "/";
        return namespace;
    }

    private static String getFileName(Definition definition) {
        String fileLocation = definition.getLocation();
        Path filePath = new Path(fileLocation);
        return filePath.removeFileExtension().lastSegment().toString();
    }
}

