/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseTypeConnectingEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.AbstractModelCollection;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.ReferencedTypeColumn;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IComplexType;

public class ColumnEditPart
extends BaseEditPart {
    protected int spacing = 20;
    protected int minorAlignment = -1;
    protected boolean isHorizontal = false;

    public ColumnEditPart() {
    }

    public ColumnEditPart(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        ToolbarLayout layout = new ToolbarLayout(this.isHorizontal);
        if (this.minorAlignment != -1) {
            layout.setMinorAlignment(this.minorAlignment);
        }
        layout.setStretchMinorAxis(false);
        layout.setSpacing(this.spacing);
        figure.setLayoutManager((LayoutManager)layout);
        return figure;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        if (this.figure != null) {
            ((ToolbarLayout)this.figure.getLayoutManager()).setSpacing(spacing);
        }
    }

    public IComplexType getComplexType() {
        return (IComplexType)this.getModel();
    }

    protected void createEditPolicies() {
    }

    protected List getModelChildren() {
        AbstractModelCollection collection = (AbstractModelCollection)this.getModel();
        return collection.getChildren();
    }

    public int getMinorAlignment() {
        return this.minorAlignment;
    }

    public void setMinorAlignment(int minorAlignment) {
        this.minorAlignment = minorAlignment;
    }

    protected void refreshChildren() {
        super.refreshChildren();
        if (this.getModel() instanceof ReferencedTypeColumn) {
            if (this.getParent().getChildren().size() > 0) {
                EditPart editPart = (EditPart)this.getParent().getChildren().get(0);
                this.refreshConnections(editPart);
            }
        } else {
            this.refreshConnections((EditPart)this);
        }
    }

    public void refreshConnections(EditPart parent) {
        Iterator i = parent.getChildren().iterator();
        while (i.hasNext()) {
            EditPart editPart = (EditPart)i.next();
            if (editPart instanceof BaseTypeConnectingEditPart) {
                BaseTypeConnectingEditPart connectingEditPart = (BaseTypeConnectingEditPart)editPart;
                connectingEditPart.refreshConnections();
            }
            this.refreshConnections(editPart);
        }
    }

    public boolean isSelectable() {
        return false;
    }
}

