/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.compiler.binding.annotationType;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;


/**
 * @author Harmon
 */
public class JasperReportAnnotationTypeBinding extends PartSubTypeAnnotationTypeBinding {
    public static final String caseSensitiveName = InternUtil.internCaseSensitive("JasperReport");
    public static final String name = InternUtil.intern(caseSensitiveName);

    private static JasperReportAnnotationTypeBinding INSTANCE = new JasperReportAnnotationTypeBinding();
    
    public JasperReportAnnotationTypeBinding() {
        super(caseSensitiveName, new Object[0]);
    }
    
    public static JasperReportAnnotationTypeBinding getInstance() {
        return INSTANCE;
    }

    public boolean isApplicableFor(IBinding binding) {
        return binding.isTypeBinding() && (((ITypeBinding) binding).getKind() == ITypeBinding.HANDLER_BINDING);
   }

    private Object readResolve() {
        return INSTANCE;
    }
}
