/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.compiler.binding.annotationType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.UserDefinedAnnotationValidationRule;
import org.eclipse.edt.compiler.binding.UserDefinedValueValidationRule;
import org.eclipse.edt.compiler.core.IEGLConstants;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.PropertiesFileAnnotationValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.RUIPropertiesLibraryValidator;


/**
 * @author demurray
 */
public class RUIPropertiesLibraryAnnotationTypeBinding extends PartSubTypeAnnotationTypeBinding {
    public static final String caseSensitiveName = InternUtil.internCaseSensitive("RUIPropertiesLibrary");
    public static final String name = InternUtil.intern(caseSensitiveName);

    private static RUIPropertiesLibraryAnnotationTypeBinding INSTANCE = new RUIPropertiesLibraryAnnotationTypeBinding();
    
	private static final List myAnnotations = new ArrayList();
   	static{
   		myAnnotations.add(new UserDefinedAnnotationValidationRule(RUIPropertiesLibraryValidator.class));
   	}
   	   	
    public RUIPropertiesLibraryAnnotationTypeBinding() {
        super(caseSensitiveName);
    }
    
    public static RUIPropertiesLibraryAnnotationTypeBinding getInstance() {
        return INSTANCE;
    }
    
	private static final ArrayList propertiesFileAnnotations = new ArrayList();
   	static{
   		propertiesFileAnnotations.add(new UserDefinedValueValidationRule(PropertiesFileAnnotationValueValidator.class));
   	}

    private static final HashMap fieldAnnotations = new HashMap();
   	static{
   		fieldAnnotations.put(InternUtil.intern(IEGLConstants.PROPERTY_PROPERTIESFILE), propertiesFileAnnotations);
   	}
    
    public boolean isApplicableFor(IBinding binding) {
        return binding.isTypeBinding() && (((ITypeBinding) binding).getKind() == ITypeBinding.LIBRARY_BINDING);
   }

    private Object readResolve() {
        return INSTANCE;
    }

	public List getAnnotations(){
		return myAnnotations;
	}
	
	public List getFieldAnnotations(String field) {
		return (List) fieldAnnotations.get(field);
	}
	

}
