/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.compiler.core;

import java.util.HashSet;
import java.util.Locale;

/**
 * @author jshavor
 *
 * This is the public interface to for all EGL keywords
 */
public class EGLKeywordHandler {

	// IF YOU MODIFY THIS LIST YOU NEED TO:
	// 1 - make sure this is insync with error.flex in org.eclipse.edt.compiler.internal.pgm.errors (see EGLFlex2EGLKeywordTool)
	//     EXCEPTIONS - need to have: and, or, no, yes, true, false, self
	// 2 - regen the constants in IEGLConstants using org.eclipse.edt.compiler.internal.dev.tools.EGLKeywordTool
	// 3 - regen the code in EGLDefinedKeywordCompletions.getDefinedKeywordCompletions() using
	//     org.eclipse.edt.compiler.internal.dev.tools.EGLDefinedKeywordCompletionTool
	// 4 - regen the HashSet in this class using org.eclipse.edt.compiler.internal.dev.tools.EGLKeywordHashSetTool
	// 5 - post a note in the Team Room so everyone is aware.  VG to EGL migration can't use this list,
	//     so they need to make appropriate analogous changes.
	// 6 - since String constants are generated from these, you may need to capitalize
	//     some of the letters if the keyword is multi-word.  (see bigInt below)
	//	

	private static String[] keywordNames =
		{

			//EGL keywords
			//Generated :  Fri Apr 15 12:38:02 EDT 2005
			//These keywords should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLFlex2EGLKeywordTool
			"absolute", //$NON-NLS-1$
			"add", //$NON-NLS-1$
			"all", //$NON-NLS-1$
			"any", //$NON-NLS-1$
			"and", //$NON-NLS-1$
			"as", //$NON-NLS-1$
			"bigInt", //$NON-NLS-1$
			"bin", //$NON-NLS-1$
			"bind", //$NON-NLS-1$
			"blob", //$NON-NLS-1$
			"boolean", //$NON-NLS-1$
			"by", //$NON-NLS-1$
			"byName", //$NON-NLS-1$
			"byPosition", //$NON-NLS-1$
			"call", //$NON-NLS-1$
			"case", //$NON-NLS-1$
			"char", //$NON-NLS-1$
			"clob", //$NON-NLS-1$
			"close", //$NON-NLS-1$
			"const", //$NON-NLS-1$
			"continue", //$NON-NLS-1$
			"constructor", //$NON-NLS-1$
			"converse", //$NON-NLS-1$
			"current", //$NON-NLS-1$
			"dataItem", //$NON-NLS-1$
			"dataTable", //$NON-NLS-1$
			"date", //$NON-NLS-1$
			"dbChar", //$NON-NLS-1$
			"decimal", //$NON-NLS-1$
			"decrement", //$NON-NLS-1$
			"delegate", //$NON-NLS-1$
			"delete", //$NON-NLS-1$
			"display", //$NON-NLS-1$
			"dliCall", //$NON-NLS-1$
			"else", //$NON-NLS-1$
			"embed", //$NON-NLS-1$
			"end", //$NON-NLS-1$
			"enumeration", //$NON-NLS-1$
			"escape", //$NON-NLS-1$
			"execute", //$NON-NLS-1$
			"exit", //$NON-NLS-1$
			"extends", //$NON-NLS-1$			
			"externalType", //$NON-NLS-1$
			"false", //$NON-NLS-1$
			"field", //$NON-NLS-1$
			"first", //$NON-NLS-1$
			"float", //$NON-NLS-1$
			"for", //$NON-NLS-1$
			"forEach", //$NON-NLS-1$
			"form", //$NON-NLS-1$
			"formGroup", //$NON-NLS-1$
			"forUpdate", //$NON-NLS-1$
			"forward", //$NON-NLS-1$
			"freeSql", //$NON-NLS-1$
			"from", //$NON-NLS-1$
			"function", //$NON-NLS-1$
			"get", //$NON-NLS-1$
			"goto", //$NON-NLS-1$
			"group", //$NON-NLS-1$
			"handler", //$NON-NLS-1$
			"hex", //$NON-NLS-1$
			"hold", //$NON-NLS-1$
			"if", //$NON-NLS-1$
			"implements", //$NON-NLS-1$
			"import", //$NON-NLS-1$
			"in", //$NON-NLS-1$
			"inOut", //$NON-NLS-1$
			"inparent", //$NON-NLS-1$
			"insert", //$NON-NLS-1$
			"int", //$NON-NLS-1$
			"interface", //$NON-NLS-1$
			"interval", //$NON-NLS-1$
			"into", //$NON-NLS-1$
			"is", //$NON-NLS-1$
			"isa", //$NON-NLS-1$
			"label", //$NON-NLS-1$
			"languageBundle", //$NON-NLS-1$
			"last", //$NON-NLS-1$
			"library", //$NON-NLS-1$
			"like", //$NON-NLS-1$
			"matches", //$NON-NLS-1$
			"mbChar", //$NON-NLS-1$
			"money", //$NON-NLS-1$
			"move", //$NON-NLS-1$
			"new", //$NON-NLS-1$
			"next", //$NON-NLS-1$
			"null", //$NON-NLS-1$
			"no", //$NON-NLS-1$
			"noCursor", //$NON-NLS-1$
			"not", //$NON-NLS-1$
			"num", //$NON-NLS-1$
			"number", //$NON-NLS-1$
			"numc", //$NON-NLS-1$
			"of", //$NON-NLS-1$
			"onEvent", //$NON-NLS-1$
			"onException", //$NON-NLS-1$
			"open", //$NON-NLS-1$
			"openUI", //$NON-NLS-1$
			"or", //$NON-NLS-1$
			"otherwise", //$NON-NLS-1$
			"out", //$NON-NLS-1$
			"pacf", //$NON-NLS-1$
			"package", //$NON-NLS-1$
			"passing", //$NON-NLS-1$
			"prepare", //$NON-NLS-1$
			"previous", //$NON-NLS-1$
			"print", //$NON-NLS-1$
			"private", //$NON-NLS-1$
			"program", //$NON-NLS-1$
			"record", //$NON-NLS-1$
			"ref", //$NON-NLS-1$
			"relative", //$NON-NLS-1$
			"replace", //$NON-NLS-1$
			"return", //$NON-NLS-1$
			"returning", //$NON-NLS-1$
			"returns", //$NON-NLS-1$
			"rununit", //$NON-NLS-1$
			"scroll", //$NON-NLS-1$
			"self", //$NON-NLS-1$
			"service", //$NON-NLS-1$
			"set", //$NON-NLS-1$
			"show", //$NON-NLS-1$
			"singleRow", //$NON-NLS-1$
			"smallFloat", //$NON-NLS-1$
			"smallInt", //$NON-NLS-1$
			"sqlnullable", //$NON-NLS-1$
			"stack", //$NON-NLS-1$
			"static", //$NON-NLS-1$
			"string", //$NON-NLS-1$
			"this", //$NON-NLS-1$
			"throw", //$NON-NLS-1$
			"time", //$NON-NLS-1$
			"timeStamp", //$NON-NLS-1$
			"to", //$NON-NLS-1$
			"transaction", //$NON-NLS-1$
			"transfer", //$NON-NLS-1$
			"true", //$NON-NLS-1$
			"try", //$NON-NLS-1$
			"type", //$NON-NLS-1$
			"unicode", //$NON-NLS-1$
			"update", //$NON-NLS-1$
			"url", //$NON-NLS-1$
			"use", //$NON-NLS-1$
			"using", //$NON-NLS-1$
			"usingKeys", //$NON-NLS-1$
			"usingPCB", //$NON-NLS-1$
			"when", //$NON-NLS-1$
			"where", //$NON-NLS-1$
			"while", //$NON-NLS-1$
			"with", //$NON-NLS-1$
			"withV60Compat", //$NON-NLS-1$
			"wrap", //$NON-NLS-1$
			"yes", //$NON-NLS-1$
			};




	//Generated :  	Mon Mar 20 11:53:39 EST 2006
	//This definition should be generated by org.eclipse.edt.compiler.internal.dev.tools.EGLKeywordHashSetTool
	private static HashSet keywordHashSet = new HashSet();
	static {
		keywordHashSet.add("absolute");  //$NON-NLS-1$
		keywordHashSet.add("add");  //$NON-NLS-1$
		keywordHashSet.add("all");  //$NON-NLS-1$
		keywordHashSet.add("any");  //$NON-NLS-1$
		keywordHashSet.add("and");  //$NON-NLS-1$
		keywordHashSet.add("as");  //$NON-NLS-1$
		keywordHashSet.add("bigint");  //$NON-NLS-1$
		keywordHashSet.add("bin");  //$NON-NLS-1$
		keywordHashSet.add("bind");  //$NON-NLS-1$
		keywordHashSet.add("blob");  //$NON-NLS-1$
		keywordHashSet.add("boolean");  //$NON-NLS-1$
		keywordHashSet.add("by");  //$NON-NLS-1$
		keywordHashSet.add("byname");  //$NON-NLS-1$
		keywordHashSet.add("byposition");  //$NON-NLS-1$
		keywordHashSet.add("call");  //$NON-NLS-1$
		keywordHashSet.add("case");  //$NON-NLS-1$
		keywordHashSet.add("char");  //$NON-NLS-1$
		keywordHashSet.add("clob");  //$NON-NLS-1$
		keywordHashSet.add("close");  //$NON-NLS-1$
		keywordHashSet.add("const");  //$NON-NLS-1$
		keywordHashSet.add("continue");  //$NON-NLS-1$
		keywordHashSet.add("constructor");  //$NON-NLS-1$
		keywordHashSet.add("converse");  //$NON-NLS-1$
		keywordHashSet.add("current");  //$NON-NLS-1$
		keywordHashSet.add("dataitem");  //$NON-NLS-1$
		keywordHashSet.add("datatable");  //$NON-NLS-1$
		keywordHashSet.add("date");  //$NON-NLS-1$
		keywordHashSet.add("dbchar");  //$NON-NLS-1$
		keywordHashSet.add("decimal");  //$NON-NLS-1$
		keywordHashSet.add("decrement");  //$NON-NLS-1$
		keywordHashSet.add("delegate");  //$NON-NLS-1$
		keywordHashSet.add("delete");  //$NON-NLS-1$
		keywordHashSet.add("display");  //$NON-NLS-1$
		keywordHashSet.add("dlicall");  //$NON-NLS-1$
		keywordHashSet.add("else");  //$NON-NLS-1$
		keywordHashSet.add("embed");  //$NON-NLS-1$
		keywordHashSet.add("end");  //$NON-NLS-1$
		keywordHashSet.add("enumeration");  //$NON-NLS-1$
		keywordHashSet.add("escape");  //$NON-NLS-1$
		keywordHashSet.add("execute");  //$NON-NLS-1$
		keywordHashSet.add("exit");  //$NON-NLS-1$
		keywordHashSet.add("extends");  //$NON-NLS-1$
		keywordHashSet.add("externaltype");  //$NON-NLS-1$
		keywordHashSet.add("false");  //$NON-NLS-1$
		keywordHashSet.add("field");  //$NON-NLS-1$
		keywordHashSet.add("first");  //$NON-NLS-1$
		keywordHashSet.add("float");  //$NON-NLS-1$
		keywordHashSet.add("for");  //$NON-NLS-1$
		keywordHashSet.add("foreach");  //$NON-NLS-1$
		keywordHashSet.add("form");  //$NON-NLS-1$
		keywordHashSet.add("formgroup");  //$NON-NLS-1$
		keywordHashSet.add("forupdate");  //$NON-NLS-1$
		keywordHashSet.add("forward");  //$NON-NLS-1$
		keywordHashSet.add("freesql");  //$NON-NLS-1$
		keywordHashSet.add("from");  //$NON-NLS-1$
		keywordHashSet.add("function");  //$NON-NLS-1$
		keywordHashSet.add("get");  //$NON-NLS-1$
		keywordHashSet.add("goto");  //$NON-NLS-1$
		keywordHashSet.add("group");  //$NON-NLS-1$
		keywordHashSet.add("handler");  //$NON-NLS-1$
		keywordHashSet.add("hex");  //$NON-NLS-1$
		keywordHashSet.add("hold");  //$NON-NLS-1$
		keywordHashSet.add("if");  //$NON-NLS-1$
		keywordHashSet.add("implements");  //$NON-NLS-1$
		keywordHashSet.add("import");  //$NON-NLS-1$
		keywordHashSet.add("in");  //$NON-NLS-1$
		keywordHashSet.add("inout");  //$NON-NLS-1$
		keywordHashSet.add("inparent");  //$NON-NLS-1$
		keywordHashSet.add("insert");  //$NON-NLS-1$
		keywordHashSet.add("int");  //$NON-NLS-1$
		keywordHashSet.add("interface");  //$NON-NLS-1$
		keywordHashSet.add("interval");  //$NON-NLS-1$
		keywordHashSet.add("into");  //$NON-NLS-1$
		keywordHashSet.add("is");  //$NON-NLS-1$
		keywordHashSet.add("isa");  //$NON-NLS-1$
		keywordHashSet.add("label");  //$NON-NLS-1$
		keywordHashSet.add("languagebundle");  //$NON-NLS-1$
		keywordHashSet.add("last");  //$NON-NLS-1$
		keywordHashSet.add("library");  //$NON-NLS-1$
		keywordHashSet.add("like");  //$NON-NLS-1$
		keywordHashSet.add("matches");  //$NON-NLS-1$
		keywordHashSet.add("mbchar");  //$NON-NLS-1$
		keywordHashSet.add("money");  //$NON-NLS-1$
		keywordHashSet.add("move");  //$NON-NLS-1$
		keywordHashSet.add("new");  //$NON-NLS-1$
		keywordHashSet.add("next");  //$NON-NLS-1$
		keywordHashSet.add("null");  //$NON-NLS-1$
		keywordHashSet.add("no");  //$NON-NLS-1$
		keywordHashSet.add("nocursor");  //$NON-NLS-1$
		keywordHashSet.add("not");  //$NON-NLS-1$
		keywordHashSet.add("num");  //$NON-NLS-1$
		keywordHashSet.add("number");  //$NON-NLS-1$
		keywordHashSet.add("numc");  //$NON-NLS-1$
		keywordHashSet.add("of");  //$NON-NLS-1$
		keywordHashSet.add("onevent");  //$NON-NLS-1$
		keywordHashSet.add("onexception");  //$NON-NLS-1$
		keywordHashSet.add("open");  //$NON-NLS-1$
		keywordHashSet.add("openui");  //$NON-NLS-1$
		keywordHashSet.add("or");  //$NON-NLS-1$
		keywordHashSet.add("otherwise");  //$NON-NLS-1$
		keywordHashSet.add("out");  //$NON-NLS-1$
		keywordHashSet.add("pacf");  //$NON-NLS-1$
		keywordHashSet.add("package");  //$NON-NLS-1$
		keywordHashSet.add("passing");  //$NON-NLS-1$
		keywordHashSet.add("prepare");  //$NON-NLS-1$
		keywordHashSet.add("previous");  //$NON-NLS-1$
		keywordHashSet.add("print");  //$NON-NLS-1$
		keywordHashSet.add("private");  //$NON-NLS-1$
		keywordHashSet.add("program");  //$NON-NLS-1$
		keywordHashSet.add("record");  //$NON-NLS-1$
		keywordHashSet.add("ref");  //$NON-NLS-1$
		keywordHashSet.add("relative");  //$NON-NLS-1$
		keywordHashSet.add("replace");  //$NON-NLS-1$
		keywordHashSet.add("return");  //$NON-NLS-1$
		keywordHashSet.add("returning");  //$NON-NLS-1$
		keywordHashSet.add("returns");  //$NON-NLS-1$
		keywordHashSet.add("rununit");  //$NON-NLS-1$
		keywordHashSet.add("scroll");  //$NON-NLS-1$
		keywordHashSet.add("self");  //$NON-NLS-1$
		keywordHashSet.add("service");  //$NON-NLS-1$
		keywordHashSet.add("set");  //$NON-NLS-1$
		keywordHashSet.add("show");  //$NON-NLS-1$
		keywordHashSet.add("singlerow");  //$NON-NLS-1$
		keywordHashSet.add("smallfloat");  //$NON-NLS-1$
		keywordHashSet.add("smallint");  //$NON-NLS-1$
		keywordHashSet.add("sqlnullable");  //$NON-NLS-1$
		keywordHashSet.add("stack");  //$NON-NLS-1$
		keywordHashSet.add("static");  //$NON-NLS-1$
		keywordHashSet.add("string");  //$NON-NLS-1$
		keywordHashSet.add("this");  //$NON-NLS-1$
		keywordHashSet.add("throw");  //$NON-NLS-1$
		keywordHashSet.add("time");  //$NON-NLS-1$
		keywordHashSet.add("timestamp");  //$NON-NLS-1$
		keywordHashSet.add("to");  //$NON-NLS-1$
		keywordHashSet.add("transaction");  //$NON-NLS-1$
		keywordHashSet.add("transfer");  //$NON-NLS-1$
		keywordHashSet.add("true");  //$NON-NLS-1$
		keywordHashSet.add("try");  //$NON-NLS-1$
		keywordHashSet.add("type");  //$NON-NLS-1$
		keywordHashSet.add("unicode");  //$NON-NLS-1$
		keywordHashSet.add("update");  //$NON-NLS-1$
		keywordHashSet.add("url");  //$NON-NLS-1$
		keywordHashSet.add("use");  //$NON-NLS-1$
		keywordHashSet.add("using");  //$NON-NLS-1$
		keywordHashSet.add("usingkeys");  //$NON-NLS-1$
		keywordHashSet.add("usingpcb");  //$NON-NLS-1$
		keywordHashSet.add("when");  //$NON-NLS-1$
		keywordHashSet.add("where");  //$NON-NLS-1$
		keywordHashSet.add("while");  //$NON-NLS-1$
		keywordHashSet.add("with");  //$NON-NLS-1$
		keywordHashSet.add("withv60compat");  //$NON-NLS-1$
		keywordHashSet.add("wrap");  //$NON-NLS-1$
		keywordHashSet.add("yes");  //$NON-NLS-1$
	}

	
	/**
	 * @return
	 */
	public static String[] getKeywordNames() {
		return keywordNames;
	}
	
	
	/**
	 * return the List of EGL keyword names in lowercase
	 */
	public static String[] getKeywordNamesToLowerCase() {
		String[] lowercaseKeywordsNames = new String[keywordNames.length];
		for (int i = 0; i < lowercaseKeywordsNames.length; i++) {
			lowercaseKeywordsNames[i] = keywordNames[i].toLowerCase(Locale.ENGLISH);
		}
		return lowercaseKeywordsNames;
	}

	/**
	 * @return
	 */
	public static HashSet getKeywordHashSet() {
		return keywordHashSet;
	}

}
