/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
/* The following code was generated by JFlex 1.4.1 on 2/24/09 4:11 PM */

package org.eclipse.edt.compiler.core.ast;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

import java_cup.runtime.Symbol;




/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 2/24/09 4:11 PM from the specification file
 * <tt>egl.flex</tt>
 */
public class Lexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 128;

  /** lexical states */
  public static final int DLI = 7;
  public static final int DLI_QUOTED_ID = 8;
  public static final int SQLDELIMITEDID = 5;
  public static final int STRING = 1;
  public static final int DLI_DBL_QUOTED_ID = 9;
  public static final int SQL = 4;
  public static final int YYINITIAL = 0;
  public static final int HEXSTRING = 2;
  public static final int BLOCK_COMMENT = 3;
  public static final int SQLSTRING = 6;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\5\1\3\1\1\1\0\1\3\1\2\16\5\4\0\1\3\1\53"+
    "\1\14\1\23\1\4\1\65\1\60\1\100\1\51\1\52\1\22\1\11"+
    "\1\54\1\13\1\7\1\12\1\50\5\6\1\47\3\6\1\56\1\55"+
    "\1\62\1\57\1\63\1\64\1\71\1\34\1\35\1\16\1\17\1\10"+
    "\1\43\1\42\1\44\1\32\1\4\1\46\1\26\1\20\1\31\1\30"+
    "\1\37\1\25\1\40\1\24\1\33\1\21\1\41\1\45\1\15\1\36"+
    "\1\4\1\66\1\72\1\67\1\0\1\4\1\0\1\34\1\73\1\16"+
    "\1\17\1\10\1\74\1\42\1\44\1\32\1\4\1\46\1\26\1\20"+
    "\1\75\1\30\1\37\1\25\1\76\1\24\1\77\1\21\1\41\1\45"+
    "\1\15\1\36\1\4\1\27\1\61\1\70\1\0\41\5\2\0\4\4"+
    "\4\0\1\4\2\0\1\5\7\0\1\4\4\0\1\4\5\0\27\4"+
    "\1\0\37\4\1\0\u013f\4\31\0\162\4\4\0\14\4\16\0\5\4"+
    "\11\0\1\4\21\0\130\5\5\0\23\5\12\0\1\4\13\0\1\4"+
    "\1\0\3\4\1\0\1\4\1\0\24\4\1\0\54\4\1\0\46\4"+
    "\1\0\5\4\4\0\202\4\1\0\4\5\3\0\105\4\1\0\46\4"+
    "\2\0\2\4\6\0\20\4\41\0\46\4\2\0\1\4\7\0\47\4"+
    "\11\0\21\5\1\0\27\5\1\0\3\5\1\0\1\5\1\0\2\5"+
    "\1\0\1\5\13\0\33\4\5\0\3\4\15\0\4\5\14\0\6\5"+
    "\13\0\32\4\5\0\13\4\16\5\7\0\12\5\4\0\2\4\1\5"+
    "\143\4\1\0\1\4\10\5\1\0\6\5\2\4\2\5\1\0\4\5"+
    "\2\4\12\5\3\4\2\0\1\4\17\0\1\5\1\4\1\5\36\4"+
    "\33\5\2\0\3\4\60\0\46\4\13\5\1\4\u014f\0\3\5\66\4"+
    "\2\0\1\5\1\4\20\5\2\0\1\4\4\5\3\0\12\4\2\5"+
    "\2\0\12\5\21\0\3\5\1\0\10\4\2\0\2\4\2\0\26\4"+
    "\1\0\7\4\1\0\1\4\3\0\4\4\2\0\1\5\1\4\7\5"+
    "\2\0\2\5\2\0\3\5\11\0\1\5\4\0\2\4\1\0\3\4"+
    "\2\5\2\0\12\5\4\4\15\0\3\5\1\0\6\4\4\0\2\4"+
    "\2\0\26\4\1\0\7\4\1\0\2\4\1\0\2\4\1\0\2\4"+
    "\2\0\1\5\1\0\5\5\4\0\2\5\2\0\3\5\13\0\4\4"+
    "\1\0\1\4\7\0\14\5\3\4\14\0\3\5\1\0\11\4\1\0"+
    "\3\4\1\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\2\0"+
    "\1\5\1\4\10\5\1\0\3\5\1\0\3\5\2\0\1\4\17\0"+
    "\2\4\2\5\2\0\12\5\1\0\1\4\17\0\3\5\1\0\10\4"+
    "\2\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4"+
    "\2\0\1\5\1\4\6\5\3\0\2\5\2\0\3\5\10\0\2\5"+
    "\4\0\2\4\1\0\3\4\4\0\12\5\1\0\1\4\20\0\1\5"+
    "\1\4\1\0\6\4\3\0\3\4\1\0\4\4\3\0\2\4\1\0"+
    "\1\4\1\0\2\4\3\0\2\4\3\0\3\4\3\0\10\4\1\0"+
    "\3\4\4\0\5\5\3\0\3\5\1\0\4\5\11\0\1\5\17\0"+
    "\11\5\11\0\1\4\7\0\3\5\1\0\10\4\1\0\3\4\1\0"+
    "\27\4\1\0\12\4\1\0\5\4\4\0\7\5\1\0\3\5\1\0"+
    "\4\5\7\0\2\5\11\0\2\4\4\0\12\5\22\0\2\5\1\0"+
    "\10\4\1\0\3\4\1\0\27\4\1\0\12\4\1\0\5\4\2\0"+
    "\1\5\1\4\7\5\1\0\3\5\1\0\4\5\7\0\2\5\7\0"+
    "\1\4\1\0\2\4\4\0\12\5\22\0\2\5\1\0\10\4\1\0"+
    "\3\4\1\0\27\4\1\0\20\4\4\0\6\5\2\0\3\5\1\0"+
    "\4\5\11\0\1\5\10\0\2\4\4\0\12\5\22\0\2\5\1\0"+
    "\22\4\3\0\30\4\1\0\11\4\1\0\1\4\2\0\7\4\3\0"+
    "\1\5\4\0\6\5\1\0\1\5\1\0\10\5\22\0\2\5\15\0"+
    "\60\4\1\5\2\4\7\5\4\0\10\4\10\5\1\0\12\5\47\0"+
    "\2\4\1\0\1\4\2\0\2\4\1\0\1\4\2\0\1\4\6\0"+
    "\4\4\1\0\7\4\1\0\3\4\1\0\1\4\1\0\1\4\2\0"+
    "\2\4\1\0\4\4\1\5\2\4\6\5\1\0\2\5\1\4\2\0"+
    "\5\4\1\0\1\4\1\0\6\5\2\0\12\5\2\0\2\4\42\0"+
    "\1\4\27\0\2\5\6\0\12\5\13\0\1\5\1\0\1\5\1\0"+
    "\1\5\4\0\2\5\10\4\1\0\42\4\6\0\24\5\1\0\2\5"+
    "\4\4\4\0\10\5\1\0\44\5\11\0\1\5\71\0\42\4\1\0"+
    "\5\4\1\0\2\4\1\0\7\5\3\0\4\5\6\0\12\5\6\0"+
    "\6\4\4\5\106\0\46\4\12\0\51\4\7\0\132\4\5\0\104\4"+
    "\5\0\122\4\6\0\7\4\1\0\77\4\1\0\1\4\1\0\4\4"+
    "\2\0\7\4\1\0\1\4\1\0\4\4\2\0\47\4\1\0\1\4"+
    "\1\0\4\4\2\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4"+
    "\1\0\1\4\1\0\4\4\2\0\7\4\1\0\7\4\1\0\27\4"+
    "\1\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0\47\4"+
    "\1\0\23\4\16\0\11\5\56\0\125\4\14\0\u026c\4\2\0\10\4"+
    "\12\0\32\4\5\0\113\4\3\0\3\4\17\0\15\4\1\0\4\4"+
    "\3\5\13\0\22\4\3\5\13\0\22\4\2\5\14\0\15\4\1\0"+
    "\3\4\1\0\2\5\14\0\64\4\40\5\3\0\1\4\3\0\2\4"+
    "\1\5\2\0\12\5\41\0\3\5\2\0\12\5\6\0\130\4\10\0"+
    "\51\4\1\5\126\0\35\4\3\0\14\5\4\0\14\5\12\0\12\5"+
    "\36\4\2\0\5\4\u038b\0\154\4\224\0\234\4\4\0\132\4\6\0"+
    "\26\4\2\0\6\4\2\0\46\4\2\0\6\4\2\0\10\4\1\0"+
    "\1\4\1\0\1\4\1\0\1\4\1\0\37\4\2\0\65\4\1\0"+
    "\7\4\1\0\1\4\3\0\3\4\1\0\7\4\3\0\4\4\2\0"+
    "\6\4\4\0\15\4\5\0\3\4\1\0\7\4\17\0\4\5\32\0"+
    "\5\5\20\0\2\4\23\0\1\4\13\0\4\5\6\0\6\5\1\0"+
    "\1\4\15\0\1\4\40\0\22\4\36\0\15\5\4\0\1\5\3\0"+
    "\6\5\27\0\1\4\4\0\1\4\2\0\12\4\1\0\1\4\3\0"+
    "\5\4\6\0\1\4\1\0\1\4\1\0\1\4\1\0\4\4\1\0"+
    "\3\4\1\0\7\4\3\0\3\4\5\0\5\4\26\0\44\4\u0e81\0"+
    "\3\4\31\0\11\4\6\5\1\0\5\4\2\0\5\4\4\0\126\4"+
    "\2\0\2\5\2\0\3\4\1\0\137\4\5\0\50\4\4\0\136\4"+
    "\21\0\30\4\70\0\20\4\u0200\0\u19b6\4\112\0\u51a6\4\132\0\u048d\4"+
    "\u0773\0\u2ba4\4\u215c\0\u012e\4\2\0\73\4\225\0\7\4\14\0\5\4"+
    "\5\0\1\4\1\5\12\4\1\0\15\4\1\0\5\4\1\0\1\4"+
    "\1\0\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4"+
    "\2\0\66\4\50\0\15\4\3\0\20\5\20\0\4\5\17\0\2\4"+
    "\30\0\3\4\31\0\1\4\6\0\5\4\1\0\207\4\2\0\1\5"+
    "\4\0\1\4\13\0\12\5\7\0\32\4\4\0\1\4\1\0\32\4"+
    "\12\0\132\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4"+
    "\3\0\2\4\3\0\2\4\22\0\3\5\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\2\0\1\1\2\0\1\2\1\3\1\4"+
    "\1\5\1\6\1\7\1\5\1\10\1\11\1\12\1\13"+
    "\5\5\1\14\1\2\2\5\1\15\15\5\1\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\1\31\1\32\1\33\1\34\1\35\1\36\1\37"+
    "\2\40\1\41\1\42\2\43\1\37\2\4\4\1\1\44"+
    "\1\45\1\46\1\1\2\47\1\50\1\1\1\51\1\52"+
    "\1\53\1\54\2\55\1\56\1\57\1\0\1\60\1\0"+
    "\5\5\1\61\1\62\1\63\1\64\1\65\1\66\1\5"+
    "\1\67\7\5\1\70\5\5\1\71\11\5\1\72\1\73"+
    "\2\0\15\5\1\74\1\75\2\5\1\76\1\5\1\77"+
    "\1\100\1\101\1\102\5\5\1\103\6\5\1\104\24\5"+
    "\1\105\1\106\1\107\1\110\1\111\1\112\1\74\1\113"+
    "\1\114\1\115\1\116\1\117\1\120\1\121\1\122\1\123"+
    "\1\124\1\125\1\126\1\1\1\127\1\130\1\131\1\0"+
    "\6\5\1\132\1\5\2\62\1\133\1\134\10\5\1\135"+
    "\4\5\1\136\4\5\1\137\1\140\3\5\1\141\1\142"+
    "\2\0\1\143\15\5\1\144\4\5\1\145\1\146\2\5"+
    "\1\147\1\5\1\150\2\5\1\151\5\5\1\152\2\5"+
    "\1\153\1\154\1\111\1\155\3\5\1\156\3\5\1\157"+
    "\11\5\1\160\1\5\1\161\4\5\1\162\5\5\1\163"+
    "\6\5\1\164\1\165\1\1\1\5\1\166\3\5\1\167"+
    "\1\5\1\170\2\5\1\171\3\5\1\172\1\173\1\174"+
    "\5\5\1\175\3\5\1\176\5\5\2\0\10\5\1\177"+
    "\1\5\1\200\1\201\5\5\1\202\1\203\1\204\1\5"+
    "\1\205\6\5\1\206\1\5\1\207\1\210\1\5\1\211"+
    "\2\5\1\212\1\5\1\213\3\5\1\214\14\5\1\215"+
    "\4\5\1\216\6\5\1\217\1\220\1\5\1\221\1\222"+
    "\1\223\5\5\1\224\3\5\1\225\1\226\13\5\1\227"+
    "\2\5\1\230\2\5\1\231\2\0\1\232\5\5\1\233"+
    "\4\5\1\234\11\5\1\235\4\5\1\236\12\5\1\237"+
    "\6\5\1\240\1\5\1\241\4\5\1\242\1\243\1\76"+
    "\3\5\1\244\1\245\3\5\1\246\7\5\1\247\5\5"+
    "\1\250\1\5\1\251\3\5\1\252\1\0\1\5\1\253"+
    "\4\5\1\254\1\255\5\5\1\256\1\257\2\5\1\260"+
    "\1\261\10\5\1\262\1\263\7\5\1\264\1\5\1\265"+
    "\12\5\1\266\1\267\2\5\1\270\3\5\1\271\2\5"+
    "\1\272\1\273\2\5\1\274\2\5\1\275\1\0\1\276"+
    "\4\5\1\277\2\5\1\300\12\5\1\301\1\5\1\302"+
    "\1\303\1\304\1\5\1\305\1\306\1\5\1\307\1\5"+
    "\1\310\1\311\1\5\1\312\2\5\1\313\1\314\1\315"+
    "\4\5\1\316\1\317\1\5\1\320\1\321\1\5\1\322"+
    "\1\5\1\0\1\323\6\5\1\324\1\5\1\325\1\5"+
    "\1\326\2\5\1\327\1\330\1\5\1\331\1\332\1\5"+
    "\1\333\6\5\1\334\1\335\1\336\1\0\2\5\1\337"+
    "\2\5\1\340\1\5\1\341\1\342\2\5\1\343\1\344"+
    "\1\345\4\5\1\0\1\346\3\5\1\347\1\5\1\350"+
    "\2\5\1\351\1\352\1\0\1\353\1\5\1\354\1\355"+
    "\1\5\1\356\1\0\2\5\1\0\1\5\1\357\1\360"+
    "\1\361";

  private static int [] zzUnpackAction() {
    int [] result = new int[753];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\101\0\202\0\303\0\u0104\0\u0145\0\u0186\0\u01c7"+
    "\0\u0208\0\u0249\0\u028a\0\u02cb\0\u030c\0\u034d\0\u038e\0\u03cf"+
    "\0\u0410\0\u0451\0\u0492\0\u04d3\0\u028a\0\u0514\0\u0555\0\u0596"+
    "\0\u05d7\0\u0618\0\u0659\0\u069a\0\u06db\0\u071c\0\u028a\0\u075d"+
    "\0\u079e\0\u07df\0\u0820\0\u0861\0\u08a2\0\u08e3\0\u0924\0\u0965"+
    "\0\u09a6\0\u09e7\0\u0a28\0\u0a69\0\u028a\0\u028a\0\u0aaa\0\u028a"+
    "\0\u028a\0\u0aeb\0\u0b2c\0\u0b6d\0\u0bae\0\u0bef\0\u0c30\0\u0c71"+
    "\0\u0cb2\0\u028a\0\u028a\0\u028a\0\u028a\0\u0cf3\0\u028a\0\u0d34"+
    "\0\u028a\0\u0d75\0\u028a\0\u0d34\0\u0db6\0\u028a\0\u0df7\0\u028a"+
    "\0\u0e38\0\u0e79\0\u0eba\0\u028a\0\u028a\0\u028a\0\u0efb\0\u028a"+
    "\0\u0f3c\0\u0f7d\0\u0fbe\0\u0fff\0\u028a\0\u028a\0\u028a\0\u028a"+
    "\0\u1040\0\u0fff\0\u0f7d\0\u02cb\0\u1081\0\u10c2\0\u1103\0\u1144"+
    "\0\u1185\0\u11c6\0\u1207\0\u028a\0\u1248\0\u028a\0\u028a\0\u028a"+
    "\0\u028a\0\u1289\0\u028a\0\u12ca\0\u130b\0\u134c\0\u138d\0\u13ce"+
    "\0\u140f\0\u1450\0\u028a\0\u1491\0\u14d2\0\u1513\0\u1554\0\u1595"+
    "\0\u028a\0\u15d6\0\u1617\0\u1658\0\u1699\0\u16da\0\u171b\0\u175c"+
    "\0\u179d\0\u17de\0\u181f\0\u028a\0\u1860\0\u18a1\0\u18e2\0\u1923"+
    "\0\u1964\0\u19a5\0\u19e6\0\u1a27\0\u1a68\0\u1aa9\0\u1aea\0\u1b2b"+
    "\0\u1b6c\0\u1bad\0\u1bee\0\u034d\0\u034d\0\u1c2f\0\u1c70\0\u1cb1"+
    "\0\u1cf2\0\u1d33\0\u1d74\0\u034d\0\u034d\0\u1db5\0\u1df6\0\u1e37"+
    "\0\u1e78\0\u1eb9\0\u034d\0\u1efa\0\u1f3b\0\u1f7c\0\u1fbd\0\u1ffe"+
    "\0\u203f\0\u2080\0\u20c1\0\u2102\0\u2143\0\u2184\0\u21c5\0\u2206"+
    "\0\u2247\0\u2288\0\u22c9\0\u230a\0\u234b\0\u238c\0\u23cd\0\u240e"+
    "\0\u244f\0\u2490\0\u24d1\0\u2512\0\u2553\0\u2594\0\u028a\0\u25d5"+
    "\0\u028a\0\u028a\0\u028a\0\u028a\0\u028a\0\u028a\0\u028a\0\u2616"+
    "\0\u028a\0\u028a\0\u028a\0\u028a\0\u028a\0\u028a\0\u028a\0\u028a"+
    "\0\u028a\0\u2657\0\u028a\0\u028a\0\u2698\0\u2698\0\u26d9\0\u271a"+
    "\0\u275b\0\u279c\0\u27dd\0\u281e\0\u034d\0\u285f\0\u028a\0\u28a0"+
    "\0\u28e1\0\u028a\0\u2922\0\u2963\0\u29a4\0\u29e5\0\u2a26\0\u2a67"+
    "\0\u2aa8\0\u2ae9\0\u028a\0\u2b2a\0\u2b6b\0\u2bac\0\u2bed\0\u028a"+
    "\0\u2c2e\0\u2c6f\0\u2cb0\0\u2cf1\0\u028a\0\u034d\0\u2d32\0\u2d73"+
    "\0\u2db4\0\u034d\0\u028a\0\u2df5\0\u2e36\0\u034d\0\u2e77\0\u2eb8"+
    "\0\u2ef9\0\u2f3a\0\u2f7b\0\u2fbc\0\u2ffd\0\u303e\0\u307f\0\u30c0"+
    "\0\u3101\0\u3142\0\u3183\0\u034d\0\u31c4\0\u3205\0\u3246\0\u3287"+
    "\0\u034d\0\u32c8\0\u3309\0\u334a\0\u034d\0\u338b\0\u034d\0\u33cc"+
    "\0\u340d\0\u344e\0\u348f\0\u34d0\0\u3511\0\u3552\0\u3593\0\u034d"+
    "\0\u35d4\0\u3615\0\u034d\0\u034d\0\u034d\0\u034d\0\u3656\0\u3697"+
    "\0\u36d8\0\u3719\0\u375a\0\u379b\0\u37dc\0\u034d\0\u381d\0\u385e"+
    "\0\u389f\0\u38e0\0\u3921\0\u3962\0\u39a3\0\u39e4\0\u3a25\0\u034d"+
    "\0\u3a66\0\u034d\0\u3aa7\0\u3ae8\0\u3b29\0\u3b6a\0\u3bab\0\u3bec"+
    "\0\u3c2d\0\u3c6e\0\u3caf\0\u3cf0\0\u034d\0\u3d31\0\u3d72\0\u3db3"+
    "\0\u3df4\0\u3e35\0\u3e76\0\u028a\0\u028a\0\u3eb7\0\u3ef8\0\u034d"+
    "\0\u3f39\0\u3f7a\0\u3fbb\0\u034d\0\u3ffc\0\u028a\0\u403d\0\u407e"+
    "\0\u034d\0\u40bf\0\u4100\0\u4141\0\u034d\0\u034d\0\u034d\0\u4182"+
    "\0\u41c3\0\u4204\0\u4245\0\u4286\0\u034d\0\u42c7\0\u4308\0\u4349"+
    "\0\u034d\0\u438a\0\u43cb\0\u440c\0\u444d\0\u448e\0\u44cf\0\u4510"+
    "\0\u4551\0\u4592\0\u45d3\0\u4614\0\u4655\0\u4696\0\u46d7\0\u4718"+
    "\0\u034d\0\u4759\0\u034d\0\u034d\0\u479a\0\u47db\0\u481c\0\u485d"+
    "\0\u489e\0\u48df\0\u034d\0\u034d\0\u4920\0\u034d\0\u4961\0\u49a2"+
    "\0\u49e3\0\u4a24\0\u4a65\0\u4aa6\0\u034d\0\u4ae7\0\u4b28\0\u034d"+
    "\0\u4b69\0\u034d\0\u4baa\0\u4beb\0\u034d\0\u4c2c\0\u034d\0\u4c6d"+
    "\0\u4cae\0\u4cef\0\u034d\0\u4d30\0\u4d71\0\u4db2\0\u4df3\0\u4e34"+
    "\0\u4e75\0\u4eb6\0\u4ef7\0\u4f38\0\u4f79\0\u4fba\0\u4ffb\0\u034d"+
    "\0\u503c\0\u507d\0\u50be\0\u50ff\0\u5140\0\u5181\0\u51c2\0\u5203"+
    "\0\u5244\0\u5285\0\u52c6\0\u034d\0\u034d\0\u5307\0\u5348\0\u034d"+
    "\0\u034d\0\u5389\0\u53ca\0\u540b\0\u544c\0\u548d\0\u034d\0\u54ce"+
    "\0\u550f\0\u5550\0\u034d\0\u5591\0\u55d2\0\u5613\0\u5654\0\u5695"+
    "\0\u56d6\0\u5717\0\u5758\0\u5799\0\u57da\0\u581b\0\u585c\0\u034d"+
    "\0\u589d\0\u58de\0\u591f\0\u5960\0\u59a1\0\u028a\0\u59e2\0\u5a23"+
    "\0\u028a\0\u5a64\0\u5aa5\0\u5ae6\0\u5b27\0\u5b68\0\u034d\0\u5ba9"+
    "\0\u5bea\0\u5c2b\0\u5c6c\0\u034d\0\u5cad\0\u5cee\0\u5d2f\0\u5d70"+
    "\0\u5db1\0\u5df2\0\u5e33\0\u5e74\0\u5eb5\0\u034d\0\u5ef6\0\u5f37"+
    "\0\u5f78\0\u5fb9\0\u034d\0\u5ffa\0\u603b\0\u607c\0\u60bd\0\u60fe"+
    "\0\u613f\0\u6180\0\u61c1\0\u6202\0\u6243\0\u034d\0\u6284\0\u62c5"+
    "\0\u6306\0\u6347\0\u6388\0\u63c9\0\u034d\0\u640a\0\u034d\0\u644b"+
    "\0\u648c\0\u64cd\0\u650e\0\u034d\0\u034d\0\u034d\0\u654f\0\u6590"+
    "\0\u65d1\0\u034d\0\u034d\0\u6612\0\u6653\0\u6694\0\u034d\0\u66d5"+
    "\0\u6716\0\u6757\0\u6798\0\u67d9\0\u681a\0\u685b\0\u034d\0\u689c"+
    "\0\u68dd\0\u691e\0\u695f\0\u69a0\0\u034d\0\u69e1\0\u034d\0\u6a22"+
    "\0\u6a63\0\u6aa4\0\u034d\0\u6ae5\0\u6b26\0\u034d\0\u6b67\0\u6ba8"+
    "\0\u6be9\0\u6c2a\0\u034d\0\u034d\0\u6c6b\0\u6cac\0\u6ced\0\u6d2e"+
    "\0\u6d6f\0\u034d\0\u034d\0\u6db0\0\u6df1\0\u034d\0\u034d\0\u6e32"+
    "\0\u6e73\0\u6eb4\0\u6ef5\0\u6f36\0\u6f77\0\u6fb8\0\u6ff9\0\u034d"+
    "\0\u034d\0\u703a\0\u707b\0\u70bc\0\u70fd\0\u713e\0\u717f\0\u71c0"+
    "\0\u034d\0\u7201\0\u7242\0\u7283\0\u72c4\0\u7305\0\u7346\0\u7387"+
    "\0\u73c8\0\u7409\0\u744a\0\u748b\0\u74cc\0\u034d\0\u034d\0\u750d"+
    "\0\u754e\0\u034d\0\u758f\0\u75d0\0\u7611\0\u034d\0\u7652\0\u7693"+
    "\0\u034d\0\u034d\0\u76d4\0\u7715\0\u034d\0\u7756\0\u7797\0\u034d"+
    "\0\u77d8\0\u034d\0\u7819\0\u785a\0\u789b\0\u78dc\0\u034d\0\u791d"+
    "\0\u795e\0\u034d\0\u799f\0\u79e0\0\u7a21\0\u7a62\0\u7aa3\0\u7ae4"+
    "\0\u7b25\0\u7b66\0\u7ba7\0\u7be8\0\u034d\0\u7c29\0\u034d\0\u034d"+
    "\0\u034d\0\u7c6a\0\u034d\0\u034d\0\u7cab\0\u034d\0\u7cec\0\u034d"+
    "\0\u034d\0\u7d2d\0\u034d\0\u7d6e\0\u7daf\0\u034d\0\u034d\0\u034d"+
    "\0\u7df0\0\u7e31\0\u7e72\0\u7eb3\0\u034d\0\u034d\0\u7ef4\0\u034d"+
    "\0\u034d\0\u7f35\0\u034d\0\u7f76\0\u7fb7\0\u034d\0\u7ff8\0\u8039"+
    "\0\u807a\0\u80bb\0\u80fc\0\u813d\0\u034d\0\u817e\0\u034d\0\u81bf"+
    "\0\u034d\0\u8200\0\u8241\0\u034d\0\u034d\0\u8282\0\u034d\0\u034d"+
    "\0\u82c3\0\u034d\0\u8304\0\u8345\0\u8386\0\u83c7\0\u8408\0\u8449"+
    "\0\u034d\0\u034d\0\u034d\0\u848a\0\u84cb\0\u850c\0\u034d\0\u854d"+
    "\0\u858e\0\u034d\0\u85cf\0\u034d\0\u034d\0\u8610\0\u8651\0\u034d"+
    "\0\u034d\0\u034d\0\u8692\0\u86d3\0\u8714\0\u8755\0\u8796\0\u034d"+
    "\0\u87d7\0\u8818\0\u8859\0\u034d\0\u889a\0\u034d\0\u88db\0\u891c"+
    "\0\u034d\0\u034d\0\u895d\0\u034d\0\u899e\0\u034d\0\u034d\0\u89df"+
    "\0\u034d\0\u8a20\0\u8a61\0\u8aa2\0\u8ae3\0\u8b24\0\u034d\0\u028a"+
    "\0\u034d";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[753];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\13\2\14\1\15\1\16\1\13\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\16\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\16\1\51\1\52\1\53\1\54\1\16\2\17\1\55"+
    "\1\56\1\57\1\60\1\61\1\62\1\63\1\64\1\65"+
    "\1\66\1\67\1\70\1\71\1\72\1\73\1\74\1\75"+
    "\1\13\1\45\1\52\1\41\1\50\1\43\1\13\1\76"+
    "\1\77\1\100\11\76\1\101\55\76\1\102\6\76\2\103"+
    "\1\104\3\103\1\105\1\103\1\105\3\103\1\101\1\103"+
    "\2\105\14\103\2\105\5\103\1\105\3\103\2\105\22\103"+
    "\2\105\4\103\22\106\1\107\56\106\1\110\3\111\1\112"+
    "\3\110\1\112\2\110\1\113\1\114\5\112\2\110\3\112"+
    "\1\110\17\112\21\110\1\115\2\110\5\112\1\116\1\117"+
    "\1\120\1\121\11\117\1\122\64\117\1\123\1\120\1\121"+
    "\75\123\1\124\1\110\3\111\1\112\3\110\1\112\3\110"+
    "\1\125\5\112\2\110\3\112\1\110\17\112\21\110\1\126"+
    "\2\110\5\112\1\127\1\123\1\130\1\131\75\123\1\132"+
    "\1\117\1\130\1\131\11\117\1\133\64\117\102\0\2\14"+
    "\1\134\100\0\1\15\101\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\7\0"+
    "\1\17\1\135\1\136\36\0\2\17\36\0\1\135\40\0"+
    "\2\135\34\0\3\16\1\0\1\16\4\0\1\137\2\16"+
    "\1\140\1\16\2\0\1\141\1\16\1\142\1\0\1\16"+
    "\1\143\17\16\22\0\2\16\1\143\2\16\60\0\1\144"+
    "\33\0\1\145\7\0\1\146\34\0\1\147\100\0\1\150"+
    "\25\0\3\16\1\0\1\16\3\0\1\151\5\16\2\0"+
    "\3\16\1\0\1\152\20\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\3\0\1\153\1\154\3\16\1\155\2\0"+
    "\2\16\1\156\1\0\1\157\3\16\1\160\7\16\1\161"+
    "\4\16\22\0\5\16\5\0\3\16\1\0\1\162\3\0"+
    "\1\163\1\164\4\16\2\0\2\16\1\165\1\0\2\16"+
    "\1\166\1\16\1\167\1\170\13\16\22\0\1\170\4\16"+
    "\5\0\3\16\1\0\1\16\3\0\1\171\1\172\4\16"+
    "\2\0\3\16\1\0\1\173\3\16\1\174\1\175\13\16"+
    "\22\0\1\175\4\16\5\0\3\16\1\0\1\16\4\0"+
    "\1\176\4\16\2\0\1\177\2\16\1\0\1\16\1\200"+
    "\5\16\1\201\1\202\10\16\22\0\2\16\1\200\1\202"+
    "\1\16\23\0\1\203\34\0\1\204\40\0\1\205\4\0"+
    "\1\206\60\0\3\16\1\0\1\207\4\0\1\16\1\210"+
    "\1\16\1\211\1\16\2\0\1\16\1\212\1\16\1\0"+
    "\2\16\1\213\1\214\10\16\1\215\4\16\22\0\4\16"+
    "\1\214\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\2\16\1\216\1\16\1\217\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\4\16\1\220"+
    "\2\0\3\16\1\0\1\16\1\221\1\16\1\222\3\16"+
    "\1\223\1\224\2\16\1\225\5\16\22\0\1\16\1\225"+
    "\1\221\1\224\1\222\5\0\3\16\1\0\1\226\4\0"+
    "\4\16\1\227\2\0\3\16\1\0\1\230\20\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\3\16\1\231"+
    "\1\16\2\0\1\232\2\16\1\0\1\16\1\233\11\16"+
    "\1\234\5\16\22\0\1\16\1\234\1\233\2\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\1\235\1\16\1\236\3\16\1\237\1\16\1\240\3\16"+
    "\1\241\4\16\22\0\3\16\1\240\1\16\5\0\3\16"+
    "\1\0\1\16\4\0\2\16\1\242\2\16\2\0\1\243"+
    "\1\16\1\244\1\0\1\16\1\245\3\16\1\246\13\16"+
    "\22\0\1\246\1\16\1\245\2\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\2\16\1\247\1\0\1\250"+
    "\1\16\1\251\3\16\1\252\12\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\253\4\0\5\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\254\3\16\1\255"+
    "\10\16\22\0\3\16\1\255\1\16\5\0\3\16\1\0"+
    "\1\256\4\0\4\16\1\257\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\260\4\0\5\16"+
    "\2\0\3\16\1\0\1\261\7\16\1\262\10\16\22\0"+
    "\3\16\1\262\1\16\5\0\3\16\1\0\1\16\4\0"+
    "\4\16\1\263\2\0\2\16\1\264\1\0\1\265\1\16"+
    "\1\266\1\16\1\267\3\16\1\270\10\16\22\0\3\16"+
    "\1\270\1\16\5\0\3\16\1\0\1\271\4\0\5\16"+
    "\2\0\3\16\1\0\1\272\3\16\1\273\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\2\16\1\274\5\16\1\275\3\16\1\276"+
    "\4\16\22\0\3\16\1\275\1\16\60\0\1\277\77\0"+
    "\1\300\101\0\1\301\100\0\1\302\1\303\77\0\1\304"+
    "\1\0\1\305\76\0\1\306\100\0\1\307\77\0\1\310"+
    "\101\0\1\311\21\0\1\76\2\0\11\76\1\0\55\76"+
    "\1\0\6\76\1\0\1\77\113\0\1\312\55\0\1\313"+
    "\1\314\1\315\1\316\1\317\1\320\7\0\1\105\1\0"+
    "\1\105\5\0\2\105\14\0\2\105\5\0\1\105\3\0"+
    "\2\105\22\0\2\105\16\0\1\321\67\0\3\111\101\0"+
    "\3\112\1\0\1\112\4\0\5\112\2\0\3\112\1\0"+
    "\21\112\22\0\5\112\14\0\1\322\65\0\1\117\2\0"+
    "\11\117\1\0\64\117\1\0\1\120\113\0\1\323\64\0"+
    "\1\123\2\0\75\123\101\0\1\324\1\0\1\130\105\0"+
    "\1\135\1\0\1\136\36\0\2\135\36\0\1\325\2\0"+
    "\1\326\1\0\1\326\33\0\2\325\34\0\3\16\1\0"+
    "\1\327\4\0\5\16\2\0\3\16\1\0\2\16\1\330"+
    "\1\331\15\16\22\0\4\16\1\331\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\5\16\1\332"+
    "\13\16\22\0\1\332\4\16\5\0\3\16\1\0\1\16"+
    "\4\0\1\16\1\333\3\16\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\1\334\2\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\2\16\1\335\1\16\1\336"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\1\0\1\145"+
    "\1\337\1\340\76\145\4\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\10\16\1\341\10\16\22\0"+
    "\3\16\1\341\1\16\5\0\3\16\1\0\1\16\3\0"+
    "\1\342\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\10\16\1\343\10\16\22\0\3\16\1\343\1\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\1\344\20\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\1\16\1\345"+
    "\17\16\22\0\2\16\1\345\2\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\1\346\1\16\1\347\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\350\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\1\16\1\351"+
    "\3\16\2\0\2\16\1\352\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\3\0\1\353\5\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\2\16\1\354"+
    "\16\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\1\355\2\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\3\16\1\356\15\16\22\0\4\16\1\356\5\0"+
    "\3\16\1\0\1\16\4\0\1\16\1\357\3\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\3\0\1\360\5\16\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\1\16\1\361\7\16\1\362\7\16"+
    "\22\0\2\16\1\361\2\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\363\15\16"+
    "\22\0\4\16\1\363\5\0\3\16\1\0\1\16\4\0"+
    "\1\16\1\364\3\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\3\0\1\365\5\16"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\366\4\0\5\16\2\0\3\16\1\0\2\16"+
    "\1\367\16\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\2\16\1\370\16\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\2\16"+
    "\1\371\2\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\2\16"+
    "\1\372\1\0\21\16\22\0\5\16\60\0\1\373\47\0"+
    "\1\374\77\0\1\375\57\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\3\16\1\376\4\16\1\377"+
    "\10\16\22\0\3\16\1\377\1\376\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\10\16\1\u0100"+
    "\10\16\22\0\3\16\1\u0100\1\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\4\16\1\u0101"+
    "\14\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\2\16\1\u0102\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\1\16\1\u0103\17\16\22\0\2\16\1\u0103\2\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\4\16\1\u0104\3\16\1\u0105\10\16\22\0\3\16"+
    "\1\u0105\1\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\1\u0106\20\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\5\16\1\u0107\10\16\1\u0108\2\16\22\0\1\u0107\4\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\1\u0109"+
    "\2\16\1\0\1\16\1\u010a\3\16\1\u010b\13\16\22\0"+
    "\1\u010b\1\16\1\u010a\2\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u010c\15\16"+
    "\22\0\4\16\1\u010c\5\0\3\16\1\0\1\u010d\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\14\16\1\u010e\4\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\u010f\4\0\5\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\1\u0110\4\16"+
    "\2\0\3\16\1\0\15\16\1\u0111\3\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\3\16\1\u0112\1\16"+
    "\2\0\2\16\1\u0113\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\1\16\1\u0114\3\16\2\0"+
    "\3\16\1\0\3\16\1\u0115\15\16\22\0\4\16\1\u0115"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\7\16\1\u0116\11\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\4\16"+
    "\1\u0117\14\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\1\u0118\2\16\1\0\1\u0119\2\16"+
    "\1\u011a\3\16\1\u011b\11\16\22\0\4\16\1\u011a\5\0"+
    "\3\16\1\0\1\16\4\0\3\16\1\u011c\1\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\7\16\1\u011d"+
    "\11\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\4\16\1\u011e\2\0\3\16\1\0\4\16\1\u011f\1\16"+
    "\1\u0120\12\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\2\16\1\u0121\5\16"+
    "\1\u0122\10\16\22\0\3\16\1\u0122\1\16\5\0\3\16"+
    "\1\0\1\16\4\0\2\16\1\u0123\2\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\2\16\1\u0124\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\2\16\1\u0125"+
    "\2\16\2\0\3\16\1\0\6\16\1\u0126\12\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\1\u0127\2\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\1\u0128"+
    "\20\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\u0129\20\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\1\16\1\u012a\10\16\1\u012b\6\16\22\0\2\16"+
    "\1\u012a\2\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\1\16\1\u012c\5\16\1\u012d\11\16"+
    "\22\0\2\16\1\u012c\2\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\1\u012e\2\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\1\16\1\u012f"+
    "\3\16\2\0\1\u0130\2\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u0131\4\0\5\16\2\0\3\16"+
    "\1\0\1\u0132\1\16\1\u0133\16\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\1\16\1\u0134\3\16\2\0"+
    "\2\16\1\u0135\1\0\3\16\1\u0136\3\16\1\u0137\3\16"+
    "\1\u0138\5\16\22\0\1\16\1\u0138\2\16\1\u0136\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\1\16\1\u0139\17\16\22\0\2\16\1\u0139\2\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\3\16\1\u013a\15\16\22\0\4\16\1\u013a\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\3\16"+
    "\1\u013b\15\16\22\0\4\16\1\u013b\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\1\u013c\20\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\1\16\1\u013d\17\16\22\0\2\16"+
    "\1\u013d\2\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\1\u013e\20\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\10\16\1\u013f\10\16\22\0\3\16\1\u013f\1\16\5\0"+
    "\3\16\1\0\1\u0140\4\0\5\16\2\0\3\16\1\0"+
    "\10\16\1\u0141\10\16\22\0\3\16\1\u0141\1\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\2\16\1\u0142"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\u0143"+
    "\4\0\5\16\2\0\3\16\1\0\1\u0144\20\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\1\u0145\4\16"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\2\16\1\u0146\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\16\1\u0147\17\16\22\0"+
    "\2\16\1\u0147\2\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\3\16\1\u0148\15\16\22\0"+
    "\4\16\1\u0148\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\4\16\1\u0149\14\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u014a\4\0\5\16\2\0\3\16"+
    "\1\0\2\16\1\u014b\16\16\22\0\5\16\60\0\1\u014c"+
    "\100\0\1\u014d\21\0\1\322\1\110\1\u014e\76\322\6\0"+
    "\1\325\40\0\2\325\34\0\3\16\1\0\1\16\4\0"+
    "\1\16\1\u014f\3\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\3\16\1\u0150\15\16\22\0\4\16\1\u0150"+
    "\5\0\3\16\1\0\1\u0151\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\u0152"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\4\16\1\u0153\14\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\u0154\4\0\5\16\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\3\16"+
    "\1\u0155\1\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\2\0\1\337\103\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\21\16\6\0\1\u0156\13\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\10\16\1\u0157\10\16\22\0\3\16\1\u0157\1\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\1\u0158"+
    "\2\16\1\0\5\16\1\u0159\13\16\22\0\1\u0159\4\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\1\u015a"+
    "\2\16\1\0\3\16\1\u015b\5\16\1\u015c\7\16\22\0"+
    "\4\16\1\u015b\5\0\3\16\1\0\1\u015d\4\0\5\16"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\2\16\1\u015e\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\10\16\1\u015f\10\16\22\0"+
    "\3\16\1\u015f\1\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\2\16\1\u0160\5\16\1\u0161"+
    "\10\16\22\0\3\16\1\u0161\1\16\5\0\3\16\1\0"+
    "\1\u0162\4\0\5\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\1\16\1\u0163"+
    "\3\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\7\16\1\u0164\11\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\u0165\4\0\5\16\2\0\3\16\1\0\4\16\1\u0166"+
    "\14\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\14\16\1\u0167\4\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u0168\4\0\5\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\u0169\4\0\5\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\1\16\1\u016a"+
    "\3\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\14\16\1\u016b\4\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\1\16\1\u016c"+
    "\17\16\22\0\2\16\1\u016c\2\16\5\0\3\16\1\0"+
    "\1\16\4\0\1\16\1\u016d\3\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\u016e\14\16\22\0"+
    "\5\16\33\0\1\u016f\74\0\1\u0170\56\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\11\16\1\u0171"+
    "\7\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\u0172\20\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\2\16"+
    "\1\u0173\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\1\16\1\u0174"+
    "\17\16\22\0\2\16\1\u0174\2\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\12\16\1\u0175"+
    "\6\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\1\16\1\u0176\3\16\2\0\3\16\1\0\3\16\1\u0177"+
    "\15\16\22\0\4\16\1\u0177\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\2\16\1\u0178\16\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\15\16\1\u0179\3\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\10\16\1\u017a\10\16\22\0\3\16\1\u017a\1\16"+
    "\5\0\3\16\1\0\1\u017b\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u017c\15\16"+
    "\22\0\4\16\1\u017c\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\12\16\1\u017d\6\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u017e\4\0\5\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\1\u017f\4\16\2\0\3\16\1\0\11\16"+
    "\1\u0180\7\16\22\0\5\16\5\0\3\16\1\0\1\u0181"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\1\16\1\u0182\17\16\22\0\2\16\1\u0182\2\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\3\16\1\u0183\15\16\22\0\4\16\1\u0183\5\0"+
    "\3\16\1\0\1\16\4\0\1\16\1\u0184\3\16\2\0"+
    "\3\16\1\0\5\16\1\u0185\13\16\22\0\1\u0185\4\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\2\16"+
    "\1\u0186\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\4\16\1\u0187\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\2\16\1\u0188\1\0\1\u0189\20\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u018a\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\4\16\1\u018b\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u018c\4\0\5\16\2\0"+
    "\3\16\1\0\1\u018d\20\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\4\16"+
    "\1\u018e\14\16\22\0\5\16\5\0\3\16\1\0\1\u018f"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u0190\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\u012e"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\1\16\1\u0191\17\16\22\0\2\16\1\u0191\2\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\1\u0192"+
    "\2\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\1\u0193\20\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\1\u0194\20\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\5\16\1\u0195\13\16\22\0\1\u0195\4\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\2\16\1\u0196\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\2\16\1\u0197\2\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\2\16\1\u0198\16\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\4\16\1\u0199\14\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\1\u019a\20\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\13\16\1\u019b\2\16\1\u019c\2\16"+
    "\22\0\1\16\1\u019b\3\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\1\u019d\2\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\7\16\1\u019e\1\16\1\u019f\7\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\12\16\1\u01a0\6\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\1\16\1\u01a1\7\16\1\u01a2\7\16\22\0\2\16\1\u01a1"+
    "\2\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\1\u01a3\20\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\4\16"+
    "\1\u01a4\14\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\4\16\1\u01a5\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\2\16\1\u01a6\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\4\16\1\u01a7\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\u01a8\20\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\4\16\1\u01a9\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\1\16\1\u01aa\3\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\u01ab\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u01ac\4\0\3\16\1\u01ad"+
    "\1\u01ae\2\0\3\16\1\0\15\16\1\u01af\3\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\2\16\1\u01b0\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\1\u01b1\2\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\1\u01b2\2\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u01b3\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\3\16\1\u01b4\1\16\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\2\16"+
    "\1\u01b5\2\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\2\16\1\u01b6\2\16"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\14\16"+
    "\1\u01b7\4\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\7\16\1\u01b8\11\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\1\16\1\u01b9\6\16\1\u01ba\10\16"+
    "\22\0\2\16\1\u01b9\1\u01ba\1\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\2\16\1\u01bb\1\0\21\16"+
    "\22\0\5\16\2\0\1\110\103\0\3\16\1\0\1\16"+
    "\4\0\4\16\1\u01bc\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\1\16\1\u01bd\6\16\1\u01be\10\16\22\0"+
    "\2\16\1\u01bd\1\u01be\1\16\5\0\3\16\1\0\1\16"+
    "\4\0\2\16\1\u01bf\2\16\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\7\16\1\u01c0\11\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u01c1\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\u01c2"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u01c3\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u01c4\15\16"+
    "\22\0\4\16\1\u01c4\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\2\16\1\u01c5\16\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u01c6\4\0\5\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\3\16\1\u01c7\1\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\u01c8\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\3\16\1\u01c9\6\16\1\u01ca\6\16\22\0\4\16\1\u01c9"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\4\16\1\u01cb\14\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\2\16\1\u01cc\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\2\16\1\u01cd\1\u01ce\15\16"+
    "\22\0\4\16\1\u01ce\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\u01cf\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\6\16\1\u01d0\12\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\14\16\1\u01d1\4\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\4\16\1\u01d2"+
    "\14\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\12\16\1\u01d3\6\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\1\u01d4\20\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\3\16"+
    "\1\u01d5\15\16\22\0\4\16\1\u01d5\2\0\3\u016f\23\0"+
    "\1\u01d6\52\0\3\u01d7\12\0\1\u01d8\10\0\1\u01d9\55\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\2\16\1\u01da\16\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\2\16\1\u01db\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\2\16\1\u01dc\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\4\16\1\u01dd\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\2\16\1\u01de\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\16\16\1\u01df\2\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\2\16\1\u01e0\16\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\1\16\1\u01e1"+
    "\17\16\22\0\2\16\1\u01e1\2\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\4\16\1\u01e2"+
    "\14\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\4\16\1\u01e3\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\2\16"+
    "\1\u01e4\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\1\16\1\u01e5\3\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\u01e6\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\10\16\1\u01e7\10\16\22\0\3\16\1\u01e7\1\16\5\0"+
    "\3\16\1\0\1\16\4\0\4\16\1\u01e8\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\u01e9"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\10\16\1\u01ea\10\16\22\0\3\16\1\u01ea\1\16"+
    "\5\0\3\16\1\0\1\u01eb\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\10\16\1\u01ec\10\16"+
    "\22\0\3\16\1\u01ec\1\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\10\16\1\u01ed\10\16"+
    "\22\0\3\16\1\u01ed\1\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u01ee\15\16"+
    "\22\0\4\16\1\u01ee\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\10\16\1\u01ef\10\16\22\0"+
    "\3\16\1\u01ef\1\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\10\16\1\u01f0\10\16\22\0"+
    "\3\16\1\u01f0\1\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\1\u01f1\2\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\1\u01f2"+
    "\2\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\15\16\1\u01f3"+
    "\3\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\2\16\1\u01f4\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u01f5\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\1\16\1\u01f6\17\16"+
    "\22\0\2\16\1\u01f6\2\16\5\0\3\16\1\0\1\16"+
    "\4\0\3\16\1\u01f7\1\16\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\1\u01f8\2\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\4\16\1\u01f9\14\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\2\16\1\u01fa"+
    "\16\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\u01fb\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\2\16\1\u01fc\16\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\10\16\1\u01fd\10\16\22\0\3\16\1\u01fd\1\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\3\16\1\u01fe\15\16\22\0\4\16\1\u01fe\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\4\16"+
    "\1\u01ff\14\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\10\16\1\u0200\10\16"+
    "\22\0\3\16\1\u0200\1\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u0201\15\16"+
    "\22\0\4\16\1\u0201\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\10\16\1\u0202\10\16\22\0"+
    "\3\16\1\u0202\1\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\u0203\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\1\16\1\u0204\17\16\22\0\2\16\1\u0204"+
    "\2\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\7\16\1\u0205\11\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\3\16\1\u0206\15\16\22\0\4\16\1\u0206\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\3\16"+
    "\1\u0207\15\16\22\0\4\16\1\u0207\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\4\16\1\u0208"+
    "\14\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\12\16\1\u0209\6\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\7\16\1\u020a\11\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\4\16\1\u020b\14\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\2\16\1\u020c\2\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\3\16\1\u020d\15\16\22\0"+
    "\4\16\1\u020d\5\0\3\16\1\0\1\u020e\4\0\5\16"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\1\u020f\2\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\2\16\1\u0210\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\11\16\1\u0211\7\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\u0212\4\0\5\16\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\u0213\4\0\5\16"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\3\16"+
    "\1\u0214\15\16\22\0\4\16\1\u0214\5\0\3\16\1\0"+
    "\1\16\4\0\2\16\1\u0215\2\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\16\1\u0216\17\16\22\0"+
    "\2\16\1\u0216\2\16\5\0\3\16\1\0\1\u0217\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\10\16\1\u0218\10\16\22\0\3\16\1\u0218\1\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\1\16\1\u0219\17\16\22\0\2\16\1\u0219\2\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\10\16\1\u021a\10\16\22\0\3\16\1\u021a\1\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\1\16\1\u021b\17\16\22\0\2\16\1\u021b\2\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\10\16\1\u021c\10\16\22\0\3\16\1\u021c\1\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\4\16\1\u021d\14\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\3\16\1\u021e\1\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\u021f\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\4\16\1\u0220\14\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\2\16\1\u0221\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\4\16\1\u0222\14\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\3\16\1\u0223\15\16\22\0\4\16\1\u0223\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\4\16\1\u0224\14\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\10\16\1\u0225"+
    "\10\16\22\0\3\16\1\u0225\1\16\5\0\3\16\1\0"+
    "\1\u0226\4\0\5\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\10\16\1\u0227\10\16\22\0\3\16\1\u0227"+
    "\1\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\7\16\1\u0228\6\16\1\u0229\2\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\2\16\1\u022a"+
    "\2\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\u022b\4\0\5\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\2\0\3\u01d7\23\0\1\u01d9\101\0"+
    "\1\u022c\54\0\3\16\1\0\1\16\4\0\1\16\1\u022d"+
    "\3\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\2\16\1\u022e"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\2\16\1\u022f\10\16"+
    "\1\u0230\5\16\22\0\1\16\1\u0230\3\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\2\16\1\u0231\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\u0232\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\1\16\1\u0233\3\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\12\16\1\u0234"+
    "\6\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\10\16\1\u0235\10\16\22\0"+
    "\3\16\1\u0235\1\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\u0236\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u0237\4\0\5\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\1\16\1\u0238"+
    "\17\16\22\0\2\16\1\u0238\2\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\15\16\1\u0239"+
    "\3\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\2\16\1\u023a\16\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\10\16\1\u023b\10\16\22\0\3\16\1\u023b"+
    "\1\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\1\u023c\2\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\3\16\1\u023d\1\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u023e\15\16"+
    "\22\0\4\16\1\u023e\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\3\16\1\u023f\15\16\22\0"+
    "\4\16\1\u023f\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\11\16\1\u0240\1\16\1\u0241\5\16"+
    "\22\0\1\16\1\u0241\3\16\5\0\3\16\1\0\1\u0242"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\3\16\1\u0243\15\16\22\0\4\16\1\u0243\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\4\16\1\u0244\6\16\1\u0245\5\16\22\0\1\16\1\u0245"+
    "\3\16\5\0\3\16\1\0\1\16\4\0\4\16\1\u0246"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\4\16"+
    "\1\u0247\14\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u0248\15\16"+
    "\22\0\4\16\1\u0248\5\0\3\16\1\0\1\u0249\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\2\16\1\u024a\16\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\12\16\1\u024b"+
    "\6\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\16\1\u024c\17\16\22\0"+
    "\2\16\1\u024c\2\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\10\16\1\u024d\10\16\22\0"+
    "\3\16\1\u024d\1\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\u024e\20\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\4\16\1\u024f\14\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\3\16"+
    "\1\u0250\15\16\22\0\4\16\1\u0250\5\0\3\16\1\0"+
    "\1\16\4\0\2\16\1\u0251\2\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\2\16\1\u0252\16\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\1\16\1\u0253\17\16\22\0\2\16\1\u0253"+
    "\2\16\5\0\3\16\1\0\1\16\4\0\1\16\1\u0254"+
    "\3\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\2\16\1\u0255\16\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\2\16\1\u0256"+
    "\16\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\1\16\1\u0257\3\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\10\16\1\u0258\10\16\22\0\3\16\1\u0258"+
    "\1\16\5\0\3\16\1\0\1\16\4\0\2\16\1\u0259"+
    "\2\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\10\16\1\u025a\10\16\22\0\3\16\1\u025a\1\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\1\16\1\u025b"+
    "\1\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\u025c\4\0\5\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\17\16\1\u025d\1\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\u025e\4\0\5\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\1\u025f\2\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\4\16\1\u0260\14\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\4\16"+
    "\1\u0261\14\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u0262\15\16"+
    "\22\0\4\16\1\u0262\5\0\3\16\1\0\1\16\4\0"+
    "\4\16\1\u0263\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\4\16\1\u0264\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\1\u0265\2\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\2\16\1\u0266\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\u0267\4\0\5\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\3\16\1\u0268\15\16\22\0"+
    "\4\16\1\u0268\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\2\16\1\u0269\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\6\16\1\u026a\12\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\u026b\4\0\5\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\5\16\1\u026c\13\16\22\0\1\u026c\4\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\1\u026d"+
    "\2\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\1\16\1\u026e\3\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\u026f\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\u0270\4\0\5\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\32\0\1\u0271\43\0\1\u0271\7\0"+
    "\3\16\1\0\1\u0272\4\0\5\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\16\1\u0273\17\16\22\0"+
    "\2\16\1\u0273\2\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\2\16\1\u0274\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\2\16"+
    "\1\u0275\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\10\16\1\u0276"+
    "\10\16\22\0\3\16\1\u0276\1\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\6\16\1\u0277"+
    "\12\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\12\16\1\u0278\6\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\7\16\1\u0279\11\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\3\16\1\u027a\15\16\22\0\4\16\1\u027a\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\2\16"+
    "\1\u027b\16\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\1\u027c\20\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u027d\4\0\5\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\4\16\1\u027e"+
    "\14\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\u027f\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\1\16\1\u0280\17\16\22\0\2\16\1\u0280"+
    "\2\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\4\16\1\u0281\14\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\1\16\1\u0282\3\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\u0283\4\0\5\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\3\16\1\u0284\15\16\22\0\4\16\1\u0284"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\1\16\1\u0285\17\16\22\0\2\16\1\u0285\2\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\3\16\1\u0286\15\16\22\0\4\16\1\u0286\5\0"+
    "\3\16\1\0\1\u0287\4\0\5\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\12\16\1\u0288\6\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u0289\4\0\5\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\4\16\1\u028a\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\3\16"+
    "\1\u028b\1\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u028c\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\11\16\1\u028d\7\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\1\u028e\2\16\1\0\2\16\1\u028f\16\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u0290\4\0\5\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\3\16\1\u0291"+
    "\15\16\22\0\4\16\1\u0291\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\1\u0292\20\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\14\16\1\u0293\4\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\1\u0294\20\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\4\16\1\u0295\14\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\2\16"+
    "\1\u0296\2\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\2\16"+
    "\1\u0297\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\10\16\1\u0298"+
    "\10\16\22\0\3\16\1\u0298\1\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\20\16\1\u0299"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\2\16\1\u029a\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\3\16\1\u029b\15\16\22\0\4\16\1\u029b\5\0\3\16"+
    "\1\0\1\16\4\0\1\16\1\u029c\3\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\u029d"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\u029e\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\1\16\1\u029f\17\16"+
    "\22\0\2\16\1\u029f\2\16\5\0\3\16\1\0\1\u02a0"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\3\16\1\u02a1\1\16"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\2\16\1\u02a2\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\5\16\1\u02a3\13\16\22\0"+
    "\1\u02a3\4\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\6\16\1\u02a4\12\16\22\0\5\16"+
    "\20\0\1\u02a5\65\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\3\16\1\u02a6\15\16\22\0\4\16"+
    "\1\u02a6\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\1\u02a7\20\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\4\16"+
    "\1\u02a8\14\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\1\u02a9\20\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\u02aa\4\0\5\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\3\16\1\u02ab"+
    "\15\16\22\0\4\16\1\u02ab\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\1\u02ac\2\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\10\16\1\u02ad\10\16\22\0\3\16\1\u02ad"+
    "\1\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\1\16\1\u02ae\17\16\22\0\2\16\1\u02ae"+
    "\2\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\2\16\1\u02af\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\1\16\1\u02b0\3\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u02b1\15\16"+
    "\22\0\4\16\1\u02b1\5\0\3\16\1\0\1\16\4\0"+
    "\3\16\1\u02b2\1\16\2\0\3\16\1\0\21\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\3\16\1\u02b3\15\16\22\0\4\16\1\u02b3"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\10\16\1\u02b4\10\16\22\0\3\16\1\u02b4\1\16"+
    "\5\0\3\16\1\0\1\u02b5\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\2\16\1\u02b6\16\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\1\u02b7\2\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\u02b8\4\0\5\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\16\1\u02b9\17\16\22\0"+
    "\2\16\1\u02b9\2\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\16\1\u02ba\17\16\22\0"+
    "\2\16\1\u02ba\2\16\5\0\3\16\1\0\1\16\4\0"+
    "\4\16\1\u02bb\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\3\16\1\u02bc\15\16\22\0\4\16\1\u02bc\5\0"+
    "\3\16\1\0\1\16\4\0\1\16\1\u02bd\3\16\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\3\16\1\u02be"+
    "\15\16\22\0\4\16\1\u02be\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\2\16\1\u02bf\16\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\3\16\1\u02c0\15\16\22\0\4\16"+
    "\1\u02c0\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\3\16\1\u02c1\15\16\22\0\4\16\1\u02c1"+
    "\5\0\3\16\1\0\1\u02c2\4\0\5\16\2\0\3\16"+
    "\1\0\21\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\1\u02c3\2\16\1\0\21\16\22\0"+
    "\5\16\33\0\1\u02c4\52\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\4\16\1\u02c5\14\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\5\16\1\u02c6\13\16\22\0\1\u02c6\4\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\15\16\1\u02c7\3\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\5\16"+
    "\1\u02c8\13\16\22\0\1\u02c8\4\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\2\16\1\u02c9"+
    "\16\16\22\0\5\16\5\0\3\16\1\0\1\u02ca\4\0"+
    "\5\16\2\0\3\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\3\16\1\u02cb\15\16\22\0\4\16\1\u02cb\5\0\3\16"+
    "\1\0\1\u02cc\4\0\5\16\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\7\16\1\u02cd\11\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\2\16\1\u02ce\16\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\1\u02cf"+
    "\20\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\12\16\1\u02d0\6\16\22\0"+
    "\5\16\5\0\3\16\1\0\1\16\4\0\5\16\2\0"+
    "\3\16\1\0\7\16\1\u02d1\11\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\u02d2\4\0\5\16\2\0\3\16\1\0"+
    "\21\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\u02d3\20\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\6\16\1\u02d4\12\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\1\u02d5"+
    "\20\16\22\0\5\16\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\3\16\1\0\1\u02d6\20\16\22\0\5\16"+
    "\34\0\1\u02d7\43\0\1\u02d7\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\3\16\1\u02d8\15\16"+
    "\22\0\4\16\1\u02d8\5\0\3\16\1\0\1\16\4\0"+
    "\5\16\2\0\2\16\1\u02d9\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\4\16\1\u02da\2\0"+
    "\3\16\1\0\21\16\22\0\5\16\5\0\3\16\1\0"+
    "\1\16\4\0\5\16\2\0\3\16\1\0\1\u02db\20\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\1\u02dc\2\16\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\1\u02dd\20\16\22\0\5\16\5\0\3\16\1\0\1\16"+
    "\4\0\5\16\2\0\3\16\1\0\1\16\1\u02de\17\16"+
    "\22\0\2\16\1\u02de\2\16\5\0\3\16\1\0\1\16"+
    "\4\0\3\16\1\u02df\1\16\2\0\3\16\1\0\21\16"+
    "\22\0\5\16\5\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\3\16\1\0\7\16\1\u02e0\11\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\1\16\1\u02e1\17\16\22\0\2\16\1\u02e1\2\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\10\16\1\u02e2\10\16\22\0\3\16\1\u02e2\1\16"+
    "\33\0\1\u02e3\52\0\3\16\1\0\1\u02e4\4\0\5\16"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\1\16"+
    "\1\u02e5\17\16\22\0\2\16\1\u02e5\2\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\1\16"+
    "\1\u02e6\17\16\22\0\2\16\1\u02e6\2\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\1\16"+
    "\1\u02e7\17\16\22\0\2\16\1\u02e7\2\16\5\0\3\16"+
    "\1\0\1\16\4\0\5\16\2\0\3\16\1\0\7\16"+
    "\1\u02e8\11\16\22\0\5\16\5\0\3\16\1\0\1\u02e9"+
    "\4\0\5\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\31\0\1\u02ea\54\0\3\16\1\0\1\16\4\0\2\16"+
    "\1\u02eb\2\16\2\0\3\16\1\0\21\16\22\0\5\16"+
    "\5\0\3\16\1\0\1\16\4\0\5\16\2\0\3\16"+
    "\1\0\4\16\1\u02ec\14\16\22\0\5\16\32\0\1\u02ed"+
    "\43\0\1\u02ed\7\0\3\16\1\0\1\16\4\0\5\16"+
    "\2\0\2\16\1\u02ee\1\0\21\16\22\0\5\16\5\0"+
    "\3\16\1\0\1\16\4\0\5\16\2\0\3\16\1\0"+
    "\3\16\1\u02ef\15\16\22\0\4\16\1\u02ef\2\0\3\u02ed"+
    "\23\0\1\u02f0\55\0\3\16\1\0\1\u02f1\4\0\5\16"+
    "\2\0\3\16\1\0\21\16\22\0\5\16\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[35685];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\1\1\2\0\1\1\2\0\1\11\11\1\1\11"+
    "\11\1\1\11\15\1\2\11\1\1\2\11\10\1\4\11"+
    "\1\1\1\11\1\1\1\11\1\1\1\11\2\1\1\11"+
    "\1\1\1\11\3\1\3\11\1\1\1\11\4\1\4\11"+
    "\3\1\1\0\1\1\1\0\5\1\1\11\1\1\4\11"+
    "\1\1\1\11\7\1\1\11\5\1\1\11\12\1\1\11"+
    "\2\0\70\1\1\11\1\1\7\11\1\1\11\11\1\1"+
    "\2\11\1\1\1\0\10\1\1\11\2\1\1\11\10\1"+
    "\1\11\4\1\1\11\4\1\1\11\5\1\1\11\2\0"+
    "\116\1\2\11\10\1\1\11\30\1\2\0\145\1\1\11"+
    "\2\0\1\11\122\1\1\0\104\1\1\0\63\1\1\0"+
    "\36\1\1\0\22\1\1\0\13\1\1\0\6\1\1\0"+
    "\2\1\1\0\2\1\1\11\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[753];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	private Symbol symbol(int type) {
		return new Symbol(type, yychar, yychar + yylength());
	}
	
	private Symbol symbol(int type, int offset, int length) {
		return new Symbol(type, offset, offset + length);
	}	

	private Symbol symbol(int type, Object value) {
		return new Symbol(type, yychar, yychar + yylength(), value);
	}
	
	private Symbol symbol(int type, Object value, int offset, int length) {
		return new Symbol(type, offset, offset + length, value);
	}
	
	private Symbol sqlStatement() {
		rawString.append("}");
		if(openingBraceOffset != "#sql{".length()) {
			lexerErrors.add(new SyntaxError(2206, startOffset + "#sql".length(), startOffset + openingBraceOffset - 1, SyntaxError.WARNING)); 
		}
		return symbol(NodeTypes.SQLSTMTLIT, new InlineSQLStatement(rawString.toString(), openingBraceOffset, startOffset, startOffset+rawString.length()), startOffset, rawString.length());
	}
	
	private Symbol sqlCondition() {
		rawString.append("}");
		if(openingBraceOffset != "#sqlcondition{".length()) {
			lexerErrors.add(new SyntaxError(2207, startOffset + "#sqlcondition".length(), startOffset + openingBraceOffset - 1, SyntaxError.WARNING)); 
		}
		return symbol(NodeTypes.SQLCONDITION, new InlineSQLStatement(rawString.toString(), openingBraceOffset, startOffset, startOffset+rawString.length()), startOffset, rawString.length());
	}
	
	private Symbol dli() {
		rawString.append("}");
		if(openingBraceOffset != "#dli{".length()) {
			lexerErrors.add(new SyntaxError(2208, startOffset + "#dli".length(), startOffset + openingBraceOffset - 1, SyntaxError.WARNING)); 
		}
		return symbol(NodeTypes.INLINE_DLI, new InlineDLIStatement(rawString.toString(), openingBraceOffset, startOffset, startOffset+rawString.length()), startOffset, rawString.length());
	}
	
	private static final int LITERALTYPE_STRING		= 0;
	private static final int LITERALTYPE_HEX		= 1;
	private static final int LITERALTYPE_CHAR		= 2;
	private static final int LITERALTYPE_DBCHAR		= 3;
	private static final int LITERALTYPE_MBCHAR		= 4;
	private static final int LITERALTYPE_CHARHEX	= 5;
	private static final int LITERALTYPE_DBCHARHEX	= 6;
	private static final int LITERALTYPE_MBCHARHEX	= 7;
	private static final int LITERALTYPE_UNICODEHEX	= 8;
	
	private Symbol string() {
		switch(stringLiteralType) {
			case LITERALTYPE_STRING:	return symbol(NodeTypes.STRING, new StringLiteral(rawString.toString(), stringValue.toString(), false, startOffset, startOffset+rawString.length()), startOffset, rawString.length());
			case LITERALTYPE_HEX:		return symbol(NodeTypes.HEXLIT, new HexLiteral(rawString.toString(), stringValue.toString(), startOffset, startOffset+rawString.length()+1), startOffset, rawString.length()+1);
			case LITERALTYPE_CHAR:		return symbol(NodeTypes.CHARLIT, new CharLiteral(rawString.toString(), stringValue.toString(), false, startOffset, startOffset+rawString.length()+1), startOffset, rawString.length()+1);
			case LITERALTYPE_DBCHAR:	return symbol(NodeTypes.DBCHARLIT, new DBCharLiteral(rawString.toString(), stringValue.toString(), false, startOffset, startOffset+rawString.length()+1), startOffset, rawString.length()+1);
			case LITERALTYPE_MBCHAR:	return symbol(NodeTypes.MBCHARLIT, new MBCharLiteral(rawString.toString(), stringValue.toString(), false, startOffset, startOffset+rawString.length()+1), startOffset, rawString.length()+1);
			case LITERALTYPE_CHARHEX:	return symbol(NodeTypes.CHARLIT, new CharLiteral(rawString.toString(), stringValue.toString(), true, startOffset, startOffset+rawString.length()+2), startOffset, rawString.length()+2);
			case LITERALTYPE_DBCHARHEX:	return symbol(NodeTypes.DBCHARLIT, new DBCharLiteral(rawString.toString(), stringValue.toString(), true, startOffset, startOffset+rawString.length()+2), startOffset, rawString.length()+2);
			case LITERALTYPE_MBCHARHEX:	return symbol(NodeTypes.MBCHARLIT, new MBCharLiteral(rawString.toString(), stringValue.toString(), true, startOffset, startOffset+rawString.length()+2), startOffset, rawString.length()+2);
			case LITERALTYPE_UNICODEHEX:	return symbol(NodeTypes.STRING, new StringLiteral(rawString.toString(), stringValue.toString(), true, startOffset, startOffset+rawString.length()+2), startOffset, rawString.length()+2);
			default: throw new RuntimeException("Should not happen.");
		}
	}
	
	public List getLexerErrors() {
		return lexerErrors;
	}
	
	public void reset(Reader reader) {
		lexerErrors = new ArrayList();
		yyreset(reader);
	}
	protected int stringLiteralType;
	protected StringBuffer rawString = new StringBuffer();		// The raw string of delimited tokens (i.e. for string literals, including the ")
	protected StringBuffer stringValue = new StringBuffer();	// The canonical string of delimiated tokens (i.e. for string literals, excluding the ")
	protected int startOffset;									// The start offset of delimited tokens
	protected int openingBraceOffset;							// The offset of the opening brace for inline SQL and inline SQL Condition tokens
	
	protected boolean isSQLCondition;
	
	protected List lexerErrors = new ArrayList();
	
	protected boolean returnLineBreaks;
	protected boolean returnLineComments;
	protected boolean returnBlockComments;
	
	protected List lineBreaks = new ArrayList();
	protected List lineComments = new ArrayList();
	protected List blockComments = new ArrayList();


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Lexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1814) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 197: 
          { return symbol(NodeTypes.PROGRAM);
          }
        case 242: break;
        case 1: 
          { rawString.append(yytext());
          }
        case 243: break;
        case 169: 
          { return symbol(NodeTypes.CHARPRIMITIVE, Primitive.MBCHAR);
          }
        case 244: break;
        case 76: 
          { return symbol(NodeTypes.GE);
          }
        case 245: break;
        case 62: 
          { return symbol(NodeTypes.BOOLEANLIT, org.eclipse.edt.compiler.core.Boolean.NO);
          }
        case 246: break;
        case 58: 
          { return symbol(NodeTypes.TIMESTIMES);
          }
        case 247: break;
        case 236: 
          { return symbol(NodeTypes.ONEXCEPTION);
          }
        case 248: break;
        case 49: 
          { return symbol(NodeTypes.PLUSEQ);
          }
        case 249: break;
        case 216: 
          { return symbol(NodeTypes.ABSOLUTE);
          }
        case 250: break;
        case 10: 
          { return symbol(NodeTypes.MINUS);
          }
        case 251: break;
        case 141: 
          { return symbol(NodeTypes.GOTO);
          }
        case 252: break;
        case 202: 
          { return symbol(NodeTypes.FOREACH);
          }
        case 253: break;
        case 186: 
          { return symbol(NodeTypes.DLICALL);
          }
        case 254: break;
        case 213: 
          { return symbol(NodeTypes.TIMESTAMPINTERVALPRIMITIVE, null);
          }
        case 255: break;
        case 118: 
          { return symbol(NodeTypes.EXIT);
          }
        case 256: break;
        case 30: 
          { return symbol(NodeTypes.AT);
          }
        case 257: break;
        case 176: 
          { return symbol(NodeTypes.IMPORT);
          }
        case 258: break;
        case 75: 
          { return symbol(NodeTypes.LE);
          }
        case 259: break;
        case 132: 
          { return symbol(NodeTypes.NUMERICPRIMITIVE, Primitive.NUMC);
          }
        case 260: break;
        case 130: 
          { return symbol(NodeTypes.OPEN);
          }
        case 261: break;
        case 196: 
          { return symbol(NodeTypes.PREPARE);
          }
        case 262: break;
        case 97: 
          { return symbol(NodeTypes.URL);
          }
        case 263: break;
        case 89: 
          { return symbol(NodeTypes.FLOATLIT, yytext());
          }
        case 264: break;
        case 237: 
          { return symbol(NodeTypes.TRANSACTION);
          }
        case 265: break;
        case 224: 
          { return symbol(NodeTypes.OTHERWISE);
          }
        case 266: break;
        case 185: 
          { return symbol(NodeTypes.NUMERICPRIMITIVE, Primitive.DECIMAL);
          }
        case 267: break;
        case 60: 
          { return symbol(NodeTypes.OR);
          }
        case 268: break;
        case 163: 
          { return symbol(NodeTypes.FIRST);
          }
        case 269: break;
        case 126: 
          { return symbol(NodeTypes.MOVE);
          }
        case 270: break;
        case 227: 
          { return symbol(NodeTypes.RETURNING);
          }
        case 271: break;
        case 158: 
          { return symbol(NodeTypes.THROW);
          }
        case 272: break;
        case 115: 
          { return symbol(NodeTypes.CHARPRIMITIVE, Primitive.HEX);
          }
        case 273: break;
        case 105: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.INT);
          }
        case 274: break;
        case 82: 
          { rawString.append("\\f");		stringValue.append('\f');
          }
        case 275: break;
        case 165: 
          { return symbol(NodeTypes.WHILE);
          }
        case 276: break;
        case 110: 
          { return symbol(NodeTypes.NUMERICPRIMITIVE, Primitive.BIN);
          }
        case 277: break;
        case 113: 
          { return symbol(NodeTypes.GET);
          }
        case 278: break;
        case 78: 
          { return symbol(NodeTypes.MODULOEQ);
          }
        case 279: break;
        case 51: 
          { yybegin(BLOCK_COMMENT); startOffset = yychar;
          }
        case 280: break;
        case 7: 
          { return symbol(NodeTypes.DOT);
          }
        case 281: break;
        case 220: 
          { return symbol(NodeTypes.DECREMENT);
          }
        case 282: break;
        case 204: 
          { return symbol(NodeTypes.FREESQL);
          }
        case 283: break;
        case 144: 
          { return symbol(NodeTypes.HOLD);
          }
        case 284: break;
        case 128: 
          { return symbol(NodeTypes.LIKE);
          }
        case 285: break;
        case 112: 
          { return symbol(NodeTypes.REF);
          }
        case 286: break;
        case 95: 
          { yybegin(HEXSTRING); stringLiteralType = LITERALTYPE_UNICODEHEX; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 287: break;
        case 138: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.BLOB);
          }
        case 288: break;
        case 15: 
          { return symbol(NodeTypes.RPAREN);
          }
        case 289: break;
        case 219: 
          { return symbol(NodeTypes.FUNCTION);
          }
        case 290: break;
        case 61: 
          { return symbol(NodeTypes.OF);
          }
        case 291: break;
        case 50: 
          { Symbol symbol = symbol(NodeTypes.LINE_COMMENT); if(returnLineComments) lineComments.add(symbol); return symbol;
          }
        case 292: break;
        case 187: 
          { return symbol(NodeTypes.DISPLAY);
          }
        case 293: break;
        case 239: 
          { return symbol(NodeTypes.WITHV60COMPAT);
          }
        case 294: break;
        case 206: 
          { return symbol(NodeTypes.CONTINUE);
          }
        case 295: break;
        case 119: 
          { return symbol(NodeTypes.ELSE);
          }
        case 296: break;
        case 3: 
          { Symbol symbol = symbol(NodeTypes.LINEBREAKS); if(returnLineBreaks) lineBreaks.add(symbol); return symbol;
          }
        case 297: break;
        case 214: 
          { return symbol(NodeTypes.INPARENT);
          }
        case 298: break;
        case 45: 
          { yybegin(DLI); rawString.append(yytext());
          }
        case 299: break;
        case 168: 
          { return symbol(NodeTypes.CHARPRIMITIVE, Primitive.DBCHAR);
          }
        case 300: break;
        case 39: 
          { yybegin(SQL); rawString.append(yytext());
          }
        case 301: break;
        case 81: 
          { rawString.append("\\b");		stringValue.append('\b');
          }
        case 302: break;
        case 25: 
          { return symbol(NodeTypes.QUESTION);
          }
        case 303: break;
        case 5: 
          { return symbol(NodeTypes.ID, yytext());
          }
        case 304: break;
        case 86: 
          { yybegin(YYINITIAL); Symbol symbol = symbol(NodeTypes.BLOCK_COMMENT, startOffset, yychar + 2 - startOffset); if(returnBlockComments) blockComments.add(symbol); return symbol;
          }
        case 305: break;
        case 116: 
          { return symbol(NodeTypes.CONCATEQ);
          }
        case 306: break;
        case 104: 
          { return symbol(NodeTypes.ISA);
          }
        case 307: break;
        case 195: 
          { return symbol(NodeTypes.PASSING);
          }
        case 308: break;
        case 21: 
          { return symbol(NodeTypes.BITAND);
          }
        case 309: break;
        case 43: 
          { yybegin(YYINITIAL); return dli();
          }
        case 310: break;
        case 63: 
          { return symbol(NodeTypes.IS);
          }
        case 311: break;
        case 79: 
          { rawString.append("\\\"");		stringValue.append('\"');
          }
        case 312: break;
        case 92: 
          { yybegin(HEXSTRING); stringLiteralType = LITERALTYPE_CHARHEX; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 313: break;
        case 37: 
          { yybegin(YYINITIAL); return isSQLCondition ? sqlCondition() : sqlStatement();
          }
        case 314: break;
        case 28: 
          { return symbol(NodeTypes.RBRACKET);
          }
        case 315: break;
        case 200: 
          { return symbol(NodeTypes.REPLACE);
          }
        case 316: break;
        case 184: 
          { return symbol(NodeTypes.CURRENT);
          }
        case 317: break;
        case 183: 
          { return symbol(NodeTypes.EXTENDS);
          }
        case 318: break;
        case 124: 
          { return symbol(NodeTypes.CHARPRIMITIVE, Primitive.CHAR);
          }
        case 319: break;
        case 217: 
          { return symbol(NodeTypes.PREVIOUS);
          }
        case 320: break;
        case 103: 
          { return symbol(NodeTypes.NOT);
          }
        case 321: break;
        case 42: 
          { yybegin(DLI_DBL_QUOTED_ID); rawString.append('\"');
          }
        case 322: break;
        case 172: 
          { return symbol(NodeTypes.STATIC);
          }
        case 323: break;
        case 173: 
          { return symbol(NodeTypes.CHARPRIMITIVE, Primitive.STRING);
          }
        case 324: break;
        case 98: 
          { return symbol(NodeTypes.TIMESTIMESEQ);
          }
        case 325: break;
        case 100: 
          { return symbol(NodeTypes.OUT);
          }
        case 326: break;
        case 125: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.DATE);
          }
        case 327: break;
        case 87: 
          { rawString.append("\"\"");
          }
        case 328: break;
        case 181: 
          { return symbol(NodeTypes.RETURN);
          }
        case 329: break;
        case 111: 
          { return symbol(NodeTypes.BOOLEANLIT, org.eclipse.edt.compiler.core.Boolean.YES);
          }
        case 330: break;
        case 24: 
          { return symbol(NodeTypes.GT);
          }
        case 331: break;
        case 142: 
          { return symbol(NodeTypes.FORM);
          }
        case 332: break;
        case 188: 
          { return symbol(NodeTypes.MATCHES);
          }
        case 333: break;
        case 194: 
          { return symbol(NodeTypes.PACKAGE);
          }
        case 334: break;
        case 56: 
          { yybegin(STRING); stringLiteralType = LITERALTYPE_DBCHAR; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 335: break;
        case 47: 
          { yybegin(DLI); rawString.append('\"');
          }
        case 336: break;
        case 225: 
          { return symbol(NodeTypes.INTERFACE);
          }
        case 337: break;
        case 8: 
          { return symbol(NodeTypes.PLUS);
          }
        case 338: break;
        case 14: 
          { return symbol(NodeTypes.LPAREN);
          }
        case 339: break;
        case 70: 
          { return symbol(NodeTypes.CONCAT);
          }
        case 340: break;
        case 241: 
          { return symbol(NodeTypes.LANGUAGEBUNDLE);
          }
        case 341: break;
        case 147: 
          { return symbol(NodeTypes.WHEN);
          }
        case 342: break;
        case 162: 
          { return symbol(NodeTypes.FIELD);
          }
        case 343: break;
        case 149: 
          { return symbol(NodeTypes.CLOSE);
          }
        case 344: break;
        case 175: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.NUMBER);
          }
        case 345: break;
        case 108: 
          { return symbol(NodeTypes.ALL);
          }
        case 346: break;
        case 145: 
          { return symbol(NodeTypes.WITH);
          }
        case 347: break;
        case 31: 
          { rawString.append(yytext());	stringValue.append(yytext());
          }
        case 348: break;
        case 121: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.CLOB);
          }
        case 349: break;
        case 23: 
          { return symbol(NodeTypes.LT);
          }
        case 350: break;
        case 152: 
          { return symbol(NodeTypes.USING);
          }
        case 351: break;
        case 231: 
          { return symbol(NodeTypes.IMPLEMENTS);
          }
        case 352: break;
        case 71: 
          { return symbol(NodeTypes.EQ);
          }
        case 353: break;
        case 191: 
          { return symbol(NodeTypes.LIBRARY);
          }
        case 354: break;
        case 153: 
          { yybegin(DLI); rawString.setLength(0); rawString.append(yytext()); startOffset = yychar; openingBraceOffset = yylength();
          }
        case 355: break;
        case 46: 
          { yybegin(DLI); rawString.append('\'');
          }
        case 356: break;
        case 16: 
          { return symbol(NodeTypes.BANG);
          }
        case 357: break;
        case 40: 
          { yybegin(SQL); rawString.append('\"');
          }
        case 358: break;
        case 57: 
          { yybegin(STRING); stringLiteralType = LITERALTYPE_MBCHAR; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 359: break;
        case 53: 
          { return symbol(NodeTypes.MINUSEQ);
          }
        case 360: break;
        case 238: 
          { return symbol(NodeTypes.EXTERNALTYPE);
          }
        case 361: break;
        case 17: 
          { return symbol(NodeTypes.COMMA);
          }
        case 362: break;
        case 6: 
          { return symbol(NodeTypes.INTEGER, yytext());
          }
        case 363: break;
        case 18: 
          { return symbol(NodeTypes.SEMI);
          }
        case 364: break;
        case 156: 
          { return symbol(NodeTypes.LABEL);
          }
        case 365: break;
        case 174: 
          { return symbol(NodeTypes.OPENUI);
          }
        case 366: break;
        case 69: 
          { return symbol(NodeTypes.NE);
          }
        case 367: break;
        case 230: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.SMALLFLOAT);
          }
        case 368: break;
        case 201: 
          { return symbol(NodeTypes.RUNUNIT);
          }
        case 369: break;
        case 178: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.BIGINT);
          }
        case 370: break;
        case 129: 
          { return symbol(NodeTypes.LAST);
          }
        case 371: break;
        case 192: 
          { return symbol(NodeTypes.ONEVENT);
          }
        case 372: break;
        case 170: 
          { return symbol(NodeTypes.UPDATE);
          }
        case 373: break;
        case 91: 
          { return symbol(NodeTypes.XOR);
          }
        case 374: break;
        case 29: 
          { return symbol(NodeTypes.RCURLY);
          }
        case 375: break;
        case 52: 
          { return symbol(NodeTypes.DIVEQ);
          }
        case 376: break;
        case 210: 
          { return symbol(NodeTypes.USINGPCB);
          }
        case 377: break;
        case 140: 
          { return symbol(NodeTypes.NUMERICPRIMITIVE, Primitive.PACF);
          }
        case 378: break;
        case 166: 
          { return symbol(NodeTypes.ESCAPE);
          }
        case 379: break;
        case 48: 
          { return symbol(NodeTypes.DECIMALLIT, yytext());
          }
        case 380: break;
        case 41: 
          { yybegin(SQL); rawString.append('\'');
          }
        case 381: break;
        case 74: 
          { return symbol(NodeTypes.BITOREQ);
          }
        case 382: break;
        case 164: 
          { return symbol(NodeTypes.WHERE);
          }
        case 383: break;
        case 11: 
          { yybegin(STRING); stringLiteralType = LITERALTYPE_STRING; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 384: break;
        case 67: 
          { return symbol(NodeTypes.AS);
          }
        case 385: break;
        case 167: 
          { return symbol(NodeTypes.DELETE);
          }
        case 386: break;
        case 205: 
          { return symbol(NodeTypes.HANDLER);
          }
        case 387: break;
        case 207: 
          { return symbol(NodeTypes.CONVERSE);
          }
        case 388: break;
        case 19: 
          { return symbol(NodeTypes.COLON);
          }
        case 389: break;
        case 177: 
          { return symbol(NodeTypes.INSERT);
          }
        case 390: break;
        case 171: 
          { return symbol(NodeTypes.SCROLL);
          }
        case 391: break;
        case 155: 
          { return symbol(NodeTypes.STACK);
          }
        case 392: break;
        case 232: 
          { return symbol(NodeTypes.BYPOSITION);
          }
        case 393: break;
        case 114: 
          { return symbol(NodeTypes.FOR);
          }
        case 394: break;
        case 179: 
          { return symbol(NodeTypes.BYNAME);
          }
        case 395: break;
        case 36: 
          { yybegin(SQLDELIMITEDID); rawString.append('\"');
          }
        case 396: break;
        case 157: 
          { return symbol(NodeTypes.INOUT);
          }
        case 397: break;
        case 101: 
          { return symbol(NodeTypes.NEW);
          }
        case 398: break;
        case 88: 
          { rawString.append("\'\'");
          }
        case 399: break;
        case 154: 
          { yybegin(SQL); isSQLCondition = false; rawString.setLength(0); rawString.append(yytext()); startOffset = yychar; openingBraceOffset = yylength();
          }
        case 400: break;
        case 229: 
          { return symbol(NodeTypes.FORUPDATE);
          }
        case 401: break;
        case 12: 
          { return symbol(NodeTypes.TIMES);
          }
        case 402: break;
        case 20: 
          { return symbol(NodeTypes.ASSIGN);
          }
        case 403: break;
        case 159: 
          { return symbol(NodeTypes.PRINT);
          }
        case 404: break;
        case 160: 
          { return symbol(NodeTypes.GROUP);
          }
        case 405: break;
        case 26: 
          { return symbol(NodeTypes.MODULO);
          }
        case 406: break;
        case 33: 
          { yybegin(YYINITIAL); rawString.append('\"'); return string();
          }
        case 407: break;
        case 146: 
          { return symbol(NodeTypes.WRAP);
          }
        case 408: break;
        case 59: 
          { return symbol(NodeTypes.TIMESEQ);
          }
        case 409: break;
        case 135: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.TIME);
          }
        case 410: break;
        case 228: 
          { return symbol(NodeTypes.FORMGROUP);
          }
        case 411: break;
        case 66: 
          { return symbol(NodeTypes.TO);
          }
        case 412: break;
        case 218: 
          { return symbol(NodeTypes.RELATIVE);
          }
        case 413: break;
        case 68: 
          { return symbol(NodeTypes.BY);
          }
        case 414: break;
        case 139: 
          { return symbol(NodeTypes.BIND);
          }
        case 415: break;
        case 13: 
          { return symbol(NodeTypes.LCURLY);
          }
        case 416: break;
        case 77: 
          { return symbol(NodeTypes.NULLCONCAT);
          }
        case 417: break;
        case 123: 
          { return symbol(NodeTypes.CALL);
          }
        case 418: break;
        case 180: 
          { return symbol(NodeTypes.RECORD);
          }
        case 419: break;
        case 106: 
          { return symbol(NodeTypes.TRY);
          }
        case 420: break;
        case 182: 
          { return symbol(NodeTypes.EXECUTE);
          }
        case 421: break;
        case 34: 
          { rawString.append("\\");		stringValue.append('\\'); lexerErrors.add(new SyntaxError(2205, yychar, yychar+2));
          }
        case 422: break;
        case 209: 
          { return symbol(NodeTypes.DATAITEM);
          }
        case 423: break;
        case 234: 
          { return symbol(NodeTypes.CONSTRUCTOR);
          }
        case 424: break;
        case 148: 
          { return symbol(NodeTypes.EMBED);
          }
        case 425: break;
        case 99: 
          { return symbol(NodeTypes.SET);
          }
        case 426: break;
        case 80: 
          { rawString.append("\\\\");		stringValue.append('\\');
          }
        case 427: break;
        case 27: 
          { return symbol(NodeTypes.LBRACKET);
          }
        case 428: break;
        case 107: 
          { return symbol(NodeTypes.ADD);
          }
        case 429: break;
        case 2: 
          { return symbol(NodeTypes.error);
          }
        case 430: break;
        case 193: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.BOOLEAN);
          }
        case 431: break;
        case 93: 
          { yybegin(HEXSTRING); stringLiteralType = LITERALTYPE_DBCHARHEX; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 432: break;
        case 120: 
          { return symbol(NodeTypes.XOREQ);
          }
        case 433: break;
        case 208: 
          { return symbol(NodeTypes.DELEGATE);
          }
        case 434: break;
        case 85: 
          { rawString.append("\\t");		stringValue.append('\t');
          }
        case 435: break;
        case 161: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.FLOAT);
          }
        case 436: break;
        case 117: 
          { return symbol(NodeTypes.NULLCONCATEQ);
          }
        case 437: break;
        case 90: 
          { return symbol(NodeTypes.END);
          }
        case 438: break;
        case 136: 
          { return symbol(NodeTypes.TYPE);
          }
        case 439: break;
        case 22: 
          { return symbol(NodeTypes.BITOR);
          }
        case 440: break;
        case 240: 
          { yybegin(SQL); isSQLCondition = true;  rawString.setLength(0); rawString.append(yytext()); startOffset = yychar; openingBraceOffset = yylength();
          }
        case 441: break;
        case 122: 
          { return symbol(NodeTypes.CASE);
          }
        case 442: break;
        case 189: 
          { return symbol(NodeTypes.CHARPRIMITIVE, Primitive.UNICODE);
          }
        case 443: break;
        case 221: 
          { return symbol(NodeTypes.DATATABLE);
          }
        case 444: break;
        case 109: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.ANY);
          }
        case 445: break;
        case 134: 
          { return symbol(NodeTypes.INTO);
          }
        case 446: break;
        case 9: 
          { return symbol(NodeTypes.DIV);
          }
        case 447: break;
        case 150: 
          { return symbol(NodeTypes.CONST);
          }
        case 448: break;
        case 55: 
          { yybegin(STRING); stringLiteralType = LITERALTYPE_CHAR; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 449: break;
        case 64: 
          { return symbol(NodeTypes.IN);
          }
        case 450: break;
        case 44: 
          { yybegin(DLI_QUOTED_ID); rawString.append('\'');
          }
        case 451: break;
        case 223: 
          { return symbol(NodeTypes.SINGLEROW);
          }
        case 452: break;
        case 102: 
          { return symbol(NodeTypes.NUMERICPRIMITIVE, Primitive.NUM);
          }
        case 453: break;
        case 96: 
          { return symbol(NodeTypes.USE);
          }
        case 454: break;
        case 143: 
          { return symbol(NodeTypes.FROM);
          }
        case 455: break;
        case 32: 
          { yybegin(YYINITIAL); rawString.append(yytext()); lexerErrors.add(new SyntaxError(2200, startOffset, yychar)); return string();
          }
        case 456: break;
        case 226: 
          { return symbol(NodeTypes.TIMESTAMPINTERVALPRIMITIVE, Primitive.TIMESTAMP);
          }
        case 457: break;
        case 215: 
          { return symbol(NodeTypes.TRANSFER);
          }
        case 458: break;
        case 84: 
          { rawString.append("\\r");		stringValue.append('\r');
          }
        case 459: break;
        case 211: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.SMALLINT);
          }
        case 460: break;
        case 35: 
          { lexerErrors.add(new SyntaxError(2209, yychar, yychar+1));
          }
        case 461: break;
        case 65: 
          { return symbol(NodeTypes.IF);
          }
        case 462: break;
        case 151: 
          { return symbol(NodeTypes.NUMERICPRIMITIVE, Primitive.MONEY);
          }
        case 463: break;
        case 190: 
          { return symbol(NodeTypes.SERVICE);
          }
        case 464: break;
        case 73: 
          { return symbol(NodeTypes.AND);
          }
        case 465: break;
        case 94: 
          { yybegin(HEXSTRING); stringLiteralType = LITERALTYPE_MBCHARHEX; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 466: break;
        case 222: 
          { return symbol(NodeTypes.USINGKEYS);
          }
        case 467: break;
        case 198: 
          { return symbol(NodeTypes.PRIVATE);
          }
        case 468: break;
        case 83: 
          { rawString.append("\\n");		stringValue.append('\n');
          }
        case 469: break;
        case 133: 
          { return symbol(NodeTypes.NULL);
          }
        case 470: break;
        case 212: 
          { return symbol(NodeTypes.NOCURSOR);
          }
        case 471: break;
        case 54: 
          { yybegin(HEXSTRING); stringLiteralType = LITERALTYPE_HEX; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 472: break;
        case 137: 
          { return symbol(NodeTypes.THIS);
          }
        case 473: break;
        case 127: 
          { return symbol(NodeTypes.SHOW);
          }
        case 474: break;
        case 38: 
          { yybegin(SQLSTRING); rawString.append('\'');
          }
        case 475: break;
        case 72: 
          { return symbol(NodeTypes.BITANDEQ);
          }
        case 476: break;
        case 203: 
          { return symbol(NodeTypes.FORWARD);
          }
        case 477: break;
        case 235: 
          { return symbol(NodeTypes.SQLNULLABLE);
          }
        case 478: break;
        case 233: 
          { return symbol(NodeTypes.ENUMERATION);
          }
        case 479: break;
        case 199: 
          { return symbol(NodeTypes.RETURNS);
          }
        case 480: break;
        case 4: 
          { 
          }
        case 481: break;
        case 131: 
          { return symbol(NodeTypes.NEXT);
          }
        case 482: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case DLI: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(2204, startOffset, startOffset + openingBraceOffset)); return dli();
            }
            case 754: break;
            case DLI_QUOTED_ID: {
              yybegin(DLI);
            }
            case 755: break;
            case SQLDELIMITEDID: {
              yybegin(SQL);
            }
            case 756: break;
            case STRING: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(2200, startOffset, yychar)); return string();
            }
            case 757: break;
            case DLI_DBL_QUOTED_ID: {
              yybegin(DLI);
            }
            case 758: break;
            case SQL: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(isSQLCondition ? 2203 : 2202, startOffset, startOffset + openingBraceOffset)); return isSQLCondition ? sqlCondition() : sqlStatement();
            }
            case 759: break;
            case HEXSTRING: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(2200, startOffset, yychar)); return string();
            }
            case 760: break;
            case BLOCK_COMMENT: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(2201, startOffset, startOffset + 2)); Symbol symbol = symbol(NodeTypes.BLOCK_COMMENT, startOffset, yychar);  if(returnBlockComments) blockComments.add(symbol); return symbol;
            }
            case 761: break;
            case SQLSTRING: {
              yybegin(SQL);
            }
            case 762: break;
            default:
              { return new java_cup.runtime.Symbol(NodeTypes.EOF, yychar, yychar);
 }
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
