/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URISyntaxException;
import java.security.ProtectionDomain;
import org.eclipse.edt.debug.core.EDTDebugCoreMessages;
import org.eclipse.osgi.util.NLS;

public class SMAPTransformer
implements ClassFileTransformer {
    private File location;

    public SMAPTransformer(String location) {
        if (location != null && location.length() != 0) {
            this.location = new File(location);
        }
    }

    public byte[] transform(ClassLoader loader, String name, Class redefiningClass, ProtectionDomain domain, byte[] bytes) throws IllegalClassFormatException {
        return new TransformerWorker().transform(loader, name, redefiningClass, domain, bytes);
    }

    private class TransformerWorker {
        private String className;
        private int sourceDebugExtensionIndex;
        private byte[] debugInfoBytes;
        private byte[] inClassBytes;
        private int inClassOffset;
        private byte[] outClassBytes;
        private int outClassIndex;

        private TransformerWorker() {
        }

        byte[] transform(ClassLoader loader, String name, Class redefiningClass, ProtectionDomain domain, byte[] bytes) throws IllegalClassFormatException {
            this.className = name;
            this.inClassBytes = bytes;
            try {
                if (SMAPTransformer.this.location == null) {
                    try {
                        SMAPTransformer.this.location = new File(domain.getCodeSource().getLocation().toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        SMAPTransformer.this.location = new File(domain.getCodeSource().getLocation().getFile().replaceAll("%20", " "));
                    }
                }
                File inSmapFile = new File(SMAPTransformer.this.location, String.valueOf(this.className) + ".eglsmap");
                FileInputStream inputStream = new FileInputStream(inSmapFile);
                int length = (int)inSmapFile.length();
                this.debugInfoBytes = new byte[length];
                inputStream.read(this.debugInfoBytes, 0, length);
                inputStream.close();
            }
            catch (IOException iOException) {
                return null;
            }
            this.outClassBytes = new byte[bytes.length + this.debugInfoBytes.length + 100];
            if (this.updateClass()) {
                if (this.outClassIndex < this.outClassBytes.length) {
                    byte[] temp = new byte[this.outClassIndex];
                    System.arraycopy(this.outClassBytes, 0, temp, 0, this.outClassIndex);
                    return temp;
                }
                return this.outClassBytes;
            }
            return null;
        }

        private boolean updateClass() {
            this.copyBytes(8);
            int tagPosition = this.outClassIndex;
            int tagCount = this.readUnicode2();
            this.writeU2(tagCount);
            if (!this.copyTags(tagCount)) {
                return false;
            }
            if (this.sourceDebugExtensionIndex < 0) {
                this.writeUtf8ForSourceDebugExtension();
                this.sourceDebugExtensionIndex = tagCount++;
                this.randomAccessWriteU2(tagPosition, tagCount);
            }
            this.copyBytes(6);
            int interfaceCount = this.readUnicode2();
            this.writeU2(interfaceCount);
            this.copyBytes(interfaceCount * 2);
            this.copyMembers();
            this.copyMembers();
            int attrPosition = this.outClassIndex;
            int attrCount = this.readUnicode2();
            this.writeU2(attrCount);
            if (!this.copyAttrs(attrCount)) {
                this.randomAccessWriteU2(attrPosition, ++attrCount);
            }
            this.writeAttrForSourceDebugExtension(this.debugInfoBytes);
            return true;
        }

        private void copyMembers() {
            int count = this.readUnicode2();
            this.writeU2(count);
            int i = 0;
            while (i < count) {
                this.copyBytes(6);
                int attrCount = this.readUnicode2();
                this.writeU2(attrCount);
                this.copyAttrs(attrCount);
                ++i;
            }
        }

        private boolean copyAttrs(int attrCount) {
            boolean sourceDebugExtensionFound = false;
            int i = 0;
            while (i < attrCount) {
                int nameIndex = this.readUnicode2();
                if (nameIndex == this.sourceDebugExtensionIndex) {
                    sourceDebugExtensionFound = true;
                } else {
                    this.writeU2(nameIndex);
                    int length = this.readUnicode4();
                    this.writeU4(length);
                    this.copyBytes(length);
                }
                ++i;
            }
            return sourceDebugExtensionFound;
        }

        private void writeAttrForSourceDebugExtension(byte[] debugInfo) {
            this.writeU2(this.sourceDebugExtensionIndex);
            this.writeU4(debugInfo.length);
            int i = 0;
            while (i < debugInfo.length) {
                this.writeU1(debugInfo[i]);
                ++i;
            }
        }

        private void randomAccessWriteU2(int pos, int val) {
            int savePos = this.outClassIndex;
            this.outClassIndex = pos;
            this.writeU2(val);
            this.outClassIndex = savePos;
        }

        private int readUnicode1() {
            return this.inClassBytes[this.inClassOffset++] & 0xFF;
        }

        private int readUnicode2() {
            return (this.readUnicode1() << 8) + this.readUnicode1();
        }

        private int readUnicode4() {
            return (this.readUnicode2() << 16) + this.readUnicode2();
        }

        private void writeU1(int val) {
            this.outClassBytes[this.outClassIndex++] = (byte)val;
        }

        private void writeU2(int val) {
            this.writeU1(val >> 8);
            this.writeU1(val & 0xFF);
        }

        private void writeU4(int val) {
            this.writeU2(val >> 16);
            this.writeU2(val & 0xFFFF);
        }

        private void copyBytes(int count) {
            int i = 0;
            while (i < count) {
                this.outClassBytes[this.outClassIndex++] = this.inClassBytes[this.inClassOffset++];
                ++i;
            }
        }

        private byte[] readBytes(int count) {
            byte[] bytes = new byte[count];
            int i = 0;
            while (i < count) {
                bytes[i] = this.inClassBytes[this.inClassOffset++];
                ++i;
            }
            return bytes;
        }

        private void writeBytes(byte[] bytes) {
            int i = 0;
            while (i < bytes.length) {
                this.outClassBytes[this.outClassIndex++] = bytes[i];
                ++i;
            }
        }

        private boolean copyTags(int tagCount) {
            this.sourceDebugExtensionIndex = -1;
            int i = 1;
            while (i < tagCount) {
                int tag = this.readUnicode1();
                this.writeU1(tag);
                switch (tag) {
                    case 1: {
                        int length = this.readUnicode2();
                        this.writeU2(length);
                        byte[] utf8 = this.readBytes(length);
                        String str = null;
                        try {
                            str = new String(utf8, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            System.out.println(NLS.bind((String)EDTDebugCoreMessages.TransformerUnsupportedEncoding, (Object)this.className));
                            return false;
                        }
                        if (str.equals("SourceDebugExtension")) {
                            this.sourceDebugExtensionIndex = i;
                        }
                        this.writeBytes(utf8);
                        break;
                    }
                    case 3: {
                        this.copyBytes(4);
                        break;
                    }
                    case 4: {
                        this.copyBytes(4);
                        break;
                    }
                    case 5: {
                        this.copyBytes(8);
                        ++i;
                        break;
                    }
                    case 6: {
                        this.copyBytes(8);
                        ++i;
                        break;
                    }
                    case 7: {
                        this.copyBytes(2);
                        break;
                    }
                    case 8: {
                        this.copyBytes(2);
                        break;
                    }
                    case 9: {
                        this.copyBytes(4);
                        break;
                    }
                    case 10: {
                        this.copyBytes(4);
                        break;
                    }
                    case 11: {
                        this.copyBytes(4);
                        break;
                    }
                    case 12: {
                        this.copyBytes(4);
                        break;
                    }
                    default: {
                        System.out.println(NLS.bind((String)EDTDebugCoreMessages.TransformerUnknownTag, (Object)this.className));
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        private void writeUtf8ForSourceDebugExtension() {
            this.writeU1(1);
            this.writeU2("SourceDebugExtension".length());
            int i = 0;
            while (i < "SourceDebugExtension".length()) {
                this.writeU1("SourceDebugExtension".charAt(i));
                ++i;
            }
        }
    }
}

