/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.IEGLDebugTarget;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaThread;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaThread;

public class EGLJavaDebugTarget
extends EGLJavaDebugElement
implements IEGLDebugTarget,
IDebugEventFilter {
    private final IJavaDebugTarget javaTarget;
    private final Map<IJavaThread, EGLJavaThread> threads;
    private final List<EGLJavaThread> eglThreads;

    public EGLJavaDebugTarget(IJavaDebugTarget target) {
        super(null);
        this.javaTarget = target;
        this.threads = new HashMap<IJavaThread, EGLJavaThread>();
        this.eglThreads = new ArrayList<EGLJavaThread>();
        try {
            IThread[] threads = this.javaTarget.getThreads();
            int i = 0;
            while (i < threads.length) {
                if (threads[i] instanceof IJavaThread) {
                    this.getThread((IJavaThread)threads[i]);
                }
                ++i;
            }
        }
        catch (DebugException e) {
            EDTDebugCorePlugin.log(e);
        }
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.javaTarget.getLaunch();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IDebugTarget.class || adapter == EGLJavaDebugTarget.class || adapter == IEGLDebugTarget.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean canTerminate() {
        return this.javaTarget.canTerminate();
    }

    public boolean isTerminated() {
        return this.javaTarget.isTerminated();
    }

    public void terminate() throws DebugException {
        this.javaTarget.terminate();
    }

    public boolean canResume() {
        return this.javaTarget.canResume();
    }

    public boolean canSuspend() {
        return this.javaTarget.canSuspend();
    }

    public boolean isSuspended() {
        return this.javaTarget.isSuspended();
    }

    public void resume() throws DebugException {
        this.javaTarget.resume();
    }

    public void suspend() throws DebugException {
        this.javaTarget.suspend();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.javaTarget.breakpointAdded(breakpoint);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.javaTarget.breakpointRemoved(breakpoint, delta);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.javaTarget.breakpointChanged(breakpoint, delta);
    }

    public boolean canDisconnect() {
        return this.javaTarget.canDisconnect();
    }

    public void disconnect() throws DebugException {
        this.javaTarget.disconnect();
    }

    public boolean isDisconnected() {
        return this.javaTarget.isDisconnected();
    }

    public boolean supportsStorageRetrieval() {
        return this.javaTarget.supportsStorageRetrieval();
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return this.javaTarget.getMemoryBlock(startAddress, length);
    }

    public IProcess getProcess() {
        return this.javaTarget.getProcess();
    }

    public IThread[] getThreads() throws DebugException {
        return this.eglThreads.toArray(new EGLJavaThread[this.eglThreads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreads().length != 0;
    }

    public String getName() throws DebugException {
        return this.javaTarget.getName();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.javaTarget.supportsBreakpoint(breakpoint);
    }

    protected EGLJavaThread getThread(IJavaThread javaThread) {
        EGLJavaThread eglThread = this.threads.get(javaThread);
        if (eglThread == null) {
            eglThread = new EGLJavaThread(this, javaThread);
            this.threads.put(javaThread, eglThread);
            this.eglThreads.add(eglThread);
        }
        return eglThread;
    }

    EGLJavaThread removeThread(IJavaThread javaThread) {
        EGLJavaThread eglThread = this.threads.remove(javaThread);
        if (eglThread != null) {
            this.eglThreads.remove(eglThread);
            return eglThread;
        }
        return null;
    }

    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        if (events == null || events.length < 1) {
            return events;
        }
        Object src = events[0].getSource();
        if (!(src instanceof IDebugElement)) {
            return events;
        }
        if (((IDebugElement)src).getDebugTarget() != this.javaTarget) {
            return events;
        }
        ArrayList unfiltered = new ArrayList(events.length);
        HashMap<Object, List<DebugEvent>> groupedEvents = this.groupBySource(events);
        for (Map.Entry entry : groupedEvents.entrySet()) {
            EGLJavaThread eglThread;
            IJavaThread javaThread;
            src = entry.getKey();
            List srcEvents = (List)entry.getValue();
            if (src instanceof IDebugTarget) {
                this.handleDebugEvents(srcEvents.toArray(new DebugEvent[srcEvents.size()]));
                continue;
            }
            if (src instanceof IThread) {
                javaThread = (IJavaThread)((IThread)src).getAdapter(IJavaThread.class);
                if (javaThread != null) {
                    eglThread = this.getThread(javaThread);
                    eglThread.handleDebugEvents(srcEvents.toArray(new DebugEvent[srcEvents.size()]));
                    continue;
                }
                unfiltered.addAll(srcEvents);
                continue;
            }
            if (src instanceof IStackFrame) {
                javaThread = (IJavaThread)((IStackFrame)src).getThread().getAdapter(IJavaThread.class);
                if (javaThread != null) {
                    eglThread = this.getThread(javaThread);
                    eglThread.handleDebugEvents(srcEvents.toArray(new DebugEvent[srcEvents.size()]));
                    continue;
                }
                unfiltered.addAll(srcEvents);
                continue;
            }
            unfiltered.addAll(srcEvents);
        }
        return unfiltered.toArray(new DebugEvent[unfiltered.size()]);
    }

    @Override
    public void handleDebugEvents(DebugEvent[] events) {
        if (events == null || events.length == 0) {
            return;
        }
        if (events[0].getSource() == this.javaTarget) {
            if (events[0].getKind() == 8) {
                DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)this);
            }
            super.handleDebugEvents(events);
        }
    }

    public IJavaDebugTarget getJavaDebugTarget() {
        return this.javaTarget;
    }

    @Override
    public Object getJavaElement() {
        return this.getJavaDebugTarget();
    }
}

