/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaStackFrame;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.SMAPUtil;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class EGLJavaFunctionValue
extends EGLJavaDebugElement
implements IValue {
    private final EGLJavaStackFrame frame;
    private EGLJavaVariable[] eglVariables;
    private IVariable[] previousJavaVariables;

    public EGLJavaFunctionValue(EGLJavaStackFrame frame) {
        super(frame.getDebugTarget());
        this.frame = frame;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.frame.getSMAP().length() == 0) {
            return this.frame.getJavaStackFrame().getLocalVariables();
        }
        boolean recompute = true;
        IJavaVariable[] javaVariables = this.frame.getJavaStackFrame().getLocalVariables();
        if (this.previousJavaVariables != null && javaVariables.length == this.previousJavaVariables.length) {
            recompute = false;
            int i = 0;
            while (i < javaVariables.length) {
                if (javaVariables[i] != this.previousJavaVariables[i]) {
                    recompute = true;
                    break;
                }
                ++i;
            }
        }
        if (recompute) {
            List<EGLJavaVariable> newEGLVariables = SMAPUtil.filterAndWrapVariables((IVariable[])javaVariables, this.eglVariables, this.frame.getSMAPVariableInfos(), this.frame, this.frame.getEGLJavaDebugTarget(), false);
            this.previousJavaVariables = javaVariables;
            this.eglVariables = newEGLVariables.toArray(new EGLJavaVariable[newEGLVariables.size()]);
        }
        return this.eglVariables;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IVariable.class || adapter == EGLJavaVariable.class || adapter == IEGLVariable.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getReferenceTypeName() throws DebugException {
        return "";
    }

    public String getValueString() throws DebugException {
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    @Override
    public Object getJavaElement() {
        return this.frame;
    }
}

