/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLStackFrame;
import org.eclipse.edt.debug.core.IEGLThread;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaFunctionVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaThread;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.SMAPFunctionInfo;
import org.eclipse.edt.debug.internal.core.java.SMAPUtil;
import org.eclipse.edt.debug.internal.core.java.SMAPVariableInfo;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;

public class EGLJavaStackFrame
extends EGLJavaDebugElement
implements IEGLStackFrame,
IDropToFrame {
    private final IJavaStackFrame javaFrame;
    private final EGLJavaThread eglThread;
    private EGLJavaVariable[] eglVariables;
    private IVariable[] previousJavaVariables;
    private String smap;
    private SMAPVariableInfo[] smapVariableInfos;
    private SMAPFunctionInfo smapFunctionInfo;

    public EGLJavaStackFrame(IJavaStackFrame frame, EGLJavaThread thread) {
        super(thread.getDebugTarget());
        this.javaFrame = frame;
        this.eglThread = thread;
    }

    public boolean canStepInto() {
        return this.javaFrame.canStepInto();
    }

    public boolean canStepOver() {
        return this.javaFrame.canStepOver();
    }

    public boolean canStepReturn() {
        return this.javaFrame.canStepReturn();
    }

    public boolean isStepping() {
        return this.javaFrame.isStepping();
    }

    public void stepInto() throws DebugException {
        this.javaFrame.stepInto();
    }

    public void stepOver() throws DebugException {
        this.javaFrame.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.javaFrame.stepReturn();
    }

    public boolean canResume() {
        return this.javaFrame.canResume();
    }

    public boolean canSuspend() {
        return this.javaFrame.canSuspend();
    }

    public boolean isSuspended() {
        return this.javaFrame.isSuspended();
    }

    public void resume() throws DebugException {
        this.javaFrame.resume();
    }

    public void suspend() throws DebugException {
        this.javaFrame.suspend();
    }

    public boolean canTerminate() {
        return this.javaFrame.canTerminate();
    }

    public boolean isTerminated() {
        return this.javaFrame.isTerminated();
    }

    public void terminate() throws DebugException {
        this.javaFrame.terminate();
    }

    public IThread getThread() {
        return this.eglThread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.getSMAP().length() == 0) {
            return this.javaFrame.getVariables();
        }
        boolean recompute = true;
        IVariable[] javaVariables = this.javaFrame.getVariables();
        if (this.previousJavaVariables != null && javaVariables.length == this.previousJavaVariables.length) {
            recompute = false;
            int i = 0;
            while (i < javaVariables.length) {
                if (javaVariables[i] != this.previousJavaVariables[i]) {
                    recompute = true;
                    break;
                }
                ++i;
            }
        }
        if (recompute) {
            List<EGLJavaVariable> newEGLVariables = SMAPUtil.filterAndWrapVariables(javaVariables, this.eglVariables, this.getSMAPVariableInfos(), this, this.getEGLJavaDebugTarget(), true);
            this.previousJavaVariables = javaVariables;
            this.eglVariables = new EGLJavaVariable[newEGLVariables.size() + 1];
            newEGLVariables.toArray(this.eglVariables);
            this.eglVariables[this.eglVariables.length - 1] = new EGLJavaFunctionVariable(this);
        }
        return this.eglVariables;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length != 0;
    }

    public int getLineNumber() throws DebugException {
        return this.javaFrame.getLineNumber();
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.javaFrame.getName();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.javaFrame.getRegisterGroups();
    }

    public boolean hasRegisterGroups() throws DebugException {
        return this.javaFrame.hasRegisterGroups();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IStackFrame.class || adapter == EGLJavaStackFrame.class || adapter == IEGLStackFrame.class || adapter == IDropToFrame.class) {
            return this;
        }
        if (adapter == IThread.class || adapter == EGLJavaThread.class || adapter == IEGLThread.class) {
            return this.getThread();
        }
        if (adapter == IJavaStackFrame.class) {
            return this.javaFrame;
        }
        return super.getAdapter(adapter);
    }

    public IJavaStackFrame getJavaStackFrame() {
        return this.javaFrame;
    }

    @Override
    public Object getJavaElement() {
        return this.getJavaStackFrame();
    }

    public boolean canDropToFrame() {
        return this.javaFrame.canDropToFrame();
    }

    public void dropToFrame() throws DebugException {
        this.javaFrame.dropToFrame();
    }

    public String getSMAP() throws DebugException {
        if (this.smap == null) {
            this.smap = SMAPUtil.getSMAP((IJavaType)this.javaFrame.getReferenceType());
        }
        return this.smap;
    }

    public SMAPVariableInfo[] getSMAPVariableInfos() throws DebugException {
        if (this.smapVariableInfos == null) {
            this.smapVariableInfos = SMAPUtil.parseVariables(this.getSMAP(), this);
        }
        return this.smapVariableInfos;
    }

    public SMAPFunctionInfo getSMAPFunctionInfo() throws DebugException {
        return this.smapFunctionInfo;
    }

    public void setSMAPFunctionInfo(SMAPFunctionInfo info) {
        this.smapFunctionInfo = info;
    }
}

