/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.edt.debug.core.IEGLStackFrame;
import org.eclipse.edt.debug.core.IEGLThread;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;

public class EGLJavaThread
extends EGLJavaDebugElement
implements IEGLThread {
    private final IJavaThread javaThread;
    private EGLJavaStackFrame[] eglFrames;
    private IStackFrame[] previousJavaFrames;

    public EGLJavaThread(IDebugTarget target, IJavaThread thread) {
        super(target);
        this.javaThread = thread;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IThread.class || adapter == EGLJavaThread.class || adapter == IEGLThread.class) {
            return this;
        }
        if (adapter == IStackFrame.class || adapter == EGLJavaStackFrame.class || adapter == IEGLStackFrame.class) {
            try {
                return this.getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (adapter == IJavaThread.class) {
            return this.javaThread;
        }
        return super.getAdapter(adapter);
    }

    public boolean canResume() {
        return this.javaThread.canResume();
    }

    public boolean canSuspend() {
        return this.javaThread.canSuspend();
    }

    public boolean isSuspended() {
        return this.javaThread.isSuspended();
    }

    public void resume() throws DebugException {
        this.javaThread.resume();
    }

    public void suspend() throws DebugException {
        this.javaThread.suspend();
    }

    public boolean canStepInto() {
        return this.javaThread.canStepInto();
    }

    public boolean canStepOver() {
        return this.javaThread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.javaThread.canStepReturn();
    }

    public boolean isStepping() {
        return this.javaThread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.javaThread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.javaThread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.javaThread.stepReturn();
    }

    public boolean canTerminate() {
        return this.javaThread.canTerminate();
    }

    public boolean isTerminated() {
        return this.javaThread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.javaThread.terminate();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        boolean recompute = true;
        IStackFrame[] javaFrames = this.javaThread.getStackFrames();
        if (this.previousJavaFrames != null && javaFrames.length == this.previousJavaFrames.length) {
            recompute = false;
            int i = 0;
            while (i < javaFrames.length) {
                if (javaFrames[i] != this.previousJavaFrames[i]) {
                    recompute = true;
                    break;
                }
                ++i;
            }
        }
        if (recompute) {
            EGLJavaStackFrame[] newEGLFrames = new EGLJavaStackFrame[javaFrames.length];
            int i = 0;
            while (i < javaFrames.length) {
                if (this.eglFrames != null) {
                    int j = 0;
                    while (j < this.eglFrames.length) {
                        if (this.eglFrames[j].getJavaStackFrame() == javaFrames[i]) {
                            newEGLFrames[i] = this.eglFrames[j];
                            break;
                        }
                        ++j;
                    }
                }
                if (newEGLFrames[i] == null) {
                    newEGLFrames[i] = new EGLJavaStackFrame((IJavaStackFrame)javaFrames[i], this);
                }
                ++i;
            }
            this.previousJavaFrames = javaFrames;
            this.eglFrames = newEGLFrames;
        }
        return this.eglFrames;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.javaThread.hasStackFrames();
    }

    public int getPriority() throws DebugException {
        return this.javaThread.getPriority();
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return this.javaThread.getName();
    }

    public IBreakpoint[] getBreakpoints() {
        return this.javaThread.getBreakpoints();
    }

    @Override
    public void handleDebugEvents(DebugEvent[] events) {
        if (events == null || events.length == 0) {
            return;
        }
        Object src = events[0].getSource();
        if (src == this.javaThread) {
            int i = 0;
            while (i < events.length) {
                if (src instanceof IThread) {
                    switch (events[i].getKind()) {
                        case 4: {
                            this.fireCreationEvent();
                            break;
                        }
                        case 8: {
                            this.getEGLJavaDebugTarget().removeThread(this.javaThread);
                            this.fireTerminateEvent();
                            break;
                        }
                        default: {
                            super.handleDebugEvents(events);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public IJavaThread getJavaThread() {
        return this.javaThread;
    }

    @Override
    public Object getJavaElement() {
        return this.getJavaThread();
    }
}

