/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLValue;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.SMAPUtil;
import org.eclipse.edt.debug.internal.core.java.SMAPVariableInfo;
import org.eclipse.jdt.debug.core.IJavaValue;

public class EGLJavaValue
extends EGLJavaDebugElement
implements IEGLValue {
    private final IJavaValue javaValue;
    private final EGLJavaVariable parentVariable;
    private EGLJavaVariable[] eglVariables;
    private IVariable[] previousJavaVariables;
    private String smap;
    private SMAPVariableInfo[] smapVariableInfos;

    public EGLJavaValue(IDebugTarget target, IJavaValue value, EGLJavaVariable parent) {
        super(target);
        this.javaValue = value;
        this.parentVariable = parent;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IValue.class || adapter == EGLJavaValue.class || adapter == IEGLValue.class) {
            return this;
        }
        if (adapter == IJavaValue.class) {
            return this.javaValue;
        }
        return super.getAdapter(adapter);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.parentVariable.getReferenceTypeName();
    }

    public String getValueString() throws DebugException {
        return this.javaValue.getValueString();
    }

    public boolean isAllocated() throws DebugException {
        return this.javaValue.isAllocated();
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.getSMAP().length() == 0) {
            return this.javaValue.getVariables();
        }
        boolean recompute = true;
        IVariable[] javaVariables = this.javaValue.getVariables();
        if (this.previousJavaVariables != null && javaVariables.length == this.previousJavaVariables.length) {
            recompute = false;
            int i = 0;
            while (i < javaVariables.length) {
                if (javaVariables[i] != this.previousJavaVariables[i]) {
                    recompute = true;
                    break;
                }
                ++i;
            }
        }
        if (recompute) {
            List<EGLJavaVariable> newEGLVariables = SMAPUtil.filterAndWrapVariables(javaVariables, this.eglVariables, this.getSMAPVariableInfos(), null, this.getEGLJavaDebugTarget(), false);
            this.previousJavaVariables = javaVariables;
            this.eglVariables = newEGLVariables.toArray(new EGLJavaVariable[newEGLVariables.size()]);
        }
        return this.eglVariables;
    }

    public boolean hasVariables() throws DebugException {
        return this.javaValue.hasVariables() && this.getVariables().length != 0;
    }

    @Override
    public Object getJavaElement() {
        return this.getJavaValue();
    }

    public IJavaValue getJavaValue() {
        return this.javaValue;
    }

    public String getSMAP() throws DebugException {
        if (this.smap == null) {
            this.smap = SMAPUtil.getSMAP(this.javaValue.getJavaType());
        }
        return this.smap;
    }

    public SMAPVariableInfo[] getSMAPVariableInfos() throws DebugException {
        if (this.smapVariableInfos == null) {
            this.smapVariableInfos = SMAPUtil.parseVariables(this.getSMAP(), null);
        }
        return this.smapVariableInfos;
    }
}

