/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaValue;
import org.eclipse.edt.debug.internal.core.java.SMAPVariableInfo;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class EGLJavaVariable
extends EGLJavaDebugElement
implements IEGLVariable {
    protected final IJavaVariable javaVariable;
    protected EGLJavaValue value;
    protected final SMAPVariableInfo variableInfo;

    public EGLJavaVariable(IDebugTarget target, IJavaVariable javaVariable, SMAPVariableInfo variableInfo) {
        super(target);
        this.javaVariable = javaVariable;
        this.variableInfo = variableInfo;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IVariable.class || adapter == EGLJavaVariable.class || adapter == IEGLVariable.class) {
            return this;
        }
        if (adapter == IJavaVariable.class) {
            return this.javaVariable;
        }
        return super.getAdapter(adapter);
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public IValue getValue() throws DebugException {
        IValue javaValue = this.javaVariable.getValue();
        if (javaValue instanceof IJavaValue) {
            if (this.value == null || this.value.getJavaValue() != javaValue) {
                this.value = new EGLJavaValue(this.getDebugTarget(), (IJavaValue)javaValue, this);
            }
            return this.value;
        }
        return javaValue;
    }

    public String getName() throws DebugException {
        return this.variableInfo.eglName;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.variableInfo.type;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.javaVariable.hasValueChanged();
    }

    public IJavaVariable getJavaVariable() {
        return this.javaVariable;
    }

    @Override
    public Object getJavaElement() {
        return this.getJavaVariable();
    }
}

