/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugTarget;
import org.eclipse.edt.debug.internal.core.java.EGLJavaFunctionContainerVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaStackFrame;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.SMAPFunctionInfo;
import org.eclipse.edt.debug.internal.core.java.SMAPVariableInfo;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;

public class SMAPUtil {
    private static final SMAPVariableInfo[] EMPTY_VARIABLE_INFOS = new SMAPVariableInfo[0];

    private SMAPUtil() {
    }

    public static SMAPVariableInfo[] parseVariables(String smap, EGLJavaStackFrame frame) {
        if (smap == null || smap.trim().length() == 0) {
            return EMPTY_VARIABLE_INFOS;
        }
        ArrayList<SMAPVariableInfo> vars = new ArrayList<SMAPVariableInfo>();
        int idx = smap.indexOf("*E");
        if (idx != -1) {
            String variableSection = smap.substring(idx + 2).trim();
            StringTokenizer tok = new StringTokenizer(variableSection, "\n");
            String javaFrameSignature = null;
            if (frame != null) {
                try {
                    javaFrameSignature = String.valueOf(frame.getJavaStackFrame().getMethodName()) + ";" + frame.getJavaStackFrame().getSignature();
                }
                catch (DebugException debugException) {}
            }
            String currentFunction = null;
            while (tok.hasMoreTokens()) {
                int semicolon;
                String next = tok.nextToken().trim();
                int tokenLen = next.length();
                if (tokenLen == 0) continue;
                if ("*X".equals(next)) break;
                int pound = next.indexOf("#");
                if (pound == -1 || (semicolon = next.indexOf(";", pound)) == -1) continue;
                try {
                    if (tokenLen > semicolon + 2 && next.charAt(semicolon + 1) == 'F' && next.charAt(semicolon + 2) == ':') {
                        currentFunction = next.substring(semicolon + 3);
                        if (frame == null || currentFunction == null || !currentFunction.equals(javaFrameSignature)) continue;
                        frame.setSMAPFunctionInfo(new SMAPFunctionInfo(currentFunction, Integer.parseInt(next.substring(0, pound))));
                        continue;
                    }
                    StringTokenizer semiTok = new StringTokenizer(next.substring(semicolon + 1), ";");
                    if (semiTok.countTokens() != 3) continue;
                    vars.add(new SMAPVariableInfo(semiTok.nextToken(), semiTok.nextToken(), semiTok.nextToken(), Integer.parseInt(next.substring(0, pound)), currentFunction));
                }
                catch (NumberFormatException nfe) {
                    EDTDebugCorePlugin.log(nfe);
                }
            }
        }
        return vars.toArray(new SMAPVariableInfo[vars.size()]);
    }

    public static String getSMAP(IJavaType type) {
        Type underlyingType;
        String smap = null;
        if (type instanceof JDIReferenceType && (underlyingType = ((JDIReferenceType)type).getUnderlyingType()) instanceof ReferenceType) {
            try {
                smap = ((ReferenceType)underlyingType).sourceDebugExtension();
            }
            catch (AbsentInformationException absentInformationException) {}
        }
        return smap == null ? "" : smap.trim();
    }

    public static List<EGLJavaVariable> filterAndWrapVariables(IVariable[] javaVariables, EGLJavaVariable[] existingEGLVars, SMAPVariableInfo[] infos, EGLJavaStackFrame frame, EGLJavaDebugTarget target, boolean skipLocals) throws DebugException {
        ArrayList<EGLJavaVariable> newEGLVariables = new ArrayList<EGLJavaVariable>(javaVariables.length);
        String javaFrameSignature = frame == null ? "" : String.valueOf(frame.getJavaStackFrame().getMethodName()) + ";" + frame.getJavaStackFrame().getSignature();
        int currentLine = frame == null ? -1 : frame.getLineNumber();
        int frameStartLine = frame == null || frame.getSMAPFunctionInfo() == null ? -1 : frame.getSMAPFunctionInfo().lineDeclared;
        int i = 0;
        while (i < javaVariables.length) {
            IJavaVariable javaVar = (IJavaVariable)javaVariables[i];
            String javaName = javaVar.getName();
            if (!javaName.startsWith("eze")) {
                boolean addNew = true;
                if (existingEGLVars != null) {
                    int j = 0;
                    while (j < existingEGLVars.length) {
                        if (existingEGLVars[j].getJavaVariable() == javaVar) {
                            newEGLVariables.add(existingEGLVars[j]);
                            addNew = false;
                            break;
                        }
                        ++j;
                    }
                }
                if (addNew) {
                    SMAPVariableInfo info;
                    int j;
                    if (javaVar.isLocal()) {
                        if (!skipLocals) {
                            SMAPVariableInfo matchingInfo = null;
                            j = 0;
                            while (j < infos.length) {
                                info = infos[j];
                                if (info.javaName.equals(javaName) && info.javaMethodSignature != null && info.javaMethodSignature.equals(javaFrameSignature) && (currentLine >= info.lineDeclared || currentLine == frameStartLine) && (matchingInfo == null || matchingInfo.lineDeclared < info.lineDeclared)) {
                                    matchingInfo = info;
                                }
                                ++j;
                            }
                            if (matchingInfo != null) {
                                newEGLVariables.add(new EGLJavaVariable(target, javaVar, matchingInfo));
                            }
                        }
                    } else if ("this".equals(javaVar.getName())) {
                        newEGLVariables.add(new EGLJavaFunctionContainerVariable(target, javaVar));
                    } else {
                        SMAPVariableInfo matchingInfo = null;
                        j = 0;
                        while (j < infos.length) {
                            info = infos[j];
                            if (info.javaName.equals(javaName) && info.javaMethodSignature == null) {
                                matchingInfo = info;
                                break;
                            }
                            ++j;
                        }
                        if (matchingInfo != null) {
                            newEGLVariables.add(new EGLJavaVariable(target, javaVar, matchingInfo));
                        }
                    }
                }
            }
            ++i;
        }
        return newEGLVariables;
    }
}

