/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.edt.compiler.internal.core.utils.Aliaser;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageDeclaration;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointsTarget
implements IToggleBreakpointsTargetExtension {
    private static final String STRATUM_BREAKPOINT = "org.eclipse.jdt.debug.javaStratumLineBreakpointMarker";

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection) throws CoreException {
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        Job job = new Job("Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                ITextEditor editor = ToggleBreakpointsTarget.this.getEditor(part);
                if (editor != null) {
                    IDocumentProvider provider = editor.getDocumentProvider();
                    if (provider == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IEditorInput input = editor.getEditorInput();
                    if (!(input instanceof IFileEditorInput)) {
                        return Status.CANCEL_STATUS;
                    }
                    IDocument document = provider.getDocument((Object)input);
                    if (document != null) {
                        try {
                            ITextSelection textSelection = (ITextSelection)selection;
                            IFile file = ((IFileEditorInput)input).getFile();
                            String qualName = ToggleBreakpointsTarget.this.getGeneratedClassName(textSelection, file);
                            if (qualName == null) {
                                return Status.CANCEL_STATUS;
                            }
                            IJavaStratumLineBreakpoint breakpoint = ToggleBreakpointsTarget.stratumBreakpointExists((IResource)file, textSelection.getStartLine() + 1, "egl");
                            if (breakpoint != null) {
                                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                            } else {
                                int line;
                                if (editor instanceof EGLEditor) {
                                    EGLEditor eglEditor = (EGLEditor)editor;
                                    line = eglEditor.getLineAtOffset(eglEditor.getStatementNode(textSelection.getStartLine()).getOffset()) + 1;
                                } else {
                                    line = textSelection.getStartLine() + 1;
                                }
                                if (line != textSelection.getStartLine() + 1) {
                                    breakpoint = ToggleBreakpointsTarget.stratumBreakpointExists((IResource)file, line, "egl");
                                }
                                if (breakpoint != null) {
                                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                                } else {
                                    JDIDebugModel.createStratumBreakpoint((IResource)file, (String)"egl", (String)file.getName(), null, (String)qualName, (int)line, (int)-1, (int)-1, (int)0, (boolean)true, null);
                                }
                            }
                        }
                        catch (CoreException coreException) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    protected String getGeneratedClassName(ITextSelection selection, IFile file) {
        IEGLFile eglFile = (IEGLFile)EGLCore.create((IFile)file);
        if (eglFile != null && eglFile.exists()) {
            try {
                String name;
                int idx;
                StringBuilder buf = new StringBuilder(50);
                IPackageDeclaration[] pkg = eglFile.getPackageDeclarations();
                if (pkg != null && pkg.length > 0) {
                    buf.append(Aliaser.packageNameAlias((String)pkg[0].getElementName()));
                    buf.append('.');
                }
                if ((idx = (name = eglFile.getElementName()).lastIndexOf(46)) != -1) {
                    name = name.substring(0, idx);
                }
                buf.append(Aliaser.getAlias((String)name));
                return buf.toString();
            }
            catch (EGLModelException eGLModelException) {}
        }
        return null;
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            ITextEditor textEditor = this.getEditor(part);
            IEditorInput input = textEditor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                try {
                    if (ToggleBreakpointsTarget.stratumBreakpointExists((IResource)((IFileEditorInput)textEditor.getEditorInput()).getFile(), textSelection.getStartLine() + 1, "egl") != null) {
                        return true;
                    }
                }
                catch (CoreException coreException) {}
            }
            if (textEditor instanceof EGLEditor) {
                return ((EGLEditor)textEditor).isBreakpointValid(textSelection.getStartLine());
            }
        }
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    protected ITextEditor getEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    public static IJavaStratumLineBreakpoint stratumBreakpointExists(IResource resource, int lineNumber, String stratum) throws CoreException {
        String modelId = JDIDebugModel.getPluginIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            IJavaStratumLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof IJavaStratumLineBreakpoint && (marker = (breakpoint = (IJavaStratumLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists() && STRATUM_BREAKPOINT.equals(marker.getType()) && breakpoint.getLineNumber() == lineNumber && resource.equals((Object)marker.getResource()) && breakpoint.getStratum().equals(stratum)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }
}

