/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates.egl.lang;

import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.SequenceType;
import org.eclipse.edt.mof.egl.SubstringAccess;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;

public class AnyStringTypeTemplate
extends JavaTemplate {
    public void genDefaultValue(SequenceType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processDefaultValue((Type)type, ctx, out, args);
    }

    public void genDefaultValue(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processDefaultValue((Type)type, ctx, out, args);
    }

    public void processDefaultValue(Type type, Context ctx, TabbedWriter out, Object ... args) {
        if (args.length > 0 && args[0] instanceof TypedElement && ((TypedElement)args[0]).isNullable()) {
            out.print("null");
        } else if (args.length > 0 && args[0] instanceof Expression && ((Expression)args[0]).isNullable()) {
            out.print("null");
        } else {
            out.print("Constants.EMPTY_STRING");
        }
    }

    public void genSubstringAssignment(SequenceType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processSubstringAssignment((Type)type, ctx, out, args);
    }

    public void genSubstringAssignment(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processSubstringAssignment((Type)type, ctx, out, args);
    }

    public void processSubstringAssignment(Type type, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genExpression", ((SubstringAccess)args[0]).getStringExpression(), (TemplateContext)ctx, out, args);
        out.print(" = ");
        out.print(String.valueOf(ctx.getNativeImplementationMapping(((SubstringAccess)args[0]).getType())) + ".substringAssign(");
        ctx.gen("genExpression", ((SubstringAccess)args[0]).getStringExpression(), (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", (Expression)args[1], (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", ((SubstringAccess)args[0]).getStart(), (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", ((SubstringAccess)args[0]).getEnd(), (TemplateContext)ctx, out, args);
        out.print(")");
    }

    public void genSubstringAccess(SequenceType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processSubstringAccess((Type)type, ctx, out, args);
    }

    public void genSubstringAccess(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processSubstringAccess((Type)type, ctx, out, args);
    }

    public void processSubstringAccess(Type type, Context ctx, TabbedWriter out, Object ... args) {
        out.print(String.valueOf(ctx.getNativeImplementationMapping(((SubstringAccess)args[0]).getType())) + ".substring(");
        ctx.gen("genExpression", ((SubstringAccess)args[0]).getStringExpression(), (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", ((SubstringAccess)args[0]).getStart(), (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", ((SubstringAccess)args[0]).getEnd(), (TemplateContext)ctx, out, args);
        out.print(")");
    }

    public void genBinaryExpression(EGLClass type, Context ctx, TabbedWriter out, Object ... args) throws GenerationException {
        if (((BinaryExpression)args[0]).getLHS().isNullable() || ((BinaryExpression)args[0]).getRHS().isNullable() || this.getNativeStringOperation((BinaryExpression)args[0]).length() == 0) {
            out.print(String.valueOf(ctx.getNativeImplementationMapping((Type)((BinaryExpression)args[0]).getOperation().getContainer())) + '.');
            out.print(CommonUtilities.getNativeRuntimeOperationName((BinaryExpression)((BinaryExpression)args[0])));
            out.print("(ezeProgram, ");
            ctx.gen("genExpression", ((BinaryExpression)args[0]).getLHS(), (TemplateContext)ctx, out, args);
            out.print(", ");
            ctx.gen("genExpression", ((BinaryExpression)args[0]).getRHS(), (TemplateContext)ctx, out, args);
            out.print(")" + CommonUtilities.getNativeRuntimeComparisionOperation((BinaryExpression)((BinaryExpression)args[0])));
        } else {
            out.print(this.getNativeStringPrefixOperation((BinaryExpression)args[0]));
            out.print("(");
            ctx.gen("genExpression", ((BinaryExpression)args[0]).getLHS(), (TemplateContext)ctx, out, args);
            out.print(")");
            out.print(this.getNativeStringOperation((BinaryExpression)args[0]));
            ctx.gen("genExpression", ((BinaryExpression)args[0]).getRHS(), (TemplateContext)ctx, out, args);
            out.print(this.getNativeStringComparisionOperation((BinaryExpression)args[0]));
        }
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("!=")) {
            return "!";
        }
        return "";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("==")) {
            return ".equals(";
        }
        if (op.equals("!=")) {
            return ".equals(";
        }
        if (op.equals("<")) {
            return ".compareTo(";
        }
        if (op.equals(">")) {
            return ".compareTo(";
        }
        if (op.equals("<=")) {
            return ".compareTo(";
        }
        if (op.equals(">=")) {
            return ".compareTo(";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        return "";
    }

    protected String getNativeStringComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("==")) {
            return ")";
        }
        if (op.equals("!=")) {
            return ")";
        }
        if (op.equals("<")) {
            return ") < 0";
        }
        if (op.equals(">")) {
            return ") > 0";
        }
        if (op.equals("<=")) {
            return ") <= 0";
        }
        if (op.equals(">=")) {
            return ") >= 0";
        }
        return "";
    }
}

