/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.DecimalLiteral;

public class DecimalLiteralTemplate
extends JavaTemplate {
    public void genExpression(DecimalLiteral expr, Context ctx, TabbedWriter out, Object ... args) {
        out.print(this.decimalLiteral(expr.getValue().toString()));
    }

    protected String decimalLiteral(String value) {
        BigDecimal bd = new BigDecimal(value);
        if (bd.signum() == 0) {
            return "java.math.BigDecimal.ZERO";
        }
        if (bd.compareTo(BigDecimal.ONE) == 0) {
            return "java.math.BigDecimal.ONE";
        }
        if (bd.compareTo(BigDecimal.valueOf(-1L)) == 0) {
            return "java.math.BigDecimal.ONE.negate()";
        }
        if (bd.compareTo(BigDecimal.TEN) == 0) {
            return "java.math.BigDecimal.TEN";
        }
        if (bd.compareTo(BigDecimal.valueOf(-10L)) == 0) {
            return "java.math.BigDecimal.TEN.negate()";
        }
        int length = value.length();
        int pointIndex = value.indexOf(46);
        int scale = length - pointIndex - 1;
        String unscaled = String.valueOf(value.substring(0, pointIndex)) + value.substring(pointIndex + 1, length);
        return "new java.math.BigDecimal( " + this.bigInteger(unscaled) + ", " + scale + " )";
    }

    protected String bigInteger(String number) {
        BigInteger bi;
        if (number.charAt(0) == '+') {
            number = number.substring(1);
        }
        if ((bi = new BigInteger(number)).equals(BigInteger.ZERO)) {
            return "java.math.BigInteger.ZERO";
        }
        if (bi.equals(BigInteger.ONE)) {
            return "java.math.BigInteger.ONE";
        }
        if (bi.equals(BigInteger.ONE.negate())) {
            return "java.math.BigInteger.ONE.negate()";
        }
        if (bi.equals(BigInteger.TEN)) {
            return "java.math.BigInteger.TEN";
        }
        if (bi.equals(BigInteger.TEN.negate())) {
            return "java.math.BigInteger.TEN.negate()";
        }
        byte[] bytes = bi.toByteArray();
        String str = "new java.math.BigInteger( new byte[] {";
        int i = 0;
        while (i < bytes.length) {
            str = bytes[i] >= 0 ? String.valueOf(str) + " 0x" + Integer.toHexString(bytes[i] & 0xFF) + ',' : String.valueOf(str) + " (byte)0x" + Integer.toHexString(bytes[i] & 0xFF) + ',';
            ++i;
        }
        return String.valueOf(str) + " } )";
    }
}

